/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.text.DecimalFormat;
import org.opensourcephysics.media.core.NumberField;

public class DecimalField
extends NumberField {
    public DecimalField(int n, int n2) {
        super(n);
        n2 = Math.min(n2, 5);
        n2 = Math.max(n2, 1);
        if (this.format instanceof DecimalFormat) {
            String string = "0.";
            int n3 = 0;
            while (n3 < n2) {
                string = String.valueOf(string) + "0";
                ++n3;
            }
            ((DecimalFormat)this.format).applyPattern(string);
        }
    }

    public void setResolution(double d) {
        if (this.format instanceof DecimalFormat) {
            if (d < 0.001) {
                ((DecimalFormat)this.format).applyPattern("0.0000");
            } else if (d < 0.01) {
                ((DecimalFormat)this.format).applyPattern("0.000");
            } else if (d < 0.1) {
                ((DecimalFormat)this.format).applyPattern("0.00");
            } else if (d < 1.0) {
                ((DecimalFormat)this.format).applyPattern("0.0");
            } else {
                ((DecimalFormat)this.format).applyPattern("0");
            }
        }
    }
}

