/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

public class Interpolation {
    private Interpolation() {
    }

    public static double linear(double d, double d2, double d3, double d4, double d5) {
        if (d3 - d2 == 0.0) {
            return (d4 + d5) / 2.0;
        }
        return d4 + (d - d2) * (d5 - d4) / (d3 - d2);
    }

    public static double lagrange(double d, double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays must be of equal length.");
        }
        double d2 = 0.0;
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            if (d - dArray[n] == 0.0) {
                return d;
            }
            double d3 = dArray2[n];
            int n3 = 0;
            while (n3 < n2) {
                if (n != n3 && dArray[n] - dArray[n3] != 0.0) {
                    d3 *= (d - dArray[n]) / (dArray[n] - dArray[n3]);
                }
                ++n3;
            }
            d2 += d3;
            ++n;
        }
        return d2;
    }
}

