/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode.IRK;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODESolver;
import org.opensourcephysics.ode.IRK.AlgebraicEquationSimpleSolver;
import org.opensourcephysics.ode.IRK.IRKAlgebraicEquation;
import org.opensourcephysics.ode.IRK.IRKSimplifiedNewtonStep;

public class Radau5Light
implements ODESolver {
    protected ODE ode;
    protected double stepSize = 1.0E-6;
    protected int numEqn;
    protected int jacobianAge = 0;
    private int nSteps = 0;
    protected double[] state;
    protected double[] rate;
    protected double[][] intermediateStagesIncrement;
    protected AlgebraicEquationSimpleSolver aeSolver;
    protected static int maxNewtonIterations = 7;

    public Radau5Light(ODE oDE) {
        this.ode = oDE;
        this.state = oDE.getState();
        this.numEqn = this.state.length;
        this.rate = new double[this.numEqn];
        this.intermediateStagesIncrement = new double[3][this.numEqn];
        this.aeSolver = this.getInnerSolver(new DifferenceSchemeEquation(this.numEqn));
    }

    protected AlgebraicEquationSimpleSolver getInnerSolver(IRKAlgebraicEquation iRKAlgebraicEquation) {
        return new IRKSimplifiedNewtonStep(iRKAlgebraicEquation);
    }

    protected void preStepPreparations() {
        this.ode.getRate(this.state, this.rate);
    }

    protected void performStep() {
        double d = 0.0;
        int n = 0;
        while (n < maxNewtonIterations) {
            d += this.aeSolver.resolve() / (double)maxNewtonIterations;
            ++n;
        }
        this.aeSolver.restart(d > 0.001);
    }

    protected void commitStepResults() {
        int n = 0;
        while (n < this.numEqn) {
            int n2 = n;
            this.state[n2] = this.state[n2] + this.intermediateStagesIncrement[2][n];
            ++n;
        }
    }

    public double step() {
        this.preStepPreparations();
        this.commitStepResults();
        this.aeSolver.restart(++this.nSteps % 4 == 0);
        return this.stepSize;
    }

    public void setStepSize(double d) {
        this.stepSize = d;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void initialize(double d) {
    }

    protected class DifferenceSchemeEquation
    implements IRKAlgebraicEquation {
        private double[] realEigenvalues = new double[]{3.6378342527444962};
        private double[] complexEigenvalues = new double[]{2.6810828736277523, 3.0504301992474105};
        private double[][] T = new double[][]{{0.09123239487089295, -0.1412552950209542, -0.030029194105147424}, {0.241717932707107, 0.20412935229379994, 0.3829421127572619}, {0.966048182615093, 1.0, 0.0}};
        private double[][] inverseT = new double[][]{{4.325579890063155, 0.33919925181580984, 0.5417705399358749}, {-4.178718591551905, -0.32768282076106237, 0.47662355450055044}, {-0.5028726349457868, 2.571926949855605, -0.5960392048282249}};
        private int nStgs = 3;
        private double[] someState;
        private double[] someRate;
        double uRound = 2.220446049250313E-16;

        public void evaluate(double[][] dArray, double[][] dArray2) {
            int n;
            int n2;
            double[][] dArray3 = new double[3][3];
            double[][] dArray4 = new double[3][3];
            dArray3[0][0] = this.realEigenvalues[0];
            dArray3[1][1] = this.complexEigenvalues[0];
            dArray3[1][2] = -this.complexEigenvalues[1];
            dArray3[2][1] = this.complexEigenvalues[1];
            dArray3[2][2] = this.complexEigenvalues[0];
            int n3 = 0;
            while (n3 < 3) {
                n2 = 0;
                while (n2 < 3) {
                    dArray4[n3][n2] = 0.0;
                    n = 0;
                    while (n < 3) {
                        double[] dArray5 = dArray4[n3];
                        int n4 = n2;
                        dArray5[n4] = dArray5[n4] + this.T[n3][n] * dArray3[n][n2];
                        ++n;
                    }
                    ++n2;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < 3) {
                n2 = 0;
                while (n2 < 3) {
                    dArray3[n3][n2] = 0.0;
                    n = 0;
                    while (n < 3) {
                        double[] dArray6 = dArray3[n3];
                        int n5 = n2;
                        dArray6[n5] = dArray6[n5] + dArray4[n3][n] * this.inverseT[n][n2];
                        ++n;
                    }
                    ++n2;
                }
                ++n3;
            }
            double[][] dArray7 = new double[3][Radau5Light.this.numEqn];
            n2 = 0;
            while (n2 < 3) {
                this.evaluateNonLinearComponent(dArray[n2], dArray7[n2]);
                ++n2;
            }
            n2 = 0;
            while (n2 < Radau5Light.this.numEqn) {
                n = 0;
                while (n < 3) {
                    int n6 = 0;
                    while (n6 < 3) {
                        dArray2[n][n2] = dArray3[n][n6] * dArray7[n6][n2];
                        ++n6;
                    }
                    ++n;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < Radau5Light.this.numEqn) {
                n = 0;
                while (n < 3) {
                    double[] dArray8 = dArray2[n];
                    int n7 = n2;
                    dArray8[n7] = dArray8[n7] - dArray[n][n2] / Radau5Light.this.stepSize;
                    ++n;
                }
                ++n2;
            }
        }

        public DifferenceSchemeEquation(int n) {
            this.someState = new double[n];
            this.someRate = new double[n];
        }

        public double[][] getApproximation() {
            return Radau5Light.this.intermediateStagesIncrement;
        }

        public double[] getComplexEigenvalues() {
            return this.complexEigenvalues;
        }

        public double[] getRealEigenvalues() {
            return this.realEigenvalues;
        }

        public double getScalarMultiplier() {
            return 1.0 / Radau5Light.this.stepSize;
        }

        public void evaluateNonLinearComponent(double[] dArray, double[] dArray2) {
            int n = 0;
            while (n < Radau5Light.this.numEqn) {
                this.someState[n] = Radau5Light.this.state[n] + dArray[n];
                ++n;
            }
            Radau5Light.this.ode.getRate(this.someState, dArray2);
        }

        public void evaluateNonLinearComponentJacobian(double[] dArray, double[][] dArray2) {
            System.arraycopy(Radau5Light.this.state, 0, this.someState, 0, Radau5Light.this.numEqn);
            int n = 0;
            while (n < Radau5Light.this.numEqn) {
                double d = Math.sqrt(this.uRound * Math.max(1.0E-5, Math.abs(Radau5Light.this.state[n])));
                int n2 = n;
                this.someState[n2] = this.someState[n2] + d;
                Radau5Light.this.ode.getRate(this.someState, this.someRate);
                int n3 = n;
                this.someState[n3] = this.someState[n3] - d;
                int n4 = 0;
                while (n4 < Radau5Light.this.numEqn) {
                    dArray2[n4][n] = (this.someRate[n4] - Radau5Light.this.rate[n4]) / d;
                    ++n4;
                }
                ++n;
            }
            Radau5Light.this.jacobianAge = 0;
        }

        public void directChangeOfVariables(double[][] dArray, double[][] dArray2) {
            int n = 0;
            while (n < Radau5Light.this.numEqn) {
                int n2 = 0;
                while (n2 < this.nStgs) {
                    dArray2[n2][n] = 0.0;
                    int n3 = 0;
                    while (n3 < this.nStgs) {
                        double[] dArray3 = dArray2[n2];
                        int n4 = n;
                        dArray3[n4] = dArray3[n4] + this.inverseT[n2][n3] * dArray[n3][n];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }

        public void inverseChangeOfVariables(double[][] dArray, double[][] dArray2) {
            int n = 0;
            while (n < Radau5Light.this.numEqn) {
                int n2 = 0;
                while (n2 < this.nStgs) {
                    dArray2[n2][n] = 0.0;
                    int n3 = 0;
                    while (n3 < this.nStgs) {
                        double[] dArray3 = dArray2[n2];
                        int n4 = n;
                        dArray3[n4] = dArray3[n4] + this.T[n2][n3] * dArray[n3][n];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }
}

