/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.OSPCombo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTable;
import org.opensourcephysics.numerics.DoubleArray;
import org.opensourcephysics.numerics.IntegerArray;
import org.opensourcephysics.numerics.Util;

public class OSPControlTable
extends XMLTable
implements Control {
    static Color ERROR_COLOR = Color.PINK;
    private HashMap valueCache = new HashMap();
    private boolean lockValues = false;
    private DecimalFormat format;

    public OSPControlTable() {
        this(new XMLControlElement());
    }

    public OSPControlTable(XMLControlElement xMLControlElement) {
        super(xMLControlElement);
    }

    public void setLockValues(boolean bl) {
        this.tableModel.control.setLockValues(bl);
        this.lockValues = bl;
        if (!this.lockValues) {
            this.refresh();
        }
    }

    public void setValue(String string, Object object) {
        if (this.getBackgroundColor(string) == ERROR_COLOR) {
            this.setBackgroundColor(string, Color.WHITE);
        }
        this.tableModel.control.setValue(string, object);
        if (!this.lockValues) {
            this.refresh();
        }
    }

    public void setDecimalFormat(String string) {
        this.format = string == null ? null : new DecimalFormat(string);
    }

    public void setValue(String string, double d) {
        if (this.format == null) {
            this.setValue(string, Double.toString(d));
        } else {
            this.setValue(string, this.format.format(d));
        }
        if (!Double.isNaN(d)) {
            this.valueCache.put(string, new Double(d));
        }
    }

    public void setValue(String string, int n) {
        this.setValue(string, Integer.toString(n));
        this.valueCache.put(string, new Double(n));
    }

    public void setValue(String string, boolean bl) {
        if (this.getBackgroundColor(string) == ERROR_COLOR) {
            this.setBackgroundColor(string, Color.WHITE);
        }
        this.tableModel.control.setValue(string, bl);
    }

    public int getInt(String string) {
        Object object;
        String string2 = this.tableModel.control.getString(string);
        if (string2 == null) {
            string2 = this.getObject(string).toString();
        }
        if (this.tableModel.control.getPropertyType(string).equals("object") && (object = this.tableModel.control.getChildControl(string)).getObjectClass() == OSPCombo.class) {
            OSPCombo oSPCombo = (OSPCombo)object.loadObject(null);
            return oSPCombo.getSelectedIndex();
        }
        if (string2 == null) {
            this.setBackgroundColor(string, ERROR_COLOR);
            this.refresh();
            if (this.valueCache.containsKey(string)) {
                return (int)((Double)this.valueCache.get(string)).doubleValue();
            }
            return 0;
        }
        object = (Color)this.cellColors.get(string);
        boolean bl = this.isEditable(string);
        try {
            int n = Integer.parseInt(string);
            if (bl && object != Color.WHITE) {
                this.setBackgroundColor(string, Color.WHITE);
                this.refresh();
            } else if (!bl && object != Control.NOT_EDITABLE_BACKGROUND) {
                this.setBackgroundColor(string, Control.NOT_EDITABLE_BACKGROUND);
                this.refresh();
            }
            this.valueCache.put(string, new Double(n));
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                int n = (int)Double.parseDouble(string);
                if (bl && object != Color.WHITE) {
                    this.setBackgroundColor(string, Color.WHITE);
                    this.refresh();
                } else if (!bl && object != Control.NOT_EDITABLE_BACKGROUND) {
                    this.setBackgroundColor(string, Control.NOT_EDITABLE_BACKGROUND);
                    this.refresh();
                }
                this.valueCache.put(string, new Double(n));
                return n;
            }
            catch (NumberFormatException numberFormatException2) {
                double d = Util.evalMath(string2);
                if (Double.isNaN(d) && object != ERROR_COLOR) {
                    this.setBackgroundColor(string, ERROR_COLOR);
                    this.refresh();
                    if (this.valueCache.containsKey(string)) {
                        return (int)((Double)this.valueCache.get(string)).doubleValue();
                    }
                    return 0;
                }
                if (bl && object != Color.WHITE) {
                    this.setBackgroundColor(string, Color.WHITE);
                    this.refresh();
                } else if (!bl && object != Control.NOT_EDITABLE_BACKGROUND) {
                    this.setBackgroundColor(string, Control.NOT_EDITABLE_BACKGROUND);
                    this.refresh();
                }
                this.valueCache.put(string, new Double(d));
                return (int)d;
            }
        }
    }

    public boolean inputError(String string) {
        return this.getBackgroundColor(string) == ERROR_COLOR;
    }

    public double getDouble(String string) {
        String string2 = this.tableModel.control.getString(string);
        if (string2 == null) {
            string2 = this.getObject(string).toString();
        }
        if (string2 == null) {
            this.setBackgroundColor(string, ERROR_COLOR);
            this.refresh();
            if (this.valueCache.containsKey(string)) {
                return (Double)this.valueCache.get(string);
            }
            return 0.0;
        }
        Color color = (Color)this.cellColors.get(string);
        boolean bl = this.isEditable(string);
        try {
            double d = Double.parseDouble(string2);
            if (bl && color != Color.WHITE) {
                this.setBackgroundColor(string, Color.WHITE);
                this.refresh();
            } else if (!bl && color != Control.NOT_EDITABLE_BACKGROUND) {
                this.setBackgroundColor(string, Control.NOT_EDITABLE_BACKGROUND);
                this.refresh();
            }
            this.valueCache.put(string, new Double(d));
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            double d = Util.evalMath(string2);
            if (Double.isNaN(d) && color != ERROR_COLOR) {
                this.setBackgroundColor(string, ERROR_COLOR);
                this.refresh();
            } else if (bl && color != Color.WHITE) {
                this.setBackgroundColor(string, Color.WHITE);
                this.refresh();
            } else if (!bl && color != Control.NOT_EDITABLE_BACKGROUND) {
                this.setBackgroundColor(string, Control.NOT_EDITABLE_BACKGROUND);
                this.refresh();
            }
            if (Double.isNaN(d) && this.valueCache.containsKey(string)) {
                d = (Double)this.valueCache.get(string);
            } else {
                this.valueCache.put(string, new Double(d));
            }
            return d;
        }
    }

    public Object getObject(String string) throws UnsupportedOperationException {
        return this.tableModel.control.getObject(string);
    }

    public String getString(String string) {
        return this.tableModel.control.getString(string);
    }

    public boolean getBoolean(String string) {
        return this.tableModel.control.getBoolean(string);
    }

    public Collection getPropertyNames() {
        return this.tableModel.control.getPropertyNames();
    }

    public void removeParameter(String string) {
        this.tableModel.control.setValue(string, null);
        this.setBackgroundColor(string, Color.WHITE);
    }

    public void println(String string) {
        this.tableModel.control.println(string);
    }

    public void println() {
        this.tableModel.control.println();
    }

    public void print(String string) {
        this.tableModel.control.print(string);
    }

    public void clearMessages() {
        this.tableModel.control.clearMessages();
    }

    public void clearValues() {
        this.tableModel.control.clearValues();
    }

    public void calculationDone(String string) {
        if (string != null) {
            this.tableModel.control.calculationDone(string);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new OSPControlTableLoader();
    }

    static class OSPControlTableLoader
    implements XML.ObjectLoader {
        OSPControlTableLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            OSPControlTable oSPControlTable = (OSPControlTable)object;
            for (String string : oSPControlTable.getPropertyNames()) {
                Object object2 = oSPControlTable.getObject(string);
                if (object2.getClass() == DoubleArray.class) {
                    xMLControl.setValue(string, ((DoubleArray)object2).getArray());
                    continue;
                }
                if (object2.getClass() == IntegerArray.class) {
                    xMLControl.setValue(string, ((IntegerArray)object2).getArray());
                    continue;
                }
                if (object2.getClass() == Boolean.class) {
                    xMLControl.setValue(string, (Boolean)object2);
                    continue;
                }
                if (object2.getClass() == Double.class) {
                    xMLControl.setValue(string, (Double)object2);
                    continue;
                }
                if (object2.getClass() == Integer.class) {
                    xMLControl.setValue(string, (Integer)object2);
                    continue;
                }
                if (object2.getClass().isArray()) {
                    xMLControl.setValue(string, object2);
                    continue;
                }
                xMLControl.setValue(string, object2);
            }
        }

        public Object createObject(XMLControl xMLControl) {
            return new OSPControlTable();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            OSPControlTable oSPControlTable = (OSPControlTable)object;
            Iterator iterator = xMLControl.getPropertyNames().iterator();
            oSPControlTable.setLockValues(true);
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (xMLControl.getPropertyType(string).equals("string")) {
                    oSPControlTable.setValue(string, xMLControl.getString(string));
                    continue;
                }
                if (xMLControl.getPropertyType(string).equals("int")) {
                    oSPControlTable.setValue(string, xMLControl.getInt(string));
                    continue;
                }
                if (xMLControl.getPropertyType(string).equals("double")) {
                    oSPControlTable.setValue(string, xMLControl.getDouble(string));
                    continue;
                }
                if (xMLControl.getPropertyType(string).equals("boolean")) {
                    oSPControlTable.setValue(string, xMLControl.getBoolean(string));
                    continue;
                }
                oSPControlTable.setValue(string, xMLControl.getObject(string));
            }
            oSPControlTable.setLockValues(false);
            return object;
        }
    }
}

