/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.displayejs.InteractionTargetElementPosition;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.displayejs.Point3D;

public class InteractionTargetPoligonMovingPoint
extends InteractionTargetElementPosition {
    protected InteractivePoligon poligon = null;
    protected int index = -1;

    InteractionTargetPoligonMovingPoint(InteractivePoligon interactivePoligon, int n) {
        super(interactivePoligon);
        this.poligon = interactivePoligon;
        this.index = n;
    }

    public int getPointIndex() {
        return this.index;
    }

    public Point3D getHotspot(DrawingPanel drawingPanel) {
        if (this.element.getGroup() == null) {
            return new Point3D(this.poligon.x + this.poligon.coordinates[0][this.index] * this.poligon.sizex, this.poligon.y + this.poligon.coordinates[1][this.index] * this.poligon.sizey, this.poligon.z + this.poligon.coordinates[2][this.index] * this.poligon.sizez);
        }
        return new Point3D(this.element.getGroup().getX() + (this.poligon.x + this.poligon.coordinates[0][this.index] * this.poligon.sizex) * this.element.getGroup().getSizeX(), this.element.getGroup().getY() + (this.poligon.y + this.poligon.coordinates[1][this.index] * this.poligon.sizey) * this.element.getGroup().getSizeY(), this.element.getGroup().getZ() + (this.poligon.z + this.poligon.coordinates[2][this.index] * this.poligon.sizez) * this.element.getGroup().getSizeZ());
    }

    public void updateHotspot(DrawingPanel drawingPanel, Point3D point3D) {
        if (this.element.getGroup() == null) {
            this.poligon.x = point3D.x - this.poligon.coordinates[0][this.index] * this.poligon.sizex;
            this.poligon.y = point3D.y - this.poligon.coordinates[1][this.index] * this.poligon.sizey;
            this.poligon.z = point3D.z - this.poligon.coordinates[2][this.index] * this.poligon.sizez;
        } else if (this.element.isGroupEnabled(0)) {
            this.element.getGroup().setXYZ(point3D.x - (this.poligon.x + this.poligon.coordinates[0][this.index] * this.poligon.sizex) * this.element.getGroup().getSizeX(), point3D.y - (this.poligon.y + this.poligon.coordinates[1][this.index] * this.poligon.sizey) * this.element.getGroup().getSizeY(), point3D.z - (this.poligon.z + this.poligon.coordinates[2][this.index] * this.poligon.sizez) * this.element.getGroup().getSizeZ());
        } else {
            double d = this.element.getGroup().getSizeX();
            double d2 = this.element.getGroup().getSizeY();
            double d3 = this.element.getGroup().getSizeZ();
            if (d != 0.0) {
                this.poligon.x = (point3D.x - this.element.getGroup().getX()) / d - this.poligon.coordinates[0][this.index] * this.poligon.sizex;
            }
            if (d2 != 0.0) {
                this.poligon.y = (point3D.y - this.element.getGroup().getY()) / d2 - this.poligon.coordinates[1][this.index] * this.poligon.sizey;
            }
            if (d3 != 0.0) {
                this.poligon.z = (point3D.z - this.element.getGroup().getZ()) / d3 - this.poligon.coordinates[2][this.index] * this.poligon.sizez;
            }
        }
        this.poligon.hasChanged = true;
    }
}

