/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.displayejs.InteractionTargetElementSize;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.displayejs.Point3D;

public class InteractionTargetPoligonPoint
extends InteractionTargetElementSize {
    protected InteractivePoligon poligon = null;
    protected int index = -1;

    InteractionTargetPoligonPoint(InteractivePoligon interactivePoligon, int n) {
        super(interactivePoligon);
        this.poligon = interactivePoligon;
        this.index = n;
    }

    public int getPointIndex() {
        return this.index;
    }

    public Point3D getHotspot(DrawingPanel drawingPanel) {
        if (this.element.getGroup() == null) {
            return new Point3D(this.poligon.x + this.poligon.coordinates[0][this.index] * this.poligon.sizex, this.poligon.y + this.poligon.coordinates[1][this.index] * this.poligon.sizey, this.poligon.z + this.poligon.coordinates[2][this.index] * this.poligon.sizez);
        }
        return new Point3D(this.element.getGroup().getX() + (this.poligon.x + this.poligon.coordinates[0][this.index] * this.poligon.sizex) * this.element.getGroup().getSizeX(), this.element.getGroup().getY() + (this.poligon.y + this.poligon.coordinates[1][this.index] * this.poligon.sizey) * this.element.getGroup().getSizeY(), this.element.getGroup().getZ() + (this.poligon.z + this.poligon.coordinates[2][this.index] * this.poligon.sizez) * this.element.getGroup().getSizeZ());
    }

    public void updateHotspot(DrawingPanel drawingPanel, Point3D point3D) {
        if (this.element.getGroup() == null) {
            this.poligon.coordinates[0][this.index] = (point3D.x - this.poligon.x) / this.poligon.sizex;
            this.poligon.coordinates[1][this.index] = (point3D.y - this.poligon.y) / this.poligon.sizey;
            this.poligon.coordinates[2][this.index] = (point3D.z - this.poligon.z) / this.poligon.sizez;
        } else if (this.element.isGroupEnabled(1)) {
            double d = this.poligon.x + this.poligon.coordinates[0][this.index] * this.poligon.sizex;
            double d2 = this.poligon.y + this.poligon.coordinates[1][this.index] * this.poligon.sizey;
            double d3 = this.poligon.z + this.poligon.coordinates[2][this.index] * this.poligon.sizez;
            d = d == 0.0 ? this.element.getGroup().getSizeX() : (point3D.x - this.element.getGroup().getX()) / d;
            d2 = d2 == 0.0 ? this.element.getGroup().getSizeY() : (point3D.y - this.element.getGroup().getY()) / d2;
            d3 = d3 == 0.0 ? this.element.getGroup().getSizeZ() : (point3D.z - this.element.getGroup().getZ()) / d3;
            this.element.getGroup().setSizeXYZ(d, d2, d3);
        } else {
            if (this.element.getGroup().getSizeX() != 0.0 && this.poligon.sizex != 0.0) {
                this.poligon.coordinates[0][this.index] = ((point3D.x - this.element.getGroup().getX()) / this.element.getGroup().getSizeX() - this.poligon.x) / this.poligon.sizex;
            }
            if (this.element.getGroup().getSizeY() != 0.0 && this.poligon.sizey != 0.0) {
                this.poligon.coordinates[1][this.index] = ((point3D.y - this.element.getGroup().getY()) / this.element.getGroup().getSizeY() - this.poligon.y) / this.poligon.sizey;
            }
            if (this.element.getGroup().getSizeZ() != 0.0 && this.poligon.sizez != 0.0) {
                this.poligon.coordinates[2][this.index] = ((point3D.z - this.element.getGroup().getZ()) / this.element.getGroup().getSizeZ() - this.poligon.z) / this.poligon.sizez;
            }
        }
        this.poligon.hasChanged = true;
    }
}

