/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.beans.PropertyChangeEvent;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class FitFunctionPanel
extends FunctionPanel {
    DatasetCurveFitter curveFitter;

    public FitFunctionPanel(UserFunctionEditor userFunctionEditor) {
        super(userFunctionEditor);
        UserFunction[] userFunctionArray = userFunctionEditor.getMainFunctions();
        int n = 0;
        while (n < userFunctionArray.length) {
            int n2 = 0;
            while (n2 < userFunctionArray[n].getParameterCount()) {
                if (this.paramEditor.getObject(userFunctionArray[n].getParameterName(n2)) == null) {
                    Parameter parameter = new Parameter(userFunctionArray[n].getParameterName(n2), String.valueOf(userFunctionArray[n].getParameterValue(n2)));
                    this.paramEditor.addObject(parameter, n, false, false);
                }
                ++n2;
            }
            ++n;
        }
        this.refreshFunctions();
        this.addForbiddenNames(new String[]{this.getFitFunction().getIndependentVariable()});
        this.setName(this.getFitFunction().getName());
    }

    public UserFunctionEditor getFitFunctionEditor() {
        return (UserFunctionEditor)this.functionEditor;
    }

    public UserFunction getFitFunction() {
        return ((UserFunctionEditor)this.functionEditor).getMainFunctions()[0];
    }

    public UserFunction[] getSupportFunctions() {
        return ((UserFunctionEditor)this.functionEditor).getSupportFunctions();
    }

    public String getLabel() {
        return ToolsRes.getString("FitFunctionPanel.Label");
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        UserFunctionEditor userFunctionEditor;
        UserFunction[] userFunctionArray;
        if (propertyChangeEvent.getPropertyName().equals("edit") && this.functionTool != null && propertyChangeEvent.getSource() == this.functionEditor && (userFunctionArray = (userFunctionEditor = (UserFunctionEditor)this.functionEditor).getMainFunctions()) != null && userFunctionArray[0].getName().equals(propertyChangeEvent.getOldValue())) {
            this.functionTool.renamePanel(this.getName(), this.getFitFunction().getName());
            FunctionEditor.DefaultEdit defaultEdit = (FunctionEditor.DefaultEdit)propertyChangeEvent.getNewValue();
            if (defaultEdit != null) {
                this.functionEditor.getTable().selectCell(defaultEdit.undoRow, defaultEdit.undoCol);
            }
        }
        super.propertyChange(propertyChangeEvent);
    }

    protected void refreshFunctions() {
        if (this.paramEditor != null) {
            UserFunction[] userFunctionArray = ((UserFunctionEditor)this.functionEditor).getMainFunctions();
            int n = 0;
            while (n < userFunctionArray.length) {
                userFunctionArray[n].setParameters(this.paramEditor.getNames(), this.paramEditor.getValues());
                ++n;
            }
            userFunctionArray = ((UserFunctionEditor)this.functionEditor).getSupportFunctions();
            n = 0;
            while (n < userFunctionArray.length) {
                userFunctionArray[n].setParameters(this.paramEditor.getNames(), this.paramEditor.getValues());
                ++n;
            }
        }
        this.functionEditor.evaluateAll();
    }

    protected void refreshParameters() {
        if (this.paramEditor != null) {
            UserFunction userFunction = this.getFitFunction();
            this.paramEditor.refreshParametersFromFunction(userFunction);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            FitFunctionPanel fitFunctionPanel = (FitFunctionPanel)object;
            Parameter[] parameterArray = fitFunctionPanel.getParamEditor().getParameters();
            xMLControl.setValue("user_parameters", parameterArray);
            xMLControl.setValue("function_editor", fitFunctionPanel.getFitFunctionEditor());
        }

        public Object createObject(XMLControl xMLControl) {
            UserFunctionEditor userFunctionEditor = (UserFunctionEditor)xMLControl.getObject("function_editor");
            return new FitFunctionPanel(userFunctionEditor);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            FitFunctionPanel fitFunctionPanel = (FitFunctionPanel)object;
            Parameter[] parameterArray = (Parameter[])xMLControl.getObject("user_parameters");
            fitFunctionPanel.getParamEditor().setParameters(parameterArray);
            fitFunctionPanel.getFitFunctionEditor().parametersValid = false;
            fitFunctionPanel.getFitFunctionEditor().evaluateAll();
            return object;
        }
    }
}

