/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.TextLine;

public class DrawableTextLine
extends TextLine
implements Drawable {
    double x;
    double y;
    double theta = 0.0;
    protected boolean pixelXY = false;

    public DrawableTextLine(String string, double d, double d2) {
        super(string);
        this.x = d;
        this.y = d2;
        this.color = Color.BLACK;
    }

    public void setPixelXY(boolean bl) {
        this.pixelXY = bl;
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setTheta(double d) {
        this.theta = d;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double d) {
        this.y = d;
    }

    public double getY() {
        return this.y;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.text == null || this.text.equals("")) {
            return;
        }
        Font font = graphics.getFont();
        if (this.pixelXY) {
            this.drawWithPix(drawingPanel, graphics);
        } else {
            this.drawWithWorld(drawingPanel, graphics);
        }
        graphics.setFont(font);
    }

    void drawWithPix(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.theta != 0.0) {
            ((Graphics2D)graphics).transform(AffineTransform.getRotateInstance(-this.theta, this.x, this.y));
            this.drawText(graphics, (int)this.x, (int)this.y);
            ((Graphics2D)graphics).transform(AffineTransform.getRotateInstance(this.theta, this.x, this.y));
        } else {
            this.drawText(graphics, (int)this.x, (int)this.y);
        }
    }

    void drawWithWorld(DrawingPanel drawingPanel, Graphics graphics) {
        Point2D point2D = new Point2D.Double(this.x, this.y);
        point2D = drawingPanel.getPixelTransform().transform(point2D, point2D);
        if (this.theta != 0.0) {
            ((Graphics2D)graphics).transform(AffineTransform.getRotateInstance(-this.theta, point2D.getX(), point2D.getY()));
            this.drawText(graphics, (int)point2D.getX(), (int)point2D.getY());
            ((Graphics2D)graphics).transform(AffineTransform.getRotateInstance(this.theta, point2D.getX(), point2D.getY()));
        } else {
            this.drawText(graphics, (int)point2D.getX(), (int)point2D.getY());
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new DrawableTextLineLoader();
    }

    protected static class DrawableTextLineLoader
    extends XMLLoader {
        protected DrawableTextLineLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            DrawableTextLine drawableTextLine = (DrawableTextLine)object;
            xMLControl.setValue("text", drawableTextLine.getText());
            xMLControl.setValue("x", drawableTextLine.x);
            xMLControl.setValue("y", drawableTextLine.y);
            xMLControl.setValue("theta", drawableTextLine.theta);
            xMLControl.setValue("color", drawableTextLine.color);
            xMLControl.setValue("pixel position", drawableTextLine.pixelXY);
        }

        public Object createObject(XMLControl xMLControl) {
            return new DrawableTextLine("", 0.0, 0.0);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            DrawableTextLine drawableTextLine = (DrawableTextLine)object;
            drawableTextLine.x = xMLControl.getDouble("x");
            drawableTextLine.y = xMLControl.getDouble("y");
            drawableTextLine.theta = xMLControl.getDouble("theta");
            drawableTextLine.pixelXY = xMLControl.getBoolean("pixel position");
            drawableTextLine.setText(xMLControl.getString("text"));
            drawableTextLine.color = (Color)xMLControl.getObject("color");
            return object;
        }
    }
}

