/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ConstantParser;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.swing.ControlWindow;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.tools.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControlSwingElement
extends ControlElement {
    public static final int SWING_ELEMENT_NAME = 0;
    public static final int POSITION = 1;
    public static final int PARENT = 2;
    public static final int ENABLED = 3;
    public static final int VISIBLE = 4;
    public static final int SIZE = 5;
    public static final int FOREGROUND = 6;
    public static final int BACKGROUND = 7;
    public static final int FONT = 8;
    public static final int TOOLTIP = 9;
    public static final int MENU_NAME = 10;
    public static final int PRINT_TARGET = 11;
    public static final int ACTION_PRESS = 10;
    public static final int ACTION_ON = 20;
    public static final int ACTION_OFF = 21;
    public static final int KEY_ACTION = 30;
    public static final int MOUSE_ENTERED_ACTION = 31;
    public static final int MOUSE_EXITED_ACTION = 32;
    public static final int MOUSE_MOVED_ACTION = 33;
    private static ArrayList<String> myInfoList = null;
    protected Component myVisual = this.createVisual();
    protected Color myDefaultBkgd;
    protected Color myDefaultFrgd;
    protected Font myDefaultFont;
    private Dimension mySize;
    private String menuNameEntry = null;
    private ControlWindow myControlWindow = null;
    private String printTarget = null;
    private String tooltipText = null;

    public ControlSwingElement() {
        this.myObject = this.myVisual;
        this.myDefaultFrgd = this.myVisual.getForeground();
        this.myDefaultBkgd = this.myVisual.getBackground();
        this.myDefaultFont = this.myVisual.getFont();
        if (this.myVisual instanceof JComponent) {
            this.mySize = ((JComponent)this.myVisual).getPreferredSize();
        }
    }

    protected abstract Component createVisual();

    @Override
    public final Component getVisual() {
        return this.myVisual;
    }

    @Override
    public Component getComponent() {
        return this.myVisual;
    }

    public Window getTopWindow() {
        Container container = this.myVisual.getParent();
        while (container != null) {
            if (container instanceof Window) {
                return (Window)container;
            }
            container = container.getParent();
        }
        return null;
    }

    public final void changeVisual(Component component) {
        ControlElement controlElement;
        if (component.equals(this.myVisual)) {
            return;
        }
        component.setEnabled(this.myVisual.isEnabled());
        component.setVisible(this.myVisual.isVisible());
        if (component instanceof JComponent && this.getComponent() instanceof JComponent) {
            ((JComponent)component).setPreferredSize(this.mySize);
            if (component instanceof Container) {
                ((Container)component).validate();
            }
            if ((controlElement = this.myGroup.getElement(this.getProperty("parent"))) != null) {
                ((ControlContainer)controlElement).adjustSize();
            }
        }
        component.setForeground(this.myVisual.getForeground());
        component.setBackground(this.myVisual.getBackground());
        component.setFont(this.myVisual.getFont());
        if (component instanceof JComponent) {
            ((JComponent)component).setToolTipText(this.tooltipText);
        }
        if ((controlElement = this.myGroup.getElement(this.getProperty("parent"))) != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                ((ControlContainer)controlElement).remove(this);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public synchronized void run() {
                            ((ControlContainer)controlElement).remove(ControlSwingElement.this);
                        }
                    });
                }
                catch (Exception exception) {}
            }
        }
        this.myVisual = component;
        this.myObject = this.myVisual;
        this.myDefaultFrgd = this.myVisual.getForeground();
        this.myDefaultBkgd = this.myVisual.getBackground();
        this.myDefaultFont = this.myVisual.getFont();
        if (this.myVisual instanceof JComponent) {
            this.mySize = ((JComponent)this.myVisual).getPreferredSize();
        }
        if (controlElement != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                ((ControlContainer)controlElement).add(this);
                ((ControlContainer)controlElement).adjustSize();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public synchronized void run() {
                            ((ControlContainer)controlElement).add(ControlSwingElement.this);
                            ((ControlContainer)controlElement).adjustSize();
                        }
                    });
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getPrintTarget() {
        if (this.printTarget == null) {
            return this.getProperty("name");
        }
        return this.printTarget;
    }

    protected void getPopupMenu(int n, int n2) {
        this.getSimulation().getPopupMenu(this.getVisual(), n, n2, this.getPrintTarget());
    }

    protected void printScreen() {
        this.getSimulation().saveImage(this.getPrintTarget());
    }

    public final void setControlWindow(ControlWindow controlWindow) {
        this.myControlWindow = controlWindow;
    }

    public final ControlWindow getControlWindow() {
        return this.myControlWindow;
    }

    public String getMenuNameEntry() {
        if (this.menuNameEntry != null) {
            if (this.menuNameEntry.equals("null")) {
                return null;
            }
            return this.menuNameEntry;
        }
        return this.getProperty("name");
    }

    @Override
    public List<String> getPropertyList() {
        if (myInfoList == null) {
            myInfoList = new ArrayList();
            myInfoList.add("name");
            myInfoList.add("position");
            myInfoList.add("parent");
            myInfoList.add("enabled");
            myInfoList.add("visible");
            myInfoList.add("size");
            myInfoList.add("foreground");
            myInfoList.add("background");
            myInfoList.add("font");
            myInfoList.add("tooltip");
            myInfoList.add("menuName");
            myInfoList.add("printTarget");
        }
        return myInfoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("name")) {
            return "String         CONSTANT";
        }
        if (string.equals("position")) {
            return "Position       CONSTANT PREVIOUS";
        }
        if (string.equals("parent")) {
            return "ControlElement CONSTANT";
        }
        if (string.equals("enabled")) {
            return "boolean";
        }
        if (string.equals("visible")) {
            return "boolean";
        }
        if (string.equals("size")) {
            return "Dimension|Object|String TRANSLATABLE";
        }
        if (string.equals("foreground")) {
            return "int|Color|Object";
        }
        if (string.equals("background")) {
            return "int|Color|Object";
        }
        if (string.equals("font")) {
            return "Font|Object";
        }
        if (string.equals("tooltip")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("menuName")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("printTarget")) {
            return "String";
        }
        return null;
    }

    @Override
    public Value parseConstant(String string, String string2) {
        Value value;
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("Alignment") >= 0 && (value = ConstantParser.alignmentConstant(string2)) != null) {
            return value;
        }
        if (string.indexOf("Dimension") >= 0 && (value = ConstantParser.dimensionConstant(string2)) != null) {
            return value;
        }
        if (string.indexOf("Layout") >= 0 && (value = ConstantParser.layoutConstant(((ControlContainer)this).getContainer(), string2)) != null) {
            return value;
        }
        if (string.indexOf("Orientation") >= 0 && (value = ConstantParser.orientationConstant(string2)) != null) {
            return value;
        }
        if (string.indexOf("Placement") >= 0 && (value = ConstantParser.placementConstant(string2)) != null) {
            return value;
        }
        if (string.indexOf("Point") >= 0 && (value = ConstantParser.pointConstant(string2)) != null) {
            return value;
        }
        if (string.indexOf("Mnemonic") >= 0 && (string2 = string2.trim().toLowerCase()).length() > 0) {
            return new IntegerValue(string2.charAt(0));
        }
        return super.parseConstant(string, string2);
    }

    @Override
    public String toStringValue(Value value) {
        if (value instanceof ObjectValue) {
            ObjectValue objectValue = (ObjectValue)value;
            if (objectValue.value instanceof Point) {
                return ConstantParser.toString((Point)objectValue.value);
            }
            if (objectValue.value instanceof Dimension) {
                return ConstantParser.toString((Dimension)objectValue.value);
            }
        }
        return super.toStringValue(value);
    }

    @Override
    public void setValue(int n, final Value value) {
        switch (n) {
            case 0: {
                super.setValue(0, value);
                this.getComponent().setName(value.toString());
                break;
            }
            case 1: {
                Runnable runnable = new Runnable(){

                    public synchronized void run() {
                        ControlElement controlElement = ControlSwingElement.this.myGroup.getElement(ControlSwingElement.this.getProperty("parent"));
                        if (controlElement != null && controlElement instanceof ControlContainer) {
                            ((ControlContainer)controlElement).remove(ControlSwingElement.this);
                        }
                        ControlSwingElement.this.myPropertiesTable.put("position", value.toString());
                        if (controlElement != null && controlElement instanceof ControlContainer) {
                            ((ControlContainer)controlElement).add(ControlSwingElement.this);
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                    break;
                }
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    runnable.run();
                }
                break;
            }
            case 2: {
                Runnable runnable = new Runnable(){

                    public synchronized void run() {
                        ControlElement controlElement = ControlSwingElement.this.myGroup.getElement(ControlSwingElement.this.getProperty("parent"));
                        if (controlElement != null && controlElement instanceof ControlContainer) {
                            ((ControlContainer)controlElement).remove(ControlSwingElement.this);
                        }
                        if ((controlElement = ControlSwingElement.this.myGroup.getElement(value.toString())) == null) {
                            if (!(ControlSwingElement.this instanceof ControlWindow)) {
                                System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + value + "> not found for " + this.toString());
                            }
                        } else if (controlElement instanceof ControlContainer) {
                            ((ControlContainer)controlElement).add(ControlSwingElement.this);
                        } else {
                            System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + value + "> is not a ControlContainer");
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                    break;
                }
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    runnable.run();
                }
                break;
            }
            case 3: {
                this.getVisual().setEnabled(value.getBoolean());
                break;
            }
            case 4: {
                this.getVisual().setVisible(value.getBoolean());
                break;
            }
            case 5: {
                if (value.getObject() == null) {
                    System.err.println("Size invalid for element " + this.getProperty("name"));
                    return;
                }
                Runnable runnable = new Runnable(){

                    public synchronized void run() {
                        if (ControlSwingElement.this.getComponent() instanceof JComponent) {
                            ControlElement controlElement;
                            Dimension dimension = (Dimension)value.getObject();
                            if (dimension.width == ((ControlSwingElement)ControlSwingElement.this).mySize.width && dimension.height == ((ControlSwingElement)ControlSwingElement.this).mySize.height) {
                                return;
                            }
                            JComponent jComponent = (JComponent)ControlSwingElement.this.getComponent();
                            Dimension dimension2 = dimension;
                            ControlSwingElement.this.mySize = dimension2;
                            jComponent.setPreferredSize(dimension2);
                            if (ControlSwingElement.this instanceof ControlContainer) {
                                ((ControlContainer)ControlSwingElement.this).getContainer().validate();
                            }
                            if ((controlElement = ControlSwingElement.this.myGroup.getElement(ControlSwingElement.this.getProperty("parent"))) != null) {
                                ((ControlContainer)controlElement).adjustSize();
                            }
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                    break;
                }
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    runnable.run();
                }
                break;
            }
            case 6: {
                if (value.getObject() instanceof Color) {
                    this.getVisual().setForeground((Color)value.getObject());
                    break;
                }
                this.getVisual().setForeground(DisplayColors.getLineColor(value.getInteger()));
                break;
            }
            case 7: {
                if (value.getObject() instanceof Color) {
                    this.getVisual().setBackground((Color)value.getObject());
                    break;
                }
                this.getVisual().setBackground(DisplayColors.getLineColor(value.getInteger()));
                break;
            }
            case 8: {
                if (!(value.getObject() instanceof Font)) break;
                this.getVisual().setFont((Font)value.getObject());
                break;
            }
            case 9: {
                this.tooltipText = TeXParser.parseTeX(value.getString());
                if (!(this.getVisual() instanceof JComponent)) break;
                ((JComponent)this.getVisual()).setToolTipText(this.tooltipText);
                break;
            }
            case 10: {
                this.menuNameEntry = value.getString();
                break;
            }
            case 11: {
                this.printTarget = value.getString();
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                super.setDefaultValue(0);
                this.getComponent().setName("");
                break;
            }
            case 1: {
                ControlElement controlElement = this.myGroup.getElement(this.getProperty("parent"));
                if (controlElement != null && controlElement instanceof ControlContainer) {
                    ((ControlContainer)controlElement).remove(this);
                }
                this.myPropertiesTable.remove("position");
                if (controlElement == null || !(controlElement instanceof ControlContainer)) break;
                ((ControlContainer)controlElement).add(this);
                break;
            }
            case 2: {
                ControlElement controlElement = this.myGroup.getElement(this.getProperty("parent"));
                if (controlElement == null || !(controlElement instanceof ControlContainer)) break;
                ((ControlContainer)controlElement).remove(this);
                break;
            }
            case 3: {
                this.getVisual().setEnabled(true);
                break;
            }
            case 4: {
                this.getVisual().setVisible(true);
                break;
            }
            case 5: {
                ControlElement controlElement;
                if (!(this.getComponent() instanceof JComponent)) break;
                ((JComponent)this.getComponent()).setPreferredSize(null);
                if (this instanceof ControlContainer) {
                    ((ControlContainer)this).getContainer().validate();
                }
                if ((controlElement = this.myGroup.getElement(this.getProperty("parent"))) == null) break;
                ((ControlContainer)controlElement).adjustSize();
                break;
            }
            case 6: {
                this.getVisual().setForeground(this.myDefaultFrgd);
                break;
            }
            case 7: {
                this.getVisual().setBackground(this.myDefaultBkgd);
                break;
            }
            case 8: {
                this.getVisual().setFont(this.myDefaultFont);
                break;
            }
            case 9: {
                this.tooltipText = null;
                if (!(this.getComponent() instanceof JComponent)) break;
                ((JComponent)this.getVisual()).setToolTipText(this.tooltipText);
                break;
            }
            case 10: {
                this.menuNameEntry = null;
                break;
            }
            case 11: {
                this.printTarget = null;
                break;
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 3: {
                return "true";
            }
            case 4: {
                return "true";
            }
        }
        return "<none>";
    }

    @Override
    public Value getValue(int n) {
        return null;
    }

    protected ImageIcon getIcon(String string) {
        ImageIcon imageIcon = ResourceLoader.getIcon(string);
        return imageIcon;
    }
}

