/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.core;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;

public class Resolution {
    public static final int DIVISIONS = 0;
    public static final int MAX_LENGTH = 1;
    private int type = 0;
    private double maxLength = 1.0;
    private int n1 = 1;
    private int n2 = 1;
    private int n3 = 1;

    public Resolution(double d) {
        this.type = 1;
        this.maxLength = d;
    }

    public Resolution(int n, int n2, int n3) {
        this.type = 0;
        this.n1 = n;
        this.n2 = n2;
        this.n3 = n3;
    }

    public final int getType() {
        return this.type;
    }

    public final double getMaxLength() {
        return this.maxLength;
    }

    public final int getN1() {
        return this.n1;
    }

    public final int getN2() {
        return this.n2;
    }

    public final int getN3() {
        return this.n3;
    }

    public static XML.ObjectLoader getLoader() {
        return new ResolutionLoader();
    }

    public static class ResolutionLoader
    extends XMLLoader {
        public void saveObject(XMLControl xMLControl, Object object) {
            Resolution resolution = (Resolution)object;
            xMLControl.setValue("type", resolution.type);
            xMLControl.setValue("max length", resolution.maxLength);
            xMLControl.setValue("n1", resolution.n1);
            xMLControl.setValue("n2", resolution.n2);
            xMLControl.setValue("n3", resolution.n3);
        }

        public Object createObject(XMLControl xMLControl) {
            return new Resolution(1, 1, 1);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Resolution resolution = (Resolution)object;
            resolution.type = xMLControl.getInt("type");
            resolution.maxLength = xMLControl.getDouble("max length");
            resolution.n1 = xMLControl.getInt("n1");
            resolution.n2 = xMLControl.getInt("n2");
            resolution.n3 = xMLControl.getInt("n3");
            return object;
        }
    }
}

