/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.jogl;

import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import org.opensourcephysics.display3d.core.Resolution;
import org.opensourcephysics.display3d.jogl.DrawingPanel3D;
import org.opensourcephysics.display3d.jogl.ElementSurface;
import org.opensourcephysics.display3d.jogl.utils.GLTools;

public class ElementEllipsoid
extends ElementSurface
implements org.opensourcephysics.display3d.core.ElementEllipsoid {
    private boolean closedBottom = true;
    private boolean closedTop = true;
    private boolean closedLeft = true;
    private boolean closedRight = true;
    private int minAngleU = 0;
    private int maxAngleU = 360;
    private int minAngleV = -90;
    private int maxAngleV = 90;
    private boolean changeNTiles = true;
    private int nr = -1;
    private int nu = -1;
    private int nv = -1;
    protected static final double TO_RADIANS = Math.PI / 180;
    protected static final double[] vectorx = new double[]{1.0, 0.0, 0.0};
    protected static final double[] vectory = new double[]{0.0, 1.0, 0.0};
    protected static final double[] vectorz = new double[]{0.0, 0.0, 1.0};

    public ElementEllipsoid() {
        this.getStyle().setResolution(new Resolution(3, 12, 12));
    }

    void draw(GLAutoDrawable gLAutoDrawable) {
        if (!this.isVisible()) {
            return;
        }
        if (this.minAngleU != 0 || this.maxAngleU != 360 || this.minAngleV != -90 || this.maxAngleV != 90) {
            this.computeCorners();
            super.draw(gLAutoDrawable);
        } else {
            int n;
            int n2;
            GL gL = gLAutoDrawable.getGL();
            gL.glPushMatrix();
            this.transform(gL);
            gL.glScaled(this.getSizeX(), this.getSizeY(), this.getSizeZ());
            if (this.getStyle().getResolution().getType() == 1) {
                n2 = (int)Math.ceil(Math.min(this.getSizeX(), this.getSizeZ()) / this.getStyle().getResolution().getMaxLength());
                n = (int)Math.ceil(this.getSizeY() / this.getStyle().getResolution().getMaxLength());
            } else {
                n2 = this.getStyle().getResolution().getN2();
                n = this.getStyle().getResolution().getN3();
            }
            if (this.getStyle().isDrawingFill()) {
                GLTools.setColor(gL, this.getStyle().getFillColor());
                gL.glEnable(2896);
                gL.glMaterialfv(1032, 5634, this.getStyle().getFillColor().getComponents(null), 0);
                this.preFillGL(gLAutoDrawable);
                DrawingPanel3D.GLUT.glutSolidSphere(0.5, n2, n);
            }
            if (this.getStyle().isDrawingLines()) {
                GLTools.setColor(gL, this.getStyle().getLineColor());
                gL.glEnable(2896);
                gL.glMaterialfv(1032, 5634, this.getStyle().getLineColor().getComponents(null), 0);
                gL.glLineWidth(this.getStyle().getLineWidth());
                this.preLinesGL(gLAutoDrawable);
                DrawingPanel3D.GLUT.glutWireSphere(0.5, n2, n);
            }
            gL.glPopMatrix();
            this.setElementChanged(false);
        }
    }

    protected synchronized void computeCorners() {
        Resolution resolution;
        double d;
        double d2;
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        double d3 = this.maxAngleU;
        double d4 = this.minAngleU;
        if (Math.abs(d3 - d4) > 360.0) {
            d3 = d4 + 360.0;
        }
        if (Math.abs((d2 = (double)this.maxAngleV) - (d = (double)this.minAngleV)) > 180.0) {
            d2 = d + 180.0;
        }
        if ((resolution = this.getStyle().getResolution()) != null) {
            switch (resolution.getType()) {
                case 0: {
                    n = Math.max(resolution.getN1(), 1);
                    n2 = Math.max(resolution.getN2(), 1);
                    n3 = Math.max(resolution.getN3(), 1);
                    break;
                }
                case 1: {
                    double d5 = Math.max(Math.max(Math.abs(this.getSizeX()), Math.abs(this.getSizeY())), Math.abs(this.getSizeZ())) / 2.0;
                    n = Math.max((int)Math.round(0.49 + d5 / resolution.getMaxLength()), 1);
                    n2 = Math.max((int)Math.round(0.49 + Math.abs(d3 - d4) * (Math.PI / 180) * d5 / resolution.getMaxLength()), 1);
                    n3 = Math.max((int)Math.round(0.49 + Math.abs(d2 - d) * (Math.PI / 180) * d5 / resolution.getMaxLength()), 1);
                }
            }
        }
        if (this.nr != n || this.nu != n2 || this.nv != n3 || this.changeNTiles) {
            this.nr = n;
            this.nu = n2;
            this.nv = n3;
            this.setData(ElementEllipsoid.createStandardEllipsoid(this.nr, this.nu, this.nv, d4, d3, d, d2, this.closedTop, this.closedBottom, this.closedLeft, this.closedRight));
            this.changeNTiles = false;
        }
        this.setElementChanged(false);
    }

    private static double[][][] createStandardEllipsoid(int n, int n2, int n3, double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n4;
        int n5;
        int n6;
        double d5;
        int n7 = n2 * n3;
        if (Math.abs(d4 - d3) < 180.0) {
            if (bl2) {
                n7 += n * n2;
            }
            if (bl) {
                n7 += n * n2;
            }
        }
        if (Math.abs(d2 - d) < 360.0) {
            if (bl3) {
                n7 += n * n3;
            }
            if (bl4) {
                n7 += n * n3;
            }
        }
        double[][][] dArray = new double[n7][4][3];
        double[] dArray2 = new double[n2 + 1];
        double[] dArray3 = new double[n2 + 1];
        double[] dArray4 = new double[n3 + 1];
        double[] dArray5 = new double[n3 + 1];
        int n8 = 0;
        while (n8 <= n2) {
            d5 = ((double)(n2 - n8) * d + (double)n8 * d2) * (Math.PI / 180) / (double)n2;
            dArray2[n8] = Math.cos(d5);
            dArray3[n8] = Math.sin(d5);
            ++n8;
        }
        n8 = 0;
        while (n8 <= n3) {
            d5 = ((double)(n3 - n8) * d3 + (double)n8 * d4) * (Math.PI / 180) / (double)n3;
            dArray4[n8] = Math.cos(d5) / 2.0;
            dArray5[n8] = Math.sin(d5) / 2.0;
            ++n8;
        }
        n8 = 0;
        double[] dArray6 = new double[]{0.0, 0.0, 0.0};
        int n9 = 0;
        while (n9 < n3) {
            n6 = 0;
            while (n6 < n2) {
                n5 = 0;
                while (n5 < 3) {
                    dArray[n8][0][n5] = (dArray2[n6] * vectorx[n5] + dArray3[n6] * vectory[n5]) * dArray4[n9] + dArray5[n9] * vectorz[n5];
                    dArray[n8][1][n5] = (dArray2[n6 + 1] * vectorx[n5] + dArray3[n6 + 1] * vectory[n5]) * dArray4[n9] + dArray5[n9] * vectorz[n5];
                    dArray[n8][2][n5] = (dArray2[n6 + 1] * vectorx[n5] + dArray3[n6 + 1] * vectory[n5]) * dArray4[n9 + 1] + dArray5[n9 + 1] * vectorz[n5];
                    dArray[n8][3][n5] = (dArray2[n6] * vectorx[n5] + dArray3[n6] * vectory[n5]) * dArray4[n9 + 1] + dArray5[n9 + 1] * vectorz[n5];
                    ++n5;
                }
                ++n6;
                ++n8;
            }
            ++n9;
        }
        if (Math.abs(d4 - d3) < 180.0) {
            if (bl2) {
                dArray6[2] = dArray5[0];
                n9 = 0;
                while (n9 < n2) {
                    n6 = 0;
                    while (n6 < n) {
                        n5 = 0;
                        while (n5 < 3) {
                            dArray[n8][0][n5] = ((double)(n - n6) * dArray6[n5] + (double)n6 * dArray[n9][0][n5]) / (double)n;
                            dArray[n8][1][n5] = ((double)(n - n6 - 1) * dArray6[n5] + (double)(n6 + 1) * dArray[n9][0][n5]) / (double)n;
                            dArray[n8][2][n5] = ((double)(n - n6 - 1) * dArray6[n5] + (double)(n6 + 1) * dArray[n9][1][n5]) / (double)n;
                            dArray[n8][3][n5] = ((double)(n - n6) * dArray6[n5] + (double)n6 * dArray[n9][1][n5]) / (double)n;
                            ++n5;
                        }
                        ++n6;
                        ++n8;
                    }
                    ++n9;
                }
            }
            if (bl) {
                dArray6[2] = dArray5[n3];
                n9 = n2 * (n3 - 1);
                n6 = 0;
                while (n6 < n2) {
                    n5 = 0;
                    while (n5 < n) {
                        n4 = 0;
                        while (n4 < 3) {
                            dArray[n8][0][n4] = ((double)(n - n5) * dArray6[n4] + (double)n5 * dArray[n9 + n6][3][n4]) / (double)n;
                            dArray[n8][1][n4] = ((double)(n - n5 - 1) * dArray6[n4] + (double)(n5 + 1) * dArray[n9 + n6][3][n4]) / (double)n;
                            dArray[n8][2][n4] = ((double)(n - n5 - 1) * dArray6[n4] + (double)(n5 + 1) * dArray[n9 + n6][2][n4]) / (double)n;
                            dArray[n8][3][n4] = ((double)(n - n5) * dArray6[n4] + (double)n5 * dArray[n9 + n6][2][n4]) / (double)n;
                            ++n4;
                        }
                        ++n5;
                        ++n8;
                    }
                    ++n6;
                }
            }
        }
        if (Math.abs(d2 - d) < 360.0) {
            int n10;
            double[] dArray7 = new double[]{0.0, 0.0, 0.0};
            if (bl4) {
                n6 = 0;
                n5 = 0;
                while (n5 < n3) {
                    dArray6[2] = dArray5[n5];
                    dArray7[2] = dArray5[n5 + 1];
                    n4 = 0;
                    while (n4 < n) {
                        n10 = 0;
                        while (n10 < 3) {
                            dArray[n8][0][n10] = ((double)(n - n4) * dArray6[n10] + (double)n4 * dArray[n6][0][n10]) / (double)n;
                            dArray[n8][1][n10] = ((double)(n - n4 - 1) * dArray6[n10] + (double)(n4 + 1) * dArray[n6][0][n10]) / (double)n;
                            dArray[n8][2][n10] = ((double)(n - n4 - 1) * dArray7[n10] + (double)(n4 + 1) * dArray[n6][3][n10]) / (double)n;
                            dArray[n8][3][n10] = ((double)(n - n4) * dArray7[n10] + (double)n4 * dArray[n6][3][n10]) / (double)n;
                            ++n10;
                        }
                        ++n4;
                        ++n8;
                    }
                    ++n5;
                    n6 += n2;
                }
            }
            if (bl3) {
                n6 = n2 - 1;
                n5 = 0;
                while (n5 < n3) {
                    dArray6[2] = dArray5[n5];
                    dArray7[2] = dArray5[n5 + 1];
                    n4 = 0;
                    while (n4 < n) {
                        n10 = 0;
                        while (n10 < 3) {
                            dArray[n8][0][n10] = ((double)(n - n4) * dArray6[n10] + (double)n4 * dArray[n6][1][n10]) / (double)n;
                            dArray[n8][1][n10] = ((double)(n - n4 - 1) * dArray6[n10] + (double)(n4 + 1) * dArray[n6][1][n10]) / (double)n;
                            dArray[n8][2][n10] = ((double)(n - n4 - 1) * dArray7[n10] + (double)(n4 + 1) * dArray[n6][2][n10]) / (double)n;
                            dArray[n8][3][n10] = ((double)(n - n4) * dArray7[n10] + (double)n4 * dArray[n6][2][n10]) / (double)n;
                            ++n10;
                        }
                        ++n4;
                        ++n8;
                    }
                    ++n5;
                    n6 += n2;
                }
            }
        }
        return dArray;
    }

    public void setClosedBottom(boolean bl) {
        this.closedBottom = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedBottom() {
        return this.closedBottom;
    }

    public void setClosedTop(boolean bl) {
        this.closedTop = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedTop() {
        return this.closedTop;
    }

    public void setClosedLeft(boolean bl) {
        this.closedLeft = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedLeft() {
        return this.closedLeft;
    }

    public void setClosedRight(boolean bl) {
        this.closedRight = bl;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public boolean isClosedRight() {
        return this.closedRight;
    }

    public void setMinimumAngleU(int n) {
        this.minAngleU = n;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMinimumAngleU() {
        return this.minAngleU;
    }

    public void setMaximumAngleU(int n) {
        this.maxAngleU = n;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMaximumAngleU() {
        return this.maxAngleU;
    }

    public void setMinimumAngleV(int n) {
        this.minAngleV = n;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMinimumAngleV() {
        return this.minAngleV;
    }

    public void setMaximumAngleV(int n) {
        this.maxAngleV = n;
        this.setElementChanged(true);
        this.changeNTiles = true;
    }

    public int getMaximumAngleV() {
        return this.maxAngleV;
    }

    public int getBlendPriority() {
        if (this.getStyle().isDrawingFill()) {
            if (this.getStyle().getFillColor().getAlpha() < 255) {
                return 1;
            }
            return 0;
        }
        return 1;
    }
}

