/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.jogl;

import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import org.opensourcephysics.display3d.jogl.Element;
import org.opensourcephysics.display3d.jogl.utils.GLTools;

public class ElementPolygon
extends Element
implements org.opensourcephysics.display3d.core.ElementPolygon {
    private boolean closed = true;
    private double[][] data;

    void draw(GLAutoDrawable gLAutoDrawable) {
        int n;
        if (!this.isVisible()) {
            return;
        }
        GL gL = gLAutoDrawable.getGL();
        gL.glPushMatrix();
        this.transform(gL);
        if (this.getStyle().isDrawingFill() && this.closed) {
            GLTools.setColor(gL, this.getStyle().getFillColor());
            gL.glEnable(2896);
            gL.glMaterialfv(1032, 5634, this.getStyle().getFillColor().getComponents(null), 0);
            this.preFillGL(gLAutoDrawable);
            gL.glBegin(9);
            n = 0;
            while (n < this.data.length) {
                gL.glVertex3dv(this.data[n], 0);
                ++n;
            }
            gL.glEnd();
        }
        if (this.getStyle().isDrawingLines()) {
            GLTools.setColor(gL, this.getStyle().getLineColor());
            gL.glEnable(2896);
            gL.glMaterialfv(1032, 5634, this.getStyle().getLineColor().getComponents(null), 0);
            gL.glLineWidth(this.getStyle().getLineWidth());
            this.preLinesGL(gLAutoDrawable);
            gL.glBegin(this.closed ? 2 : 3);
            n = 0;
            while (n < this.data.length) {
                gL.glVertex3dv(this.data[n], 0);
                ++n;
            }
            gL.glEnd();
        }
        gL.glPopMatrix();
        this.setElementChanged(false);
    }

    public void setClosed(boolean bl) {
        this.closed = bl;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setData(double[][] dArray) {
        this.data = dArray;
    }

    public void setData(double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray == null || dArray2 == null || dArray3 == null) {
            return;
        }
        int n = Math.max(dArray.length, Math.max(dArray2.length, dArray3.length));
        if (this.data.length != n) {
            this.data = new double[n][3];
        }
        if (dArray.length == dArray2.length && dArray.length == dArray3.length) {
            int n2 = 0;
            while (n2 < n) {
                this.data[n2][0] = dArray[n2];
                this.data[n2][1] = dArray2[n2];
                this.data[n2][2] = dArray3[n2];
                ++n2;
            }
        } else {
            double d = dArray[dArray.length - 1];
            double d2 = dArray2[dArray2.length - 1];
            double d3 = dArray3[dArray3.length - 1];
            int n3 = 0;
            while (n3 < n) {
                this.data[n3][0] = n3 < dArray.length ? dArray[n3] : d;
                this.data[n3][1] = n3 < dArray2.length ? dArray2[n3] : d2;
                this.data[n3][2] = n3 < dArray3.length ? dArray3[n3] : d3;
                ++n3;
            }
        }
        this.setData(this.data);
    }

    public double[][] getData() {
        return this.data;
    }

    public int getBlendPriority() {
        if (this.getStyle().isDrawingLines()) {
            return 1;
        }
        return 0;
    }
}

