/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.LogMeasurable;
import org.opensourcephysics.drawing2d.DrawingPanel;
import org.opensourcephysics.drawing2d.Group;
import org.opensourcephysics.drawing2d.Style;
import org.opensourcephysics.drawing2d.interaction.InteractionEvent;
import org.opensourcephysics.drawing2d.interaction.InteractionListener;
import org.opensourcephysics.drawing2d.interaction.InteractionTarget;
import org.opensourcephysics.numerics.Matrix2DTransformation;

public abstract class Element
implements Interactive,
LogMeasurable {
    public static final int TARGET_POSITION = 0;
    public static final int TARGET_SIZE = 1;
    protected static final double[] STD_ORIGIN = new double[]{0.0, 0.0};
    protected static final double[] STD_END = new double[]{1.0, 1.0};
    private boolean visible = true;
    private double x = 0.0;
    private double y = 0.0;
    private double sizeX = 1.0;
    private double sizeY = 1.0;
    private String name = "unnamed";
    private Style style = new Style(this);
    private Group group = null;
    private Object dataObject = null;
    private AffineTransform transformation = new AffineTransform();
    private boolean elementChanged = true;
    private boolean needsToProject = true;
    protected boolean canBeMeasured = true;
    private DrawingPanel panel;
    private double[] corners = new double[8];
    private AffineTransform totalTransformation = new AffineTransform();
    private double xmax;
    private double ymax;
    private double xmin;
    private double ymin;
    private double xmaxLogscale;
    private double ymaxLogscale;
    private double xminLogscale;
    private double yminLogscale;
    private List<InteractionListener> listeners = new ArrayList<InteractionListener>();
    protected final InteractionTarget targetPosition = new InteractionTarget(this, 0);
    protected final InteractionTarget targetSize = new InteractionTarget(this, 1);

    public final void setDataObject(Object object) {
        this.dataObject = object;
    }

    public final Object getDataObject() {
        return this.dataObject;
    }

    public final void setPanel(DrawingPanel drawingPanel) {
        this.panel = drawingPanel;
        this.needsToProject = true;
    }

    public final DrawingPanel getPanel() {
        Element element = this;
        while (element.group != null) {
            element = element.group;
        }
        return element.panel;
    }

    protected final void setGroup(Group group) {
        this.group = group;
        this.elementChanged = true;
    }

    protected final Group getGroup() {
        return this.group;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final String getName() {
        return this.name;
    }

    public final void setX(double d) {
        this.x = d;
        this.elementChanged = true;
    }

    public final double getX() {
        return this.x;
    }

    public final void setY(double d) {
        this.y = d;
        this.elementChanged = true;
    }

    public final double getY() {
        return this.y;
    }

    public final void setXY(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.elementChanged = true;
    }

    public final void setPosition(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.elementChanged = true;
    }

    public final double[] getPosition() {
        return new double[]{this.x, this.y};
    }

    public void setSizeX(double d) {
        this.sizeX = d;
        this.elementChanged = true;
    }

    public final double getSizeX() {
        return this.sizeX;
    }

    public void setSizeY(double d) {
        this.sizeY = d;
        this.elementChanged = true;
    }

    public final double getSizeY() {
        return this.sizeY;
    }

    public void setSizeXY(double d, double d2) {
        this.sizeX = d;
        this.sizeY = d2;
        this.elementChanged = true;
    }

    public void setSize(double[] dArray) {
        this.sizeX = dArray[0];
        this.sizeY = dArray[1];
        this.elementChanged = true;
    }

    public final double[] getSize() {
        return new double[]{this.sizeX, this.sizeY};
    }

    public void setCanBeMeasured(boolean bl) {
        this.canBeMeasured = bl;
    }

    protected final double getDiagonalSize() {
        return Math.sqrt(this.sizeX * this.sizeX + this.sizeY * this.sizeY);
    }

    public double getXMin() {
        this.updateExtrema();
        return this.xmin;
    }

    public double getXMax() {
        this.updateExtrema();
        return this.xmax;
    }

    public double getYMin() {
        this.updateExtrema();
        return this.ymin;
    }

    public double getYMax() {
        this.updateExtrema();
        return this.ymax;
    }

    public double getXMinLogscale() {
        this.updateExtrema();
        return this.xminLogscale;
    }

    public double getXMaxLogscale() {
        this.updateExtrema();
        return this.xmaxLogscale;
    }

    public double getYMinLogscale() {
        this.updateExtrema();
        return this.yminLogscale;
    }

    public double getYMaxLogscale() {
        this.updateExtrema();
        return this.ymaxLogscale;
    }

    protected int getCorners(double[] dArray) {
        dArray[6] = 0.0;
        dArray[0] = 0.0;
        dArray[4] = 1.0;
        dArray[2] = 1.0;
        dArray[3] = 0.0;
        dArray[1] = 0.0;
        dArray[7] = 1.0;
        dArray[5] = 1.0;
        return 4;
    }

    protected final void initExtrema() {
        this.yminLogscale = Double.MAX_VALUE;
        this.xminLogscale = Double.MAX_VALUE;
        this.ymin = Double.MAX_VALUE;
        this.xmin = Double.MAX_VALUE;
        this.ymaxLogscale = -1.7976931348623157E308;
        this.xmaxLogscale = -1.7976931348623157E308;
        this.ymax = -1.7976931348623157E308;
        this.xmax = -1.7976931348623157E308;
    }

    protected final void compareToAllExtrema(double d, double d2) {
        this.compareToExtrema(d, d2);
        this.compareToLogExtrema(d, d2);
    }

    protected final void compareToExtrema(double d, double d2) {
        this.xmin = Math.min(this.xmin, d);
        this.xmax = Math.max(this.xmax, d);
        this.ymin = Math.min(this.ymin, d2);
        this.ymax = Math.max(this.ymax, d2);
    }

    protected final void compareToLogExtrema(double d, double d2) {
        if (d > 0.0) {
            this.xminLogscale = Math.min(this.xminLogscale, d);
            this.xmaxLogscale = Math.max(this.xmaxLogscale, d);
        }
        if (d2 > 0.0) {
            this.yminLogscale = Math.min(this.yminLogscale, d2);
            this.ymaxLogscale = Math.max(this.ymaxLogscale, d2);
        }
    }

    protected void updateExtrema() {
        if (!this.hasChanged()) {
            return;
        }
        this.initExtrema();
        int n = this.getCorners(this.corners);
        this.getTotalTransform().transform(this.corners, 0, this.corners, 0, n);
        int n2 = 0;
        int n3 = 2 * n;
        while (n2 < n3) {
            this.compareToAllExtrema(this.corners[n2], this.corners[n2 + 1]);
            n2 += 2;
        }
    }

    public boolean isMeasured() {
        return this.canBeMeasured;
    }

    public final void setVisible(boolean bl) {
        this.visible = bl;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    protected final boolean isReallyVisible() {
        Group group = this.group;
        while (group != null) {
            if (!group.visible) {
                return false;
            }
            group = group.group;
        }
        return this.visible;
    }

    public final Style getStyle() {
        return this.style;
    }

    protected void styleChanged(int n) {
    }

    public boolean hasChanged() {
        Element element = this;
        while (element != null) {
            if (element.elementChanged) {
                return true;
            }
            element = element.group;
        }
        return false;
    }

    public final void setElementChanged() {
        this.elementChanged = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setTransformation(Object object) throws ClassCastException {
        if (object == null) {
            this.transformation.setToIdentity();
        } else if (object instanceof Matrix2DTransformation) {
            this.transformation.setTransform(((Matrix2DTransformation)object).getTotalTransform());
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            if (dArray.length >= 6) {
                this.transformation.setTransform(new AffineTransform(dArray));
            }
        } else if (object instanceof double[][]) {
            double[][] dArray = (double[][])object;
            if (dArray.length < 2) throw new ClassCastException();
            if (dArray[0].length == 2) {
                this.transformation.setTransform(new AffineTransform(dArray[0][0], dArray[1][0], dArray[0][1], dArray[1][1], 0.0, 0.0));
            } else if (dArray[0].length >= 3) {
                this.transformation.setTransform(new AffineTransform(dArray[0][0], dArray[1][0], dArray[0][1], dArray[1][1], dArray[0][2], dArray[1][2]));
            }
        } else {
            this.transformation.setTransform((AffineTransform)object);
        }
        this.elementChanged = true;
    }

    public final Object getTransformation() {
        return new AffineTransform(this.transformation);
    }

    protected final AffineTransform getTheTransformation() {
        return this.transformation;
    }

    protected final AffineTransform getTotalTransform() {
        if (this.elementChanged) {
            this.totalTransformation = AffineTransform.getTranslateInstance(this.x, this.y);
            this.totalTransformation.concatenate(this.transformation);
            this.totalTransformation.scale(this.sizeX, this.sizeY);
            this.elementChanged = false;
            this.setNeedToProject(true);
        }
        if (this.group == null) {
            return this.totalTransformation;
        }
        AffineTransform affineTransform = new AffineTransform(this.group.getTotalTransform());
        affineTransform.concatenate(this.totalTransformation);
        return affineTransform;
    }

    protected final AffineTransform getPixelTransform(org.opensourcephysics.display.DrawingPanel drawingPanel) {
        AffineTransform affineTransform = drawingPanel.getPixelTransform();
        affineTransform.concatenate(this.getTotalTransform());
        return affineTransform;
    }

    public final double[] toSpaceFrame(double[] dArray) {
        this.transformation.transform(dArray, 0, dArray, 0, 1);
        dArray[0] = dArray[0] + this.x;
        dArray[1] = dArray[1] + this.y;
        Group group = this.group;
        while (group != null) {
            dArray[0] = dArray[0] * group.sizeX;
            dArray[1] = dArray[1] * group.sizeY;
            group.transformation.transform(dArray, 0, dArray, 0, 1);
            dArray[0] = dArray[0] + group.x;
            dArray[1] = dArray[1] + group.y;
            group = group.group;
        }
        return dArray;
    }

    public final double[] toBodyFrame(double[] dArray) throws NoninvertibleTransformException {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element element = this;
        do {
            arrayList.add(element);
        } while ((element = element.group) != null);
        int n = arrayList.size() - 1;
        while (n >= 0) {
            element = (Element)arrayList.get(n);
            dArray[0] = dArray[0] - element.x;
            dArray[1] = dArray[1] - element.y;
            element.transformation.inverseTransform(dArray, 0, dArray, 0, 1);
            if (element != this) {
                if (element.sizeX != 0.0) {
                    dArray[0] = dArray[0] / element.sizeX;
                }
                if (element.sizeY != 0.0) {
                    dArray[1] = dArray[1] / element.sizeY;
                }
            }
            --n;
        }
        return dArray;
    }

    public abstract void draw(org.opensourcephysics.display.DrawingPanel var1, Graphics var2);

    public void setNeedToProject(boolean bl) {
        this.needsToProject = bl;
    }

    protected final boolean needsToProject() {
        return this.needsToProject;
    }

    public void setEnabled(boolean bl) {
        this.targetPosition.setEnabled(bl);
        this.targetSize.setEnabled(bl);
    }

    public boolean isEnabled() {
        return this.targetPosition.isEnabled() || this.targetSize.isEnabled();
    }

    public final InteractionTarget getInteractionTarget(int n) {
        switch (n) {
            case 0: {
                return this.targetPosition;
            }
            case 1: {
                return this.targetSize;
            }
        }
        return null;
    }

    public final void addInteractionListener(InteractionListener interactionListener) {
        if (interactionListener == null || this.listeners.contains(interactionListener)) {
            return;
        }
        this.listeners.add(interactionListener);
    }

    public final void removeInteractionListener(InteractionListener interactionListener) {
        this.listeners.remove(interactionListener);
    }

    public final void invokeActions(InteractionEvent interactionEvent) {
        Iterator<InteractionListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().interactionPerformed(interactionEvent);
        }
    }

    public abstract Interactive findInteractive(org.opensourcephysics.display.DrawingPanel var1, int var2, int var3);

    protected double[] getHotSpotBodyCoordinates(InteractionTarget interactionTarget) {
        if (interactionTarget == this.targetPosition) {
            return new double[]{0.0, 0.0};
        }
        if (interactionTarget == this.targetSize) {
            return new double[]{this.sizeX != 0.0 ? 1 : 0, this.sizeY != 0.0 ? 1 : 0};
        }
        return null;
    }

    private final double[] getHotSpot(InteractionTarget interactionTarget) {
        double[] dArray = this.getHotSpotBodyCoordinates(interactionTarget);
        if (dArray != null) {
            this.getTotalTransform().transform(dArray, 0, dArray, 0, 1);
        }
        return dArray;
    }

    public void updateHotSpot(InteractionTarget interactionTarget, double[] dArray) {
        Group group = this.group;
        switch (interactionTarget.getType()) {
            case 0: {
                if (group != null && interactionTarget.getAffectsGroup()) {
                    double[] dArray2 = this.getHotSpot(interactionTarget);
                    group.setXY(group.x + dArray[0] - dArray2[0], group.y + dArray[1] - dArray2[1]);
                    break;
                }
                double[] dArray3 = (double[])dArray.clone();
                this.groupInverseTransformations(dArray3);
                double[] dArray4 = this.getHotSpotBodyCoordinates(interactionTarget);
                dArray4[0] = dArray4[0] * this.sizeX;
                dArray4[1] = dArray4[1] * this.sizeY;
                this.transformation.transform(dArray4, 0, dArray4, 0, 1);
                this.setXY(dArray3[0] - dArray4[0], dArray3[1] - dArray4[1]);
                break;
            }
            case 1: {
                if (group != null && interactionTarget.getAffectsGroup()) {
                    double[] dArray5 = (double[])dArray.clone();
                    dArray5[0] = dArray5[0] - group.x;
                    dArray5[1] = dArray5[1] - group.y;
                    try {
                        group.transformation.inverseTransform(dArray5, 0, dArray5, 0, 1);
                    }
                    catch (Exception exception) {}
                    double[] dArray6 = this.getHotSpotBodyCoordinates(interactionTarget);
                    this.elementDirectTransformations(dArray6);
                    dArray5[0] = dArray6[0] != 0.0 ? dArray5[0] / dArray6[0] : group.x;
                    dArray5[1] = dArray6[1] != 0.0 ? dArray5[1] / dArray6[1] : group.y;
                    group.setSize(dArray5);
                    break;
                }
                double[] dArray7 = (double[])dArray.clone();
                this.groupInverseTransformations(dArray7);
                dArray7[0] = dArray7[0] - this.x;
                dArray7[1] = dArray7[1] - this.y;
                try {
                    this.transformation.inverseTransform(dArray7, 0, dArray7, 0, 1);
                }
                catch (Exception exception) {}
                double[] dArray8 = this.getHotSpotBodyCoordinates(interactionTarget);
                if (dArray8[0] != 0.0) {
                    dArray7[0] = dArray7[0] / dArray8[0];
                }
                if (dArray8[1] != 0.0) {
                    dArray7[1] = dArray7[1] / dArray8[1];
                }
                this.setSize(dArray7);
            }
        }
    }

    protected final void groupInverseTransformations(double[] dArray) throws UnsupportedOperationException {
        ArrayList<Group> arrayList = new ArrayList<Group>();
        Element element = this.group;
        while (element != null) {
            arrayList.add((Group)element);
            element = element.group;
        }
        int n = arrayList.size() - 1;
        while (n >= 0) {
            element = (Element)arrayList.get(n);
            dArray[0] = dArray[0] - element.x;
            dArray[1] = dArray[1] - element.y;
            try {
                element.transformation.inverseTransform(dArray, 0, dArray, 0, 1);
            }
            catch (Exception exception) {}
            if (element.sizeX != 0.0) {
                dArray[0] = dArray[0] / element.sizeX;
            }
            if (element.sizeY != 0.0) {
                dArray[1] = dArray[1] / element.sizeY;
            }
            --n;
        }
    }

    protected final void elementDirectTransformations(double[] dArray) {
        Element element = this;
        do {
            if (element.sizeX != 0.0) {
                dArray[0] = dArray[0] * element.sizeX;
            }
            if (element.sizeY != 0.0) {
                dArray[1] = dArray[1] * element.sizeY;
            }
            if (element.transformation != null) {
                element.transformation.transform(dArray, 0, dArray, 0, 1);
            }
            dArray[0] = dArray[0] + this.x;
            dArray[1] = dArray[1] + this.y;
        } while ((element = element.group) != null && element.group != null);
    }
}

