/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

public class DoubleArray {
    private double[] map;
    private int length;

    public DoubleArray(int n, double d) {
        this.length = n;
        this.map = new double[this.length];
        this.fill(d, 0);
    }

    public double get(int n) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        return this.map[n];
    }

    public boolean set(int n, double d) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        boolean bl = this.map[n] != d;
        this.map[n] = d;
        return bl;
    }

    public void setLength(int n) {
        if (n == this.length || n < 1) {
            return;
        }
        double[] dArray = new double[n];
        System.arraycopy(this.map, 0, dArray, 0, Math.min(n, this.length));
        this.map = dArray;
        if (n > this.length) {
            double d = this.map[this.length - 1];
            int n2 = this.length;
            this.length = n;
            this.fill(d, n2);
        } else {
            this.length = n;
        }
    }

    public boolean fill(double d) {
        boolean bl = false;
        int n = this.length - 1;
        while (n >= 0) {
            bl = bl || this.map[n] != d;
            this.map[n] = d;
            --n;
        }
        return bl;
    }

    private void fill(double d, int n) {
        int n2 = n;
        while (n2 < this.length) {
            this.map[n2] = d;
            ++n2;
        }
    }
}

