/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.rk;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.rk.AbstractAdaptiveRKSolverInterpolator;

public class Dopri5
extends AbstractAdaptiveRKSolverInterpolator {
    private static final double A_11 = 0.2;
    private static final double A_21 = 0.075;
    private static final double A_22 = 0.225;
    private static final double A_31 = 0.9777777777777777;
    private static final double A_32 = -3.7333333333333334;
    private static final double A_33 = 3.5555555555555554;
    private static final double A_41 = 2.9525986892242035;
    private static final double A_42 = -11.595793324188385;
    private static final double A_43 = 9.822892851699436;
    private static final double A_44 = -0.2908093278463649;
    private static final double A_51 = 2.8462752525252526;
    private static final double A_52 = -10.757575757575758;
    private static final double A_53 = 8.906422717743473;
    private static final double A_54 = 0.2784090909090909;
    private static final double A_55 = -0.2735313036020583;
    private static final double B5_1 = 0.09114583333333333;
    private static final double B5_2 = 0.0;
    private static final double B5_3 = 0.44923629829290207;
    private static final double B5_4 = 0.6510416666666666;
    private static final double B5_5 = -0.322376179245283;
    private static final double B5_6 = 0.13095238095238096;
    private static final double E_1 = 0.0012326388888888888;
    private static final double E_2 = 0.0;
    private static final double E_3 = -0.0042527702905061394;
    private static final double E_4 = 0.03697916666666667;
    private static final double E_5 = -0.05086379716981132;
    private static final double E_6 = 0.0419047619047619;
    private static final double E_7 = -0.025;
    private static final double D_1 = -1.1270175653862835;
    private static final double D_2 = 0.0;
    private static final double D_3 = 2.675424484351598;
    private static final double D_4 = -5.685526961588504;
    private static final double D_5 = 3.5219323679207912;
    private static final double D_6 = -1.7672812570757455;
    private static final double D_7 = 2.382468931778144;
    private boolean computeCoefficients = true;
    private double[][] coeffs;
    private double[] rate2;
    private double[] rate3;
    private double[] rate4;
    private double[] rate5;
    private double[] rate6;

    public Dopri5(ODE oDE) {
        this.ode = oDE;
    }

    protected void allocateOtherArrays() {
        super.allocateOtherArrays();
        this.rate2 = new double[this.dimension];
        this.rate3 = new double[this.dimension];
        this.rate4 = new double[this.dimension];
        this.rate5 = new double[this.dimension];
        this.rate6 = new double[this.dimension];
        this.coeffs = new double[5][this.dimension];
    }

    protected double getMethodOrder() {
        return 5.0;
    }

    protected int getNumberOfEvaluations() {
        return 6;
    }

    protected double computeApproximations(double d) {
        this.computeIntermediateStep(d, this.finalState);
        this.ode.getRate(this.finalState, this.finalRate);
        double d2 = 0.0;
        int n = 0;
        while (n < this.dimension) {
            double d3 = this.absTol[n] + this.relTol[n] * Math.max(Math.abs(this.finalState[n]), Math.abs(this.initialState[n]));
            double d4 = (0.0012326388888888888 * this.initialRate[n] + 0.0 * this.rate2[n] + -0.0042527702905061394 * this.rate3[n] + 0.03697916666666667 * this.rate4[n] + -0.05086379716981132 * this.rate5[n] + 0.0419047619047619 * this.rate6[n] + -0.025 * this.finalRate[n]) / d3;
            d2 += d4 * d4;
            ++n;
        }
        return Math.sqrt(d2 / (double)this.dimension);
    }

    protected void computeFinalRate() {
        this.computeCoefficients = true;
    }

    protected double[] computeIntermediateStep(double d, double[] dArray) {
        int n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * 0.2 * this.initialRate[n];
            ++n;
        }
        this.ode.getRate(dArray, this.rate2);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.075 * this.initialRate[n] + 0.225 * this.rate2[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate3);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.9777777777777777 * this.initialRate[n] + -3.7333333333333334 * this.rate2[n] + 3.5555555555555554 * this.rate3[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate4);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (2.9525986892242035 * this.initialRate[n] + -11.595793324188385 * this.rate2[n] + 9.822892851699436 * this.rate3[n] + -0.2908093278463649 * this.rate4[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate5);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (2.8462752525252526 * this.initialRate[n] + -10.757575757575758 * this.rate2[n] + 8.906422717743473 * this.rate3[n] + 0.2784090909090909 * this.rate4[n] + -0.2735313036020583 * this.rate5[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate6);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.09114583333333333 * this.initialRate[n] + 0.0 * this.rate2[n] + 0.44923629829290207 * this.rate3[n] + 0.6510416666666666 * this.rate4[n] + -0.322376179245283 * this.rate5[n] + 0.13095238095238096 * this.rate6[n]);
            ++n;
        }
        return dArray;
    }

    public double[] interpolate(double d, double[] dArray) {
        if (this.computeCoefficients) {
            this.computeCoefficients = false;
            int n = 0;
            while (n < this.dimension) {
                this.coeffs[0][n] = this.initialState[n];
                this.coeffs[1][n] = this.finalState[n] - this.initialState[n];
                this.coeffs[2][n] = this.deltaTime * this.initialRate[n] - this.coeffs[1][n];
                this.coeffs[3][n] = this.coeffs[1][n] - this.deltaTime * this.finalRate[n] - this.coeffs[2][n];
                this.coeffs[4][n] = this.deltaTime * (-1.1270175653862835 * this.initialRate[n] + 0.0 * this.rate2[n] + 2.675424484351598 * this.rate3[n] + -5.685526961588504 * this.rate4[n] + 3.5219323679207912 * this.rate5[n] + -1.7672812570757455 * this.rate6[n] + 2.382468931778144 * this.finalRate[n]);
                ++n;
            }
        }
        double d2 = (d - this.initialTime) / this.deltaTime;
        double d3 = 1.0 - d2;
        int n = 0;
        while (n < this.dimension) {
            dArray[n] = this.coeffs[0][n] + d2 * (this.coeffs[1][n] + d3 * (this.coeffs[2][n] + d2 * (this.coeffs[3][n] + d3 * this.coeffs[4][n])));
            ++n;
        }
        dArray[this.timeIndex] = d;
        return dArray;
    }
}

