/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.rk;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODESolverInterpolator;
import org.opensourcephysics.numerics.rk.irk.Radau5Adaptive;

public class Radau5
extends Radau5Adaptive
implements ODESolverInterpolator {
    static final double c1 = (4.0 - Math.sqrt(6.0)) / 10.0;
    static final double c2 = (4.0 + Math.sqrt(6.0)) / 10.0;
    static final double c1m1 = c1 - 1.0;
    static final double c2m1 = c2 - 1.0;
    static final double c1mc2 = c1 - c2;
    private double takenStepSize = 0.0;
    private double initialTime = Double.NaN;
    private double finalTime = Double.NaN;
    private double[] initialState;
    private double[][] interpolationCoeffs;

    public Radau5(ODE oDE) {
        super(oDE);
    }

    protected void allocateArrays(int n) {
        super.allocateArrays(n);
        this.initialState = new double[n];
        this.interpolationCoeffs = new double[4][n];
    }

    public void reinitialize(double[] dArray) {
        super.reinitialize(dArray);
        this.initialTime = dArray[this.numEqn - 1];
        System.arraycopy(dArray, 0, this.initialState, 0, this.numEqn);
        this.ode.getRate(this.initialState, this.rate);
        this.finalTime = Double.NaN;
        this.error_code = 0;
    }

    public double[] getCurrentRate() {
        return this.rate;
    }

    public final void setEstimateFirstStep(boolean bl) {
    }

    public final double getMaximumTime() {
        if (this.error_code != 0) {
            return Double.NaN;
        }
        if (Double.isNaN(this.finalTime)) {
            return this.internalStep();
        }
        return this.finalTime;
    }

    public final double internalStep() {
        this.initialTime = this.state[this.numEqn - 1];
        System.arraycopy(this.state, 0, this.initialState, 0, this.numEqn);
        this.takenStepSize = super.doStep();
        this.constructInterpolationCoeffs();
        this.finalTime = this.error_code != 0 ? Double.NaN : this.initialTime + this.takenStepSize;
        return this.finalTime;
    }

    private void constructInterpolationCoeffs() {
        int n = 0;
        while (n < this.numEqn) {
            this.interpolationCoeffs[0][n] = this.state[n];
            this.interpolationCoeffs[1][n] = (this.intermediateStagesIncrement[1][n] - this.intermediateStagesIncrement[2][n]) / c2m1;
            double d = (this.intermediateStagesIncrement[0][n] - this.intermediateStagesIncrement[1][n]) / c1mc2;
            double d2 = this.intermediateStagesIncrement[0][n] / c1;
            d2 = (d - d2) / c2;
            this.interpolationCoeffs[2][n] = (d - this.interpolationCoeffs[1][n]) / c1m1;
            this.interpolationCoeffs[3][n] = this.interpolationCoeffs[2][n] - d2;
            ++n;
        }
    }

    public double[] interpolate(double d, double[] dArray) {
        double d2 = (d - this.finalTime) / this.takenStepSize;
        int n = 0;
        int n2 = this.numEqn - 1;
        while (n < n2) {
            dArray[n] = this.interpolationCoeffs[0][n] + d2 * (this.interpolationCoeffs[1][n] + (d2 - c2m1) * (this.interpolationCoeffs[2][n] + (d2 - c1m1) * this.interpolationCoeffs[3][n]));
            ++n;
        }
        dArray[this.numEqn - 1] = d;
        return dArray;
    }

    public double[] bestInterpolate(double d, double[] dArray) {
        return this.interpolate(d, dArray);
    }

    protected void estimateNewtonInitialValue(double[][] dArray) {
        double d = this.actualStepSize / this.takenStepSize;
        double d2 = c1 * d;
        double d3 = c2 * d;
        int n = 0;
        while (n < this.numEqn) {
            dArray[0][n] = d2 * (this.interpolationCoeffs[1][n] + (d2 - c2m1) * (this.interpolationCoeffs[2][n] + (d2 - c1m1) * this.interpolationCoeffs[3][n]));
            dArray[1][n] = d3 * (this.interpolationCoeffs[1][n] + (d3 - c2m1) * (this.interpolationCoeffs[2][n] + (d3 - c1m1) * this.interpolationCoeffs[3][n]));
            dArray[2][n] = d * (this.interpolationCoeffs[1][n] + (d - c2m1) * (this.interpolationCoeffs[2][n] + (d - c1m1) * this.interpolationCoeffs[3][n]));
            ++n;
        }
    }
}

