/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.rk.irk;

import org.opensourcephysics.numerics.rk.irk.AlgebraicEquationSolver;
import org.opensourcephysics.numerics.rk.irk.IRKAlgebraicEquation;
import org.opensourcephysics.numerics.rk.irk.IRKSimplifiedNewtonStep;
import org.opensourcephysics.numerics.rk.irk.LAESolverLU;
import org.opensourcephysics.numerics.rk.irk.NewtonLastIterationErrorIsTooLarge;
import org.opensourcephysics.numerics.rk.irk.NewtonLostOfConvergence;

public class IRKSimplifiedNewton
extends IRKSimplifiedNewtonStep
implements AlgebraicEquationSolver {
    private int numEqn;
    private static final int maxIterations = 7;
    protected int nIteration = 0;
    private double[][] rightHand;
    private double[] tolerance;
    protected double thetaqOld;
    private double fnewt;
    private double convergenceRateOld = 1.0;
    private double faccon = 1.0;

    public IRKSimplifiedNewton(IRKAlgebraicEquation iRKAlgebraicEquation) {
        super(iRKAlgebraicEquation);
        this.initialize(iRKAlgebraicEquation);
    }

    public IRKSimplifiedNewton(IRKAlgebraicEquation iRKAlgebraicEquation, LAESolverLU lAESolverLU) {
        super(iRKAlgebraicEquation, lAESolverLU);
        this.initialize(iRKAlgebraicEquation);
    }

    private void initialize(IRKAlgebraicEquation iRKAlgebraicEquation) {
        this.numEqn = iRKAlgebraicEquation.getApproximation()[0].length;
        this.rightHand = super.getSubstitutedApproximationIncrement();
        this.tolerance = new double[this.numEqn];
        int n = 0;
        while (n < this.numEqn) {
            this.setTolerance(n, 1.0E-6);
            ++n;
        }
    }

    public double resolve() throws NewtonLostOfConvergence, NewtonLastIterationErrorIsTooLarge {
        double d;
        this.nIteration = 0;
        this.faccon = Math.pow(Math.max(this.faccon, this.uround), 0.8);
        double d2 = 0.001;
        do {
            ++this.nIteration;
            double d3 = super.singleStep();
            d = this.estimateIncrementNorm(this.rightHand);
            if (1 < this.nIteration && this.nIteration < 7) {
                d2 = this.nIteration == 2 ? d3 : Math.sqrt(d3 * this.convergenceRateOld);
                this.convergenceRateOld = d3;
                if (d2 > 0.99) {
                    throw new NewtonLostOfConvergence(this.nIteration, d2);
                }
                this.faccon = d2 / (1.0 - d2);
                double d4 = this.predictLastIterationError(d, d2);
                if (d4 > 1.0) {
                    throw new NewtonLastIterationErrorIsTooLarge(this.nIteration, 7, d4);
                }
            }
            super.commitStep();
        } while (!this.convergenceAchieved(d, d2));
        return d2;
    }

    protected double estimateIncrementNorm(double[][] dArray) {
        double d = 0.0;
        int n = 0;
        while (n < this.numEqn) {
            int n2 = 0;
            while (n2 < 3) {
                d += Math.pow(dArray[n2][n] / this.tolerance[n], 2.0);
                ++n2;
            }
            ++n;
        }
        return Math.sqrt(d / (double)(3 * this.numEqn));
    }

    private double predictLastIterationError(double d, double d2) {
        return d2 / (1.0 - d2) * d * Math.pow(d2, 6 - this.nIteration) / this.fnewt;
    }

    private boolean convergenceAchieved(double d, double d2) {
        return this.faccon * d < this.fnewt;
    }

    void setFNewton(double d) {
        this.fnewt = d;
    }

    public double getTolerance(int n) {
        return this.tolerance[n];
    }

    public void setTolerance(int n, double d) {
        this.tolerance[n] = d;
    }
}

