/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.rk.irk;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.rk.irk.AlgebraicEquationSimpleSolver;
import org.opensourcephysics.numerics.rk.irk.IRKAlgebraicEquation;
import org.opensourcephysics.numerics.rk.irk.IRKSimplifiedNewtonStep;

public class Radau5Light {
    protected ODE ode;
    private double initialStepSize = 1.0E-6;
    protected double actualStepSize = 1.0E-6;
    protected double maximumStepSize = Double.POSITIVE_INFINITY;
    protected int numEqn;
    protected int jacobianAge = 0;
    protected double[] state;
    protected double[] rate;
    protected double[][] intermediateStagesIncrement;
    protected AlgebraicEquationSimpleSolver aeSolver;
    protected static int maxNewtonIterations = 7;

    public Radau5Light(ODE oDE) {
        this.ode = oDE;
    }

    public final ODE getODE() {
        return this.ode;
    }

    public final long getCounter() {
        return -1L;
    }

    protected void allocateArrays(int n) {
        this.state = new double[n];
        this.rate = new double[n];
        this.intermediateStagesIncrement = new double[3][n];
    }

    public final void setStepSize(double d) {
        this.initialStepSize = d;
    }

    public void setMaximumStepSize(double d) {
        this.maximumStepSize = Math.abs(d);
    }

    protected final double limitStepSize(double d) {
        if (d >= 0.0) {
            return Math.min(d, this.maximumStepSize);
        }
        return Math.max(d, -this.maximumStepSize);
    }

    public final double getStepSize() {
        return this.initialStepSize;
    }

    public final void initialize(double d) {
        this.initialStepSize = d;
        this.actualStepSize = this.limitStepSize(this.initialStepSize);
        double[] dArray = this.ode.getState();
        if (this.state == null || this.state.length != dArray.length) {
            this.numEqn = dArray.length;
            this.allocateArrays(this.numEqn);
        }
        this.aeSolver = this.getInnerSolver(new DifferenceSchemeEquation(this.numEqn));
        this.reinitialize(dArray);
    }

    public void reinitialize(double[] dArray) {
        this.actualStepSize = this.limitStepSize(this.initialStepSize);
        System.arraycopy(dArray, 0, this.state, 0, this.numEqn);
        this.ode.getRate(this.state, this.rate);
        this.aeSolver.restart(false);
    }

    protected AlgebraicEquationSimpleSolver getInnerSolver(IRKAlgebraicEquation iRKAlgebraicEquation) {
        return new IRKSimplifiedNewtonStep(iRKAlgebraicEquation);
    }

    protected void preStepPreparations() {
        this.ode.getRate(this.state, this.rate);
    }

    protected void performStep() {
        double d = 0.0;
        int n = 0;
        while (n < maxNewtonIterations) {
            d += this.aeSolver.resolve() / (double)maxNewtonIterations;
            ++n;
        }
        this.aeSolver.restart(d > 0.001);
    }

    protected void commitStepResults() {
        int n = 0;
        while (n < this.numEqn) {
            int n2 = n;
            this.state[n2] = this.state[n2] + this.intermediateStagesIncrement[2][n];
            ++n;
        }
    }

    protected class DifferenceSchemeEquation
    implements IRKAlgebraicEquation {
        private double[] realEigenvalues = new double[]{3.6378342527444962};
        private double[] complexEigenvalues = new double[]{2.6810828736277523, 3.0504301992474105};
        private double[][] T = new double[][]{{0.09123239487089295, -0.1412552950209542, -0.030029194105147424}, {0.241717932707107, 0.20412935229379994, 0.3829421127572619}, {0.966048182615093, 1.0, 0.0}};
        private double[][] inverseT = new double[][]{{4.325579890063155, 0.33919925181580984, 0.5417705399358749}, {-4.178718591551905, -0.32768282076106237, 0.47662355450055044}, {-0.5028726349457868, 2.571926949855605, -0.5960392048282249}};
        private int nStgs = 3;
        private double[] someState;
        private double[] someRate;
        double uRound = 2.220446049250313E-16;

        public DifferenceSchemeEquation(int n) {
            this.someState = new double[n];
            this.someRate = new double[n];
        }

        public double[][] getApproximation() {
            return Radau5Light.this.intermediateStagesIncrement;
        }

        public double[] getComplexEigenvalues() {
            return this.complexEigenvalues;
        }

        public double[] getRealEigenvalues() {
            return this.realEigenvalues;
        }

        public double getScalarMultiplier() {
            return 1.0 / Radau5Light.this.actualStepSize;
        }

        public void evaluateNonLinearComponent(double[] dArray, double[] dArray2) {
            int n = 0;
            while (n < Radau5Light.this.numEqn) {
                this.someState[n] = Radau5Light.this.state[n] + dArray[n];
                ++n;
            }
            Radau5Light.this.ode.getRate(this.someState, dArray2);
        }

        public void evaluateNonLinearComponentJacobian(double[] dArray, double[][] dArray2) {
            System.arraycopy(Radau5Light.this.state, 0, this.someState, 0, Radau5Light.this.numEqn);
            int n = 0;
            while (n < Radau5Light.this.numEqn) {
                double d = Math.sqrt(this.uRound * Math.max(1.0E-5, Math.abs(Radau5Light.this.state[n])));
                int n2 = n;
                this.someState[n2] = this.someState[n2] + d;
                Radau5Light.this.ode.getRate(this.someState, this.someRate);
                int n3 = n;
                this.someState[n3] = this.someState[n3] - d;
                int n4 = 0;
                while (n4 < Radau5Light.this.numEqn) {
                    dArray2[n4][n] = (this.someRate[n4] - Radau5Light.this.rate[n4]) / d;
                    ++n4;
                }
                ++n;
            }
            Radau5Light.this.jacobianAge = 0;
        }

        public void directChangeOfVariables(double[][] dArray, double[][] dArray2) {
            int n = 0;
            while (n < Radau5Light.this.numEqn) {
                int n2 = 0;
                while (n2 < this.nStgs) {
                    dArray2[n2][n] = 0.0;
                    int n3 = 0;
                    while (n3 < this.nStgs) {
                        double[] dArray3 = dArray2[n2];
                        int n4 = n;
                        dArray3[n4] = dArray3[n4] + this.inverseT[n2][n3] * dArray[n3][n];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }

        public void inverseChangeOfVariables(double[][] dArray, double[][] dArray2) {
            int n = 0;
            while (n < Radau5Light.this.numEqn) {
                int n2 = 0;
                while (n2 < this.nStgs) {
                    dArray2[n2][n] = 0.0;
                    int n3 = 0;
                    while (n3 < this.nStgs) {
                        double[] dArray3 = dArray2[n2];
                        int n4 = n;
                        dArray3[n4] = dArray3[n4] + this.T[n2][n3] * dArray[n3][n];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }
}

