/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.specialfunctions;

import java.util.ArrayList;
import org.opensourcephysics.numerics.Polynomial;
import org.opensourcephysics.numerics.specialfunctions.Messages;

public class Chebyshev {
    static final ArrayList<Polynomial> chebyshevTList = new ArrayList();
    static final ArrayList<Polynomial> chebyshevUList = new ArrayList();

    static {
        Polynomial polynomial = new Polynomial(new double[]{1.0});
        chebyshevTList.add(polynomial);
        chebyshevUList.add(polynomial);
        polynomial = new Polynomial(new double[]{0.0, 1.0});
        chebyshevTList.add(polynomial);
        polynomial = new Polynomial(new double[]{0.0, 2.0});
        chebyshevUList.add(polynomial);
    }

    private Chebyshev() {
    }

    public static synchronized Polynomial getPolynomialT(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Messages.getString("Chebyshev.neg_degree"));
        }
        if (n < chebyshevTList.size()) {
            return chebyshevTList.get(n);
        }
        Polynomial polynomial = new Polynomial(new double[]{0.0, 2.0});
        Polynomial polynomial2 = polynomial.multiply(Chebyshev.getPolynomialT(n - 1)).subtract(Chebyshev.getPolynomialT(n - 2));
        chebyshevTList.add(polynomial2);
        return polynomial2;
    }

    public static synchronized Polynomial getPolynomialU(int n) {
        if (n < chebyshevUList.size()) {
            return chebyshevUList.get(n);
        }
        Polynomial polynomial = new Polynomial(new double[]{0.0, 2.0});
        Polynomial polynomial2 = polynomial.multiply(Chebyshev.getPolynomialU(n - 1)).subtract(Chebyshev.getPolynomialU(n - 2));
        chebyshevUList.add(polynomial2);
        return polynomial2;
    }
}

