/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.specialfunctions;

import org.opensourcephysics.numerics.Function;

public class Gamma
implements Function {
    public double evaluate(double d) {
        return Gamma.gamma(d);
    }

    public static double gamma(double d) {
        double[] dArray = new double[]{1.6011952247675185E-4, 0.0011913514700658638, 0.010421379756176158, 0.04763678004571372, 0.20744822764843598, 0.4942148268014971, 1.0};
        double[] dArray2 = new double[]{-2.3158187332412014E-5, 5.396055804933034E-4, -0.004456419138517973, 0.011813978522206043, 0.035823639860549865, -0.23459179571824335, 0.0714304917030273, 1.0};
        double d2 = 1.0;
        double d3 = Math.abs(d);
        if (d3 > 33.0) {
            double d4;
            if (d < 0.0) {
                int n = (int)Math.floor(d3);
                int n2 = Math.round(n);
                if (n2 % 2 == 0) {
                    d2 = -1.0;
                }
                if ((d4 = d3 - (double)n) > 0.5) {
                    d4 = d3 - (double)(++n);
                }
                d4 = d3 * Math.sin(Math.PI * d4);
                d4 = Math.abs(d4);
                d4 = Math.PI / (d4 * Gamma.gammastirf(d3));
            } else {
                d4 = Gamma.gammastirf(d);
            }
            double d5 = d2 * d4;
            return d5;
        }
        double d6 = 1.0;
        while (d >= 3.0) {
            d6 *= (d -= 1.0);
        }
        while (d < 0.0) {
            if (d > -1.0E-9) {
                double d7 = d6 / ((1.0 + 0.5772156649015329 * d) * d);
                return d7;
            }
            d6 /= d;
            d += 1.0;
        }
        while (d < 2.0) {
            if (d < 1.0E-9) {
                double d8 = d6 / ((1.0 + 0.5772156649015329 * d) * d);
                return d8;
            }
            d6 /= d;
            d += 1.0;
        }
        if (d == 2.0) {
            double d9 = d6;
            return d9;
        }
        d -= 2.0;
        double d10 = dArray[0];
        int n = 1;
        while (n < 7) {
            d10 = dArray[n] + d10 * d;
            ++n;
        }
        double d11 = dArray2[0];
        n = 1;
        while (n < 8) {
            d11 = dArray2[n] + d11 * d;
            ++n;
        }
        return d6 * d10 / d11;
    }

    private static double gammastirf(double d) {
        double d2 = 1.0 / d;
        double[] dArray = new double[]{7.873113957930937E-4, -2.2954996161337813E-4, -0.0026813261780578124, 0.0034722222160545866, 0.08333333333334822};
        double d3 = dArray[0];
        int n = 1;
        while (n < 5) {
            d3 = dArray[n] + d3 * d;
            ++n;
        }
        d2 = 1.0 + d2 * d3;
        double d4 = Math.exp(d);
        if (d > 143.01608) {
            double d5 = Math.pow(d, 0.5 * d - 0.25);
            d4 = d5 * (d5 / d4);
        } else {
            d4 = Math.pow(d, d - 0.5) / d4;
        }
        return 2.5066282746310007 * d4 * d2;
    }
}

