/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.opensourcephysics.controls.Cryptic;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTreePanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.JobManager;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;
import org.opensourcephysics.tools.ToolsRes;

public class EncryptionTool
extends JFrame
implements Tool {
    private static final String VERSION = " 1.0";
    private static Dimension dim = new Dimension(720, 500);
    private XMLTreePanel treePanel;
    private JPanel contentPane = new JPanel(new BorderLayout());
    private JobManager jobManager = new JobManager(this);
    private JTextField passwordField;
    private JCheckBox encryptedCheckBox;
    private JCheckBox previewCheckBox;
    private String fileName;
    private JMenuItem openItem;
    private JMenuItem saveItem;
    private JMenuItem saveAsItem;
    private JLabel passwordLabel;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuItem exitItem;
    private JMenuItem logItem;
    private JMenuItem aboutItem;
    private Icon openIcon;
    private JButton openButton;
    private Icon saveIcon;
    private JButton saveButton;
    private static final EncryptionTool ENCRYPTION_TOOL = new EncryptionTool();

    public static EncryptionTool getTool() {
        return ENCRYPTION_TOOL;
    }

    public EncryptionTool() {
        String string = "EncryptionTool";
        this.setName(string);
        this.createGUI();
        this.refreshGUI();
        Toolbox.addTool(string, this);
    }

    public EncryptionTool(String string) {
        this();
        this.open(string);
    }

    public String open(String string) {
        OSPLog.fine("opening " + string);
        XMLControlElement xMLControlElement = new XMLControlElement();
        xMLControlElement.setDecryptPolicy(5);
        xMLControlElement.read(string);
        if (xMLControlElement.failedToRead()) {
            return null;
        }
        String string2 = xMLControlElement.getPassword();
        if (string2 == null) {
            this.passwordField.setText(null);
            this.displayXML(xMLControlElement);
            this.encryptedCheckBox.setEnabled(true);
        } else if (this.passwordField.getText().equals(string2)) {
            this.displayXML(this.decrypt(xMLControlElement));
            this.encryptedCheckBox.setEnabled(true);
        } else {
            this.displayXML(xMLControlElement);
            this.encryptedCheckBox.setEnabled(false);
        }
        this.fileName = string;
        this.refreshGUI();
        return string;
    }

    public void send(Job job, Tool tool) throws RemoteException {
        XMLControlElement xMLControlElement = new XMLControlElement();
        xMLControlElement.setDecryptPolicy(5);
        xMLControlElement.readXML(job.getXML());
        if (xMLControlElement.failedToRead()) {
            return;
        }
        String string = xMLControlElement.getPassword();
        if (string == null) {
            this.passwordField.setText(null);
            this.displayXML(xMLControlElement);
        } else if (this.passwordField.getText().equals(string)) {
            this.displayXML(this.decrypt(xMLControlElement));
        } else {
            this.displayXML(xMLControlElement);
        }
        this.fileName = null;
        this.refreshGUI();
        this.jobManager.log(job, tool);
    }

    public void refreshGUI() {
        String string = ToolsRes.getString("EncryptionTool.Title");
        if (this.fileName != null) {
            string = String.valueOf(string) + ": " + this.fileName;
        }
        this.setTitle(string);
        this.openButton.setToolTipText(ToolsRes.getString("EncryptionTool.Button.Open.ToolTip"));
        this.saveButton.setToolTipText(ToolsRes.getString("EncryptionTool.Button.Save.ToolTip"));
        this.passwordLabel.setText(ToolsRes.getString("EncryptionTool.Label.Password"));
        this.passwordField.setToolTipText(ToolsRes.getString("EncryptionTool.PasswordField.ToolTip"));
        this.encryptedCheckBox.setText(ToolsRes.getString("EncryptionTool.CheckBox.Encrypted"));
        this.encryptedCheckBox.setToolTipText(ToolsRes.getString("EncryptionTool.CheckBox.Encrypted.ToolTip"));
        this.previewCheckBox.setText(ToolsRes.getString("EncryptionTool.CheckBox.Preview"));
        this.previewCheckBox.setToolTipText(ToolsRes.getString("EncryptionTool.CheckBox.Preview.ToolTip"));
        this.fileMenu.setText(ToolsRes.getString("EncryptionTool.Menu.File"));
        this.openItem.setText(ToolsRes.getString("EncryptionTool.MenuItem.Open"));
        this.saveItem.setText(ToolsRes.getString("EncryptionTool.MenuItem.Save"));
        this.saveAsItem.setText(ToolsRes.getString("EncryptionTool.MenuItem.SaveAs"));
        this.exitItem.setText(ToolsRes.getString("EncryptionTool.MenuItem.Exit"));
        this.helpMenu.setText(ToolsRes.getString("EncryptionTool.Menu.Help"));
        this.logItem.setText(ToolsRes.getString("EncryptionTool.MenuItem.Log"));
        this.aboutItem.setText(ToolsRes.getString("EncryptionTool.MenuItem.About"));
        this.saveButton.setEnabled(this.encryptedCheckBox.isEnabled());
        this.saveItem.setEnabled(this.encryptedCheckBox.isEnabled());
        this.saveAsItem.setEnabled(this.encryptedCheckBox.isEnabled());
        XMLControlElement xMLControlElement = this.getCurrentControl();
        this.encryptedCheckBox.setSelected(xMLControlElement != null && xMLControlElement.getPassword() != null);
        this.passwordLabel.setEnabled(this.encryptedCheckBox.isSelected());
        this.passwordField.setEnabled(this.encryptedCheckBox.isSelected());
        this.previewCheckBox.setEnabled(this.encryptedCheckBox.isEnabled() && this.encryptedCheckBox.isSelected());
        this.previewCheckBox.setSelected(xMLControlElement != null && xMLControlElement.getObjectClass() == Cryptic.class);
    }

    public static void main(String[] stringArray) {
        EncryptionTool encryptionTool = EncryptionTool.getTool();
        encryptionTool.setDefaultCloseOperation(3);
        encryptionTool.open("Untitled.xset");
        encryptionTool.setVisible(true);
    }

    private XMLControlElement getCurrentControl() {
        if (this.treePanel == null) {
            return null;
        }
        XMLControl xMLControl = this.treePanel.getControl();
        if (xMLControl instanceof XMLControlElement) {
            return (XMLControlElement)xMLControl;
        }
        return null;
    }

    private void displayXML(XMLControlElement xMLControlElement) {
        if (this.treePanel != null) {
            this.contentPane.remove(this.treePanel);
        }
        this.treePanel = new XMLTreePanel(xMLControlElement, false);
        this.contentPane.add((Component)this.treePanel, "Center");
        this.validate();
        this.refreshGUI();
    }

    private void setPassword(String string) {
        XMLControlElement xMLControlElement = this.getCurrentControl();
        if (xMLControlElement == null) {
            return;
        }
        String string2 = xMLControlElement.getPassword();
        if (!this.encryptedCheckBox.isEnabled()) {
            boolean bl = string.equals(string2);
            if (bl) {
                this.displayXML(this.decrypt(xMLControlElement));
                this.encryptedCheckBox.setEnabled(true);
            } else {
                Toolkit.getDefaultToolkit().beep();
                OSPLog.fine("Bad password: " + string);
            }
        } else if (xMLControlElement.getObjectClass() == Cryptic.class) {
            XMLControlElement xMLControlElement2 = this.decrypt(xMLControlElement);
            xMLControlElement2.setPassword(string);
            xMLControlElement2 = this.encrypt(xMLControlElement2);
            xMLControlElement.setValue("cryptic", xMLControlElement2.getString("cryptic"));
            this.treePanel.refresh();
        } else {
            if (string.equals("") && !this.encryptedCheckBox.isSelected()) {
                string = null;
            }
            xMLControlElement.setPassword(string);
            this.treePanel.refresh();
        }
        this.refreshGUI();
    }

    private XMLControlElement encrypt(XMLControlElement xMLControlElement) {
        if (xMLControlElement.getObjectClass() == Cryptic.class) {
            return xMLControlElement;
        }
        String string = xMLControlElement.toXML();
        Cryptic cryptic = new Cryptic(string);
        XMLControlElement xMLControlElement2 = new XMLControlElement(cryptic);
        xMLControlElement2.setPassword(xMLControlElement.getPassword());
        return xMLControlElement2;
    }

    private XMLControlElement decrypt(XMLControlElement xMLControlElement) {
        if (xMLControlElement.getObjectClass() != Cryptic.class) {
            return xMLControlElement;
        }
        Cryptic cryptic = (Cryptic)xMLControlElement.loadObject(null);
        String string = cryptic.decrypt();
        XMLControlElement xMLControlElement2 = new XMLControlElement(string);
        return xMLControlElement2;
    }

    private String open() {
        int n = OSPRuntime.getChooser().showOpenDialog(this);
        if (n == 0) {
            OSPRuntime.chooserDir = OSPRuntime.getChooser().getCurrentDirectory().toString();
            String string = OSPRuntime.getChooser().getSelectedFile().getAbsolutePath();
            string = XML.getRelativePath(string);
            return this.open(string);
        }
        return null;
    }

    private String save(String string) {
        XMLControlElement xMLControlElement;
        if (string == null || string.equals("")) {
            return null;
        }
        if (this.passwordField.getBackground() == Color.yellow) {
            this.passwordField.setBackground(Color.white);
            this.setPassword(this.passwordField.getText());
        }
        if ((xMLControlElement = this.getCurrentControl()) == null) {
            return null;
        }
        if (xMLControlElement.getObjectClass() == Cryptic.class) {
            xMLControlElement = this.decrypt(xMLControlElement);
        }
        if (xMLControlElement.write(string) == null) {
            return null;
        }
        this.fileName = string;
        this.refreshGUI();
        return string;
    }

    private String saveAs() {
        int n = OSPRuntime.getChooser().showSaveDialog(this);
        if (n == 0) {
            int n2;
            OSPRuntime.chooserDir = OSPRuntime.getChooser().getCurrentDirectory().toString();
            File file = OSPRuntime.getChooser().getSelectedFile();
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(null, String.valueOf(ToolsRes.getString("EncryptionTool.Dialog.ReplaceFile.Message")) + " " + file.getName() + "?", ToolsRes.getString("EncryptionTool.Dialog.ReplaceFile.Title"), 1)) != 0) {
                return null;
            }
            String string = file.getAbsolutePath();
            if (string == null || string.trim().equals("")) {
                return null;
            }
            return this.save(XML.getRelativePath(string));
        }
        return null;
    }

    private void createGUI() {
        this.contentPane.setPreferredSize(dim);
        this.setContentPane(this.contentPane);
        this.setDefaultCloseOperation(1);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.contentPane.add((Component)jToolBar, "North");
        String string = "/org/opensourcephysics/resources/tools/images/open.gif";
        this.openIcon = ResourceLoader.getIcon(string);
        this.openButton = new JButton(this.openIcon);
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EncryptionTool.this.open();
            }
        });
        jToolBar.add(this.openButton);
        string = "/org/opensourcephysics/resources/tools/images/save.gif";
        this.saveIcon = ResourceLoader.getIcon(string);
        this.saveButton = new JButton(this.saveIcon);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EncryptionTool.this.save(EncryptionTool.this.fileName);
            }
        });
        jToolBar.add(this.saveButton);
        jToolBar.addSeparator();
        this.passwordLabel = new JLabel();
        this.passwordLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.passwordField = new JTextField(20);
        this.passwordField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    EncryptionTool.this.passwordField.setBackground(Color.white);
                    EncryptionTool.this.setPassword(EncryptionTool.this.passwordField.getText());
                } else if (keyEvent.getKeyChar() != '\uffff') {
                    EncryptionTool.this.passwordField.setBackground(Color.yellow);
                }
            }
        });
        this.passwordField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (EncryptionTool.this.passwordField.getBackground() == Color.yellow) {
                    EncryptionTool.this.passwordField.setBackground(Color.white);
                    EncryptionTool.this.setPassword(EncryptionTool.this.passwordField.getText());
                }
            }
        });
        jToolBar.add(this.passwordLabel);
        jToolBar.add(this.passwordField);
        this.encryptedCheckBox = new JCheckBox("");
        this.encryptedCheckBox.setEnabled(false);
        this.encryptedCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EncryptionTool.this.encryptedCheckBox.isSelected()) {
                    EncryptionTool.this.setPassword(EncryptionTool.this.passwordField.getText());
                } else {
                    XMLControlElement xMLControlElement = EncryptionTool.this.getCurrentControl();
                    if (xMLControlElement.getObjectClass() == Cryptic.class) {
                        xMLControlElement = EncryptionTool.this.decrypt(xMLControlElement);
                        xMLControlElement.setPassword(null);
                        EncryptionTool.this.displayXML(xMLControlElement);
                    }
                    EncryptionTool.this.setPassword("");
                }
            }
        });
        this.encryptedCheckBox.setContentAreaFilled(false);
        jToolBar.add(this.encryptedCheckBox);
        this.previewCheckBox = new JCheckBox("");
        this.previewCheckBox.setOpaque(false);
        this.previewCheckBox.setEnabled(false);
        this.previewCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLControlElement xMLControlElement = EncryptionTool.this.getCurrentControl();
                if (EncryptionTool.this.previewCheckBox.isSelected()) {
                    EncryptionTool.this.displayXML(EncryptionTool.this.encrypt(xMLControlElement));
                } else {
                    EncryptionTool.this.displayXML(EncryptionTool.this.decrypt(xMLControlElement));
                }
            }
        });
        jToolBar.add(this.previewCheckBox);
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        jMenuBar.add(this.fileMenu);
        this.openItem = new JMenuItem();
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, n));
        this.openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EncryptionTool.this.open();
            }
        });
        this.fileMenu.add(this.openItem);
        this.fileMenu.addSeparator();
        this.saveItem = new JMenuItem();
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, n));
        this.saveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EncryptionTool.this.save(EncryptionTool.this.fileName);
            }
        });
        this.saveItem.setEnabled(false);
        this.fileMenu.add(this.saveItem);
        this.saveAsItem = new JMenuItem();
        this.saveAsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EncryptionTool.this.saveAs();
            }
        });
        this.saveAsItem.setEnabled(false);
        this.fileMenu.add(this.saveAsItem);
        this.exitItem = new JMenuItem(ToolsRes.getString("MenuItem.Exit"));
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, n));
        this.exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitItem);
        this.helpMenu = new JMenu();
        jMenuBar.add(this.helpMenu);
        this.logItem = new JMenuItem();
        this.logItem.setAccelerator(KeyStroke.getKeyStroke(76, n));
        this.logItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFrame jFrame = OSPLog.showLog();
                if (jFrame.getLocation().x == 0 && jFrame.getLocation().y == 0) {
                    Point point = EncryptionTool.this.getLocation();
                    jFrame.setLocation(point.x + 28, point.y + 28);
                }
            }
        });
        this.helpMenu.add(this.logItem);
        this.helpMenu.addSeparator();
        this.aboutItem = new JMenuItem();
        this.aboutItem.setAccelerator(KeyStroke.getKeyStroke(65, n));
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ToolsRes.getString("EncryptionTool.About.ToolName");
                String string2 = String.valueOf(string) + EncryptionTool.VERSION + XML.NEW_LINE + ToolsRes.getString("EncryptionTool.About.OSPName") + XML.NEW_LINE + "www.opensourcephysics.org";
                JOptionPane.showMessageDialog(EncryptionTool.this, string2, ToolsRes.getString("EncryptionTool.About.Title"), 1);
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.setJMenuBar(jMenuBar);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = (dimension.width - this.getBounds().width) / 2;
        int n3 = (dimension.height - this.getBounds().height) / 2;
        this.setLocation(n2, n3);
    }
}

