/*
 * Decompiled with CFR 0.152.
 */
package users.eckerd.coxaj.elec_distribution.ChargeRingTrajectory_pkg;

import java.awt.Dimension;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEInterpolatorEventSolver;
import org.opensourcephysics.numerics.ODESolverInterpolator;
import org.opensourcephysics.numerics.rk.CashKarp45;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataFull;
import users.eckerd.coxaj.elec_distribution.ChargeRingTrajectory_pkg.ChargeRingTrajectorySimulation;
import users.eckerd.coxaj.elec_distribution.ChargeRingTrajectory_pkg.ChargeRingTrajectoryView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChargeRingTrajectory
extends Model {
    public ChargeRingTrajectorySimulation _simulation = null;
    public ChargeRingTrajectoryView _view = null;
    public ChargeRingTrajectory _model = this;
    protected Hashtable<String, __PrivateODE> _privateOdesList = new Hashtable();
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public double t = 0.0;
    public double dt = 0.05;
    public double x = 5.0;
    public double y = 0.0;
    public double z = 0.0;
    public double vx = 0.0;
    public double vy = 0.0;
    public double vz = 0.0;
    public double size = 10.0;
    public int nCharges = 20;
    public double aRing = 8.0;
    public double[] yLocation;
    public double[] zLocation;
    public int n = 5;
    public double[][][] xField;
    public double[][][] yField;
    public double[][][] zField;
    public double[][][] eField;
    public boolean showE = true;
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_evolution1 = true;
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "/users/eckerd/coxaj/elec_distribution/ChargeRingTrajectory.xml";
    }

    public static String _getModelDirectory() {
        return "users/eckerd/coxaj/elec_distribution/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(437, 427);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("/users/eckerd/coxaj/elec_distribution/ChargeRingTrajectory/ChargeRingTrajectory.html");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/ChargeRingTrajectory/chargeRingTrajectory.jpg");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/ChargeRingTrajectory/ChargeRingTrajectoryLessonPlan.doc");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/ChargeRingTrajectory/ChargeRingTrajectoryStudentWorksheet.doc");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/ChargeRingTrajectory/ChargeRingTrajectoryStudentWorksheet.pdf");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/ChargeRingTrajectory/ejsPage.css");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/ChargeRingTrajectory/ChargeRingTrajectory.html");
        return hashSet;
    }

    public static void _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/eckerd/coxaj/elec_distribution/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/EJS_4.2/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("C:/EJS_4.2/bin/config/");
        }
    }

    public static void main(String[] stringArray) {
        ChargeRingTrajectory._common_initialization(stringArray);
        ChargeRingTrajectory chargeRingTrajectory = new ChargeRingTrajectory(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        ChargeRingTrajectory._common_initialization(stringArray);
        ChargeRingTrajectory chargeRingTrajectory = new ChargeRingTrajectory("ChargeRing", jFrame, null, null, stringArray, true);
        return (JComponent)chargeRingTrajectory._getView().getComponent("ChargeRing");
    }

    public ChargeRingTrajectory() {
        this(null, null, null, null, null, false);
    }

    public ChargeRingTrajectory(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public ChargeRingTrajectory(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new ChargeRingTrajectorySimulation(this, string, frame, uRL, bl);
        this._view = (ChargeRingTrajectoryView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        this._isEnabled_initialization1 = true;
        this._isEnabled_evolution1 = true;
        this.t = 0.0;
        this.dt = 0.05;
        this.x = 5.0;
        this.y = 0.0;
        this.z = 0.0;
        this.vx = 0.0;
        this.vy = 0.0;
        this.vz = 0.0;
        this.size = 10.0;
        this.nCharges = 20;
        this.aRing = 8.0;
        this.yLocation = new double[this.nCharges];
        this.zLocation = new double[this.nCharges];
        this.n = 5;
        this.xField = new double[this.n][this.n][this.n];
        this.yField = new double[this.n][this.n][this.n];
        this.zField = new double[this.n][this.n][this.n];
        this.eField = new double[this.n][this.n][this.n];
        this.showE = true;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public void _initializeModel() {
        if (this._isEnabled_initialization1) {
            this._initialization1();
        }
        for (__PrivateODE __PrivateODE2 : this._privateOdesList.values()) {
            __PrivateODE2.__initializeSolver();
        }
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.__resetSolver();
        this._external.resetIC();
    }

    @Override
    public void _stepModel() {
        if (this._isEnabled_evolution1) {
            this._ODEi_evolution1.__stepODE();
        }
    }

    @Override
    public void _updateModel() {
    }

    @Override
    public void _freeMemory() {
        this.yLocation = null;
        this.zLocation = null;
        this.xField = null;
        this.yField = null;
        this.zField = null;
        this.eField = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    public ODEInterpolatorEventSolver _getEventSolver(String string) {
        try {
            return this._privateOdesList.get(string).__getEventSolver();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void _setSolverClass(String string, Class<?> clazz) {
        try {
            this._privateOdesList.get(string).__setSolverClass(clazz);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
        }
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Init Page".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("Evol Page".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1 = bl;
            this._resetSolvers();
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        this.t = 0.0;
        double d = Math.PI * 2 / (double)this.nCharges;
        for (int i = 0; i < this.nCharges; ++i) {
            this.yLocation[i] = this.aRing * Math.cos(d * (double)i);
            this.zLocation[i] = this.aRing * Math.sin(d * (double)i);
        }
        this.showField();
    }

    public void showField() {
        double[] dArray = new double[3];
        for (int i = 0; i < this.n; ++i) {
            double d = this._view.vectorField3D.indexToX(i);
            for (int j = 0; j < this.n; ++j) {
                double d2 = this._view.vectorField3D.indexToY(j);
                for (int k = 0; k < this.n; ++k) {
                    double d3 = this._view.vectorField3D.indexToZ(k);
                    dArray = this.getE(d, d2, d3);
                    this.xField[i][j][k] = dArray[0];
                    this.yField[i][j][k] = dArray[1];
                    this.zField[i][j][k] = dArray[2];
                    this.eField[i][j][k] = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
                }
            }
        }
    }

    public double[] getE(double d, double d2, double d3) {
        double[] dArray = new double[3];
        for (int i = 0; i < this.nCharges; ++i) {
            double d4 = d2 - this.yLocation[i];
            double d5 = d3 - this.zLocation[i];
            double d6 = d * d + d4 * d4 + d5 * d5;
            double d7 = Math.sqrt(d6);
            double d8 = d6 * d7;
            dArray[0] = dArray[0] + -10.0 * d / d8;
            dArray[1] = dArray[1] + -10.0 * d4 / d8;
            dArray[2] = dArray[2] + -10.0 * d5 / d8;
        }
        return dArray;
    }

    public double _method_for_drawingPanelCharges_minimumX() {
        return -this.size;
    }

    public double _method_for_drawingPanelCharges_minimumY() {
        return -this.size;
    }

    public double _method_for_drawingPanelCharges_minimumZ() {
        return -this.size;
    }

    public double _method_for_vectorField3D_minimumX() {
        return -0.9 * this.size;
    }

    public double _method_for_vectorField3D_maximumX() {
        return 0.9 * this.size;
    }

    public double _method_for_vectorField3D_minimumY() {
        return -0.9 * this.size;
    }

    public double _method_for_vectorField3D_maximumY() {
        return 0.9 * this.size;
    }

    public double _method_for_vectorField3D_minimumZ() {
        return -0.9 * this.size;
    }

    public double _method_for_vectorField3D_maximumZ() {
        return 0.9 * this.size;
    }

    public boolean _method_for_testCharge_enabledPosition() {
        return this._isPaused();
    }

    public void _method_for_playPauseButton_actionOn() {
        this._play();
    }

    public void _method_for_playPauseButton_actionOff() {
        this._pause();
    }

    public void _method_for_stepButton_action() {
        this._step();
    }

    public void _method_for_resetButton_action() {
        this._reset();
    }

    public void _method_for_pdfButton_action() {
        this._view.showDocument("./ChargeRingTrajectory/ChargeRingTrajectoryStudentWorksheet.pdf");
    }

    public void _method_for_ringRadiusSlider_action() {
        this._initialize();
    }

    public void _method_for_ringRadiusField_action() {
        this.aRing = Math.max(this.aRing, 2.0);
        this.aRing = Math.min(this.aRing, 10.0);
        this._initialize();
    }

    public boolean _method_for_xField_editable() {
        return this._isPaused();
    }

    public boolean _method_for_vxField_editable() {
        return this._isPaused();
    }

    public boolean _method_for_yField_editable() {
        return this._isPaused();
    }

    public boolean _method_for_zField_editable() {
        return this._isPaused();
    }

    public boolean _method_for_vzField_editable() {
        return this._isPaused();
    }

    public void _method_for_dataToolButton_action() {
        this._tools.showDataTool(this._view.xTrail);
    }

    public void _method_for_clearButton_action() {
        this._view.clearData();
    }

    static {
        ToolForData.setTool(new ToolForDataFull());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _ODE_evolution1
    implements __PrivateODE {
        private ODESolverInterpolator __solver = null;
        private ODEInterpolatorEventSolver __eventSolver = null;
        private Class<?> __solverClass = CashKarp45.class;
        private double[] __state = null;
        private boolean __ignoreErrors = false;
        private boolean __mustReinitialize = true;

        _ODE_evolution1() {
            this.__instantiateSolver();
            ChargeRingTrajectory.this._privateOdesList.put("Evol Page", this);
        }

        @Override
        public ODEInterpolatorEventSolver __getEventSolver() {
            return this.__eventSolver;
        }

        @Override
        public void __setSolverClass(Class<?> clazz) {
            this.__solverClass = clazz;
            this.__instantiateSolver();
        }

        private void __instantiateSolver() {
            this.__state = new double[7];
            this.__pushState();
            try {
                Class[] classArray = new Class[]{ODE.class};
                Object[] objectArray = new Object[]{this};
                Constructor<?> constructor = this.__solverClass.getDeclaredConstructor(classArray);
                this.__solver = (ODESolverInterpolator)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.__eventSolver = new ODEInterpolatorEventSolver(this.__solver);
        }

        @Override
        public void __initializeSolver() {
            this.__pushState();
            this.__eventSolver.initialize(0.05);
            this.__eventSolver.setBestInterpolation(false);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.setEstimateFirstStep(false);
            this.__eventSolver.setEnableExceptions(false);
            this.__eventSolver.setTolerances(1.0E-5, 1.0E-5);
            this.__mustReinitialize = true;
        }

        private void __pushState() {
            int n = 0;
            if (this.__state[n] != ChargeRingTrajectory.this.x) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = ChargeRingTrajectory.this.x;
            if (this.__state[n] != ChargeRingTrajectory.this.vx) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = ChargeRingTrajectory.this.vx;
            if (this.__state[n] != ChargeRingTrajectory.this.y) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = ChargeRingTrajectory.this.y;
            if (this.__state[n] != ChargeRingTrajectory.this.vy) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = ChargeRingTrajectory.this.vy;
            if (this.__state[n] != ChargeRingTrajectory.this.z) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = ChargeRingTrajectory.this.z;
            if (this.__state[n] != ChargeRingTrajectory.this.vz) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = ChargeRingTrajectory.this.vz;
            if (this.__state[n] != ChargeRingTrajectory.this.t) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = ChargeRingTrajectory.this.t;
        }

        public void __resetSolver() {
            this.__mustReinitialize = true;
        }

        private void __errorAction() {
            if (this.__ignoreErrors) {
                return;
            }
            System.err.println(this.__eventSolver.getErrorMessage());
            ChargeRingTrajectorySimulation cfr_ignored_0 = ChargeRingTrajectory.this._simulation;
            ChargeRingTrajectorySimulation cfr_ignored_1 = ChargeRingTrajectory.this._simulation;
            int n = JOptionPane.showConfirmDialog(ChargeRingTrajectory.this._view.getComponent(ChargeRingTrajectory.this._simulation.getMainWindow()), ChargeRingTrajectorySimulation.getEjsString("ODEError.Continue"), ChargeRingTrajectorySimulation.getEjsString("Error"), 1);
            if (n == 0) {
                this.__ignoreErrors = true;
            } else if (n == 2) {
                ChargeRingTrajectory.this._pause();
            }
        }

        void __stepODE() {
            this.__eventSolver.setStepSize(0.05);
            this.__eventSolver.setInternalStepSize(0.05);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.setTolerances(1.0E-5, 1.0E-5);
            this.__pushState();
            if (this.__mustReinitialize) {
                this.__eventSolver.reinitialize();
                this.__mustReinitialize = false;
            }
            double d = this.__eventSolver.step();
            int n = 0;
            ChargeRingTrajectory.this.x = this.__state[n++];
            ChargeRingTrajectory.this.vx = this.__state[n++];
            ChargeRingTrajectory.this.y = this.__state[n++];
            ChargeRingTrajectory.this.vy = this.__state[n++];
            ChargeRingTrajectory.this.z = this.__state[n++];
            ChargeRingTrajectory.this.vz = this.__state[n++];
            ChargeRingTrajectory.this.t = this.__state[n++];
            if (Double.isNaN(d)) {
                this.__errorAction();
            }
        }

        @Override
        public double[] getState() {
            return this.__state;
        }

        @Override
        public void getRate(double[] dArray, double[] dArray2) {
            dArray2[dArray2.length - 1] = 0.0;
            int n = -1;
            int n2 = 0;
            double d = dArray[n2++];
            double d2 = dArray[n2++];
            double d3 = dArray[n2++];
            double d4 = dArray[n2++];
            double d5 = dArray[n2++];
            double d6 = dArray[n2++];
            double d7 = dArray[n2++];
            double[] dArray3 = ChargeRingTrajectory.this.getE(d, d3, d5);
            double d8 = dArray3[0];
            double d9 = dArray3[1];
            double d10 = dArray3[2];
            n2 = 0;
            dArray2[n2++] = d2;
            dArray2[n2++] = d8;
            dArray2[n2++] = d4;
            dArray2[n2++] = d9;
            dArray2[n2++] = d6;
            dArray2[n2++] = d10;
            dArray2[n2++] = 1.0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface __PrivateODE
    extends ODE {
        public ODEInterpolatorEventSolver __getEventSolver();

        public void __setSolverClass(Class<?> var1);

        public void __initializeSolver();
    }
}

