/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing3d.ControlSet3D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementArrow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlArrowSet3D
extends ControlSet3D {
    private static final int ARROWSET_PROPERTIES_ADDED = 1;
    static List<String> infoList = null;

    @Override
    protected int getPropertiesAddedToSet() {
        return 1;
    }

    @Override
    protected Element createAnElement() {
        ElementArrow elementArrow = new ElementArrow();
        return elementArrow;
    }

    @Override
    protected void copyAnElement(Element element, Element element2) {
        super.copyAnElement(element, element2);
        ((ElementArrow)element2).setArrowType(((ElementArrow)element).getArrowType());
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("style");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("style")) {
            return "ArrowStyle|int|int[]";
        }
        if (string.equals("elementposition")) {
            return "ArrowPosition|int|int[]";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n2 = 0;
                    int n3 = Math.min(this.numElements, nArray.length);
                    while (n2 < n3) {
                        ((ElementArrow)this.elements[n2]).setArrowType(nArray[n2]);
                        ++n2;
                    }
                } else {
                    int n4 = value.getInteger();
                    int n5 = 0;
                    while (n5 < this.numElements) {
                        ((ElementArrow)this.elements[n5]).setArrowType(n4);
                        ++n5;
                    }
                }
                break;
            }
            default: {
                super.setValue(n - 1, value);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                int n2 = 0;
                while (n2 < this.numElements) {
                    ((ElementArrow)this.elements[n2]).setArrowType(0);
                    ++n2;
                }
                break;
            }
            default: {
                super.setDefaultValue(n - 1);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "ARROW";
            }
        }
        return super.getDefaultValueString(n - 1);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return null;
            }
        }
        return super.getValue(n - 1);
    }
}

