/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import org.opensourcephysics.drawing3d.ElementCylinder;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;

public class Java3dElementCylinder
extends Java3dElement {
    private Cylinder cylinder;
    private TransformGroup tg;
    private BranchGroup bg;
    private Transform3D t = new Transform3D();
    private Transform3D tq;
    private Quat4d quat;
    double[][][] standardCylinder;
    private int nr = 0;
    private int nu = 0;
    private int nv = 0;

    public Java3dElementCylinder(ElementCylinder elementCylinder) {
        super(elementCylinder);
        this.t.rotX(-1.5707963267948966);
        this.quat = new Quat4d(this.element.getPanel().getCamera().getQuatMapping());
        this.tq = new Transform3D();
        this.tq.set(this.quat);
        this.t.mul(this.tq);
        this.tg = new TransformGroup();
        this.tg.setCapability(14);
        this.tg.setCapability(13);
        this.tg.setTransform(this.t);
    }

    public void processChanges(int n, int n2) {
        super.processChanges(n, n2);
        if ((n & 0x10) != 0) {
            int n3;
            int n4;
            if (this.element.getStyle().getResolution().getType() == 1) {
                n4 = (int)Math.floor(Math.min(this.element.getSizeX(), this.element.getSizeZ()) / this.element.getStyle().getResolution().getMaxLength());
                n3 = (int)Math.floor(this.element.getSizeY() / this.element.getStyle().getResolution().getMaxLength());
            } else {
                n4 = this.element.getStyle().getResolution().getN2();
                n3 = this.element.getStyle().getResolution().getN3();
            }
            n4 = Math.max(3, n4);
            this.nr = this.nv = (n3 = Math.max(1, n3));
            this.nu = n4;
            if (((ElementCylinder)this.element).checkStandarCylinder() && this.element.getStyle().isDrawingFill()) {
                this.primitive = true;
                this.createPrimitiveCylinder();
            } else {
                this.primitive = false;
                this.createTileCylinder();
            }
            this.styleChanged(10);
        }
        if ((n & 8) != 0) {
            if (((ElementCylinder)this.element).checkStandarCylinder() && this.element.getStyle().isDrawingFill()) {
                if (this.primitive) {
                    return;
                }
                this.primitive = true;
                this.createPrimitiveCylinder();
            } else {
                this.primitive = false;
                this.createTileCylinder();
            }
            this.styleChanged(10);
        }
    }

    private void createTileCylinder() {
        this.standardCylinder = ElementCylinder.createStandardCylinder(this.nr, this.nu, this.nv, ((ElementCylinder)this.element).getMinimumAngle(), ((ElementCylinder)this.element).getMaximumAngle(), ((ElementCylinder)this.element).isClosedTop(), ((ElementCylinder)this.element).isClosedBottom(), ((ElementCylinder)this.element).isClosedLeft(), ((ElementCylinder)this.element).isClosedRight());
        int n = this.standardCylinder.length;
        int n2 = this.standardCylinder[0].length;
        Point3d[] point3dArray = new Point3d[n * n2 * 2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                point3dArray[n3 * n2 + n4 + n * n2] = new Point3d(this.standardCylinder[n3][n4][0], this.standardCylinder[n3][n4][1], this.standardCylinder[n3][n4][2]);
                if (n4 == 0) {
                    point3dArray[n3 * n2 + n4 + 3] = new Point3d(this.standardCylinder[n3][n4][0], this.standardCylinder[n3][n4][1], this.standardCylinder[n3][n4][2]);
                } else if (n4 == 1) {
                    point3dArray[n3 * n2 + n4 + 1] = new Point3d(this.standardCylinder[n3][n4][0], this.standardCylinder[n3][n4][1], this.standardCylinder[n3][n4][2]);
                } else if (n4 == 2) {
                    point3dArray[n3 * n2 + n4 - 1] = new Point3d(this.standardCylinder[n3][n4][0], this.standardCylinder[n3][n4][1], this.standardCylinder[n3][n4][2]);
                } else {
                    point3dArray[n3 * n2 + n4 - 3] = new Point3d(this.standardCylinder[n3][n4][0], this.standardCylinder[n3][n4][1], this.standardCylinder[n3][n4][2]);
                }
                ++n4;
            }
            ++n3;
        }
        GeometryInfo geometryInfo = new GeometryInfo(2);
        geometryInfo.setCoordinates(point3dArray);
        NormalGenerator normalGenerator = new NormalGenerator();
        normalGenerator.setCreaseAngle((double)((float)Math.toRadians(40.0)));
        normalGenerator.generateNormals(geometryInfo);
        GeometryArray geometryArray = geometryInfo.getGeometryArray();
        Shape3D shape3D = new Shape3D((Geometry)geometryArray, this.getAppearance());
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.addChild((Node)shape3D);
        this.tg = new TransformGroup();
        this.tg.setCapability(14);
        this.tg.setCapability(13);
        if (this.quat.z != 0.0 && this.quat.w != 0.0) {
            this.quat.y = -this.quat.z;
            this.quat.z = 0.0;
            this.tq.set(this.quat);
        }
        this.tg.setTransform(this.tq);
        this.tg.addChild((Node)this.bg);
        this.addNode((Node)this.tg);
    }

    private void createPrimitiveCylinder() {
        if (this.cylinder != null || this.standardCylinder != null) {
            this.tg.removeChild((Node)this.bg);
        }
        this.cylinder = new Cylinder(0.5f, 1.0f, 35, this.nu, this.nr, this.getAppearance());
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.addChild((Node)this.cylinder);
        this.tg = new TransformGroup();
        this.tg.setCapability(14);
        this.tg.setCapability(13);
        this.tg.setTransform(this.t);
        this.tg.addChild((Node)this.bg);
        this.addNode((Node)this.tg);
    }

    public void styleChanged(int n) {
        super.styleChanged(n);
        if (n == 4 || n == 3) {
            if (this.element.getStyle().isDrawingLines() && !this.element.getStyle().isDrawingFill()) {
                if (this.nr == 0 && this.nv == 0 && this.nu == 0) {
                    this.processChanges(16, 0);
                }
                this.primitive = false;
                this.createTileCylinder();
            }
            if (this.element.getStyle().isDrawingFill() && ((ElementCylinder)this.element).checkStandarCylinder()) {
                if (this.primitive) {
                    return;
                }
                if (this.nr == 0 && this.nv == 0 && this.nu == 0) {
                    this.processChanges(16, 0);
                }
                this.primitive = true;
                this.createPrimitiveCylinder();
            }
        }
    }

    public boolean isPrimitive() {
        return this.primitive;
    }
}

