/*
 * Decompiled with CFR 0.152.
 */
package users.eckerd.coxaj.intro.FaradayLoopChangingField_pkg;

import java.awt.Dimension;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.colos.ejs.library.utils.HtmlPageInfo;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.TranslatorUtil;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.eckerd.coxaj.intro.FaradayLoopChangingField_pkg.FaradayLoopChangingFieldSimulation;
import users.eckerd.coxaj.intro.FaradayLoopChangingField_pkg.FaradayLoopChangingFieldView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaradayLoopChangingField
extends Model {
    public FaradayLoopChangingFieldSimulation _simulation = null;
    public FaradayLoopChangingFieldView _view = null;
    public FaradayLoopChangingField _model = this;
    private static Map<String, Set<HtmlPageInfo>> __htmlPagesMap;
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public double dt = 0.1;
    public double t = 0.0;
    public double Bx = 0.0;
    public double BxOld = 0.0;
    public double r = 1.0;
    public int angle = 90;
    public double emf = 0.0;
    public int i = 3;
    public double[] xLocation;
    public double[] yLocation;
    public double[][] Location;
    public String transform = "";
    public boolean sinWave = true;
    public boolean squareWave = false;
    public boolean triangleWave = false;
    public double yRange = 1.0;
    public int yExp = 0;
    public double w = 901.0;
    public double BAmplitude = 1.0;
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_evolution1 = true;
    private boolean _isEnabled_constraints1 = true;

    public static void _addHtmlPageInfo(String string, String string2, String string3, String string4) {
        LocaleItem localeItem;
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            set = new HashSet<HtmlPageInfo>();
            __htmlPagesMap.put(string, set);
        }
        if ((localeItem = LocaleItem.getLocaleItem(string2)) != null) {
            set.add(new HtmlPageInfo(localeItem, string3, string4));
        }
    }

    public static HtmlPageInfo _getHtmlPageClassInfo(String string, LocaleItem localeItem) {
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            return null;
        }
        HtmlPageInfo htmlPageInfo = null;
        for (HtmlPageInfo htmlPageInfo2 : set) {
            if (htmlPageInfo2.getLocaleItem().isDefaultItem()) {
                htmlPageInfo = htmlPageInfo2;
            }
            if (!htmlPageInfo2.getLocaleItem().equals(localeItem)) continue;
            return htmlPageInfo2;
        }
        return htmlPageInfo;
    }

    @Override
    public HtmlPageInfo _getHtmlPageInfo(String string, LocaleItem localeItem) {
        return FaradayLoopChangingField._getHtmlPageClassInfo(string, localeItem);
    }

    public static String _getEjsModel() {
        return "/users/eckerd/coxaj/intro/FaradayLoopChangingField.ejs";
    }

    public static String _getModelDirectory() {
        return "users/eckerd/coxaj/intro/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(510, 446);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("/users/eckerd/coxaj/intro/FaradayLoopField/FaradayLoopChangingField.html");
        return hashSet;
    }

    public static boolean _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/eckerd/coxaj/intro/");
        n = 0;
        boolean bl2 = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                bl2 = true;
                Simulation.setPathToLibrary("C:/EJS_4.3.4/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("C:/EJS_4.3.4/bin/config/");
        }
        FaradayLoopChangingField._addHtmlPageInfo("Intro Page", "_default_", "Intro Page", "/users/eckerd/coxaj/intro/FaradayLoopField/FaradayLoopChangingField.html");
        if (!bl2) {
            // empty if block
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (!FaradayLoopChangingField._common_initialization(stringArray)) {
            if (OSPRuntime.isLauncherMode()) {
                return;
            }
            System.exit(-1);
        }
        FaradayLoopChangingField faradayLoopChangingField = new FaradayLoopChangingField(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        if (!FaradayLoopChangingField._common_initialization(stringArray)) {
            return null;
        }
        FaradayLoopChangingField faradayLoopChangingField = new FaradayLoopChangingField("plottingFrame", jFrame, null, null, stringArray, true);
        return (JComponent)faradayLoopChangingField._getView().getComponent("plottingFrame");
    }

    public FaradayLoopChangingField() {
        this(null, null, null, null, null, false);
    }

    public FaradayLoopChangingField(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public FaradayLoopChangingField(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new FaradayLoopChangingFieldSimulation(this, string, frame, uRL, bl);
        this._view = (FaradayLoopChangingFieldView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public String _getClassEjsModel() {
        return FaradayLoopChangingField._getEjsModel();
    }

    @Override
    public Set<String> _getClassEjsResources() {
        return FaradayLoopChangingField._getEjsResources();
    }

    @Override
    public String _getClassModelDirectory() {
        return FaradayLoopChangingField._getModelDirectory();
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        this._isEnabled_initialization1 = true;
        this._isEnabled_evolution1 = true;
        this._isEnabled_constraints1 = true;
        this.dt = 0.1;
        this.t = 0.0;
        this.Bx = 0.0;
        this.BxOld = 0.0;
        this.r = 1.0;
        this.angle = 90;
        this.emf = 0.0;
        this.i = 3;
        this.xLocation = new double[this.i * this.i];
        this.yLocation = new double[this.i * this.i];
        this.Location = new double[this.i * this.i * this.i][3];
        this.sinWave = true;
        this.squareWave = false;
        this.triangleWave = false;
        this.yRange = 1.0;
        this.yExp = 0;
        this.w = 901.0;
        this.BAmplitude = 1.0;
    }

    public void _initializeSolvers() {
    }

    @Override
    public void _initializeModel() {
        if (this._isEnabled_initialization1) {
            this._initialization1();
        }
        this._initializeSolvers();
    }

    @Override
    public void _automaticResetSolvers() {
        this._external.resetIC();
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public void _stepModel() {
        if (this._isEnabled_evolution1) {
            this._evolution1();
        }
    }

    @Override
    public void _updateModel() {
        if (this._isEnabled_constraints1) {
            this._constraints1();
        }
    }

    @Override
    public void _freeMemory() {
        this.xLocation = null;
        this.yLocation = null;
        this.Location = null;
        System.gc();
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Init Page".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("Derivative".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1 = bl;
        }
        if ("FixRel Page".equals(string)) {
            bl2 = true;
            this._isEnabled_constraints1 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        for (int i = 0; i < this.i; ++i) {
            for (int j = 0; j < this.i; ++j) {
                for (int k = 0; k < this.i; ++k) {
                    this.Location[j + this.i * i + this.i * this.i * k][0] = (double)(2 * j - this.i) + 0.5;
                    this.Location[j + this.i * i + this.i * this.i * k][1] = (double)(2 * i - this.i) + 0.5;
                    this.Location[j + this.i * i + this.i * this.i * k][2] = (double)(2 * k - this.i) + 0.5;
                }
            }
        }
        this.transform = "y:" + this.angle + "d";
        this.sinWave = true;
        this.triangleWave = false;
        this.squareWave = false;
    }

    public void _evolution1() {
        this.emf = 3.14 * this.r * this.r * Math.sin(this.angle) * (this.Bx - this.BxOld) / this.dt;
        this.BxOld = this.Bx;
        this.t += this.dt;
    }

    public void _constraints1() {
        this.transform = "y:" + this.angle + "d";
        double d = this.BAmplitude / 1000.0;
        if (this.sinWave) {
            this.Bx = d * Math.sin(this.w * this.t);
        }
        if (this.squareWave) {
            if (Math.sin(this.w * this.t) > 0.0) {
                this.Bx = d;
            }
            if (Math.sin(this.w * this.t) < 0.0) {
                this.Bx = -d;
            }
        }
        if (this.triangleWave) {
            if (Math.sin(this.w * this.t) > 0.0) {
                this.Bx += d * this.w / 3.14 * this.dt;
            }
            if (Math.sin(this.w * this.t) < 0.0) {
                this.Bx -= d * this.w / 3.14 * this.dt;
            }
        }
    }

    public void resetWave() {
        this.t = 0.0;
        this.dt = 0.1 / this.w;
        this.Bx = 0.0;
        this.BxOld = 0.0;
        this._view.clearData();
        this._play();
    }

    public double _method_for_plottingPanel_minimumY() {
        return -Math.pow(10.0, this.yExp);
    }

    public double _method_for_plottingPanel_maximumY() {
        return Math.pow(10.0, this.yExp);
    }

    public double _method_for_magneticTrace_y() {
        return this.Bx * 1000.0;
    }

    public void _method_for_playPauseButton_actionOn() {
        this._play();
    }

    public void _method_for_playPauseButton_actionOff() {
        this._pause();
    }

    public void _method_for_resetButton_action() {
        this._reset();
    }

    public void _method_for_sinWave_action() {
        this.squareWave = false;
        this.triangleWave = false;
        this.resetWave();
    }

    public void _method_for_squareWave_action() {
        this.sinWave = false;
        this.triangleWave = false;
        this.resetWave();
    }

    public void _method_for_triangularWave_action() {
        this.sinWave = false;
        this.squareWave = false;
        this.resetWave();
    }

    public void _method_for_comboBox_action() {
        this.resetWave();
    }

    public void _method_for_freq_action() {
        this.resetWave();
    }

    public void _method_for_BAmpl_action() {
        this.resetWave();
    }

    public int _method_for_BField_numberOfElements() {
        return this.i * this.i * this.i;
    }

    public double _method_for_BField_sizeX() {
        return this.Bx * 1000.0;
    }

    public void _method_for_radius_action() {
        this.resetWave();
    }

    public void _method_for_field2_action() {
        this.resetWave();
    }

    public void _method_for_angleSlider_action() {
        this.resetWave();
    }

    public void _method_for_field_action() {
        this.resetWave();
    }

    static {
        __translatorUtil = new TranslatorUtil();
        __htmlPagesMap = new HashMap<String, Set<HtmlPageInfo>>();
    }
}

