/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.colos.ejs.library.control.DataCollector;
import org.colos.ejs.library.control.NeedsFinalUpdate;
import org.colos.ejs.library.control.NeedsUpdate;
import org.colos.ejs.library.control.Resetable;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DataPanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlDataTable
extends ControlSwingElement
implements NeedsUpdate,
NeedsFinalUpdate,
DataCollector,
Resetable {
    private static final int TABLE_ADDED = 9;
    private boolean noRepeat = true;
    private boolean isSet = false;
    private boolean active = true;
    private double[] input;
    private double[] oldInput;
    private String[] columnNames = new String[0];
    private String[] columnFormats = new String[]{"0.000;-0.000"};
    private DataPanel dataPanel;
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        this.dataPanel = new DataPanel();
        this.dataPanel.setRowNumberVisible(false);
        this.dataPanel.setAutoResizeMode(4);
        int n = 0;
        int n2 = this.dataPanel.getColumnCount();
        while (n < n2) {
            this.dataPanel.setColumnFormat(n, "0.000;-0.000");
            ++n;
        }
        this.oldInput = null;
        this.input = null;
        this.isSet = false;
        this.dataPanel.getVisual().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (ControlDataTable.this.getSimulation() == null || !OSPRuntime.isPopupTrigger(mouseEvent)) {
                    return;
                }
                ControlDataTable.this.getPopupMenu(mouseEvent.getX(), mouseEvent.getY());
            }
        });
        return this.dataPanel;
    }

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.display.DataPanel";
    }

    @Override
    public Object getObject() {
        return this.dataPanel;
    }

    @Override
    public Component getComponent() {
        return this.dataPanel;
    }

    @Override
    public void initialize() {
        this.reset();
    }

    @Override
    public void reset() {
        this.dataPanel.clearData();
        this.oldInput = null;
        this.input = null;
        this.isSet = false;
    }

    @Override
    public void onExit() {
        this.reset();
    }

    @Override
    public void update() {
        block14: {
            int n;
            int n2;
            if (!this.active || !this.isSet || this.input == null) break block14;
            if (this.noRepeat) {
                if (this.oldInput == null || this.input.length != this.oldInput.length) {
                    this.oldInput = new double[this.input.length];
                } else {
                    n2 = 1;
                    n = 0;
                    while (n < this.input.length) {
                        if (this.input[n] != this.oldInput[n]) {
                            n2 = 0;
                            break;
                        }
                        ++n;
                    }
                    if (n2 != 0) {
                        return;
                    }
                }
                n2 = 0;
                while (n2 < this.input.length) {
                    this.oldInput[n2] = this.input[n2];
                    ++n2;
                }
            }
            n2 = this.dataPanel.getColumnCount();
            this.dataPanel.appendRow(this.input);
            if (this.input.length != n2) {
                n = 0;
                int n3 = Math.min(this.columnNames.length, this.input.length);
                while (n < n3) {
                    this.dataPanel.setColumnNames(n, this.columnNames[n]);
                    ++n;
                }
                if (this.columnFormats.length >= this.input.length) {
                    n = 0;
                    n3 = this.input.length;
                    while (n < n3) {
                        this.dataPanel.setColumnFormat(n, this.columnFormats[n]);
                        ++n;
                    }
                } else {
                    n = 0;
                    n3 = this.columnFormats.length;
                    while (n < n3) {
                        this.dataPanel.setColumnFormat(n, this.columnFormats[n]);
                        ++n;
                    }
                    n = this.columnFormats.length;
                    n3 = this.input.length;
                    while (n < n3) {
                        this.dataPanel.setColumnFormat(n, this.columnFormats[this.columnFormats.length - 1]);
                        ++n;
                    }
                }
            }
        }
    }

    @Override
    public void finalUpdate() {
        this.dataPanel.refreshTable();
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("input");
            infoList.add("maxPoints");
            infoList.add("stride");
            infoList.add("active");
            infoList.add("norepeat");
            infoList.add("showRowNumber");
            infoList.add("columnNames");
            infoList.add("columnFormat");
            infoList.add("autoResizeMode");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("input")) {
            return "int|double|double[]";
        }
        if (string.equals("maxPoints")) {
            return "int";
        }
        if (string.equals("stride")) {
            return "int";
        }
        if (string.equals("active")) {
            return "boolean";
        }
        if (string.equals("norepeat")) {
            return "boolean";
        }
        if (string.equals("showRowNumber")) {
            return "boolean";
        }
        if (string.equals("columnNames")) {
            return "String|String[] TRANSLATABLE";
        }
        if (string.equals("columnFormat")) {
            return "String|String[] TRANSLATABLE";
        }
        if (string.equals("autoResizeMode")) {
            return "AutoResizeMode|int";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("AutoResizeMode") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("off")) {
                return new IntegerValue(0);
            }
            if (string2.equals("next")) {
                return new IntegerValue(1);
            }
            if (string2.equals("subsequent")) {
                return new IntegerValue(2);
            }
            if (string2.equals("last")) {
                return new IntegerValue(3);
            }
            if (string2.equals("all")) {
                return new IntegerValue(4);
            }
        }
        return super.parseConstant(string, string2);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.input = value.getObject() instanceof double[] ? (double[])value.getObject() : new double[]{value.getDouble()};
                this.isSet = true;
                break;
            }
            case 1: {
                this.dataPanel.setMaxPoints(value.getInteger());
                break;
            }
            case 2: {
                this.dataPanel.setStride(value.getInteger());
                break;
            }
            case 3: {
                this.active = value.getBoolean();
                break;
            }
            case 4: {
                this.noRepeat = value.getBoolean();
                break;
            }
            case 5: {
                this.dataPanel.setRowNumberVisible(value.getBoolean());
                break;
            }
            case 6: {
                if (value.getObject() instanceof String[]) {
                    this.columnNames = (String[])value.getObject();
                } else {
                    String string = value.getString();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    this.columnNames = new String[stringTokenizer.countTokens()];
                    int n2 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        this.columnNames[n2] = TeXParser.parseTeX(stringTokenizer.nextToken());
                        ++n2;
                    }
                }
                int n3 = 0;
                int n4 = this.columnNames.length;
                while (n3 < n4) {
                    this.dataPanel.setColumnNames(n3, this.columnNames[n3]);
                    ++n3;
                }
                break;
            }
            case 7: {
                if (value.getObject() instanceof String[]) {
                    this.columnFormats = (String[])value.getObject();
                } else {
                    String string = value.getString();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    this.columnFormats = new String[stringTokenizer.countTokens()];
                    int n5 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        this.columnFormats[n5] = TeXParser.parseTeX(stringTokenizer.nextToken());
                        ++n5;
                    }
                }
                int n6 = 0;
                int n7 = this.columnFormats.length;
                while (n6 < n7) {
                    this.dataPanel.setColumnFormat(n6, this.columnFormats[n6]);
                    ++n6;
                }
                break;
            }
            case 8: {
                this.dataPanel.setAutoResizeMode(value.getInteger());
                break;
            }
            default: {
                super.setValue(n - 9, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.oldInput = null;
                this.input = null;
                this.isSet = false;
                break;
            }
            case 1: {
                this.dataPanel.setMaxPoints(-1);
                break;
            }
            case 2: {
                this.dataPanel.setStride(1);
                break;
            }
            case 3: {
                this.active = true;
                break;
            }
            case 4: {
                this.noRepeat = true;
                break;
            }
            case 5: {
                this.dataPanel.setRowNumberVisible(false);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.columnFormats = new String[]{"0.000;-0.000"};
                int n2 = 0;
                int n3 = this.columnFormats.length;
                while (n2 < n3) {
                    this.dataPanel.setColumnFormat(n2, this.columnFormats[n2]);
                    ++n2;
                }
                break;
            }
            case 8: {
                this.dataPanel.setAutoResizeMode(4);
                break;
            }
            default: {
                super.setDefaultValue(n - 9);
            }
        }
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return null;
            }
        }
        return super.getValue(n - 9);
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "-1";
            }
            case 2: {
                return "1";
            }
            case 3: {
                return "true";
            }
            case 4: {
                return "true";
            }
            case 5: {
                return "false";
            }
            case 6: {
                return "<none>";
            }
            case 7: {
                return "0.000;-0.000";
            }
            case 8: {
                return "ALL";
            }
        }
        return super.getDefaultValueString(n - 9);
    }
}

