/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.core;

import javax.swing.JFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display3d.core.DrawingPanel3D;

public interface DrawingFrame3D {
    public void setDrawingPanel3D(DrawingPanel3D var1);

    public DrawingPanel3D getDrawingPanel3D();

    public JFrame getJFrame();

    public void setVisible(boolean var1);

    public static class Loader
    implements XML.ObjectLoader {
        public Object createObject(XMLControl xMLControl) {
            DrawingFrame drawingFrame = new DrawingFrame();
            drawingFrame.setTitle(xMLControl.getString("title"));
            drawingFrame.setLocation(xMLControl.getInt("location x"), xMLControl.getInt("location y"));
            drawingFrame.setSize(xMLControl.getInt("width"), xMLControl.getInt("height"));
            if (xMLControl.getBoolean("showing")) {
                drawingFrame.setVisible(true);
            }
            return drawingFrame;
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            DrawingFrame3D drawingFrame3D = (DrawingFrame3D)object;
            JFrame jFrame = drawingFrame3D.getJFrame();
            xMLControl.setValue("title", jFrame.getTitle());
            xMLControl.setValue("showing", jFrame.isShowing());
            xMLControl.setValue("location x", jFrame.getLocation().x);
            xMLControl.setValue("location y", jFrame.getLocation().y);
            xMLControl.setValue("width", jFrame.getSize().width);
            xMLControl.setValue("height", jFrame.getSize().height);
            xMLControl.setValue("drawing panel", drawingFrame3D.getDrawingPanel3D());
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            DrawingFrame3D drawingFrame3D = (DrawingFrame3D)object;
            JFrame jFrame = drawingFrame3D.getJFrame();
            DrawingPanel3D drawingPanel3D = drawingFrame3D.getDrawingPanel3D();
            drawingPanel3D.removeAllElements();
            XMLControl xMLControl2 = xMLControl.getChildControl("drawing panel");
            xMLControl2.loadObject(drawingPanel3D);
            drawingPanel3D.repaint();
            jFrame.setTitle(xMLControl.getString("title"));
            jFrame.setLocation(xMLControl.getInt("location x"), xMLControl.getInt("location y"));
            jFrame.setSize(xMLControl.getInt("width"), xMLControl.getInt("height"));
            if (xMLControl.getBoolean("showing")) {
                jFrame.setVisible(true);
            }
            return object;
        }
    }
}

