/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.java3d;

import com.sun.j3d.utils.geometry.Cone;
import java.awt.Color;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import org.opensourcephysics.display3d.core.Resolution;
import org.opensourcephysics.display3d.java3d.Element;

public class ElementCone
extends Element
implements org.opensourcephysics.display3d.core.ElementCone {
    private boolean hasBottom;
    private TransformGroup tg = new TransformGroup();
    private Cone cone;
    private BranchGroup bg;

    public ElementCone() {
        Transform3D transform3D = new Transform3D();
        transform3D.rotX(1.5707963267948966);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotY(-1.5707963267948966);
        transform3D.mul(transform3D2);
        this.tg.setTransform(transform3D);
        this.tg.setCapability(13);
        this.tg.setCapability(14);
        this.getStyle().setFillColor(Color.blue);
        this.getStyle().setResolution(new Resolution(2, 20, 0));
        this.getStyle().setDrawingLines(false);
        this.hasBottom = true;
        this.setNode((Node)this.tg);
    }

    private boolean needsLengthCompute(int n) {
        return this.getStyle() != null && this.getStyle().getResolution() != null && this.getStyle().getResolution().getType() == 1 && (n & 2) != 0;
    }

    public void processChanges(int n) {
        super.processChanges(n);
        if ((n & 8) != 0 || this.needsLengthCompute(n)) {
            int n2;
            int n3;
            if (this.getStyle().getResolution() == null) {
                return;
            }
            if (this.cone != null) {
                this.tg.removeChild((Node)this.bg);
            }
            if (this.getStyle().getResolution().getType() == 0) {
                n3 = Math.max(this.getStyle().getResolution().getN2(), 1);
                n2 = Math.max(this.getStyle().getResolution().getN1(), 1);
            } else {
                double d = Math.abs(this.getSizeX()) / 2.0;
                double d2 = Math.abs(this.getSizeY()) / 2.0;
                n2 = Math.max((int)Math.round(0.49 + Math.max(d, d2) / this.getStyle().getResolution().getMaxLength()), 1);
                n3 = Math.max((int)Math.round(0.49 + Math.PI * 2 * (d + d2) / this.getStyle().getResolution().getMaxLength()), 3);
            }
            this.cone = new Cone(0.5f, 1.0f, 33, n3, n2, this.getAppearance());
            this.bg = new BranchGroup();
            this.bg.setCapability(17);
            this.bg.addChild((Node)this.cone);
            this.tg.addChild((Node)this.bg);
        }
    }

    public void setTruncationHeight(double d) {
    }

    public double getTruncationHeight() {
        return 0.0;
    }

    public void setMinimumAngle(int n) {
    }

    public int getMinimumAngle() {
        return 0;
    }

    public void setMaximumAngle(int n) {
    }

    public int getMaximumAngle() {
        return 0;
    }

    public void setClosedBottom(boolean bl) {
        this.hasBottom = bl;
    }

    public boolean isClosedBottom() {
        return this.hasBottom;
    }

    public void setClosedTop(boolean bl) {
    }

    public boolean isClosedTop() {
        return true;
    }

    public void setClosedLeft(boolean bl) {
    }

    public boolean isClosedLeft() {
        return true;
    }

    public void setClosedRight(boolean bl) {
    }

    public boolean isClosedRight() {
        return true;
    }
}

