/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.jogl;

import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import org.opensourcephysics.display3d.core.Resolution;
import org.opensourcephysics.display3d.jogl.Camera;
import org.opensourcephysics.display3d.jogl.Element;
import org.opensourcephysics.display3d.jogl.utils.GLTools;
import org.opensourcephysics.numerics.Matrix3DTransformation;
import org.opensourcephysics.numerics.Vec3D;

public class ElementCircle
extends Element
implements org.opensourcephysics.display3d.core.ElementCircle {
    private double rotationAngle;

    public ElementCircle() {
        this.getStyle().setResolution(new Resolution(15, 15, 15));
        this.setSizeXYZ(0.01, 0.01, 0.01);
    }

    void draw(GLAutoDrawable gLAutoDrawable) {
        double d;
        int n;
        if (!this.isVisible()) {
            return;
        }
        GL gL = gLAutoDrawable.getGL();
        gL.glPushMatrix();
        this.transform(gL);
        gL.glScaled(this.getSizeX(), this.getSizeY(), this.getSizeZ());
        Camera camera = (Camera)this.getDrawingPanel3D().getCamera();
        Vec3D vec3D = camera.getDirection();
        double[] dArray = new double[]{0.0, 0.0, 1.0};
        double[] dArray2 = new double[]{vec3D.x, vec3D.y, vec3D.z};
        this.toBodyFrame(dArray2);
        Matrix3DTransformation matrix3DTransformation = Matrix3DTransformation.createAlignmentTransformation(dArray, dArray2);
        gL.glMultMatrixd(matrix3DTransformation.getFlatMatrix(null), 0);
        int n2 = -1;
        if (this.getStyle().isDrawingFill()) {
            GLTools.setColor(gL, this.getStyle().getFillColor());
            gL.glEnable(2896);
            gL.glMaterialfv(1032, 5634, this.getStyle().getFillColor().getComponents(null), 0);
            gL.glDisable(2884);
            n2 = this.getNumEdges();
            this.preFillGL(gLAutoDrawable);
            gL.glBegin(9);
            n = 0;
            while (n < 360) {
                d = (double)n * Math.PI / 180.0;
                gL.glVertex3d(Math.cos(d) / 2.0, Math.sin(d) / 2.0, 0.0);
                n += 360 / n2;
            }
            gL.glEnd();
            gL.glTranslated(0.0, 0.0, -0.001);
        }
        if (this.getStyle().isDrawingLines()) {
            GLTools.setColor(gL, this.getStyle().getLineColor());
            gL.glEnable(2896);
            gL.glMaterialfv(1032, 5634, this.getStyle().getLineColor().getComponents(null), 0);
            gL.glLineWidth(this.getStyle().getLineWidth());
            if (n2 == -1) {
                n2 = this.getNumEdges();
            }
            this.preLinesGL(gLAutoDrawable);
            gL.glBegin(2);
            n = 0;
            while (n < 360) {
                d = (double)n * Math.PI / 180.0;
                gL.glVertex3d(Math.cos(d) / 2.0, Math.sin(d) / 2.0, 0.0);
                n += 360 / n2;
            }
            gL.glEnd();
        }
        gL.glPopMatrix();
        this.setElementChanged(false);
    }

    private int getNumEdges() {
        switch (this.getStyle().getResolution().getType()) {
            case 1: {
                return (int)(this.getSize().magnitude() / this.getStyle().getResolution().getMaxLength());
            }
        }
        return this.getStyle().getResolution().getN1();
    }

    public void setRotationAngle(double d) {
        this.rotationAngle = d;
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public int getBlendPriority() {
        if (this.getStyle().isDrawingLines()) {
            return 1;
        }
        return 0;
    }
}

