/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.interaction.InteractionEvent;
import org.opensourcephysics.display3d.core.interaction.InteractionListener;
import org.opensourcephysics.display3d.simple3d.DrawingPanel3D;
import org.opensourcephysics.display3d.simple3d.Group;
import org.opensourcephysics.display3d.simple3d.InteractionTarget;
import org.opensourcephysics.display3d.simple3d.Object3D;
import org.opensourcephysics.display3d.simple3d.Style;
import org.opensourcephysics.numerics.Matrix3DTransformation;
import org.opensourcephysics.numerics.Quaternion;
import org.opensourcephysics.numerics.Transformation;

public abstract class Element
implements org.opensourcephysics.display3d.core.Element {
    static final int SENSIBILITY = 5;
    private boolean visible = true;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private double sizeX = 1.0;
    private double sizeY = 1.0;
    private double sizeZ = 1.0;
    private String name = "";
    private Transformation transformation = null;
    private Style style = new Style(this);
    private Group group = null;
    private double factorX = 1.0;
    private double factorY = 1.0;
    private double factorZ = 1.0;
    private boolean elementChanged = true;
    private boolean needsToProject = true;
    private DrawingPanel3D panel;
    private ArrayList<InteractionListener> listeners = new ArrayList();
    protected final InteractionTarget targetPosition = new InteractionTarget(this, 0);
    protected final InteractionTarget targetSize = new InteractionTarget(this, 1);

    public final DrawingPanel3D getDrawingPanel3D() {
        Element element = this;
        while (element.group != null) {
            element = element.group;
        }
        return element.panel;
    }

    void setPanel(DrawingPanel3D drawingPanel3D) {
        this.panel = drawingPanel3D;
        this.factorX = drawingPanel3D.getScaleFactorX();
        this.factorY = drawingPanel3D.getScaleFactorY();
        this.factorZ = drawingPanel3D.getScaleFactorZ();
        this.elementChanged = true;
    }

    final Group getGroup() {
        return this.group;
    }

    void setGroup(Group group) {
        this.group = group;
        this.elementChanged = true;
    }

    protected int getAxesMode() {
        if (this.panel != null) {
            return this.panel.getAxesMode();
        }
        return 0;
    }

    public void setName(String string) {
        this.name = string;
    }

    public final String getName() {
        return this.name;
    }

    public void setX(double d) {
        switch (this.getAxesMode()) {
            case 1: {
                this.y = d * this.factorX;
                break;
            }
            case 3: {
                this.z = d * this.factorZ;
                break;
            }
            case 5: {
                this.y = d * this.factorY;
                break;
            }
            case 4: {
                this.z = d * this.factorZ;
                break;
            }
            default: {
                this.x = d * this.factorX;
            }
        }
        this.elementChanged = true;
    }

    public final double getX() {
        return this.x / this.factorX;
    }

    public void setY(double d) {
        switch (this.getAxesMode()) {
            case 2: {
                this.z = d * this.factorZ;
                break;
            }
            case 1: {
                this.x = d * this.factorX;
                break;
            }
            case 3: {
                this.x = d * this.factorX;
                break;
            }
            case 5: {
                this.z = d * this.factorZ;
                break;
            }
            default: {
                this.y = d * this.factorY;
            }
        }
        this.elementChanged = true;
    }

    public final double getY() {
        return this.y / this.factorY;
    }

    public void setZ(double d) {
        switch (this.getAxesMode()) {
            case 2: {
                this.y = d * this.factorY;
                break;
            }
            case 3: {
                this.y = d * this.factorY;
                break;
            }
            case 5: {
                this.x = d * this.factorX;
                break;
            }
            case 4: {
                this.x = d * this.factorX;
                break;
            }
            default: {
                this.z = d * this.factorZ;
            }
        }
        this.elementChanged = true;
    }

    public final double getZ() {
        return this.z / this.factorZ;
    }

    public void setXYZ(double d, double d2, double d3) {
        switch (this.getAxesMode()) {
            case 2: {
                this.x = d * this.factorX;
                this.z = d2 * this.factorZ;
                this.y = d3 * this.factorY;
                break;
            }
            case 1: {
                this.y = d;
                this.x = d2;
                this.z = d3;
                break;
            }
            case 3: {
                this.z = d * this.factorZ;
                this.x = d2 * this.factorX;
                this.y = d3 * this.factorY;
                break;
            }
            case 5: {
                this.y = d * this.factorY;
                this.z = d2 * this.factorZ;
                this.x = d3 * this.factorX;
                break;
            }
            case 4: {
                this.z = d * this.factorZ;
                this.y = d2 * this.factorY;
                this.x = d3 * this.factorX;
                break;
            }
            default: {
                this.x = d * this.factorX;
                this.y = d2 * this.factorY;
                this.z = d3 * this.factorZ;
            }
        }
        this.elementChanged = true;
    }

    public void setXYZ(double[] dArray) {
        switch (this.getAxesMode()) {
            case 2: {
                this.x = dArray[0] * this.factorX;
                this.z = dArray[1] * this.factorZ;
                if (dArray.length < 3) break;
                this.y = dArray[2] * this.factorY;
                break;
            }
            case 1: {
                this.y = dArray[0] * this.factorY;
                this.x = dArray[1] * this.factorX;
                if (dArray.length < 3) break;
                this.z = dArray[2] * this.factorZ;
                break;
            }
            case 3: {
                this.z = dArray[0] * this.factorZ;
                this.x = dArray[1] * this.factorX;
                if (dArray.length < 3) break;
                this.y = dArray[2] * this.factorY;
                break;
            }
            case 5: {
                this.y = dArray[0] * this.factorY;
                this.z = dArray[1] * this.factorZ;
                if (dArray.length < 3) break;
                this.x = dArray[2] * this.factorX;
                break;
            }
            case 4: {
                this.z = dArray[0] * this.factorZ;
                this.y = dArray[1] * this.factorY;
                if (dArray.length < 3) break;
                this.x = dArray[2] * this.factorX;
                break;
            }
            default: {
                this.x = dArray[0] * this.factorX;
                this.y = dArray[1] * this.factorY;
                if (dArray.length < 3) break;
                this.z = dArray[2] * this.factorZ;
            }
        }
        this.elementChanged = true;
    }

    void getExtrema(double[] dArray, double[] dArray2) {
        dArray[0] = -0.5;
        dArray2[0] = 0.5;
        dArray[1] = -0.5;
        dArray2[1] = 0.5;
        dArray[2] = -0.5;
        dArray2[2] = 0.5;
        this.sizeAndToSpaceFrame(dArray);
        this.sizeAndToSpaceFrame(dArray2);
    }

    public void setSizeX(double d) {
        switch (this.getAxesMode()) {
            case 1: {
                this.sizeY = d * this.factorY;
                break;
            }
            case 3: {
                this.sizeZ = d * this.factorZ;
                break;
            }
            case 5: {
                this.sizeY = d * this.factorY;
                break;
            }
            case 4: {
                this.sizeZ = d * this.factorZ;
                break;
            }
            default: {
                this.sizeX = d * this.factorY;
            }
        }
        this.elementChanged = true;
    }

    public final double getSizeX() {
        return this.sizeX;
    }

    public void setSizeY(double d) {
        switch (this.getAxesMode()) {
            case 2: {
                this.sizeZ = d * this.factorZ;
                break;
            }
            case 1: {
                this.sizeX = d * this.factorX;
                break;
            }
            case 3: {
                this.sizeX = d * this.factorX;
                break;
            }
            case 5: {
                this.sizeZ = d * this.factorZ;
                break;
            }
            default: {
                this.sizeY = d * this.factorY;
            }
        }
        this.elementChanged = true;
    }

    public final double getSizeY() {
        return this.sizeY;
    }

    public void setSizeZ(double d) {
        switch (this.getAxesMode()) {
            case 2: {
                this.sizeY = d * this.factorY;
                break;
            }
            case 3: {
                this.sizeY = d * this.factorY;
                break;
            }
            case 5: {
                this.sizeX = d * this.factorX;
                break;
            }
            case 4: {
                this.sizeX = d * this.factorX;
                break;
            }
            default: {
                this.sizeZ = d * this.factorZ;
            }
        }
        this.elementChanged = true;
    }

    public final double getSizeZ() {
        return this.sizeZ;
    }

    public void setSizeXYZ(double d, double d2, double d3) {
        switch (this.getAxesMode()) {
            case 2: {
                this.sizeX = d * this.factorX;
                this.sizeZ = d2 * this.factorY;
                this.sizeY = d3 * this.factorZ;
                break;
            }
            case 1: {
                this.sizeY = d * this.factorY;
                this.sizeX = d2 * this.factorX;
                this.sizeZ = d3 * this.factorZ;
                break;
            }
            case 3: {
                this.sizeZ = d * this.factorZ;
                this.sizeX = d2 * this.factorX;
                this.sizeY = d3 * this.factorY;
                break;
            }
            case 5: {
                this.sizeY = d * this.factorY;
                this.sizeZ = d2 * this.factorZ;
                this.sizeX = d3 * this.factorX;
                break;
            }
            case 4: {
                this.sizeZ = d * this.factorZ;
                this.sizeY = d2 * this.factorY;
                this.sizeX = d3 * this.factorX;
                break;
            }
            default: {
                this.sizeX = d * this.factorX;
                this.sizeY = d2 * this.factorY;
                this.sizeZ = d3 * this.factorZ;
            }
        }
        this.elementChanged = true;
    }

    public void setSizeXYZ(double[] dArray) {
        switch (this.getAxesMode()) {
            case 2: {
                this.sizeX = dArray[0] * this.factorX;
                this.sizeZ = dArray[1] * this.factorZ;
                if (dArray.length < 3) break;
                this.sizeY = dArray[2] * this.factorY;
                break;
            }
            case 1: {
                this.sizeY = dArray[0] * this.factorY;
                this.sizeX = dArray[1] * this.factorX;
                if (dArray.length < 3) break;
                this.sizeZ = dArray[2] * this.factorZ;
                break;
            }
            case 3: {
                this.sizeZ = dArray[0] * this.factorZ;
                this.sizeX = dArray[1] * this.factorX;
                if (dArray.length < 3) break;
                this.sizeY = dArray[2] * this.factorY;
                break;
            }
            case 5: {
                this.sizeY = dArray[0] * this.factorY;
                this.sizeZ = dArray[1] * this.factorZ;
                if (dArray.length < 3) break;
                this.sizeX = dArray[2] * this.factorX;
                break;
            }
            case 4: {
                this.sizeZ = dArray[0] * this.factorZ;
                this.sizeY = dArray[1] * this.factorY;
                if (dArray.length < 3) break;
                this.sizeX = dArray[2] * this.factorX;
                break;
            }
            default: {
                this.sizeX = dArray[0] * this.factorX;
                this.sizeY = dArray[1] * this.factorY;
                if (dArray.length < 3) break;
                this.sizeZ = dArray[2] * this.factorZ;
            }
        }
        this.elementChanged = true;
    }

    final double getDiagonalSize() {
        return Math.sqrt(this.sizeX * this.sizeX + this.sizeY * this.sizeY + this.sizeZ * this.sizeZ);
    }

    final boolean hasChanged() {
        Element element = this;
        while (element != null) {
            if (element.elementChanged) {
                return true;
            }
            element = element.group;
        }
        return false;
    }

    boolean getElementChanged() {
        return this.elementChanged;
    }

    final void setElementChanged(boolean bl) {
        this.elementChanged = bl;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    protected final boolean isReallyVisible() {
        Group group = this.group;
        while (group != null) {
            if (!group.visible) {
                return false;
            }
            group = group.group;
        }
        return this.visible;
    }

    public final org.opensourcephysics.display3d.core.Style getStyle() {
        return this.style;
    }

    final Style getRealStyle() {
        return this.style;
    }

    final void styleChanged(int n) {
        this.elementChanged = true;
    }

    public Transformation getTransformation() {
        if (this.transformation == null) {
            return null;
        }
        return (Transformation)this.transformation.clone();
    }

    public void setTransformation(Transformation transformation) {
        if (transformation == null) {
            this.transformation = null;
        } else {
            this.transformation = (Transformation)transformation.clone();
            if (transformation instanceof Quaternion) {
                Quaternion quaternion = (Quaternion)this.transformation;
                double[] dArray = quaternion.getCoordinates();
                switch (this.getAxesMode()) {
                    case 0: {
                        quaternion.setCoordinates(dArray[0], dArray[1], dArray[2], dArray[3]);
                        break;
                    }
                    case 2: {
                        quaternion.setCoordinates(dArray[0], dArray[1], dArray[3], dArray[2]);
                        break;
                    }
                    case 1: {
                        quaternion.setCoordinates(dArray[0], dArray[2], dArray[1], dArray[3]);
                        break;
                    }
                    case 3: {
                        quaternion.setCoordinates(dArray[0], dArray[2], dArray[3], dArray[1]);
                        break;
                    }
                    case 5: {
                        quaternion.setCoordinates(dArray[0], dArray[3], dArray[1], dArray[2]);
                        break;
                    }
                    case 4: {
                        quaternion.setCoordinates(dArray[0], dArray[3], dArray[2], dArray[1]);
                        break;
                    }
                    default: {
                        quaternion.setCoordinates(dArray[0], dArray[1], dArray[2], dArray[3]);
                    }
                }
                this.transformation = new Quaternion(quaternion);
            } else {
                Matrix3DTransformation matrix3DTransformation = (Matrix3DTransformation)this.transformation;
                double[] dArray = new double[4];
                matrix3DTransformation.toQuaternion(dArray);
                Quaternion quaternion = new Quaternion(dArray);
                switch (this.getAxesMode()) {
                    case 0: {
                        quaternion.setCoordinates(dArray[0], dArray[1], dArray[2], dArray[3]);
                        break;
                    }
                    case 2: {
                        quaternion.setCoordinates(dArray[0], dArray[1], dArray[3], dArray[2]);
                        break;
                    }
                    case 1: {
                        quaternion.setCoordinates(dArray[0], dArray[2], dArray[1], dArray[3]);
                        break;
                    }
                    case 3: {
                        quaternion.setCoordinates(dArray[0], dArray[2], dArray[3], dArray[1]);
                        break;
                    }
                    case 5: {
                        quaternion.setCoordinates(dArray[0], dArray[3], dArray[1], dArray[2]);
                        break;
                    }
                    case 4: {
                        quaternion.setCoordinates(dArray[0], dArray[3], dArray[2], dArray[1]);
                        break;
                    }
                    default: {
                        quaternion.setCoordinates(dArray[0], dArray[1], dArray[2], dArray[3]);
                    }
                }
                this.transformation = new Quaternion(quaternion);
            }
        }
        this.elementChanged = true;
    }

    public double[] toSpaceFrame(double[] dArray) {
        if (this.transformation != null) {
            this.transformation.direct(dArray);
        }
        dArray[0] = dArray[0] + this.x;
        dArray[1] = dArray[1] + this.y;
        dArray[2] = dArray[2] + this.z;
        Group group = this.group;
        while (group != null) {
            dArray[0] = dArray[0] * group.sizeX;
            dArray[1] = dArray[1] * group.sizeY;
            dArray[2] = dArray[2] * group.sizeZ;
            if (group.transformation != null) {
                group.transformation.direct(dArray);
            }
            dArray[0] = dArray[0] + group.x;
            dArray[1] = dArray[1] + group.y;
            dArray[2] = dArray[2] + group.z;
            group = group.group;
        }
        return dArray;
    }

    public double[] toBodyFrame(double[] dArray) throws UnsupportedOperationException {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element element = this;
        do {
            arrayList.add(element);
        } while ((element = element.group) != null);
        int n = arrayList.size() - 1;
        while (n >= 0) {
            element = (Element)arrayList.get(n);
            dArray[0] = dArray[0] - element.x;
            dArray[1] = dArray[1] - element.y;
            dArray[2] = dArray[2] - element.z;
            if (element.transformation != null) {
                element.transformation.inverse(dArray);
            }
            if (element != this) {
                if (element.sizeX != 0.0) {
                    dArray[0] = dArray[0] / element.sizeX;
                }
                if (element.sizeY != 0.0) {
                    dArray[1] = dArray[1] / element.sizeY;
                }
                if (element.sizeZ != 0.0) {
                    dArray[2] = dArray[2] / element.sizeZ;
                }
            }
            --n;
        }
        return dArray;
    }

    final void sizeAndToSpaceFrame(double[] dArray) {
        dArray[0] = dArray[0] * this.sizeX;
        dArray[1] = dArray[1] * this.sizeY;
        dArray[2] = dArray[2] * this.sizeZ;
        this.toSpaceFrame(dArray);
    }

    abstract Object3D[] getObjects3D();

    abstract void draw(Graphics2D var1, int var2);

    abstract void drawQuickly(Graphics2D var1);

    void setNeedToProject(boolean bl) {
        this.needsToProject = bl;
    }

    final boolean needsToProject() {
        return this.needsToProject;
    }

    public org.opensourcephysics.display3d.core.interaction.InteractionTarget getInteractionTarget(int n) {
        switch (n) {
            case 0: {
                return this.targetPosition;
            }
            case 1: {
                return this.targetSize;
            }
        }
        return null;
    }

    public void addInteractionListener(InteractionListener interactionListener) {
        if (interactionListener == null || this.listeners.contains(interactionListener)) {
            return;
        }
        this.listeners.add(interactionListener);
    }

    public void removeInteractionListener(InteractionListener interactionListener) {
        this.listeners.remove(interactionListener);
    }

    final void invokeActions(InteractionEvent interactionEvent) {
        Iterator<InteractionListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().interactionPerformed(interactionEvent);
        }
    }

    protected InteractionTarget getTargetHit(int n, int n2) {
        return null;
    }

    protected double[] getHotSpotBodyCoordinates(InteractionTarget interactionTarget) {
        if (interactionTarget == this.targetPosition) {
            return new double[]{0.0, 0.0, 0.0};
        }
        if (interactionTarget == this.targetSize) {
            double[] dArray = new double[]{1.0, 1.0, 1.0};
            if (this.sizeX == 0.0) {
                dArray[0] = 0.0;
            }
            if (this.sizeY == 0.0) {
                dArray[1] = 0.0;
            }
            if (this.sizeZ == 0.0) {
                dArray[2] = 0.0;
            }
            return dArray;
        }
        return null;
    }

    final double[] getHotSpot(InteractionTarget interactionTarget) {
        double[] dArray = this.getHotSpotBodyCoordinates(interactionTarget);
        if (dArray != null) {
            this.sizeAndToSpaceFrame(dArray);
        }
        return dArray;
    }

    final void updateHotSpot(InteractionTarget interactionTarget, double[] dArray) {
        Group group = this.group;
        switch (interactionTarget.getType()) {
            case 0: {
                if (interactionTarget.getAffectsGroup() && group != null) {
                    double[] dArray2 = this.getHotSpot(interactionTarget);
                    group.setXYZ(group.x + dArray[0] - dArray2[0], group.y + dArray[1] - dArray2[1], group.z + dArray[2] - dArray2[2]);
                    break;
                }
                double[] dArray3 = new double[]{dArray[0], dArray[1], dArray[2]};
                this.groupInverseTransformations(dArray3);
                double[] dArray4 = this.getHotSpotBodyCoordinates(interactionTarget);
                dArray4[0] = dArray4[0] * this.sizeX;
                dArray4[1] = dArray4[1] * this.sizeY;
                dArray4[2] = dArray4[2] * this.sizeZ;
                if (this.transformation != null) {
                    this.transformation.direct(dArray4);
                }
                this.setXYZ(dArray3[0] - dArray4[0], dArray3[1] - dArray4[1], dArray3[2] - dArray4[2]);
                break;
            }
            case 1: {
                if (interactionTarget.getAffectsGroup() && group != null) {
                    double[] dArray5 = new double[]{dArray[0], dArray[1], dArray[2]};
                    dArray5[0] = dArray5[0] - group.x;
                    dArray5[1] = dArray5[1] - group.y;
                    dArray5[2] = dArray5[2] - group.z;
                    if (group.transformation != null) {
                        group.transformation.inverse(dArray5);
                    }
                    double[] dArray6 = this.getHotSpotBodyCoordinates(interactionTarget);
                    this.elementDirectTransformations(dArray6);
                    dArray5[0] = dArray6[0] != 0.0 ? dArray5[0] / dArray6[0] : group.sizeX;
                    dArray5[1] = dArray6[1] != 0.0 ? dArray5[1] / dArray6[1] : group.sizeY;
                    dArray5[2] = dArray6[2] != 0.0 ? dArray5[2] / dArray6[2] : group.sizeZ;
                    group.setSizeXYZ(dArray5);
                    break;
                }
                double[] dArray7 = new double[]{dArray[0], dArray[1], dArray[2]};
                this.groupInverseTransformations(dArray7);
                dArray7[0] = dArray7[0] - this.x;
                dArray7[1] = dArray7[1] - this.y;
                dArray7[2] = dArray7[2] - this.z;
                if (this.transformation != null) {
                    this.transformation.inverse(dArray7);
                }
                double[] dArray8 = this.getHotSpotBodyCoordinates(interactionTarget);
                int n = 0;
                while (n < 3) {
                    if (dArray8[n] != 0.0) {
                        int n2 = n;
                        dArray7[n2] = dArray7[n2] / dArray8[n];
                    }
                    ++n;
                }
                this.setSizeXYZ(dArray7);
            }
        }
    }

    private final void groupInverseTransformations(double[] dArray) throws UnsupportedOperationException {
        ArrayList<Group> arrayList = new ArrayList<Group>();
        Element element = this.group;
        while (element != null) {
            arrayList.add((Group)element);
            element = element.group;
        }
        int n = arrayList.size() - 1;
        while (n >= 0) {
            element = (Element)arrayList.get(n);
            dArray[0] = dArray[0] - element.x;
            dArray[1] = dArray[1] - element.y;
            dArray[2] = dArray[2] - element.z;
            if (element.transformation != null) {
                element.transformation.inverse(dArray);
            }
            if (element.sizeX != 0.0) {
                dArray[0] = dArray[0] / element.sizeX;
            }
            if (element.sizeY != 0.0) {
                dArray[1] = dArray[1] / element.sizeY;
            }
            if (element.sizeZ != 0.0) {
                dArray[2] = dArray[2] / element.sizeZ;
            }
            --n;
        }
    }

    private final void elementDirectTransformations(double[] dArray) {
        Element element = this;
        do {
            if (element.sizeX != 0.0) {
                dArray[0] = dArray[0] * element.sizeX;
            }
            if (element.sizeY != 0.0) {
                dArray[1] = dArray[1] * element.sizeY;
            }
            if (element.sizeZ != 0.0) {
                dArray[2] = dArray[2] * element.sizeZ;
            }
            if (element.transformation != null) {
                element.transformation.direct(dArray);
            }
            dArray[0] = dArray[0] + element.x;
            dArray[1] = dArray[1] + element.y;
            dArray[2] = dArray[2] + element.z;
        } while ((element = element.group) != null && element.group != null);
    }

    public void loadUnmutableObjects(XMLControl xMLControl) {
        this.style = (Style)xMLControl.getObject("style");
        this.style.setElement(this);
        this.elementChanged = true;
    }
}

