/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementSurface;
import org.opensourcephysics.display3d.simple3d.AbstractTile;

public class ElementTessellation
extends AbstractTile
implements org.opensourcephysics.display3d.core.ElementTessellation {
    protected double[][][] data;

    public ElementTessellation() {
        this.setXYZ(0.0, 0.0, 0.0);
        this.setSizeXYZ(1.0, 1.0, 1.0);
    }

    public void setTiles(double[][][] dArray) {
        if (this.data == dArray) {
            return;
        }
        int n = dArray.length;
        double[][][] dArrayArray = new double[n][][];
        int n2 = 0;
        while (n2 < n) {
            dArrayArray[n2] = new double[dArray[n2].length][3];
            ++n2;
        }
        this.setCorners(dArrayArray);
        this.data = dArray;
        this.setElementChanged(true);
    }

    public double[][][] getTiles() {
        return this.data;
    }

    public void getExtrema(double[] dArray, double[] dArray2) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        double[] dArray3 = new double[3];
        int n = 0;
        while (n < this.numberOfTiles) {
            int n2 = this.corners[n].length;
            int n3 = 0;
            while (n3 < n2) {
                System.arraycopy(this.corners[n][n3], 0, dArray3, 0, 3);
                this.sizeAndToSpaceFrame(dArray3);
                d = Math.min(d, dArray3[0]);
                d2 = Math.max(d2, dArray3[0]);
                d3 = Math.min(d3, dArray3[1]);
                d4 = Math.max(d4, dArray3[1]);
                d5 = Math.min(d5, dArray3[2]);
                d6 = Math.max(d6, dArray3[2]);
                ++n3;
            }
            ++n;
        }
        dArray[0] = d;
        dArray2[0] = d2;
        dArray[1] = d3;
        dArray2[1] = d4;
        dArray[2] = d5;
        dArray2[2] = d6;
    }

    protected synchronized void computeCorners() {
        int n;
        int n2;
        if (this.data == null) {
            return;
        }
        int n3 = 0;
        while (n3 < this.data.length) {
            n2 = 0;
            n = this.data[n3].length;
            while (n2 < n) {
                System.arraycopy(this.data[n3][n2], 0, this.corners[n3][n2], 0, 3);
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.numberOfTiles) {
            n2 = 0;
            n = this.corners[n3].length;
            while (n2 < n) {
                System.arraycopy(this.data[n3][n2], 0, this.corners[n3][n2], 0, 3);
                this.sizeAndToSpaceFrame(this.corners[n3][n2]);
                ++n2;
            }
            ++n3;
        }
        this.setElementChanged(false);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends ElementSurface.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new ElementTessellation();
        }
    }
}

