/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.ImageVideoType;
import org.opensourcephysics.media.core.ScratchVideoRecorder;
import org.opensourcephysics.media.core.Video;

public class ImageVideoRecorder
extends ScratchVideoRecorder {
    protected ArrayList<BufferedImage> images = new ArrayList();

    public ImageVideoRecorder() {
        super(new ImageVideoType());
    }

    public Video getVideo() throws IOException {
        if (this.isSaved && this.saveFile != null) {
            return this.videoType.getVideo(this.saveFile.getAbsolutePath());
        }
        Image[] imageArray = this.images.toArray(new BufferedImage[0]);
        return new ImageVideo(imageArray);
    }

    public String saveVideo(String string) throws IOException {
        if (string == null) {
            return this.saveVideoAs();
        }
        this.setFileName(string);
        if (this.saveFile == null) {
            throw new IOException("Read-only file");
        }
        this.isSaved = true;
        BufferedImage[] bufferedImageArray = this.images.toArray(new BufferedImage[0]);
        String[] stringArray = this.saveImages(string, bufferedImageArray);
        return stringArray.length == 0 ? null : stringArray[0];
    }

    protected void saveScratch() {
    }

    protected boolean startRecording() {
        this.images.clear();
        if (this.dim == null) {
            if (this.frameImage != null) {
                this.dim = new Dimension(this.frameImage.getWidth(null), this.frameImage.getHeight(null));
            } else {
                return false;
            }
        }
        return true;
    }

    protected boolean append(Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        this.images.add(bufferedImage);
        return true;
    }

    protected String[] saveImages(String string, BufferedImage[] bufferedImageArray) throws IOException {
        int n = this.getAppendedNumber(string);
        int n2 = bufferedImageArray.length;
        if (n2 == 1) {
            ImageIO.write((RenderedImage)bufferedImageArray[0], "jpg", new BufferedOutputStream(new FileOutputStream(string)));
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = n2 + n < 10 ? 1 : (n2 + n < 100 ? 2 : (n2 + n < 1000 ? 3 : 4));
        String string2 = this.getBase(string);
        int n4 = 0;
        while (n4 < bufferedImageArray.length) {
            String string3 = String.valueOf(n4 + n);
            if (n3 == 2 && n4 + n < 10) {
                string3 = "0" + string3;
            } else if (n3 == 3 && n4 + n < 10) {
                string3 = "00" + string3;
            } else if (n3 == 3 && n4 + n < 100) {
                string3 = "0" + string3;
            } else if (n3 == 4 && n4 + n < 10) {
                string3 = "000" + string3;
            } else if (n3 == 4 && n4 + n < 100) {
                string3 = "00" + string3;
            } else if (n3 == 4 && n4 + n < 1000) {
                string3 = "0" + string3;
            }
            string = String.valueOf(string2) + string3 + "." + ext;
            arrayList.add(string);
            ImageIO.write((RenderedImage)bufferedImageArray[n4], ext, new BufferedOutputStream(new FileOutputStream(string)));
            ++n4;
        }
        return arrayList.toArray(new String[0]);
    }

    protected File getFileToBeSaved(File file) {
        int n = this.images.size();
        if (n <= 1) {
            return file;
        }
        String string = file.getAbsolutePath();
        int n2 = this.getAppendedNumber(string);
        String string2 = this.getBase(string);
        string = n2 > 0 ? String.valueOf(string2) + (n + n2 < 10 ? String.valueOf(n2) : (n + n2 < 100 && n2 < 10 ? "0" + n2 : (n + n2 < 100 ? String.valueOf(n2) : (n + n2 < 1000 && n2 < 10 ? "00" + n2 : (n + n2 < 1000 && n2 < 100 ? "0" + n2 : (n + n2 < 1000 ? String.valueOf(n2) : (n2 < 10 ? "000" + n2 : (n2 < 100 ? "00" + n2 : (n2 < 1000 ? "0" + n2 : String.valueOf(n2)))))))))) : String.valueOf(string2) + (n < 10 ? "0" : (n < 100 ? "00" : (n < 1000 ? "000" : "0000")));
        return new File(String.valueOf(string) + "." + ext);
    }

    protected String getBase(String string) {
        String string2 = XML.stripExtension(string);
        int n = string2.length();
        int n2 = 1;
        while (n2 < n) {
            try {
                Integer.parseInt(string2.substring(n - n2));
            }
            catch (NumberFormatException numberFormatException) {
                break;
            }
            ++n2;
        }
        if (--n2 == 0) {
            return string2;
        }
        return string2.substring(0, n - n2);
    }

    protected int getAppendedNumber(String string) {
        String string2 = XML.stripExtension(string);
        int n = string2.length();
        int n2 = 1;
        int n3 = 0;
        while (n2 < n) {
            try {
                n3 = Integer.parseInt(string2.substring(n - n2));
            }
            catch (NumberFormatException numberFormatException) {
                break;
            }
            ++n2;
        }
        return n3;
    }
}

