/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.AbstractODESolver;
import org.opensourcephysics.numerics.ODE;

public class Butcher5
extends AbstractODESolver {
    private double[] rate1;
    private double[] rate2;
    private double[] rate3;
    private double[] rate4;
    private double[] rate5;
    private double[] rate6;
    private double[] estimated_state;

    public Butcher5(ODE oDE) {
        super(oDE);
    }

    public void initialize(double d) {
        super.initialize(d);
        this.rate1 = new double[this.numEqn];
        this.rate2 = new double[this.numEqn];
        this.rate3 = new double[this.numEqn];
        this.rate4 = new double[this.numEqn];
        this.rate5 = new double[this.numEqn];
        this.rate6 = new double[this.numEqn];
        this.estimated_state = new double[this.numEqn];
    }

    public double step() {
        double[] dArray = this.ode.getState();
        if (dArray == null) {
            return this.stepSize;
        }
        if (dArray.length != this.numEqn) {
            this.initialize(this.stepSize);
        }
        this.ode.getRate(dArray, this.rate1);
        int n = 0;
        while (n < this.numEqn) {
            this.estimated_state[n] = dArray[n] + this.stepSize * this.rate1[n] / 4.0;
            ++n;
        }
        this.ode.getRate(this.estimated_state, this.rate2);
        n = 0;
        while (n < this.numEqn) {
            this.estimated_state[n] = dArray[n] + this.stepSize * (this.rate1[n] + this.rate2[n]) / 8.0;
            ++n;
        }
        this.ode.getRate(this.estimated_state, this.rate3);
        n = 0;
        while (n < this.numEqn) {
            this.estimated_state[n] = dArray[n] + this.stepSize * (-0.5 * this.rate2[n] + this.rate3[n]);
            ++n;
        }
        this.ode.getRate(this.estimated_state, this.rate4);
        n = 0;
        while (n < this.numEqn) {
            this.estimated_state[n] = dArray[n] + this.stepSize * (3.0 * this.rate1[n] + 9.0 * this.rate4[n]) / 16.0;
            ++n;
        }
        this.ode.getRate(this.estimated_state, this.rate5);
        n = 0;
        while (n < this.numEqn) {
            this.estimated_state[n] = dArray[n] + this.stepSize * (-3.0 * this.rate1[n] + 2.0 * this.rate2[n] + 12.0 * this.rate3[n] - 12.0 * this.rate4[n] + 8.0 * this.rate5[n]) / 7.0;
            ++n;
        }
        this.ode.getRate(this.estimated_state, this.rate6);
        n = 0;
        while (n < this.numEqn) {
            dArray[n] = dArray[n] + this.stepSize * (7.0 * this.rate1[n] + 32.0 * this.rate3[n] + 12.0 * this.rate4[n] + 32.0 * this.rate5[n] + 7.0 * this.rate6[n]) / 90.0;
            ++n;
        }
        return this.stepSize;
    }
}

