/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.opensourcephysics.numerics.Complex;

public strictfp class ComplexMatrix {
    private static String input_file_name;
    private static BufferedReader in;
    private static String output_file_name;
    private static BufferedWriter out;
    private static PrintWriter file_out;

    public static void solve(Complex[][] complexArray, Complex[] complexArray2, Complex[] complexArray3) {
        int n;
        int n2 = complexArray.length;
        int n3 = n2 + 1;
        Complex[][] complexArray4 = new Complex[n2][n3];
        int[] nArray = new int[n2];
        if (complexArray[0].length != n2 || complexArray2.length != n2 || complexArray3.length != n2) {
            System.out.println("Error in ComplexMatrix.solve inconsistent array sizes.");
        }
        int n4 = 0;
        while (n4 < n2) {
            n = 0;
            while (n < n2) {
                complexArray4[n4][n] = complexArray[n4][n];
                ++n;
            }
            complexArray4[n4][n2] = complexArray2[n4];
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            nArray[n4] = n4;
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            Complex complex = complexArray4[nArray[n4]][n4];
            double d = complex.abs();
            int n5 = n4;
            n = n4 + 1;
            while (n < n2) {
                if (complexArray4[nArray[n]][n4].abs() > d) {
                    n5 = n;
                    complex = complexArray4[nArray[n]][n4];
                    d = complex.abs();
                }
                ++n;
            }
            int n6 = nArray[n4];
            nArray[n4] = nArray[n5];
            nArray[n5] = n6;
            if (d < 1.0E-10) {
                n = n4 + 1;
                while (n < n2 + 1) {
                    complexArray4[nArray[n4]][n] = new Complex(0.0, 0.0);
                    ++n;
                }
                System.out.println("redundant row (singular) " + nArray[n4]);
            } else {
                n = n4 + 1;
                while (n < n2 + 1) {
                    complexArray4[nArray[n4]][n] = complexArray4[nArray[n4]][n].div(complexArray4[nArray[n4]][n4]);
                    ++n;
                }
                n = 0;
                while (n < n2) {
                    if (n != n4) {
                        int n7 = n4 + 1;
                        while (n7 < n2 + 1) {
                            complexArray4[nArray[n]][n7] = complexArray4[nArray[n]][n7].subtract(complexArray4[nArray[n]][n4].mul(complexArray4[nArray[n4]][n7]));
                            ++n7;
                        }
                    }
                    ++n;
                }
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            complexArray3[n4] = complexArray4[nArray[n4]][n2];
            ++n4;
        }
    }

    public static final void invert(Complex[][] complexArray) {
        int n;
        int n2 = complexArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        Complex[] complexArray2 = new Complex[n2];
        if (complexArray[0].length != n2) {
            System.out.println("Error in Complex.Matrix.invert, matrix not square.");
        }
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = n3;
            nArray2[n3] = n3;
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            int n4;
            Complex complex = complexArray[nArray[n3]][nArray2[n3]];
            int n5 = n3;
            int n6 = n3;
            n = n3;
            while (n < n2) {
                n4 = n3;
                while (n4 < n2) {
                    double d = complex.abs();
                    if (complexArray[nArray[n]][nArray2[n4]].abs() > d) {
                        n5 = n;
                        n6 = n4;
                        complex = complexArray[nArray[n]][nArray2[n4]];
                    }
                    ++n4;
                }
                ++n;
            }
            if (complex.abs() < 1.0E-10) {
                System.out.println("ComplexMatrix is singular !");
                return;
            }
            int n7 = nArray[n3];
            nArray[n3] = nArray[n5];
            nArray[n5] = n7;
            n7 = nArray2[n3];
            nArray2[n3] = nArray2[n6];
            nArray2[n6] = n7;
            complexArray[nArray[n3]][nArray2[n3]] = new Complex(1.0, 0.0).div(complex);
            n = 0;
            while (n < n2) {
                if (n != n3) {
                    complexArray[nArray[n3]][nArray2[n]] = complexArray[nArray[n3]][nArray2[n]].mul(complexArray[nArray[n3]][nArray2[n3]]);
                }
                ++n;
            }
            n = 0;
            while (n < n2) {
                if (n3 != n) {
                    n4 = 0;
                    while (n4 < n2) {
                        if (n3 != n4) {
                            complexArray[nArray[n]][nArray2[n4]] = complexArray[nArray[n]][nArray2[n4]].subtract(complexArray[nArray[n]][nArray2[n3]].mul(complexArray[nArray[n3]][nArray2[n4]]));
                        }
                        ++n4;
                    }
                    complexArray[nArray[n]][nArray2[n3]] = complexArray[nArray[n]][nArray2[n3]].mul(complexArray[nArray[n3]][nArray2[n3]]).neg();
                }
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            n = 0;
            while (n < n2) {
                complexArray2[nArray2[n]] = complexArray[nArray[n]][n3];
                ++n;
            }
            n = 0;
            while (n < n2) {
                complexArray[n][n3] = complexArray2[n];
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            n = 0;
            while (n < n2) {
                complexArray2[nArray[n]] = complexArray[n3][nArray2[n]];
                ++n;
            }
            n = 0;
            while (n < n2) {
                complexArray[n3][n] = complexArray2[n];
                ++n;
            }
            ++n3;
        }
    }

    public static final Complex determinant(Complex[][] complexArray) {
        int n;
        int n2 = complexArray.length;
        Complex complex = new Complex(1.0, 0.0);
        Complex[][] complexArray2 = new Complex[n2][n2];
        int[] nArray = new int[n2];
        if (complexArray[0].length != n2) {
            System.out.println("Error in ComplexMatrix.determinant, inconsistent array sizes.");
        }
        int n3 = 0;
        while (n3 < n2) {
            n = 0;
            while (n < n2) {
                complexArray2[n3][n] = complexArray[n3][n];
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            nArray[n3] = n3;
            ++n3;
        }
        n3 = 0;
        while (n3 < n2 - 1) {
            Complex complex2 = complexArray2[nArray[n3]][n3];
            double d = complex2.abs();
            int n4 = n3;
            n = n3;
            while (n < n2) {
                if (complexArray2[nArray[n]][n3].abs() > d) {
                    n4 = n;
                    complex2 = complexArray2[nArray[n]][n3];
                    d = complex2.abs();
                }
                ++n;
            }
            if (n4 != n3) {
                int n5 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n5;
                complex = complex.neg();
            }
            if (d < 1.0E-10) {
                return new Complex(0.0, 0.0);
            }
            complex = complex.mul(complex2);
            n = n3 + 1;
            while (n < n2) {
                complexArray2[nArray[n3]][n] = complexArray2[nArray[n3]][n].div(complexArray2[nArray[n3]][n3]);
                ++n;
            }
            n = 0;
            while (n < n2) {
                if (n != n3) {
                    int n6 = n3 + 1;
                    while (n6 < n2) {
                        complexArray2[nArray[n]][n6] = complexArray2[nArray[n]][n6].subtract(complexArray2[nArray[n]][n3].mul(complexArray2[nArray[n3]][n6]));
                        ++n6;
                    }
                }
                ++n;
            }
            ++n3;
        }
        return complex.mul(complexArray2[nArray[n2 - 1]][n2 - 1]);
    }

    public static final void eigenvalues(Complex[][] complexArray, Complex[][] complexArray2, Complex[] complexArray3) {
        int n = complexArray.length;
        Complex[][] complexArray4 = new Complex[n][n];
        Complex complex = new Complex(1.0, 0.0);
        Complex complex2 = new Complex(0.0, 0.0);
        if (complexArray[0].length != n || complexArray2.length != n || complexArray2[0].length != n || complexArray3.length != n) {
            System.out.println("Error in ComplexMatrix.eigenvalues, inconsistent array sizes.");
        }
        ComplexMatrix.identity(complexArray2);
        ComplexMatrix.copy(complexArray, complexArray4);
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n - 1) {
                int n4 = n3 + 1;
                while (n4 < n) {
                    ComplexMatrix.schur2(complexArray4, n3, n4, complex, complex2);
                    ComplexMatrix.mat44(n3, n4, complex, complex2, complexArray4, complexArray2);
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            complexArray3[n2] = complexArray4[n2][n2];
            ++n2;
        }
    }

    public static final void eigenCheck(Complex[][] complexArray, Complex[][] complexArray2, Complex[] complexArray3) {
        int n;
        if (complexArray == null || complexArray2 == null || complexArray3 == null) {
            return;
        }
        int n2 = complexArray.length;
        Complex[][] complexArray4 = new Complex[n2][n2];
        Complex[][] complexArray5 = new Complex[n2][n2];
        Complex[] complexArray6 = new Complex[n2];
        Complex[] complexArray7 = new Complex[n2];
        Complex[] complexArray8 = new Complex[n2];
        double d = 0.0;
        if (complexArray[0].length != n2 || complexArray2.length != n2 || complexArray2[0].length != n2 || complexArray3.length != n2) {
            System.out.println("Error in ComplexMatrix.eigenCheck, inconsistent array sizes.");
        }
        int n3 = 0;
        while (n3 < n2) {
            n = 0;
            while (n < n2) {
                complexArray6[n] = complexArray2[n][n3];
                ++n;
            }
            ComplexMatrix.mul(complexArray, complexArray6, complexArray8);
            n = 0;
            while (n < n2) {
                complexArray7[n] = complexArray8[n].subtract(complexArray3[n3].mul(complexArray6[n]));
                ++n;
            }
            System.out.println("check for near zero norm of Z[" + n3 + "]=" + complexArray7[n3]);
            ++n3;
        }
        d = ComplexMatrix.norm2(complexArray7);
        System.out.println("norm =" + d + " is eigen vector error indication 1.");
        System.out.println("det V = " + ComplexMatrix.determinant(complexArray2));
        n3 = 0;
        while (n3 < n2) {
            n = 0;
            while (n < n2) {
                complexArray7[n] = complexArray2[n][n3];
                ++n;
            }
            System.out.println("check for 1.0 = " + ComplexMatrix.norm2(complexArray7));
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            ComplexMatrix.identity(complexArray4);
            ComplexMatrix.mul(complexArray4, complexArray3[n3], complexArray5);
            ComplexMatrix.subtract(complexArray, complexArray5, complexArray4);
            complexArray7[n3] = ComplexMatrix.determinant(complexArray4);
            ++n3;
        }
        d = ComplexMatrix.norm2(complexArray7);
        System.out.println("norm =" + d + " is eigen value error indication.");
    }

    static void schur2(Complex[][] complexArray, int n, int n2, Complex complex, Complex complex2) {
        if (complexArray[0].length != complexArray.length) {
            System.out.println("Error in schur2 of Complex jacobi, inconsistent array sizes.");
        }
        if (complexArray[n][n2].abs() != 0.0) {
            Complex complex3 = complexArray[n2][n2].subtract(complexArray[n][n]).div(complexArray[n][n2].mul(2.0));
            Complex complex4 = complex3.mul(complex3).add(1.0).sqrt();
            Complex complex5 = complex3.abs() >= 0.0 ? complex3.add(complex4).invert() : complex4.subtract(complex3).invert().neg();
            complex = complex5.mul(complex5).add(1.0).sqrt().invert();
            complex2 = complex5.mul(complex);
        } else {
            complex = new Complex(1.0, 0.0);
            complex2 = new Complex(0.0, 0.0);
        }
    }

    static void mat22(Complex complex, Complex complex2, Complex[][] complexArray, Complex[][] complexArray2) {
        if (complexArray.length != 2 || complexArray[0].length != 2 || complexArray2.length != 2 || complexArray2[0].length != 2) {
            System.out.println("Error in mat22 of Jacobi, not both 2 by 2");
        }
        Complex[][] complexArray3 = new Complex[2][2];
        complexArray3[0][0] = complex.mul(complexArray[0][0]).subtract(complex2.mul(complexArray[0][1]));
        complexArray3[0][1] = complex2.mul(complexArray[0][0]).add(complex.mul(complexArray[0][1]));
        complexArray3[1][0] = complex.mul(complexArray[1][0]).subtract(complex2.mul(complexArray[1][1]));
        complexArray3[1][1] = complex2.mul(complexArray[1][0]).add(complex.mul(complexArray[1][1]));
        complexArray2[0][0] = complex.mul(complexArray3[0][0]).subtract(complex2.mul(complexArray3[1][0]));
        complexArray2[0][1] = complex.mul(complexArray3[0][1]).subtract(complex2.mul(complexArray3[1][1]));
        complexArray2[1][0] = complex2.mul(complexArray3[0][0]).add(complex.mul(complexArray3[1][0]));
        complexArray2[1][1] = complex2.mul(complexArray3[0][1]).add(complex.mul(complexArray3[1][1]));
    }

    static void mat44(int n, int n2, Complex complex, Complex complex2, Complex[][] complexArray, Complex[][] complexArray2) {
        int n3 = complexArray.length;
        Complex[][] complexArray3 = new Complex[n3][n3];
        Complex[][] complexArray4 = new Complex[n3][n3];
        if (complexArray[0].length != n3 || complexArray2.length != n3 || complexArray2[0].length != n3) {
            System.out.println("Error in mat44 of Complex Jacobi, A or V not same and square");
        }
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n3) {
                complexArray4[n4][n5] = new Complex(0.0, 0.0);
                ++n5;
            }
            complexArray4[n4][n4] = new Complex(1.0, 0.0);
            ++n4;
        }
        complexArray4[n][n] = complex;
        complexArray4[n][n2] = complex2.neg();
        complexArray4[n2][n2] = complex;
        complexArray4[n2][n] = complex2;
        ComplexMatrix.mul(complexArray4, complexArray, complexArray3);
        complexArray4[n][n2] = complex2;
        complexArray4[n2][n] = complex2.neg();
        ComplexMatrix.mul(complexArray3, complexArray4, complexArray);
        ComplexMatrix.mul(complexArray2, complexArray4, complexArray3);
        ComplexMatrix.copy(complexArray3, complexArray2);
    }

    static double norm4(Complex[][] complexArray) {
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        double d = 0.0;
        if (n != n2) {
            System.out.println("Error in Complex norm4, non square A[" + n + "][" + n2 + "]");
        }
        int n3 = 0;
        while (n3 < n - 1) {
            int n4 = n3 + 1;
            while (n4 < n) {
                d = d + complexArray[n3][n4].abs() + complexArray[n4][n3].abs();
                ++n4;
            }
            ++n3;
        }
        return d / (double)(n * n - n);
    }

    public static final void mul(Complex[][] complexArray, Complex[][] complexArray2, Complex[][] complexArray3) {
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        int n3 = complexArray2[0].length;
        if (complexArray2.length != n2 || complexArray3.length != n || complexArray3[0].length != n3) {
            System.out.println("Error in ComplexMatrix.mul, incompatible sizes");
        }
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n3) {
                complexArray3[n4][n5] = new Complex(0.0, 0.0);
                int n6 = 0;
                while (n6 < n2) {
                    complexArray3[n4][n5] = complexArray3[n4][n5].add(complexArray[n4][n6].mul(complexArray2[n6][n5]));
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
    }

    public static final void mul(Complex[][] complexArray, Complex complex, Complex[][] complexArray2) {
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        if (complexArray2.length != n || complexArray2[0].length != n2) {
            System.out.println("Error in ComplexMatrix.mul, incompatible sizes");
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                complexArray2[n3][n4] = complexArray[n3][n4].mul(complex);
                ++n4;
            }
            ++n3;
        }
    }

    public static final void add(Complex[][] complexArray, Complex[][] complexArray2, Complex[][] complexArray3) {
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        if (complexArray2.length != n || complexArray3.length != n || complexArray2[0].length != n2 || complexArray3[0].length != n2) {
            System.out.println("Error in ComplexMatrix.add, incompatible sizes");
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                complexArray3[n3][n4] = complexArray[n3][n4].add(complexArray2[n3][n4]);
                ++n4;
            }
            ++n3;
        }
    }

    public static final void add(Complex[][] complexArray, Complex complex, Complex[][] complexArray2) {
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        if (complexArray2.length != n || complexArray2[0].length != n2) {
            System.out.println("Error in ComplexMatrix.add, incompatible sizes");
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                complexArray2[n3][n4] = complexArray[n3][n4].add(complex);
                ++n4;
            }
            ++n3;
        }
    }

    public static final void subtract(Complex[][] complexArray, Complex[][] complexArray2, Complex[][] complexArray3) {
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        if (complexArray2.length != n || complexArray3.length != n || complexArray2[0].length != n2 || complexArray3[0].length != n2) {
            System.out.println("Error in ComplexMatrix.subtract, incompatible sizes");
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                complexArray3[n3][n4] = complexArray[n3][n4].subtract(complexArray2[n3][n4]);
                ++n4;
            }
            ++n3;
        }
    }

    public static final void subtract(Complex[][] complexArray, Complex complex, Complex[][] complexArray2) {
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        if (complexArray2.length != n || complexArray2[0].length != n2) {
            System.out.println("Error in ComplexMatrix.subtract, incompatible sizes");
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                complexArray2[n3][n4] = complexArray[n3][n4].subtract(complex);
                ++n4;
            }
            ++n3;
        }
    }

    public static final double norm1(Complex[][] complexArray) {
        double d = 0.0;
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        int n3 = 0;
        while (n3 < n2) {
            double d2 = 0.0;
            int n4 = 0;
            while (n4 < n) {
                d2 += complexArray[n4][n3].abs();
                ++n4;
            }
            d = Math.max(d, d2);
            ++n3;
        }
        return d;
    }

    public static final double normInf(Complex[][] complexArray) {
        double d = 0.0;
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        int n3 = 0;
        while (n3 < n) {
            double d2 = 0.0;
            int n4 = 0;
            while (n4 < n2) {
                d2 += complexArray[n3][n4].abs();
                ++n4;
            }
            d = Math.max(d, d2);
            ++n3;
        }
        return d;
    }

    public static final double normFro(Complex[][] complexArray) {
        double d = 0.0;
        int n = complexArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                d += complexArray[n2][n3].abs() * complexArray[n2][n3].abs();
                ++n3;
            }
            ++n2;
        }
        return Math.sqrt(d);
    }

    public static final double norm2(Complex[][] complexArray) {
        double d = 0.0;
        int n = complexArray.length;
        Complex[][] complexArray2 = new Complex[n][n];
        Complex[][] complexArray3 = new Complex[n][n];
        Complex[] complexArray4 = new Complex[n];
        if (complexArray[0].length != n) {
            System.out.println("Error in ComplexMatrix.norm2, matrix not square.");
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                complexArray2[n2][n3] = new Complex(0.0, 0.0);
                int n4 = 0;
                while (n4 < n) {
                    complexArray2[n2][n3] = complexArray2[n2][n3].add(complexArray[n4][n2].mul(complexArray[n4][n3]));
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        ComplexMatrix.eigenvalues(complexArray2, complexArray3, complexArray4);
        n2 = 0;
        while (n2 < n) {
            d = Math.max(d, complexArray4[n2].abs());
            ++n2;
        }
        return Math.sqrt(d);
    }

    public static final void copy(Complex[][] complexArray, Complex[][] complexArray2) {
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        if (complexArray2.length != n || complexArray2[0].length != n2) {
            System.out.println("Error in ComplexMatrix.copy, inconsistent sizes.");
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                complexArray2[n3][n4] = complexArray[n3][n4];
                ++n4;
            }
            ++n3;
        }
    }

    public static final boolean equals(Complex[][] complexArray, Complex[][] complexArray2) {
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        boolean bl = true;
        if (complexArray2.length != n || complexArray2[0].length != n2) {
            System.out.println("Error in ComplexMatrix.equals, inconsistent sizes.");
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                bl = bl && complexArray[n3][n4].equals(complexArray2[n3][n4]);
                ++n4;
            }
            ++n3;
        }
        return bl;
    }

    public static final void fromDouble(double[][] dArray, double[][] dArray2, Complex[][] complexArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (complexArray.length != n || complexArray[0].length != n2 || dArray2.length != n || dArray2[0].length != n2) {
            System.out.println("Error in ComplexMatrix.fromDouble, inconsistent sizes.");
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                complexArray[n3][n4] = new Complex(dArray[n3][n4], dArray2[n3][n4]);
                ++n4;
            }
            ++n3;
        }
    }

    public static final void fromDouble(double[][] dArray, Complex[][] complexArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (complexArray.length != n || complexArray[0].length != n2) {
            System.out.println("Error in ComplexMatrix.fromDouble, inconsistent sizes.");
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                complexArray[n3][n4] = new Complex(dArray[n3][n4]);
                ++n4;
            }
            ++n3;
        }
    }

    public static final void identity(Complex[][] complexArray) {
        int n = complexArray.length;
        if (n != complexArray[0].length) {
            System.out.println("Error in ComplexMatrix.identity, inconsistent sizes.");
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                complexArray[n2][n3] = new Complex(0.0);
                ++n3;
            }
            complexArray[n2][n2] = new Complex(1.0);
            ++n2;
        }
    }

    public static final void zero(Complex[][] complexArray) {
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                complexArray[n3][n4] = new Complex(0.0);
                ++n4;
            }
            ++n3;
        }
    }

    public static final void print(Complex[][] complexArray) {
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                System.out.println("A[" + n3 + "][" + n4 + "]=" + complexArray[n3][n4]);
                ++n4;
            }
            ++n3;
        }
    }

    public static final void mul(Complex[][] complexArray, Complex[] complexArray2, Complex[] complexArray3) {
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        if (complexArray2.length != n2 || complexArray3.length != n) {
            System.out.println("Error in ComplexMatrix.mul, incompatible sizes.");
        }
        int n3 = 0;
        while (n3 < n) {
            complexArray3[n3] = new Complex(0.0, 0.0);
            int n4 = 0;
            while (n4 < n2) {
                complexArray3[n3] = complexArray3[n3].add(complexArray[n3][n4].mul(complexArray2[n4]));
                ++n4;
            }
            ++n3;
        }
    }

    public static final void add(Complex[] complexArray, Complex[] complexArray2, Complex[] complexArray3) {
        int n = complexArray.length;
        if (complexArray2.length != n || complexArray3.length != n) {
            System.out.println("Error in ComplexMatrix.add, incompatible sizes.");
        }
        int n2 = 0;
        while (n2 < n) {
            complexArray3[n2] = complexArray[n2].add(complexArray2[n2]);
            ++n2;
        }
    }

    public static final void subtract(Complex[] complexArray, Complex[] complexArray2, Complex[] complexArray3) {
        int n = complexArray.length;
        if (complexArray2.length != n || complexArray3.length != n) {
            System.out.println("Error in ComplexMatrix.subtract, incompatible sizes.");
        }
        int n2 = 0;
        while (n2 < n) {
            complexArray3[n2] = complexArray[n2].subtract(complexArray2[n2]);
            ++n2;
        }
    }

    public static final double norm1(Complex[] complexArray) {
        double d = 0.0;
        int n = complexArray.length;
        int n2 = 0;
        while (n2 < n) {
            d += complexArray[n2].abs();
            ++n2;
        }
        return d;
    }

    public static final double norm2(Complex[] complexArray) {
        double d = 0.0;
        int n = complexArray.length;
        int n2 = 0;
        while (n2 < n) {
            d += complexArray[n2].abs() * complexArray[n2].abs();
            ++n2;
        }
        return StrictMath.sqrt(d);
    }

    public static final double normInf(Complex[] complexArray) {
        double d = 0.0;
        int n = complexArray.length;
        int n2 = 0;
        while (n2 < n) {
            d = Math.max(d, complexArray[n2].abs());
            ++n2;
        }
        return d;
    }

    public static final void copy(Complex[] complexArray, Complex[] complexArray2) {
        int n = complexArray.length;
        if (complexArray2.length != n) {
            System.out.println("Error in ComplexMatrix.copy, incompatible sizes");
        }
        int n2 = 0;
        while (n2 < n) {
            complexArray2[n2] = complexArray[n2];
            ++n2;
        }
    }

    public static final boolean equals(Complex[] complexArray, Complex[] complexArray2) {
        int n = complexArray.length;
        boolean bl = true;
        if (complexArray2.length != n) {
            System.out.println("Error in ComplexMatrix.equals, incompatible sizes");
        }
        int n2 = 0;
        while (n2 < n) {
            bl = bl && complexArray[n2].equals(complexArray2[n2]);
            ++n2;
        }
        return bl;
    }

    public static final void fromDouble(double[] dArray, Complex[] complexArray) {
        int n = dArray.length;
        if (complexArray.length != n) {
            System.out.println("Error in ComplexMatrix.fromDouble, incompatible sizes");
        }
        int n2 = 0;
        while (n2 < n) {
            complexArray[n2] = new Complex(dArray[n2]);
            ++n2;
        }
    }

    public static final void fromDouble(double[] dArray, double[] dArray2, Complex[] complexArray) {
        int n = dArray.length;
        if (complexArray.length != n || dArray2.length != n) {
            System.out.println("Error in ComplexMatrix.fromDouble, incompatible sizes");
        }
        int n2 = 0;
        while (n2 < n) {
            complexArray[n2] = new Complex(dArray[n2], dArray2[n2]);
            ++n2;
        }
    }

    public static void fromRoots(Complex[] complexArray, Complex[] complexArray2) {
        int n = complexArray.length;
        if (complexArray2.length != n + 1) {
            System.out.println("Error in ComplexMatrix.fromRoots, incompatible sizes");
        }
        complexArray2[0] = complexArray[0].neg();
        complexArray2[1] = new Complex(1.0);
        if (n == 1) {
            return;
        }
        int n2 = 1;
        while (n2 < n) {
            complexArray2[n2 + 1] = new Complex(0.0);
            int n3 = 0;
            while (n3 <= n2) {
                complexArray2[n2 + 1 - n3] = complexArray2[n2 - n3].subtract(complexArray2[n2 + 1 - n3].mul(complexArray[n2]));
                ++n3;
            }
            complexArray2[0] = complexArray2[0].mul(complexArray[n2]).neg();
            ++n2;
        }
    }

    public static final void unitVector(Complex[] complexArray, int n) {
        int n2 = complexArray.length;
        int n3 = 0;
        while (n3 < n2) {
            complexArray[n3] = new Complex(0.0);
            ++n3;
        }
        complexArray[n] = new Complex(1.0);
    }

    public static final void zero(Complex[] complexArray) {
        int n = complexArray.length;
        int n2 = 0;
        while (n2 < n) {
            complexArray[n2] = new Complex(0.0);
            ++n2;
        }
    }

    public static final void print(Complex[] complexArray) {
        int n = complexArray.length;
        int n2 = 0;
        while (n2 < n) {
            System.out.println("X[" + n2 + "]=" + complexArray[n2]);
            ++n2;
        }
    }

    public static final void readSize(String string, int[] nArray) {
        String string2 = new String("@");
        if (input_file_name == null || !string.equals(input_file_name)) {
            input_file_name = string;
            try {
                in = new BufferedReader(new FileReader(string));
            }
            catch (Exception exception) {
                System.out.println("ComplexMatrix.read unable to open file " + string);
                return;
            }
        }
        int n = 0;
        int n2 = 0;
        try {
            string2 = in.readLine();
            while (string2 != null) {
                int n3 = (string2 = string2.trim()).length();
                if (n3 == 0) {
                    string2 = in.readLine();
                    continue;
                }
                if (string2.charAt(0) == '(') {
                    System.out.println("ComplexMatrix.readSize unable to get size " + string);
                } else {
                    int n4 = 0;
                    int n5 = string2.indexOf(32);
                    if (n5 == -1) {
                        n5 = n3;
                    }
                    String string3 = string2.substring(n4, n5);
                    n = Integer.parseInt(string3);
                    string2 = string2.substring(n5, n3);
                    n3 = (string2 = string2.trim()).length();
                    if (n3 == 0) {
                        n2 = n;
                    } else {
                        n4 = 0;
                        n5 = string2.indexOf(32);
                        if (n5 == -1) {
                            n5 = n3;
                        }
                        string3 = string2.substring(n4, n5);
                        n2 = Integer.parseInt(string3);
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            System.out.println("ComplexMatrix.readSize unable to get size " + string);
        }
        nArray[0] = n;
        nArray[1] = n2;
    }

    public static final void read(String string, Complex[][] complexArray) {
        String string2;
        int n;
        int n2;
        int n3;
        String string3 = new String("@");
        boolean bl = false;
        if (input_file_name == null || !string.equals(input_file_name)) {
            input_file_name = string;
            try {
                in = new BufferedReader(new FileReader(string));
            }
            catch (Exception exception) {
                System.out.println("ComplexMatrix.read unable to open file " + string);
                return;
            }
        }
        int n4 = 0;
        int n5 = 0;
        try {
            string3 = in.readLine();
            while (string3 != null) {
                n3 = (string3 = string3.trim()).length();
                if (n3 == 0) {
                    string3 = in.readLine();
                    continue;
                }
                if (string3.charAt(0) == '(') {
                    n4 = complexArray.length;
                    n5 = complexArray[0].length;
                    bl = true;
                } else {
                    n2 = 0;
                    n = string3.indexOf(32);
                    if (n == -1) {
                        n = n3;
                    }
                    string2 = string3.substring(n2, n);
                    n4 = Integer.parseInt(string2);
                    string3 = string3.substring(n, n3);
                    n3 = (string3 = string3.trim()).length();
                    if (n3 == 0) {
                        n5 = n4;
                    } else {
                        n2 = 0;
                        n = string3.indexOf(32);
                        if (n == -1) {
                            n = n3;
                        }
                        string2 = string3.substring(n2, n);
                        n5 = Integer.parseInt(string2);
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            System.out.println("ComplexMatrix.read unable to get size " + string);
        }
        int n6 = 0;
        int n7 = 0;
        if (complexArray.length != n4 || complexArray[0].length != n5) {
            System.out.println("incompatible size in ComplexMatrix.read");
            return;
        }
        try {
            if (!bl) {
                string3 = in.readLine();
            }
            bl = false;
            while (string3 != null) {
                n3 = (string3 = string3.trim()).length();
                if (n3 == 0) {
                    string3 = in.readLine();
                    continue;
                }
                n2 = 0;
                n = string3.indexOf(41);
                if (n == -1) {
                    string3 = in.readLine();
                    continue;
                }
                string2 = string3.substring(n2, n + 1);
                complexArray[n6][n7] = Complex.parseComplex(string2);
                if (++n7 == n5) {
                    n7 = 0;
                    ++n6;
                }
                if (n6 != n4) {
                    string3 = string3.substring(n + 1);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            System.out.println("ComplexMatrix.read unable to read data " + string);
        }
    }

    public static final void closeInput() {
        try {
            in.close();
        }
        catch (Exception exception) {
            System.out.println("ComplexMatrix.closeInput not closed");
        }
        input_file_name = null;
    }

    public static final void write(String string, Complex[][] complexArray) {
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        if (output_file_name == null || !string.equals(output_file_name)) {
            output_file_name = string;
            try {
                out = new BufferedWriter(new FileWriter(string));
                file_out = new PrintWriter(out);
            }
            catch (Exception exception) {
                System.out.println("ComplexMatrix.write unable to open file " + string);
                return;
            }
        }
        if (n == n2) {
            file_out.println(n);
        } else {
            file_out.println(String.valueOf(n) + " " + n2);
        }
        try {
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    file_out.println(complexArray[n3][n4].toString());
                    ++n4;
                }
                ++n3;
            }
            file_out.println();
        }
        catch (Exception exception) {
            System.out.println("ComplexMatrix.write unable to write data " + string);
        }
    }

    public static final void closeOutput() {
        file_out.close();
        output_file_name = null;
    }
}

