/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.qss;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODESolverInterpolator;
import org.opensourcephysics.numerics.qss.EstimatedMultirateODE;
import org.opensourcephysics.numerics.qss.MultirateODE;

public class Qss
implements ODESolverInterpolator {
    protected final ODE ode;
    protected final MultirateODE multirate_ode;
    protected int dimension;
    protected int timeIndex;
    protected int max_index;
    protected double stepSize = 0.1;
    protected double infinity = Double.POSITIVE_INFINITY;
    protected double max_t;
    protected double lastDt;
    private double absoluteTolerance = Double.NaN;
    private double relativeTolerance = Double.NaN;
    protected double[] dq;
    protected double[] dqRel;
    protected double[] dqAbs;
    protected double[] x;
    protected double[] q;
    protected double[] qPlusDt;
    protected double[] dx;
    protected double[] tLast;
    protected double[] tNext;

    public Qss(ODE oDE) {
        this.ode = oDE;
        this.multirate_ode = oDE instanceof MultirateODE ? (MultirateODE)oDE : null;
    }

    public final ODE getODE() {
        return this.ode;
    }

    protected void allocateArrays() {
        this.dimension = this.ode.getState().length;
        this.timeIndex = this.dimension - 1;
        this.dq = new double[this.dimension];
        this.dqRel = new double[this.dimension];
        this.dqAbs = new double[this.dimension];
        this.x = new double[this.dimension];
        this.q = new double[this.dimension];
        if (this.multirate_ode != null) {
            this.qPlusDt = new double[this.dimension];
        }
        this.dx = new double[this.dimension];
        this.tLast = new double[this.dimension];
        this.tNext = new double[this.dimension];
    }

    public final double[] getCurrentRate() {
        return this.dx;
    }

    public final void setEstimateFirstStep(boolean bl) {
    }

    public final double getStepSize() {
        return this.stepSize;
    }

    public final void setStepSize(double d) {
        this.stepSize = d;
        double d2 = this.infinity;
        double d3 = this.infinity = this.stepSize > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        if (d2 != this.infinity) {
            this.reinitialize(this.ode.getState());
        }
    }

    public void setMaximumStepSize(double d) {
    }

    public void initialize(double d) {
        this.stepSize = d;
        this.infinity = d > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        this.allocateArrays();
        double[] dArray = this.ode.getState();
        int n = 0;
        while (n < this.dimension) {
            this.x[n] = this.q[n] = dArray[n];
            this.tLast[n] = dArray[this.timeIndex];
            ++n;
        }
        this.ode.getRate(this.x, this.dx);
        this.setTolerances(0.001, 0.0);
        if (this.ode instanceof EstimatedMultirateODE) {
            ((EstimatedMultirateODE)this.ode).estimateIncidenceMatrix();
        }
        if (this.isAutonomous()) {
            this.tNext[this.timeIndex] = this.infinity;
        }
        this.lastDt = this.dq[this.timeIndex];
    }

    public void reinitialize(double[] dArray) {
        int n = 0;
        while (n < this.dimension) {
            this.x[n] = this.q[n] = dArray[n];
            this.tLast[n] = dArray[this.timeIndex];
            this.dq[n] = Math.max(this.dqRel[n] * Math.abs(this.q[n]), this.dqAbs[n]);
            ++n;
        }
        this.ode.getRate(this.x, this.dx);
        n = 0;
        while (n < this.dimension) {
            this.tNext[n] = this.findNextTime(n, this.tLast[n]);
            ++n;
        }
        if (this.ode instanceof EstimatedMultirateODE) {
            ((EstimatedMultirateODE)this.ode).estimateIncidenceMatrix();
        }
        if (this.isAutonomous()) {
            this.tNext[this.timeIndex] = this.infinity;
        }
    }

    public double getMaximumTime() {
        return this.max_t;
    }

    public double internalStep() {
        this.q[this.max_index] = this.x[this.max_index] = this.findState(this.max_index, this.max_t);
        if (this.max_index != this.timeIndex) {
            this.dq[this.max_index] = Math.max(this.dqRel[this.max_index] * Math.abs(this.q[this.max_index]), this.dqAbs[this.max_index]);
        }
        this.tLast[this.max_index] = this.max_t;
        if (this.multirate_ode == null) {
            int n = 0;
            while (n < this.dimension) {
                this.x[n] = this.findState(n, this.max_t);
                ++n;
            }
            this.ode.getRate(this.q, this.dx);
            n = 0;
            while (n < this.dimension) {
                this.tNext[n] = this.recomputeNextTime(n, this.max_t);
                this.tLast[n] = this.max_t;
                ++n;
            }
        } else {
            double d = 0.0;
            int[][] nArray = this.multirate_ode.getInverseIncidenceMatrix();
            boolean bl = nArray[this.timeIndex].length != 0;
            int[] nArray2 = nArray[this.max_index];
            this.q[this.timeIndex] = this.max_t;
            int n = 0;
            while (n < nArray2.length) {
                int n2 = nArray2[n];
                this.x[n2] = this.findState(n2, this.max_t);
                this.dx[n2] = ((MultirateODE)this.ode).getRate(this.q, n2);
                this.tNext[n2] = this.recomputeNextTime(n2, this.max_t);
                this.tLast[n2] = this.max_t;
                if (bl && this.max_index == this.timeIndex) {
                    System.arraycopy(this.q, 0, this.qPlusDt, 0, this.timeIndex);
                    this.qPlusDt[this.timeIndex] = this.q[this.timeIndex] + this.dq[this.timeIndex];
                    double d2 = ((MultirateODE)this.ode).getRate(this.qPlusDt, n2);
                    d = Math.max(Math.abs(d2 - this.dx[n2]), d);
                }
                ++n;
            }
            if (bl && this.max_index == this.timeIndex) {
                this.lastDt = Math.min(this.dq[this.timeIndex] * this.dq[this.timeIndex] / d, 2.0 * this.lastDt);
                this.tNext[this.timeIndex] = this.max_t + this.lastDt;
            }
            if (this.tNext[this.max_index] == this.tLast[this.max_index]) {
                this.tNext[this.max_index] = this.findNextTime(this.max_index, this.max_t);
            }
        }
        this.findNextIntegrationTime();
        return this.max_t;
    }

    public double[] interpolate(double d, double[] dArray) {
        int n = 0;
        while (n < this.timeIndex) {
            dArray[n] = this.findState(n, d);
            ++n;
        }
        dArray[this.timeIndex] = d;
        return dArray;
    }

    public double[] bestInterpolate(double d, double[] dArray) {
        return this.interpolate(d, dArray);
    }

    protected void findNextIntegrationTime() {
        this.max_t = this.tNext[0];
        this.max_index = 0;
        int n = 1;
        while (n < this.dimension) {
            if (this.max_t > this.tNext[n]) {
                this.max_index = n;
                this.max_t = this.tNext[n];
            }
            ++n;
        }
    }

    protected double findNextTime(int n, double d) {
        if (this.dx[n] == 0.0) {
            return this.infinity;
        }
        return d + Math.abs(this.dq[n] / this.dx[n]);
    }

    protected double recomputeNextTime(int n, double d) {
        if (this.dx[n] > 0.0) {
            return d + (this.q[n] + this.dq[n] - this.x[n]) / this.dx[n];
        }
        if (this.dx[n] < 0.0) {
            return d + (this.q[n] - this.dq[n] - this.x[n]) / this.dx[n];
        }
        return this.infinity;
    }

    protected double findState(int n, double d) {
        return this.x[n] + (d - this.tLast[n]) * this.dx[n];
    }

    public final void setTolerances(double d, double d2) {
        if (this.absoluteTolerance == d && this.relativeTolerance == d2) {
            return;
        }
        this.absoluteTolerance = d;
        this.relativeTolerance = d2;
        int n = 0;
        while (n < this.timeIndex) {
            this.dqRel[n] = d2;
            this.dqAbs[n] = d;
            this.dq[n] = Math.max(this.dqRel[n] * Math.abs(this.q[n]), this.dqAbs[n]);
            this.tNext[n] = this.findNextTime(n, this.tLast[n]);
            ++n;
        }
        this.dqRel[this.timeIndex] = 0.0;
        this.dq[this.timeIndex] = this.dqAbs[this.timeIndex] = d;
        this.lastDt = this.dqAbs[this.timeIndex];
        if (this.ode instanceof EstimatedMultirateODE) {
            ((EstimatedMultirateODE)this.ode).estimateIncidenceMatrix();
        }
        if (!this.isAutonomous()) {
            this.tNext[this.timeIndex] = this.findNextTime(this.timeIndex, this.tLast[this.timeIndex]);
        }
        this.findNextIntegrationTime();
    }

    public void setToleranceArray(double[] dArray, double[] dArray2) {
        this.relativeTolerance = Double.NaN;
        this.absoluteTolerance = Double.NaN;
        if (dArray2.length != this.dimension || dArray.length != this.dimension) {
            System.err.println("Tolerance arrays have wrong dimension!");
            return;
        }
        int n = 0;
        while (n < this.timeIndex) {
            this.dqRel[n] = dArray2[n];
            this.dqAbs[n] = dArray[n];
            this.dq[n] = Math.max(this.dqRel[n] * Math.abs(this.q[n]), this.dqAbs[n]);
            this.tNext[n] = this.findNextTime(n, this.tLast[n]);
            ++n;
        }
        this.dqRel[this.timeIndex] = 0.0;
        this.dq[this.timeIndex] = this.dqAbs[this.timeIndex] = dArray[this.timeIndex];
        this.lastDt = this.dqAbs[this.timeIndex];
        if (this.ode instanceof EstimatedMultirateODE) {
            ((EstimatedMultirateODE)this.ode).estimateIncidenceMatrix();
        }
        if (!this.isAutonomous()) {
            this.tNext[this.timeIndex] = this.findNextTime(this.timeIndex, this.tLast[this.timeIndex]);
        }
        this.findNextIntegrationTime();
    }

    protected final boolean isAutonomous() {
        return this.multirate_ode == null ? false : this.multirate_ode.getInverseIncidenceMatrix()[this.timeIndex].length == 0;
    }

    public long getCounter() {
        return -1L;
    }
}

