/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.qss;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.qss.MultirateODE;
import org.opensourcephysics.numerics.qss.Qss;

public class Qss2
extends Qss {
    protected double[] der_dx;
    protected double[] der_q;
    protected double[] dx_old;
    protected double[] q_copy;
    protected double[] q_after;
    private final double COEFF = 1000.0;

    public Qss2(ODE oDE) {
        super(oDE);
    }

    protected void allocateArrays() {
        super.allocateArrays();
        this.der_dx = new double[this.dimension];
        this.der_q = new double[this.dimension];
        this.dx_old = new double[this.dimension];
        this.q_copy = new double[this.dimension];
        this.q_after = new double[this.dimension];
    }

    public final void initialize(double d) {
        this.stepSize = d;
        this.infinity = d > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        this.allocateArrays();
        this.reinitialize(this.ode.getState());
        this.setTolerances(0.001, 0.0);
    }

    public void reinitialize(double[] dArray) {
        int n = 0;
        while (n < this.dimension) {
            this.x[n] = this.q[n] = dArray[n];
            this.tLast[n] = dArray[this.timeIndex];
            this.dq[n] = Math.max(this.dqRel[n] * Math.abs(this.q[n]), this.dqAbs[n]);
            ++n;
        }
        this.ode.getRate(this.x, this.dx);
        System.arraycopy(this.dx, 0, this.der_q, 0, this.dimension);
        double d = dArray[this.timeIndex];
        double d2 = this.stepSize / 1000.0;
        int n2 = 0;
        while (n2 < this.dimension) {
            this.q_after[n2] = this.find_q(n2, d + d2);
            ++n2;
        }
        this.ode.getRate(this.q_after, this.dx_old);
        n2 = 0;
        while (n2 < this.dimension) {
            this.der_dx[n2] = (this.dx_old[n2] - this.dx[n2]) / d2;
            ++n2;
        }
        n2 = 0;
        while (n2 < this.dimension) {
            this.tNext[n2] = this.findNextTime(n2, this.tLast[n2]);
            ++n2;
        }
        this.tNext[this.timeIndex] = this.infinity;
        this.der_q[this.timeIndex] = 1.0;
    }

    public double internalStep() {
        double d = Math.max((this.max_t - this.tLast[this.max_index]) / 1000.0, 1.0E-9);
        this.q[this.max_index] = this.x[this.max_index] = this.findState(this.max_index, this.max_t);
        this.der_q[this.max_index] = this.dx[this.max_index] = this.findDerState(this.max_index, this.max_t);
        if (this.max_index != this.timeIndex) {
            this.dq[this.max_index] = Math.max(this.dqRel[this.max_index] * Math.abs(this.q[this.max_index]), this.dqAbs[this.max_index]);
        }
        this.tLast[this.max_index] = this.max_t;
        if (this.multirate_ode == null) {
            int n = 0;
            while (n < this.dimension) {
                this.q_copy[n] = this.find_q(n, this.max_t);
                ++n;
            }
            System.arraycopy(this.dx, 0, this.dx_old, 0, this.dimension);
            n = 0;
            while (n < this.dimension) {
                this.x[n] = this.findState(n, this.max_t);
                this.q[n] = this.q_copy[n];
                ++n;
            }
            this.ode.getRate(this.q_copy, this.dx);
            n = 0;
            while (n < this.dimension) {
                if (this.max_t != this.tLast[n]) {
                    this.der_dx[n] = (this.dx[n] - this.dx_old[n]) / (this.max_t - this.tLast[n]);
                }
                this.tNext[n] = this.recomputeNextTime(n, this.max_t);
                this.tLast[n] = this.max_t;
                ++n;
            }
        } else {
            int[][] nArray = this.multirate_ode.getInverseIncidenceMatrix();
            int[] nArray2 = nArray[this.max_index];
            this.q[this.timeIndex] = this.max_t;
            this.tLast[this.timeIndex] = this.max_t;
            this.x[this.timeIndex] = this.max_t;
            int n = 0;
            while (n < nArray2.length) {
                int n2 = nArray2[n];
                this.find_q(this.q_copy, n2, this.max_t);
                this.find_q(this.q_after, n2, this.max_t + d);
                this.x[n2] = this.findState(n2, this.max_t);
                this.dx[n2] = this.multirate_ode.getRate(this.q_copy, n2);
                double d2 = this.multirate_ode.getRate(this.q_after, n2);
                this.der_dx[n2] = (d2 - this.dx[n2]) / d;
                this.q[n2] = this.find_q(n2, this.max_t);
                this.tNext[n2] = this.recomputeNextTime(n2, this.max_t);
                this.tLast[n2] = this.max_t;
                ++n;
            }
            if (this.tNext[this.max_index] == this.tLast[this.max_index]) {
                this.tNext[this.max_index] = this.findNextTime(this.max_index, this.max_t);
            }
        }
        this.findNextIntegrationTime();
        return this.max_t;
    }

    protected double findNextTime(int n, double d) {
        if (this.der_q[n] == this.dx[n]) {
            if (this.der_dx[n] == 0.0) {
                return this.infinity;
            }
            return d + Math.sqrt(Math.abs(2.0 * this.dq[n] / this.der_dx[n]));
        }
        return this.recomputeNextTime(n, d);
    }

    public double minimumPositiveRoot(double d, double d2, double d3) {
        if (d == 0.0) {
            if (d2 == 0.0) {
                return this.infinity;
            }
            double d4 = -d3 / d2;
            if (d4 < 0.0) {
                return this.infinity;
            }
            return d4;
        }
        double d5 = d2 * d2 - 4.0 * d * d3;
        if (d5 < 0.0) {
            return this.infinity;
        }
        d5 = Math.sqrt(d5);
        double d6 = (-d2 + d5) / (d *= 2.0);
        double d7 = (-d2 - d5) / d;
        if (d6 < 0.0) {
            d6 = this.infinity;
        }
        if (d7 < 0.0) {
            d7 = this.infinity;
        }
        return this.stepSize > 0.0 ? Math.min(d6, d7) : Math.max(d6, d7);
    }

    protected double recomputeNextTime(int n, double d) {
        if (Math.abs(this.x[n] - this.q[n]) > this.dq[n]) {
            return d;
        }
        double d2 = this.der_dx[n] / 2.0;
        double d3 = this.dx[n] - this.der_q[n];
        double d4 = this.x[n] - this.q[n] + this.dq[n];
        double d5 = this.x[n] - this.q[n] - this.dq[n];
        return d + Math.min(this.minimumPositiveRoot(d2, d3, d4), this.minimumPositiveRoot(d2, d3, d5));
    }

    protected double findState(int n, double d) {
        double d2 = d - this.tLast[n];
        return this.x[n] + d2 * this.dx[n] + d2 * d2 * this.der_dx[n] / 2.0;
    }

    protected double findDerState(int n, double d) {
        double d2 = d - this.tLast[n];
        return this.dx[n] + d2 * this.der_dx[n];
    }

    protected double find_q(int n, double d) {
        double d2 = d - this.tLast[n];
        return this.q[n] + d2 * this.der_q[n];
    }

    protected void find_q(double[] dArray, int n, double d) {
        int[] nArray = ((MultirateODE)this.ode).getDirectIncidenceMatrix()[n];
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            dArray[n3] = this.find_q(n3, d);
            ++n2;
        }
    }
}

