/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.qss;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.qss.MultirateODE;
import org.opensourcephysics.numerics.qss.Qss2;

public class Qss3
extends Qss2 {
    protected double[] der_der_dx;
    protected double[] der_der_q;
    protected double[] der_dx_old;
    protected double[] dx_new;
    private final double COEFF = 100.0;

    public Qss3(ODE oDE) {
        super(oDE);
    }

    protected void allocateArrays() {
        super.allocateArrays();
        this.der_der_dx = new double[this.dimension];
        this.der_der_q = new double[this.dimension];
        this.der_dx_old = new double[this.dimension];
        this.dx_new = new double[this.dimension];
    }

    public void reinitialize(double[] dArray) {
        double d = dArray[this.timeIndex];
        double d2 = this.stepSize / 100.0;
        int n = 0;
        while (n < this.dimension) {
            this.x[n] = this.q[n] = dArray[n];
            this.tLast[n] = d;
            this.dq[n] = Math.max(this.dqRel[n] * Math.abs(this.q[n]), this.dqAbs[n]);
            this.der_der_dx[n] = 0.0;
            this.der_dx[n] = 0.0;
            this.der_der_q[n] = 0.0;
            this.der_q[n] = 0.0;
            ++n;
        }
        this.ode.getRate(this.x, this.dx);
        System.arraycopy(this.dx, 0, this.der_q, 0, this.dimension);
        n = 0;
        while (n < this.dimension) {
            this.q_after[n] = this.find_q(n, d + d2);
            ++n;
        }
        this.ode.getRate(this.q_after, this.dx_old);
        n = 0;
        while (n < this.dimension) {
            this.der_der_q[n] = this.der_dx[n] = (this.dx_old[n] - this.dx[n]) / d2;
            ++n;
        }
        n = 0;
        while (n < this.dimension) {
            this.q_after[n] = this.find_q(n, d + 2.0 * d2);
            ++n;
        }
        this.ode.getRate(this.q_after, this.dx_new);
        n = 0;
        while (n < this.dimension) {
            this.der_dx_old[n] = (this.dx_new[n] - this.dx_old[n]) / d2;
            this.der_der_dx[n] = (this.der_dx_old[n] - this.der_dx[n]) / d2;
            ++n;
        }
        n = 0;
        while (n < this.dimension) {
            this.tNext[n] = this.findNextTime(n, this.tLast[n]);
            ++n;
        }
        this.tNext[this.timeIndex] = this.infinity;
        this.der_q[this.timeIndex] = 1.0;
        this.der_der_q[this.timeIndex] = 0.0;
    }

    public double internalStep() {
        double d = Math.max((this.max_t - this.tLast[this.max_index]) / 100.0, 1.0E-9);
        this.q[this.max_index] = this.x[this.max_index] = this.findState(this.max_index, this.max_t);
        this.der_q[this.max_index] = this.dx[this.max_index] = this.findDerState(this.max_index, this.max_t);
        this.der_der_q[this.max_index] = this.der_dx[this.max_index] = this.findDerDerState(this.max_index, this.max_t);
        if (this.max_index != this.timeIndex) {
            this.dq[this.max_index] = Math.max(this.dqRel[this.max_index] * Math.abs(this.q[this.max_index]), this.dqAbs[this.max_index]);
        }
        this.tLast[this.max_index] = this.max_t;
        if (this.multirate_ode == null) {
            int n = 0;
            while (n < this.dimension) {
                this.q_copy[n] = this.find_q(n, this.max_t);
                ++n;
            }
            System.arraycopy(this.dx, 0, this.dx_old, 0, this.dimension);
            n = 0;
            while (n < this.dimension) {
                this.x[n] = this.findState(n, this.max_t);
                this.q[n] = this.q_copy[n];
                ++n;
            }
            this.ode.getRate(this.q_copy, this.dx);
            n = 0;
            while (n < this.dimension) {
                if (this.max_t != this.tLast[n]) {
                    this.der_dx[n] = (this.dx[n] - this.dx_old[n]) / (this.max_t - this.tLast[n]);
                }
                this.tNext[n] = this.recomputeNextTime(n, this.max_t);
                this.tLast[n] = this.max_t;
                ++n;
            }
        } else {
            int[][] nArray = this.multirate_ode.getInverseIncidenceMatrix();
            int[] nArray2 = nArray[this.max_index];
            this.q[this.timeIndex] = this.max_t;
            this.tLast[this.timeIndex] = this.max_t;
            this.x[this.timeIndex] = this.max_t;
            int n = 0;
            while (n < nArray2.length) {
                int n2 = nArray2[n];
                this.x[n2] = this.findState(n2, this.max_t);
                this.find_q(this.q_copy, n2, this.max_t);
                this.dx[n2] = this.multirate_ode.getRate(this.q_copy, n2);
                this.find_q(this.q_copy, n2, this.max_t + d);
                double d2 = this.multirate_ode.getRate(this.q_copy, n2);
                this.der_dx[n2] = (d2 - this.dx[n2]) / d;
                this.find_q(this.q_copy, n2, this.max_t + 2.0 * d);
                double d3 = this.multirate_ode.getRate(this.q_copy, n2);
                this.der_der_dx[n2] = (d3 - 2.0 * d2 + this.dx[n2]) / d / d;
                this.q[n2] = this.find_q(n2, this.max_t);
                this.der_q[n2] = this.find_der_q(n2, this.max_t);
                this.tNext[n2] = this.recomputeNextTime(n2, this.max_t);
                this.tLast[n2] = this.max_t;
                ++n;
            }
            if (this.tNext[this.max_index] == this.tLast[this.max_index]) {
                this.tNext[this.max_index] = this.findNextTime(this.max_index, this.max_t);
            }
        }
        this.findNextIntegrationTime();
        return this.max_t;
    }

    protected double findNextTime(int n, double d) {
        if (this.der_q[n] == this.dx[n] && this.der_der_q[n] == this.der_dx[n]) {
            if (this.der_der_dx[n] == 0.0) {
                return this.infinity;
            }
            return d + Math.cbrt(Math.abs(6.0 * this.dq[n] / this.der_der_dx[n]));
        }
        return this.recomputeNextTime(n, d);
    }

    private double minimumPositiveRoot(double d, double d2, double d3, double d4) {
        if (d == 0.0) {
            return this.minimumPositiveRoot(d2, d3, d4);
        }
        double d5 = d3 / d - d2 * d2 / d / d / 3.0;
        double d6 = (2.0 * d2 * d2 * d2 / d / d / d - 9.0 * d2 * d3 / d / d + 27.0 * d4 / d) / 27.0;
        double d7 = d5 * d5 * d5 / 27.0 + d6 * d6 / 4.0;
        if (d7 < 0.0) {
            double d8 = Math.acos(-d6 / 2.0 / Math.sqrt(Math.abs(d5 * d5 * d5) / 27.0));
            double d9 = 2.0 * Math.sqrt(Math.abs(d5) / 3.0);
            double d10 = d9 * Math.cos(d8 / 3.0);
            double d11 = -d9 * Math.cos((d8 + Math.PI) / 3.0);
            double d12 = -d9 * Math.cos((d8 - Math.PI) / 3.0);
            d9 = d2 / d / 3.0;
            d10 -= d9;
            d11 -= d9;
            d12 -= d9;
            if (d10 < 0.0) {
                d10 = Double.POSITIVE_INFINITY;
            }
            if (d11 < 0.0) {
                d11 = Double.POSITIVE_INFINITY;
            }
            if (d12 < 0.0) {
                d12 = Double.POSITIVE_INFINITY;
            }
            return Math.min(Math.min(d10, d11), d12);
        }
        if (d7 == 0.0) {
            double d13 = 2.0 * Math.cbrt(-d6 / 2.0);
            double d14 = -d13 / 2.0;
            double d15 = d2 / d / 3.0;
            d13 -= d15;
            d14 -= d15;
            if (d13 < 0.0) {
                d13 = Double.POSITIVE_INFINITY;
            }
            if (d14 < 0.0) {
                d14 = Double.POSITIVE_INFINITY;
            }
            return Math.min(d13, d14);
        }
        double d16 = Math.sqrt(d7);
        double d17 = Math.cbrt(-d6 / 2.0 + d16) + Math.cbrt(-d6 / 2.0 - d16) - d2 / d / 3.0;
        if (d17 < 0.0) {
            d17 = Double.POSITIVE_INFINITY;
        }
        return d17;
    }

    protected double recomputeNextTime(int n, double d) {
        if (Math.abs(this.x[n] - this.q[n]) > this.dq[n]) {
            return d;
        }
        double d2 = this.der_der_dx[n] / 6.0;
        double d3 = (this.der_dx[n] - this.der_der_q[n]) / 2.0;
        double d4 = this.dx[n] - this.der_q[n];
        double d5 = this.x[n] - this.q[n] + this.dq[n];
        double d6 = this.x[n] - this.q[n] - this.dq[n];
        return d + Math.min(this.minimumPositiveRoot(d2, d3, d4, d5), this.minimumPositiveRoot(d2, d3, d4, d6));
    }

    protected double findState(int n, double d) {
        double d2 = d - this.tLast[n];
        return this.x[n] + d2 * this.dx[n] + d2 * d2 * this.der_dx[n] / 2.0 + d2 * d2 * d2 * this.der_der_dx[n] / 6.0;
    }

    protected double findDerState(int n, double d) {
        double d2 = d - this.tLast[n];
        return this.dx[n] + d2 * this.der_dx[n] + d2 * d2 * this.der_der_dx[n] / 2.0;
    }

    protected double findDerDerState(int n, double d) {
        double d2 = d - this.tLast[n];
        return this.der_dx[n] + d2 * this.der_der_dx[n];
    }

    protected double find_q(int n, double d) {
        double d2 = d - this.tLast[n];
        return this.q[n] + d2 * this.der_q[n] + d2 * d2 * this.der_der_q[n] / 2.0;
    }

    protected double find_der_q(int n, double d) {
        double d2 = d - this.tLast[n];
        return this.der_q[n] + d2 * this.der_der_q[n];
    }

    protected void find_q(double[] dArray, int n, double d) {
        int[] nArray = ((MultirateODE)this.ode).getDirectIncidenceMatrix()[n];
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            dArray[n3] = this.find_q(n3, d);
            ++n2;
        }
    }
}

