/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.rk;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.rk.AbstractExplicitRKSolverInterpolator;

public class Fehlberg8
extends AbstractExplicitRKSolverInterpolator {
    private double[] rate2;
    private double[] rate3;
    private double[] rate4;
    private double[] rate5;
    private double[] rate6;
    private double[] rate7;
    private double[] rate8;
    private double[] rate9;
    private double[] rate10;
    private double[] rate11;
    private double[] rate12;
    private double[] rate13;

    public Fehlberg8(ODE oDE) {
        this.ode = oDE;
    }

    protected void allocateOtherArrays() {
        this.rate2 = new double[this.dimension];
        this.rate3 = new double[this.dimension];
        this.rate4 = new double[this.dimension];
        this.rate5 = new double[this.dimension];
        this.rate6 = new double[this.dimension];
        this.rate7 = new double[this.dimension];
        this.rate8 = new double[this.dimension];
        this.rate9 = new double[this.dimension];
        this.rate10 = new double[this.dimension];
        this.rate11 = new double[this.dimension];
        this.rate12 = new double[this.dimension];
        this.rate13 = new double[this.dimension];
    }

    protected int getNumberOfEvaluations() {
        return 13;
    }

    protected double[] computeIntermediateStep(double d, double[] dArray) {
        int n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * 0.07407407407407407 * this.initialRate[n];
            ++n;
        }
        this.ode.getRate(dArray, this.rate2);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.027777777777777776 * this.initialRate[n] + 0.08333333333333333 * this.rate2[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate3);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.041666666666666664 * this.initialRate[n] + 0.125 * this.rate3[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate4);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.4166666666666667 * this.initialRate[n] + -1.5625 * this.rate3[n] + 1.5625 * this.rate4[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate5);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.05 * this.initialRate[n] + 0.25 * this.rate4[n] + 0.2 * this.rate5[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate6);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (-0.23148148148148148 * this.initialRate[n] + 1.1574074074074074 * this.rate4[n] + -2.4074074074074074 * this.rate5[n] + 2.314814814814815 * this.rate6[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate7);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.10333333333333333 * this.initialRate[n] + 0.27111111111111114 * this.rate5[n] + -0.2222222222222222 * this.rate6[n] + 0.014444444444444444 * this.rate7[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate8);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (2.0 * this.initialRate[n] + -8.833333333333334 * this.rate4[n] + 15.644444444444444 * this.rate5[n] + -11.88888888888889 * this.rate6[n] + 0.7444444444444445 * this.rate7[n] + 3.0 * this.rate8[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate9);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (-0.8425925925925926 * this.initialRate[n] + 0.21296296296296297 * this.rate4[n] + -7.229629629629629 * this.rate5[n] + 5.7592592592592595 * this.rate6[n] + -0.31666666666666665 * this.rate7[n] + 2.8333333333333335 * this.rate8[n] + -0.08333333333333333 * this.rate9[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate10);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.5812195121951219 * this.initialRate[n] + -2.0792682926829267 * this.rate4[n] + 4.3863414634146345 * this.rate5[n] + -3.6707317073170733 * this.rate6[n] + 0.5202439024390244 * this.rate7[n] + 0.5487804878048781 * this.rate8[n] + 0.27439024390243905 * this.rate9[n] + 0.43902439024390244 * this.rate10[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate11);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.014634146341463415 * this.initialRate[n] + -0.14634146341463414 * this.rate6[n] + -0.014634146341463415 * this.rate7[n] + -0.07317073170731707 * this.rate8[n] + 0.07317073170731707 * this.rate9[n] + 0.14634146341463414 * this.rate10[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate12);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (-0.43341463414634146 * this.initialRate[n] + -2.0792682926829267 * this.rate4[n] + 4.3863414634146345 * this.rate5[n] + -3.524390243902439 * this.rate6[n] + 0.5348780487804878 * this.rate7[n] + 0.6219512195121951 * this.rate8[n] + 0.20121951219512196 * this.rate9[n] + 0.2926829268292683 * this.rate10[n] + 1.0 * this.rate12[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate13);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.3238095238095238 * this.rate6[n] + 0.2571428571428571 * this.rate7[n] + 0.2571428571428571 * this.rate8[n] + 0.03214285714285714 * this.rate9[n] + 0.03214285714285714 * this.rate10[n] + 0.04880952380952381 * this.rate12[n] + 0.04880952380952381 * this.rate13[n]);
            ++n;
        }
        return dArray;
    }

    public double[] interpolate(double d, double[] dArray) {
        return super.interpolateBootstrap2(d, dArray);
    }
}

