/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.opensourcephysics.controls.XML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarTreeModel
implements TreeModel {
    protected File root;
    protected Map<File, JarNode[]> topLevelNodeArrays = new HashMap<File, JarNode[]>();
    protected Map<File, Map<String, JarNode>> pathMaps = new HashMap<File, Map<String, JarNode>>();

    public JarTreeModel(File file) {
        this.root = file;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        if (object instanceof File) {
            File file = (File)object;
            if (file.getName().endsWith(".jar")) {
                return false;
            }
            return ((File)object).isFile();
        }
        if (object instanceof JarNode) {
            JarNode jarNode = (JarNode)object;
            return jarNode.isLeaf();
        }
        return true;
    }

    @Override
    public int getChildCount(Object object) {
        if (object instanceof File) {
            File file = (File)object;
            if (file.getName().endsWith(".jar")) {
                JarNode[] jarNodeArray = this.getJarNodes(file);
                return jarNodeArray == null ? 0 : jarNodeArray.length;
            }
            String[] stringArray = ((File)object).list();
            return stringArray == null ? 0 : stringArray.length;
        }
        if (object instanceof JarNode) {
            JarNode jarNode = (JarNode)object;
            return jarNode.getChildCount();
        }
        return 0;
    }

    @Override
    public Object getChild(Object object, int n) {
        if (object instanceof File) {
            File file = (File)object;
            if (file.getName().endsWith(".jar")) {
                JarNode[] jarNodeArray = this.getJarNodes(file);
                if (jarNodeArray != null && jarNodeArray.length > n) {
                    return jarNodeArray[n];
                }
                return "no child found";
            }
            String[] stringArray = file.list();
            if (stringArray == null || n >= stringArray.length) {
                return null;
            }
            return new File(file, stringArray[n]){

                public String toString() {
                    return this.getName();
                }
            };
        }
        if (object instanceof JarNode) {
            JarNode jarNode = (JarNode)object;
            return jarNode.getChildAt(n);
        }
        return null;
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (object instanceof File) {
            Object[] objectArray;
            File file = (File)object;
            if (file.getName().endsWith(".jar")) {
                objectArray = this.getJarNodes(file);
                if (objectArray == null) {
                    return -1;
                }
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n].equals(object2)) {
                        return n;
                    }
                    ++n;
                }
            }
            if ((objectArray = ((File)object).list()) == null) {
                return -1;
            }
            String string = ((File)object2).getName();
            int n = 0;
            while (n < objectArray.length) {
                if (string.equals(objectArray[n])) {
                    return n;
                }
                ++n;
            }
        } else if (object instanceof JarNode) {
            JarNode jarNode = (JarNode)object;
            return jarNode.getIndex((JarNode)object2);
        }
        return -1;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
    }

    public Object getChild(Object object, String string) {
        block8: {
            block7: {
                int n;
                Object[] objectArray;
                if (!(object instanceof File)) break block7;
                File file = (File)object;
                if (file.getName().endsWith(".jar") && (objectArray = this.getJarNodes(file)) != null) {
                    n = 0;
                    while (n < objectArray.length) {
                        if (((JarNode)objectArray[n]).toString().equals(string)) {
                            return objectArray[n];
                        }
                        ++n;
                    }
                }
                if ((objectArray = file.list()) == null) break block8;
                n = 0;
                while (n < objectArray.length) {
                    if (((String)objectArray[n]).toString().equals(string)) {
                        return new File(file, (String)objectArray[n]){

                            public String toString() {
                                return this.getName();
                            }
                        };
                    }
                    ++n;
                }
                break block8;
            }
            if (object instanceof JarNode) {
                JarNode jarNode = (JarNode)object;
                Enumeration<TreeNode> enumeration = jarNode.children();
                while (enumeration.hasMoreElements()) {
                    JarNode jarNode2 = (JarNode)enumeration.nextElement();
                    if (!jarNode2.toString().equals(string)) continue;
                    return jarNode2;
                }
            }
        }
        return null;
    }

    protected Collection<Object[]> getDescendantPaths(Object[] objectArray) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        arrayList.add(objectArray);
        Object object = objectArray[objectArray.length - 1];
        int n = this.getChildCount(object);
        int n2 = 0;
        while (n2 < n) {
            Object object2 = this.getChild(object, n2);
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray2[objectArray.length] = object2;
            Collection<Object[]> collection = this.getDescendantPaths(objectArray2);
            arrayList.addAll(collection);
            ++n2;
        }
        return arrayList;
    }

    public JarNode getJarNode(File file, String string) {
        Map<String, JarNode> map = this.pathMaps.get(file);
        if (map == null) {
            this.readJar(file);
            map = this.pathMaps.get(file);
        }
        return map.get(string);
    }

    public JarNode[] getJarNodes(File file) {
        JarNode[] jarNodeArray = this.topLevelNodeArrays.get(file);
        if (jarNodeArray == null) {
            this.readJar(file);
            jarNodeArray = this.topLevelNodeArrays.get(file);
        }
        return jarNodeArray;
    }

    private void readJar(File file) {
        Collection<String> collection = this.getJarEntries(file);
        ArrayList<JarNode> arrayList = new ArrayList<JarNode>();
        HashMap<String, JarNode> hashMap = new HashMap<String, JarNode>();
        JarNode[] jarNodeArray = collection.iterator();
        while (jarNodeArray.hasNext()) {
            String string = XML.forwardSlash(jarNodeArray.next().toString());
            if (string.startsWith("META-INF")) continue;
            JarNode jarNode = null;
            String string2 = "";
            while (string != null) {
                JarNode jarNode2;
                int n = string.indexOf("/");
                if (n > -1) {
                    jarNode2 = (JarNode)hashMap.get(string2 = String.valueOf(string2) + string.substring(0, n + 1));
                    if (jarNode2 == null) {
                        jarNode2 = new JarNode(string2);
                        hashMap.put(string2, jarNode2);
                        if (jarNode != null) {
                            jarNode.add(jarNode2);
                        } else {
                            arrayList.add(jarNode2);
                        }
                    }
                    string = string.substring(n + 1);
                    jarNode = jarNode2;
                    continue;
                }
                string = String.valueOf(string2) + string;
                jarNode2 = (JarNode)hashMap.get(string);
                if (jarNode2 == null) {
                    jarNode2 = new JarNode(string);
                    hashMap.put(string, jarNode2);
                    if (jarNode != null) {
                        jarNode.add(jarNode2);
                    } else {
                        arrayList.add(jarNode2);
                    }
                }
                string = null;
            }
        }
        jarNodeArray = arrayList.toArray(new JarNode[0]);
        this.topLevelNodeArrays.put(file, jarNodeArray);
        this.pathMaps.put(file, hashMap);
    }

    private Collection<String> getJarEntries(File file) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (jarFile != null) {
            TreeSet<String> treeSet = new TreeSet<String>();
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                treeSet.add(jarEntry.getName());
            }
            return treeSet;
        }
        return null;
    }

    class JarNode
    extends DefaultMutableTreeNode {
        String name;

        public JarNode(String string) {
            this.name = XML.getName(string);
            if (this.name.equals("")) {
                this.name = XML.getName(string.substring(0, string.length() - 1));
            }
        }

        public String toString() {
            return this.name;
        }
    }
}

