/*
 * Decompiled with CFR 0.152.
 */
package users.eckerd.coxaj.elec_distribution.DipoleTrajectory_pkg;

import java.awt.Dimension;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.GeneralStateEvent;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEInterpolatorEventSolver;
import org.opensourcephysics.numerics.ODESolverInterpolator;
import org.opensourcephysics.numerics.ZenoEffectListener;
import org.opensourcephysics.numerics.rk.CashKarp45;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataFull;
import users.eckerd.coxaj.elec_distribution.DipoleTrajectory_pkg.DipoleTrajectorySimulation;
import users.eckerd.coxaj.elec_distribution.DipoleTrajectory_pkg.DipoleTrajectoryView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DipoleTrajectory
extends Model {
    public DipoleTrajectorySimulation _simulation = null;
    public DipoleTrajectoryView _view = null;
    public DipoleTrajectory _model = this;
    protected Hashtable<String, __PrivateODE> _privateOdesList = new Hashtable();
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public double s = 1.0;
    public double r = 0.12;
    public double size = 1.0;
    public double xmin = -this.size;
    public double xmax = this.size;
    public double ymin = -this.size;
    public double ymax = this.size;
    public int nx = 20;
    public int ny = 20;
    public double[][] xField;
    public double[][] yField;
    public double[][] elecField;
    public double t = 0.0;
    public double dt = 0.01;
    public double x = 0.3;
    public double y = 0.2;
    public double vx = 0.0;
    public double vy = 0.0;
    public double Ex;
    public double Ey;
    public boolean collision = false;
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_evolution1 = true;
    private boolean _isEnabled_evolution1_Event1 = true;
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "/users/eckerd/coxaj/elec_distribution/DipoleTrajectory.xml";
    }

    public static String _getModelDirectory() {
        return "users/eckerd/coxaj/elec_distribution/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(472, 556);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("/users/eckerd/coxaj/elec_distribution/DipoleTrajectoryWrong/dipoleField.jpg");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/DipoleTrajectoryWrong/DipoleTrajectory.html");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/DipoleTrajectoryWrong/DipoleTrajectoryLessonPlan.doc");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/DipoleTrajectoryWrong/DipoleTrajectoryStudentWorksheet.doc");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/DipoleTrajectoryWrong/DipoleTrajectoryStudentWorksheet.pdf");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/DipoleTrajectoryWrong/ejsPage.css");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/DipoleTrajectoryWrong/ElectricFieldStudentWorksheet.doc");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/DipoleTrajectoryWrong/DipoleTrajectory.html");
        return hashSet;
    }

    public static void _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/eckerd/coxaj/elec_distribution/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/EJS_4.2/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("C:/EJS_4.2/bin/config/");
        }
    }

    public static void main(String[] stringArray) {
        DipoleTrajectory._common_initialization(stringArray);
        DipoleTrajectory dipoleTrajectory = new DipoleTrajectory(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        DipoleTrajectory._common_initialization(stringArray);
        DipoleTrajectory dipoleTrajectory = new DipoleTrajectory("mainFrame", jFrame, null, null, stringArray, true);
        return (JComponent)dipoleTrajectory._getView().getComponent("mainFrame");
    }

    public DipoleTrajectory() {
        this(null, null, null, null, null, false);
    }

    public DipoleTrajectory(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public DipoleTrajectory(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new DipoleTrajectorySimulation(this, string, frame, uRL, bl);
        this._view = (DipoleTrajectoryView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        this._isEnabled_initialization1 = true;
        this._isEnabled_evolution1 = true;
        this._isEnabled_evolution1_Event1 = true;
        this.s = 1.0;
        this.r = 0.12;
        this.size = 1.0;
        this.xmin = -this.size;
        this.xmax = this.size;
        this.ymin = -this.size;
        this.ymax = this.size;
        this.nx = 20;
        this.ny = 20;
        this.xField = new double[this.nx][this.ny];
        this.yField = new double[this.nx][this.ny];
        this.elecField = new double[this.nx][this.ny];
        this.t = 0.0;
        this.dt = 0.01;
        this.x = 0.3;
        this.y = 0.2;
        this.vx = 0.0;
        this.vy = 0.0;
        this.collision = false;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public void _initializeModel() {
        if (this._isEnabled_initialization1) {
            this._initialization1();
        }
        for (__PrivateODE __PrivateODE2 : this._privateOdesList.values()) {
            __PrivateODE2.__initializeSolver();
        }
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.__resetSolver();
        this._external.resetIC();
    }

    @Override
    public void _stepModel() {
        if (this._isEnabled_evolution1) {
            this._ODEi_evolution1.__stepODE();
        }
    }

    @Override
    public void _updateModel() {
    }

    @Override
    public void _freeMemory() {
        this.xField = null;
        this.yField = null;
        this.elecField = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    public ODEInterpolatorEventSolver _getEventSolver(String string) {
        try {
            return this._privateOdesList.get(string).__getEventSolver();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void _setSolverClass(String string, Class<?> clazz) {
        try {
            this._privateOdesList.get(string).__setSolverClass(clazz);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
        }
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Init Page".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("Evol Page".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1 = bl;
            this._resetSolvers();
        }
        if ("Collision".equals(string)) {
            this._isEnabled_evolution1_Event1 = bl;
            this._ODEi_evolution1.__initializeSolver();
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        this.t = 0.0;
        this.x = 0.3;
        this.y = 0.2;
        this.vx = 0.0;
        this.vy = 0.0;
        this.collision = false;
        this._view.testChargeTrail.clear();
        this.computeField();
    }

    public void computeField() {
        for (int i = 0; i < this.nx; ++i) {
            double d = this._view.vectorField2D.indexToX(i);
            for (int j = 0; j < this.ny; ++j) {
                double d2 = this._view.vectorField2D.indexToY(j);
                double[] dArray = this.getE(d, d2);
                this.xField[i][j] = dArray[0];
                this.yField[i][j] = dArray[1];
                this.elecField[i][j] = dArray[2];
            }
        }
    }

    public double[] getE(double d, double d2) {
        double[] dArray = new double[3];
        for (int i = 0; i < 2; ++i) {
            double d3 = d2 + (-this.s / 2.0 + (double)i * this.s);
            double d4 = 3.0 * Math.pow(-1.0, i);
            double d5 = d * d + d3 * d3;
            double d6 = Math.sqrt(d5);
            double d7 = d5 * d6;
            if (d5 == 0.0) {
                dArray[0] = 0.0;
                dArray[1] = 0.0;
                continue;
            }
            dArray[0] = dArray[0] + d4 * d / d7;
            dArray[1] = dArray[1] + d4 * d3 / d7;
        }
        dArray[2] = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
        return dArray;
    }

    public double _method_for_fieldPlottingPanel_minimumX() {
        return -this.size;
    }

    public double _method_for_fieldPlottingPanel_minimumY() {
        return -this.size;
    }

    public double _method_for_positiveCharge_y() {
        return this.s / 2.0;
    }

    public double _method_for_positiveCharge_sizeX() {
        return this.r * 2.0;
    }

    public double _method_for_positiveCharge_sizeY() {
        return this.r * 2.0;
    }

    public double _method_for_negativeCharge_y() {
        return -this.s / 2.0;
    }

    public double _method_for_negativeCharge_sizeX() {
        return this.r * 2.0;
    }

    public double _method_for_negativeCharge_sizeY() {
        return this.r * 2.0;
    }

    public void _method_for_testCharge_dragAction() {
        this.collision = false;
        this._view.testChargeTrail.clear();
    }

    public void _method_for_testCharge_releaseAction() {
        double d = this.x * this.x + (Math.abs(this.y) - this.s / 2.0) * (Math.abs(this.y) - this.s / 2.0);
        if (d < this.r * this.r) {
            this._view.alert("playPauseButton", "Collision", "Test charge can not sit on charge.");
            this.x = this.x < 0.0 ? (this.x -= 1.4 * this.r) : (this.x += 1.4 * this.r);
        }
        this.vx = 0.0;
        this.vy = 0.0;
        this._view.testChargeTrail.clear();
    }

    public double _method_for_velocityVector_sizeX() {
        return this.vx / 10.0;
    }

    public double _method_for_velocityVector_sizeY() {
        return this.vy / 10.0;
    }

    public void _method_for_separationSlider_dragaction() {
        this._initialize();
    }

    public void _method_for_separationField_action() {
        this.s = Math.max(this.s, 0.0);
        this.s = Math.min(this.s, 1.5);
        this.computeField();
    }

    public boolean _method_for_playPauseButton_enabled() {
        return !this.collision;
    }

    public void _method_for_playPauseButton_actionOn() {
        this._play();
    }

    public void _method_for_playPauseButton_actionOff() {
        this._pause();
    }

    public boolean _method_for_stepButton_enabled() {
        return !this.collision;
    }

    public void _method_for_stepButton_action() {
        this._step();
    }

    public void _method_for_resetButton_action() {
        this._reset();
    }

    public void _method_for_pdfButton_action() {
        this._view.showDocument("./DipoleTrajectoryWrong/DipoleTrajectoryStudentWorksheet.pdf");
    }

    static {
        ToolForData.setTool(new ToolForDataFull());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _ODE_evolution1
    implements __PrivateODE,
    ZenoEffectListener {
        private ODESolverInterpolator __solver = null;
        private ODEInterpolatorEventSolver __eventSolver = null;
        private Class<?> __solverClass = CashKarp45.class;
        private double[] __state = null;
        private boolean __ignoreErrors = false;
        private boolean __mustReinitialize = true;

        _ODE_evolution1() {
            this.__instantiateSolver();
            DipoleTrajectory.this._privateOdesList.put("Evol Page", this);
        }

        @Override
        public ODEInterpolatorEventSolver __getEventSolver() {
            return this.__eventSolver;
        }

        @Override
        public void __setSolverClass(Class<?> clazz) {
            this.__solverClass = clazz;
            this.__instantiateSolver();
        }

        private void __instantiateSolver() {
            this.__state = new double[5];
            this.__pushState();
            try {
                Class[] classArray = new Class[]{ODE.class};
                Object[] objectArray = new Object[]{this};
                Constructor<?> constructor = this.__solverClass.getDeclaredConstructor(classArray);
                this.__solver = (ODESolverInterpolator)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.__eventSolver = new ODEInterpolatorEventSolver(this.__solver);
        }

        @Override
        public void __initializeSolver() {
            this.__pushState();
            this.__eventSolver.initialize(DipoleTrajectory.this.dt);
            this.__eventSolver.setBestInterpolation(false);
            this.__eventSolver.setMaximumInternalSteps(10000);
            if (DipoleTrajectory.this._isEnabled_evolution1_Event1) {
                this.__eventSolver.addEvent(new _ODE_evolution1_Event1());
            }
            this.__eventSolver.addZenoEffectListener(this);
            this.__eventSolver.setEstimateFirstStep(false);
            this.__eventSolver.setEnableExceptions(false);
            this.__eventSolver.setTolerances(1.0E-5, 1.0E-5);
            this.__mustReinitialize = true;
        }

        private void __pushState() {
            int n = 0;
            if (this.__state[n] != DipoleTrajectory.this.x) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = DipoleTrajectory.this.x;
            if (this.__state[n] != DipoleTrajectory.this.y) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = DipoleTrajectory.this.y;
            if (this.__state[n] != DipoleTrajectory.this.vx) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = DipoleTrajectory.this.vx;
            if (this.__state[n] != DipoleTrajectory.this.vy) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = DipoleTrajectory.this.vy;
            if (this.__state[n] != DipoleTrajectory.this.t) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = DipoleTrajectory.this.t;
        }

        public void __resetSolver() {
            this.__mustReinitialize = true;
        }

        private void __errorAction() {
            if (this.__ignoreErrors) {
                return;
            }
            System.err.println(this.__eventSolver.getErrorMessage());
            DipoleTrajectorySimulation cfr_ignored_0 = DipoleTrajectory.this._simulation;
            DipoleTrajectorySimulation cfr_ignored_1 = DipoleTrajectory.this._simulation;
            int n = JOptionPane.showConfirmDialog(DipoleTrajectory.this._view.getComponent(DipoleTrajectory.this._simulation.getMainWindow()), DipoleTrajectorySimulation.getEjsString("ODEError.Continue"), DipoleTrajectorySimulation.getEjsString("Error"), 1);
            if (n == 0) {
                this.__ignoreErrors = true;
            } else if (n == 2) {
                DipoleTrajectory.this._pause();
            }
        }

        void __stepODE() {
            this.__eventSolver.setStepSize(DipoleTrajectory.this.dt);
            this.__eventSolver.setInternalStepSize(DipoleTrajectory.this.dt);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.setTolerances(1.0E-5, 1.0E-5);
            this.__pushState();
            if (this.__mustReinitialize) {
                this.__eventSolver.reinitialize();
                this.__mustReinitialize = false;
            }
            double d = this.__eventSolver.step();
            int n = 0;
            DipoleTrajectory.this.x = this.__state[n++];
            DipoleTrajectory.this.y = this.__state[n++];
            DipoleTrajectory.this.vx = this.__state[n++];
            DipoleTrajectory.this.vy = this.__state[n++];
            DipoleTrajectory.this.t = this.__state[n++];
            if (Double.isNaN(d)) {
                this.__errorAction();
            }
        }

        @Override
        public double[] getState() {
            return this.__state;
        }

        @Override
        public void getRate(double[] dArray, double[] dArray2) {
            dArray2[dArray2.length - 1] = 0.0;
            int n = -1;
            int n2 = 0;
            double d = dArray[n2++];
            double d2 = dArray[n2++];
            double d3 = dArray[n2++];
            double d4 = dArray[n2++];
            double d5 = dArray[n2++];
            DipoleTrajectory.this.Ex = DipoleTrajectory.this.getE(d, d2)[0];
            DipoleTrajectory.this.Ey = DipoleTrajectory.this.getE(d, d2)[1];
            n2 = 0;
            dArray2[n2++] = d3;
            dArray2[n2++] = d4;
            dArray2[n2++] = DipoleTrajectory.this.Ex;
            dArray2[n2++] = DipoleTrajectory.this.Ey;
            dArray2[n2++] = 1.0;
        }

        @Override
        public boolean zenoEffectAction(GeneralStateEvent generalStateEvent, double[] dArray) {
            return true;
        }

        private class _ODE_evolution1_Event1
        implements GeneralStateEvent {
            private _ODE_evolution1_Event1() {
            }

            public int getTypeOfEvent() {
                return 0;
            }

            public int getRootFindingMethod() {
                return 0;
            }

            public int getMaxIterations() {
                return 100;
            }

            public String toString() {
                return "Collision";
            }

            public double getTolerance() {
                return 1.0E-5;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                double d = dArray[n++];
                double d2 = dArray[n++];
                double d3 = dArray[n++];
                double d4 = dArray[n++];
                double d5 = dArray[n++];
                double d6 = d * d + (Math.abs(d2) - DipoleTrajectory.this.s / 2.0) * (Math.abs(d2) - DipoleTrajectory.this.s / 2.0);
                return d6 - DipoleTrajectory.this.r * DipoleTrajectory.this.r;
            }

            public boolean action() {
                int n = 0;
                DipoleTrajectory.this.x = _ODE_evolution1.this.__state[n++];
                DipoleTrajectory.this.y = _ODE_evolution1.this.__state[n++];
                DipoleTrajectory.this.vx = _ODE_evolution1.this.__state[n++];
                DipoleTrajectory.this.vy = _ODE_evolution1.this.__state[n++];
                DipoleTrajectory.this.t = _ODE_evolution1.this.__state[n++];
                boolean bl = this.userDefinedAction();
                n = 0;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = DipoleTrajectory.this.x;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = DipoleTrajectory.this.y;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = DipoleTrajectory.this.vx;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = DipoleTrajectory.this.vy;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = DipoleTrajectory.this.t;
                return bl;
            }

            private boolean userDefinedAction() {
                DipoleTrajectory.this.collision = true;
                DipoleTrajectory.this._pause();
                DipoleTrajectory.this.t = 0.0;
                return true;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface __PrivateODE
    extends ODE {
        public ODEInterpolatorEventSolver __getEventSolver();

        public void __setSolverClass(Class<?> var1);

        public void __initializeSolver();
    }
}

