/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import org.opensourcephysics.drawing3d.ElementTrail;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;

public class Java3dElementTrail
extends Java3dElement {
    private LineStripArray lines = null;
    private int[] stripVertexCounts;
    private int currentSize;
    private int temp;
    private double[] points;
    private static int previousSize = 2500;
    private BranchGroup bg = null;

    public Java3dElementTrail(ElementTrail elementTrail) {
        super(elementTrail);
        this.getAppearance().getLineAttributes().setLineAntialiasingEnable(true);
        this.getAppearance().getPointAttributes().setPointSize(0.1f);
        this.points = new double[3 * previousSize];
        this.temp = 0;
        this.currentSize = 0;
        this.initTrail();
    }

    public void processChanges(int n, int n2) {
        double[][] dArray;
        super.processChanges(n, n2);
        if ((n & 8) != 0 && (dArray = ((ElementTrail)this.element).getData2D()) != null) {
            if (dArray[0].length == 1 && this.lines != null) {
                this.points = new double[3 * previousSize];
                this.initTrail();
            }
            this.currentSize = dArray[0].length;
            if (this.currentSize > 0 && this.currentSize < previousSize) {
                int n3;
                if (this.currentSize > this.temp) {
                    n3 = this.temp;
                    while (n3 < this.currentSize) {
                        this.points[n3 * 3] = dArray[0][n3];
                        this.points[n3 * 3 + 1] = dArray[1][n3];
                        this.points[n3 * 3 + 2] = dArray[2][n3];
                        ++n3;
                    }
                    this.temp = this.currentSize;
                } else {
                    n3 = 0;
                    while (n3 < this.currentSize) {
                        this.points[n3 * 3] = dArray[0][n3];
                        this.points[n3 * 3 + 1] = dArray[1][n3];
                        this.points[n3 * 3 + 2] = dArray[2][n3];
                        ++n3;
                    }
                    this.temp = this.currentSize;
                }
            }
            if (this.currentSize >= previousSize || this.currentSize * 3 >= this.points.length) {
                double[] dArray2 = new double[this.temp * 3];
                System.arraycopy(this.points, 0, dArray2, 0, this.temp * 3);
                this.points = new double[this.currentSize * 3 * 2];
                int n4 = 0;
                while (n4 < this.temp) {
                    this.points[n4 * 3] = dArray2[n4 * 3];
                    this.points[n4 * 3 + 1] = dArray2[n4 * 3 + 1];
                    this.points[n4 * 3 + 2] = dArray2[n4 * 3 + 2];
                    ++n4;
                }
                if (this.currentSize > previousSize || this.currentSize * 3 > this.points.length) {
                    n4 = this.temp;
                    while (n4 < this.currentSize) {
                        this.points[n4 * 3] = dArray[0][n4];
                        this.points[n4 * 3 + 1] = dArray[1][n4];
                        this.points[n4 * 3 + 2] = dArray[2][n4];
                        ++n4;
                    }
                    this.temp = this.currentSize;
                }
                previousSize = this.currentSize * 2;
                this.initTrail();
            }
            if (this.currentSize > 2) {
                this.stripVertexCounts[0] = Math.max(2, this.currentSize);
                this.lines.setStripVertexCounts(this.stripVertexCounts);
            }
            if (this.currentSize == ((ElementTrail)this.element).getMaximum()) {
                int n5 = 0;
                while (n5 < this.currentSize - 1) {
                    this.points[n5 * 3] = this.points[(n5 + 1) * 3];
                    this.points[n5 * 3 + 1] = this.points[(n5 + 1) * 3 + 1];
                    this.points[n5 * 3 + 2] = this.points[(n5 + 1) * 3 + 2];
                    ++n5;
                }
            }
        }
    }

    private void initTrail() {
        this.stripVertexCounts = new int[]{Math.max(2, this.currentSize)};
        this.lines = new LineStripArray(this.points.length / 3, 129, this.stripVertexCounts);
        this.lines.setCapability(19);
        this.lines.setCapability(3);
        this.lines.setCapability(20);
        this.lines.setCapability(1);
        this.lines.setCoordRefDouble(this.points);
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.addChild((Node)new Shape3D((Geometry)this.lines, this.getAppearance()));
        this.addNode((Node)this.bg);
    }

    public boolean isPrimitive() {
        return false;
    }
}

