/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.applet.AudioClip;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.ImageIcon;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.JarTool;
import org.opensourcephysics.tools.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLoader {
    protected static ArrayList<String> searchPaths = new ArrayList();
    protected static ArrayList<String> appletSearchPaths = new ArrayList();
    protected static int maxPaths = 20;
    protected static Hashtable<String, Resource> resources = new Hashtable();
    protected static boolean cacheEnabled = false;
    protected static boolean canceled = false;
    protected static Map<String, URLClassLoader> zipLoaders = new TreeMap<String, URLClassLoader>();
    protected static URLClassLoader xsetZipLoader;
    protected static ArrayList<String> extractExtensions;
    protected static ArrayList<String> pathsNotFound;
    protected static File zipCache;
    protected static boolean zipURLsOK;

    static {
        extractExtensions = new ArrayList();
        pathsNotFound = new ArrayList();
    }

    private ResourceLoader() {
    }

    public static Resource getResource(String string) {
        return ResourceLoader.getResource(string, true);
    }

    public static Resource getResourceZipURLsOK(String string) {
        zipURLsOK = true;
        Resource resource = ResourceLoader.getResource(string, true);
        zipURLsOK = false;
        return resource;
    }

    public static Resource getResource(String string, boolean bl) {
        try {
            URL uRL = ResourceLoader.getAppletResourceURL(string);
            if (uRL != null) {
                return new Resource(uRL);
            }
        }
        catch (Exception exception) {}
        return ResourceLoader.getResource(string, Resource.class, bl);
    }

    public static Resource getResource(String string, Class<?> clazz) {
        return ResourceLoader.getResource(string, clazz, true);
    }

    public static Resource getResource(String string, Class<?> clazz, boolean bl) {
        Object object;
        Resource resource;
        if (string == null || string.equals("")) {
            return null;
        }
        pathsNotFound.clear();
        if (string.startsWith("\"")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.startsWith("./")) {
            string = string.substring(2);
        }
        if (OSPRuntime.isAppletMode() || OSPRuntime.applet != null) {
            resource = null;
            if (clazz == OSPRuntime.applet.getClass()) {
                try {
                    object = clazz.getResource(string);
                    resource = ResourceLoader.createResource((URL)object);
                    if (resource != null) {
                        return resource;
                    }
                }
                catch (Exception exception) {}
            }
            object = searchPaths.iterator();
            while (object.hasNext()) {
                String string2 = ResourceLoader.getPath((String)object.next(), string);
                resource = ResourceLoader.findResourceInClass(string2, clazz, bl);
                if (resource == null) continue;
                return resource;
            }
            resource = ResourceLoader.findResourceInClass(string, clazz, bl);
            if (resource != null) {
                return resource;
            }
        }
        if ((resource = ResourceLoader.findResource(string, clazz, bl)) != null) {
            return resource;
        }
        pathsNotFound.add(string);
        object = new StringBuffer("Not found: " + string);
        ((StringBuffer)object).append(" [searched " + string);
        for (String string2 : searchPaths) {
            String string3 = ResourceLoader.getPath(string2, string);
            if (pathsNotFound.contains(string3)) continue;
            resource = ResourceLoader.findResource(string3, clazz, bl);
            if (resource != null) {
                return resource;
            }
            pathsNotFound.add(string3);
            ((StringBuffer)object).append(";" + string3);
        }
        ((StringBuffer)object).append("]");
        OSPLog.fine(((StringBuffer)object).toString());
        return null;
    }

    public static Resource getResource(String string, String string2) {
        return ResourceLoader.getResource(string, string2, Resource.class);
    }

    public static Resource getResource(String string, String string2, boolean bl) {
        return ResourceLoader.getResource(string, string2, Resource.class, bl);
    }

    public static Resource getResource(String string, String string2, Class<Resource> clazz) {
        return ResourceLoader.getResource(string, string2, clazz, true);
    }

    public static Resource getResource(String string, String string2, Class<Resource> clazz, boolean bl) {
        Object object;
        if (string == null) {
            return ResourceLoader.getResource(string2, clazz);
        }
        if (string2.startsWith("./")) {
            string2 = string2.substring(2);
        }
        pathsNotFound.clear();
        String string3 = ResourceLoader.getPath(string, string2);
        Resource resource = ResourceLoader.findResource(string3, clazz, bl);
        if (resource != null) {
            return resource;
        }
        if (string.startsWith("/") || string.indexOf(":/") > -1) {
            return null;
        }
        pathsNotFound.add(string3);
        StringBuffer stringBuffer = new StringBuffer("Not found: " + string3);
        stringBuffer.append(" [searched " + string3);
        if (OSPRuntime.applet != null) {
            String string4;
            object = OSPRuntime.applet.getDocumentBase().toExternalForm();
            string3 = ResourceLoader.getPath(ResourceLoader.getPath((String)(object = String.valueOf(XML.getDirectoryPath((String)object)) + "/"), string), string2);
            if (!pathsNotFound.contains(string3)) {
                resource = ResourceLoader.findResource(string3, clazz, bl);
                if (resource != null) {
                    return resource;
                }
                pathsNotFound.add(string3);
                stringBuffer.append(";" + string3);
            }
            if (!(string4 = OSPRuntime.applet.getCodeBase().toExternalForm()).equals(object) && !pathsNotFound.contains(string3 = ResourceLoader.getPath(ResourceLoader.getPath(string4, string), string2))) {
                resource = ResourceLoader.findResource(string3, clazz, bl);
                if (resource != null) {
                    return resource;
                }
                pathsNotFound.add(string3);
                stringBuffer.append(";" + string3);
            }
        }
        object = searchPaths.iterator();
        while (object.hasNext()) {
            string3 = ResourceLoader.getPath(ResourceLoader.getPath((String)object.next(), string), string2);
            if (pathsNotFound.contains(string3)) continue;
            resource = ResourceLoader.findResource(string3, clazz, bl);
            if (resource != null) {
                return resource;
            }
            pathsNotFound.add(string3);
            stringBuffer.append(";" + string3);
        }
        stringBuffer.append("]");
        OSPLog.fine(stringBuffer.toString());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSearchPath(String string) {
        if (string == null || string.equals("") || maxPaths < 1) {
            return;
        }
        ArrayList<String> arrayList = searchPaths;
        synchronized (arrayList) {
            if (searchPaths.contains(string)) {
                searchPaths.remove(string);
            } else {
                OSPLog.fine("Added path: " + string);
            }
            searchPaths.add(0, string);
            while (searchPaths.size() > Math.max(maxPaths, 0)) {
                string = searchPaths.get(searchPaths.size() - 1);
                OSPLog.fine("Removed path: " + string);
                searchPaths.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSearchPath(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        ArrayList<String> arrayList = searchPaths;
        synchronized (arrayList) {
            if (searchPaths.contains(string)) {
                OSPLog.fine("Removed path: " + string);
                searchPaths.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAppletSearchPath(String string) {
        if (string == null || maxPaths < 1) {
            return;
        }
        if (!(string = string.trim()).endsWith("/")) {
            string = String.valueOf(string) + "/";
        }
        ArrayList<String> arrayList = appletSearchPaths;
        synchronized (arrayList) {
            if (appletSearchPaths.contains(string)) {
                appletSearchPaths.remove(string);
            } else {
                OSPLog.fine("Applet search path added: " + string);
            }
            appletSearchPaths.add(0, string);
            while (appletSearchPaths.size() > Math.max(maxPaths, 0)) {
                string = appletSearchPaths.get(appletSearchPaths.size() - 1);
                OSPLog.fine("Removed path: " + string);
                appletSearchPaths.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAppletSearchPath(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        ArrayList<String> arrayList = appletSearchPaths;
        synchronized (arrayList) {
            if (appletSearchPaths.contains(string)) {
                OSPLog.fine("Applet search path removed: " + string);
                appletSearchPaths.remove(string);
            }
        }
    }

    public static void setCacheEnabled(boolean bl) {
        cacheEnabled = bl;
    }

    public static boolean isCacheEnabled() {
        return cacheEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExtractExtension(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        OSPLog.finest("Added extension: " + string);
        ArrayList<String> arrayList = extractExtensions;
        synchronized (arrayList) {
            extractExtensions.add(string);
        }
    }

    public static void setCanceled(boolean bl) {
        canceled = bl;
    }

    public static boolean isCanceled() {
        return canceled;
    }

    public static InputStream openInputStream(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.openInputStream();
    }

    public static Reader openReader(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.openReader();
    }

    public static String getString(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getString();
    }

    public static ImageIcon getIcon(String string) {
        URL uRL = ResourceLoader.getAppletResourceURL(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getIcon();
    }

    public static Image getImage(String string) {
        URL uRL = ResourceLoader.getAppletResourceURL(string);
        if (uRL != null) {
            return new ImageIcon(uRL).getImage();
        }
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getImage();
    }

    public static BufferedImage getBufferedImage(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getBufferedImage();
    }

    public static AudioClip getAudioClip(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getAudioClip();
    }

    public static void setZipCache(File file) {
        zipCache = file;
    }

    public static File getZipCache() {
        return zipCache;
    }

    public static Set<String> getZipContents(String string) {
        TreeSet<String> treeSet = new TreeSet<String>();
        try {
            URL uRL = new URL(ResourceLoader.getURIPath(string));
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                String string2 = zipEntry.getName();
                treeSet.add(string2);
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return treeSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<File> unzip(String string, File file, boolean bl) {
        if (file == null) {
            file = new File(System.getProperty("java.io.tmpdir"));
        }
        try {
            URL uRL = new URL(ResourceLoader.getURIPath(string));
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = null;
            HashSet<File> hashSet = new HashSet<File>();
            byte[] byArray = new byte[1024];
            ResourceLoader.setCanceled(false);
            block2: while (true) {
                if ((zipEntry = zipInputStream.getNextEntry()) == null) {
                    zipInputStream.close();
                    return hashSet;
                }
                if (zipEntry.isDirectory()) continue;
                if (ResourceLoader.isCanceled()) {
                    zipInputStream.close();
                    return null;
                }
                String string2 = zipEntry.getName();
                File file2 = new File(file, string2);
                if (!bl && file2.exists()) {
                    hashSet.add(file2);
                    continue;
                }
                file2.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                while (true) {
                    int n;
                    if ((n = zipInputStream.read(byArray)) == -1) {
                        fileOutputStream.close();
                        zipInputStream.closeEntry();
                        hashSet.add(file2);
                        continue block2;
                    }
                    fileOutputStream.write(byArray, 0, n);
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static File download(String string, String string2, File file, boolean bl) {
        string = ResourceLoader.getURIPath(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        String string3 = XML.getResolvedPath(string2, file.getAbsolutePath());
        string3 = XML.forwardSlash(string3);
        File file2 = new File(string3);
        if (bl || !file2.exists()) {
            try {
                URL uRL = new URL(string);
                InputStream inputStream = uRL.openStream();
                FileOutputStream fileOutputStream = new FileOutputStream(string3);
                byte[] byArray = new byte[65536];
                int n = 0;
                while ((n = inputStream.read(byArray)) > 0) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.close();
                inputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (file2.exists()) {
            return file2;
        }
        return null;
    }

    public static boolean isURLAvailable(String string) {
        try {
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.getContent();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static String getNonURIPath(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string2.startsWith("file:")) {
            string2 = string2.substring(5);
        }
        while (string2.startsWith("/") && string2.indexOf(":") > -1) {
            string2 = string2.substring(1);
        }
        int n = string2.indexOf("%20");
        while (n > -1) {
            String string3 = string2.substring(0, n);
            string2 = String.valueOf(string3) + " " + string2.substring(n + 3);
            n = string2.indexOf("%20");
        }
        return string2;
    }

    public static String getURIPath(String string) {
        if (string == null) {
            return null;
        }
        if (!(string = XML.forwardSlash(string.trim())).equals("") && XML.getExtension(string) == null && !string.endsWith("/")) {
            string = String.valueOf(string) + "/";
        }
        int n = string.indexOf(" ");
        while (n > -1) {
            String string2 = string.substring(0, n);
            string = String.valueOf(string2) + "%20" + string.substring(n + 1);
            n = string.indexOf(" ");
        }
        if (!(string.equals("") || string.startsWith("http:") || string.startsWith("file:/"))) {
            string = "file:/" + string;
        }
        return string;
    }

    private static URL getAppletResourceURL(String string) {
        if (OSPRuntime.applet == null || string == null || string.trim().equals("")) {
            return null;
        }
        if (string.startsWith("http:") || string.startsWith("https:")) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (!(string = string.trim()).startsWith("/")) {
            for (String string2 : appletSearchPaths) {
                String string3 = string;
                if (string3.startsWith("../")) {
                    string3 = string3.substring(3);
                    int n = (string2 = string2.substring(0, string2.length() - 1)).lastIndexOf("/");
                    string2 = n > 0 ? string2.substring(0, n) : "/";
                } else if (string3.startsWith("./")) {
                    string3 = string3.substring(2);
                }
                URL uRL = OSPRuntime.applet.getClass().getResource(String.valueOf(string2) + string3);
                if (uRL == null) continue;
                return uRL;
            }
        }
        return OSPRuntime.applet.getClass().getResource(string);
    }

    private static Resource createFileResource(String string) {
        if (OSPRuntime.applet != null) {
            return null;
        }
        if (string.indexOf(".zip") > -1 || string.indexOf(".jar") > -1) {
            return null;
        }
        File file = new File(string);
        try {
            if (file.exists() && file.canRead()) {
                Resource resource = new Resource(file);
                if (string.endsWith("xset")) {
                    xsetZipLoader = null;
                }
                OSPLog.fine("File: " + XML.forwardSlash(resource.getAbsolutePath()));
                return resource;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private static Resource createURLResource(String string) {
        URL uRL;
        if (!(zipURLsOK || string.indexOf(".zip") <= -1 && string.indexOf(".jar") <= -1)) {
            return null;
        }
        Resource resource = null;
        if (OSPRuntime.applet != null) {
            try {
                uRL = ResourceLoader.getAppletResourceURL(string);
                resource = ResourceLoader.createResource(uRL);
            }
            catch (Exception exception) {}
        }
        if (resource == null) {
            if (string.indexOf(":/") > -1) {
                try {
                    uRL = new URL(string);
                    resource = ResourceLoader.createResource(uRL);
                }
                catch (Exception exception) {}
            } else if (OSPRuntime.applet != null && !string.startsWith("/")) {
                URL uRL2;
                Object object;
                uRL = OSPRuntime.applet.getDocumentBase();
                try {
                    object = uRL.toString();
                    int n = ((String)object).indexOf("?");
                    if (n > -1) {
                        uRL = new URL(((String)object).substring(0, n));
                    }
                    uRL2 = new URL(uRL, string);
                    resource = ResourceLoader.createResource(uRL2);
                }
                catch (Exception exception) {}
                if (resource == null) {
                    object = OSPRuntime.applet.getCodeBase();
                    String string2 = String.valueOf(XML.getDirectoryPath(uRL.toExternalForm())) + "/";
                    if (!((URL)object).toExternalForm().equals(string2)) {
                        try {
                            uRL2 = new URL((URL)object, string);
                            resource = ResourceLoader.createResource(uRL2);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        if (resource != null) {
            if (string.endsWith(".xset")) {
                xsetZipLoader = null;
            }
            OSPLog.fine("URL: " + XML.forwardSlash(resource.getAbsolutePath()));
        }
        return resource;
    }

    private static Resource createZipResource(String string) {
        URL[] uRLArray;
        Object object3;
        File file;
        string = ResourceLoader.getNonURIPath(string);
        Object object4 = null;
        String string2 = string;
        int n = string.indexOf("zip!/");
        if (n == -1) {
            n = string.indexOf("jar!/");
        }
        if (n == -1) {
            n = string.indexOf("exe!/");
        }
        if (n > -1) {
            object4 = string.substring(0, n + 3);
            string2 = string.substring(n + 5);
        }
        if (object4 == null) {
            if (string.endsWith(".zip") || string.endsWith(".jar") || string.endsWith(".exe")) {
                String string3 = XML.stripExtension(XML.getName(string));
                object4 = string;
                string2 = String.valueOf(string3) + ".xset";
            } else if (string.endsWith(".xset")) {
                object4 = String.valueOf(string.substring(0, string.length() - 4)) + "zip";
            }
        }
        boolean bl = object4 != null && (object4.endsWith(".zip") || object4.endsWith(".jar"));
        boolean bl2 = false;
        File file2 = file = zipCache != null ? zipCache : new File(System.getProperty("java.io.tmpdir"));
        if (bl && string.startsWith("http:")) {
            bl2 = zipCache == null;
            object3 = ResourceLoader.download((String)object4, XML.getName((String)object4), file, false);
            if (object3 != null) {
                if (bl2) {
                    ((File)object3).deleteOnExit();
                }
                object4 = ((File)object3).getAbsolutePath();
                string = String.valueOf(object4) + "!/" + string2;
            }
        }
        object3 = null;
        URL uRL = null;
        if (object4 != null) {
            object3 = zipLoaders.get(object4);
            if (object3 != null) {
                uRL = ((URLClassLoader)object3).findResource(string2);
            } else {
                try {
                    URL object22;
                    uRLArray = new URL[]{new URL("file", null, (String)object4)};
                    object3 = new URLClassLoader(uRLArray);
                    uRL = ((URLClassLoader)object3).findResource(string2);
                    if (uRL == null && (object22 = Resource.class.getResource("/" + (String)object4)) != null) {
                        uRLArray = new URL[]{object22};
                        object3 = new URLClassLoader(uRLArray);
                        uRL = ((URLClassLoader)object3).findResource(string2);
                    }
                    if (uRL != null) {
                        zipLoaders.put((String)object4, (URLClassLoader)object3);
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (uRL == null && xsetZipLoader != null && (uRL = xsetZipLoader.findResource(string2)) != null) {
            for (Object e : zipLoaders.keySet()) {
                if (zipLoaders.get(e) != xsetZipLoader) continue;
                object4 = (String)e;
                break;
            }
        }
        uRLArray = OSPRuntime.getLaunchJarPath();
        if (uRL == null && uRLArray != null) {
            object3 = zipLoaders.get(uRLArray);
            if (object3 != null) {
                uRL = ((URLClassLoader)object3).findResource(string2);
            } else {
                try {
                    URL uRL2;
                    URL[] uRLArray2 = new URL[]{new URL("file", null, (String)uRLArray)};
                    object3 = new URLClassLoader(uRLArray2);
                    uRL = ((URLClassLoader)object3).findResource(string2);
                    if (uRL == null && (uRL2 = Resource.class.getResource("/" + (String)uRLArray)) != null) {
                        URL[] uRLArray3 = new URL[]{uRL2};
                        object3 = new URLClassLoader(uRLArray3);
                        uRL = ((URLClassLoader)object3).findResource(string2);
                    }
                    if (uRL != null) {
                        zipLoaders.put((String)uRLArray, (URLClassLoader)object3);
                    }
                }
                catch (Exception exception) {}
            }
            if (uRL != null) {
                object4 = uRLArray;
            }
        }
        if (uRL != null) {
            Resource resource;
            block36: {
                for (String string3 : extractExtensions) {
                    File file3;
                    if (!uRL.getFile().endsWith(string3)) continue;
                    File file4 = new File((String)object4);
                    String string4 = string2;
                    String string5 = file4.getParent();
                    if (string5 != null && !string4.startsWith("/") && string2.indexOf(":/") == -1) {
                        string4 = XML.getResolvedPath(string2, string5);
                    }
                    if (!(file3 = new File(string4)).exists()) {
                        file3 = JarTool.extract(file4, string2, string4);
                        if (bl2) {
                            file3.deleteOnExit();
                        }
                    }
                    return ResourceLoader.createFileResource(file3.getAbsolutePath());
                }
                try {
                    resource = ResourceLoader.createResource(uRL);
                    if (resource != null && resource.getAbsolutePath().indexOf(string) != -1) break block36;
                    return null;
                }
                catch (IOException iOException) {}
            }
            if (string2.endsWith("xset")) {
                xsetZipLoader = object3;
            }
            OSPLog.fine("Zip: " + XML.forwardSlash(resource.getAbsolutePath()));
            return resource;
        }
        return null;
    }

    private static Resource createClassResource(String string, Class<?> clazz) {
        Object object;
        if (string.indexOf(":/") != -1) {
            return null;
        }
        String string2 = string;
        int n = string.indexOf("jar!/");
        if (n == -1) {
            n = string.indexOf("exe!/");
        }
        if (n != -1) {
            string = string.substring(n + 5);
        }
        Resource resource = null;
        try {
            object = clazz.getResource("/" + string);
            resource = ResourceLoader.createResource((URL)object);
        }
        catch (Exception exception) {}
        if (resource == null) {
            try {
                object = clazz.getResource(string);
                resource = ResourceLoader.createResource((URL)object);
            }
            catch (Exception exception) {}
        }
        if (resource != null) {
            object = XML.forwardSlash(resource.getAbsolutePath());
            if (((String)object).indexOf("/jre") > -1 && ((String)object).indexOf("/lib") > -1) {
                return null;
            }
            if (((String)object).indexOf(string2) == -1) {
                return null;
            }
            if (string.endsWith("xset")) {
                xsetZipLoader = null;
            }
            OSPLog.fine("Class resource: " + (String)object);
            OSPRuntime.setLaunchJarPath((String)object);
        }
        return resource;
    }

    private static Resource createResource(URL uRL) throws IOException {
        if (uRL == null) {
            return null;
        }
        InputStream inputStream = uRL.openStream();
        if (inputStream.read() == -1) {
            return null;
        }
        inputStream.close();
        return new Resource(uRL);
    }

    private static Resource findResourceInClass(String string, Class<?> clazz, boolean bl) {
        string = string.replaceAll("/\\./", "/");
        if (clazz == null) {
            clazz = Resource.class;
        }
        Resource resource = null;
        if (cacheEnabled && (resource = resources.get(string)) != null && (bl || resource.getFile() == null)) {
            OSPLog.finest("Found in cache: " + string);
            return resource;
        }
        resource = ResourceLoader.createClassResource(string, clazz);
        if (resource != null) {
            if (cacheEnabled) {
                resources.put(string, resource);
            }
            return resource;
        }
        return null;
    }

    private static Resource findResource(String string, Class<?> clazz, boolean bl) {
        string = string.replaceAll("/\\./", "/");
        if (clazz == null) {
            clazz = Resource.class;
        }
        Resource resource = null;
        if (cacheEnabled && (resource = resources.get(string)) != null && (bl || resource.getFile() == null)) {
            OSPLog.finest("Found in cache: " + string);
            return resource;
        }
        if (bl && (resource = ResourceLoader.createFileResource(string)) != null || (resource = ResourceLoader.createURLResource(string)) != null || (resource = ResourceLoader.createZipResource(string)) != null || (resource = ResourceLoader.createClassResource(string, clazz)) != null) {
            if (cacheEnabled) {
                resources.put(string, resource);
            }
            return resource;
        }
        return null;
    }

    private static String getPath(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string.endsWith(".jar") || string.endsWith(".zip")) {
            string = String.valueOf(string) + "!";
        }
        String string3 = XML.getResolvedPath(string2, string);
        if (OSPRuntime.isMac() && string3.startsWith("file:/") && !string3.startsWith("file:///")) {
            string3 = string3.substring(6);
            while (string3.startsWith("/")) {
                string3 = string3.substring(1);
            }
            string3 = "file:///" + string3;
        }
        return string3;
    }
}

