/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JTabbedPane;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.swing.RadioButtonInterface;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.TeXParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlTabbedPanel
extends ControlContainer {
    private static final int TABBEDPANEL_PROPERTIES = 2;
    private static final int TABBEDPANEL_TOOLTIP = 11;
    protected JTabbedPane tabbedpanel;
    private String[] tabTitles = null;
    private String[] tooltipsArray = null;
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        this.tabbedpanel = new JTabbedPane(1);
        return this.tabbedpanel;
    }

    @Override
    public void add(ControlElement controlElement) {
        int n;
        String string = controlElement.getProperty("name");
        if (this.tabTitles != null && (n = this.tabbedpanel.getTabCount()) < this.tabTitles.length) {
            string = this.tabTitles[n];
        }
        if (string != null) {
            this.tabbedpanel.add(controlElement.getComponent(), string);
        } else {
            this.tabbedpanel.add(controlElement.getComponent(), "   ");
        }
        if (controlElement instanceof RadioButtonInterface) {
            this.radioButtons.add((ControlSwingElement)controlElement);
            ((RadioButtonInterface)((Object)controlElement)).setControlParent(this);
        }
    }

    private void refreshTitles() {
        if (this.tabTitles == null) {
            int n = this.tabbedpanel.getTabCount();
            int n2 = 0;
            while (n2 < n) {
                String string = this.tabbedpanel.getComponentAt(n2).getName();
                if (string != null) {
                    this.tabbedpanel.setTitleAt(n2, string);
                }
                ++n2;
            }
            return;
        }
        int n = Math.min(this.tabbedpanel.getTabCount(), this.tabTitles.length);
        int n3 = 0;
        while (n3 < n) {
            this.tabbedpanel.setTitleAt(n3, this.tabTitles[n3]);
            ++n3;
        }
    }

    private void refreshToolTips() {
        if (this.tooltipsArray == null) {
            int n = this.tabbedpanel.getTabCount();
            int n2 = 0;
            while (n2 < n) {
                String string = this.tabbedpanel.getComponentAt(n2).getName();
                if (string != null) {
                    this.tabbedpanel.setToolTipTextAt(n2, string);
                }
                ++n2;
            }
            return;
        }
        int n = Math.min(this.tabbedpanel.getTabCount(), this.tooltipsArray.length);
        int n3 = 0;
        while (n3 < n) {
            this.tabbedpanel.setToolTipTextAt(n3, this.tooltipsArray[n3]);
            ++n3;
        }
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("placement");
            infoList.add("tabTitles");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("placement")) {
            return "Placement|int";
        }
        if (string.equals("tabTitles")) {
            return "String|String[] TRANSLATABLE";
        }
        if (string.equals("tooltip")) {
            return "String|String[] TRANSLATABLE";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (this.tabbedpanel.getTabPlacement() == value.getInteger()) break;
                this.tabbedpanel.setTabPlacement(value.getInteger());
                break;
            }
            case 1: {
                if (value.getObject() instanceof String[]) {
                    this.tabTitles = (String[])value.getObject();
                } else {
                    String string = value.getString();
                    if (string == null) {
                        this.tabTitles = null;
                    } else {
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                        this.tabTitles = new String[stringTokenizer.countTokens()];
                        int n2 = 0;
                        while (stringTokenizer.hasMoreTokens()) {
                            this.tabTitles[n2] = TeXParser.parseTeX(stringTokenizer.nextToken());
                            ++n2;
                        }
                    }
                }
                this.refreshTitles();
                break;
            }
            default: {
                super.setValue(n - 2, value);
                break;
            }
            case 11: {
                if (value.getObject() instanceof String[]) {
                    this.tooltipsArray = (String[])value.getObject();
                } else {
                    String string = value.getString();
                    if (string == null) {
                        this.tooltipsArray = null;
                    } else {
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                        this.tooltipsArray = new String[stringTokenizer.countTokens()];
                        int n3 = 0;
                        while (stringTokenizer.hasMoreTokens()) {
                            this.tooltipsArray[n3] = TeXParser.parseTeX(stringTokenizer.nextToken());
                            ++n3;
                        }
                    }
                }
                this.refreshToolTips();
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.tabbedpanel.setTabPlacement(1);
                break;
            }
            case 1: {
                this.tabTitles = null;
                this.refreshTitles();
                break;
            }
            default: {
                super.setDefaultValue(n - 2);
                break;
            }
            case 11: {
                this.tooltipsArray = null;
                this.refreshToolTips();
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "TOP";
            }
            case 1: 
            case 2: {
                return "<none>";
            }
        }
        return super.getDefaultValueString(n - 2);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return null;
            }
        }
        return super.getValue(n - 2);
    }
}

