/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.event.MouseInputAdapter;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementText;
import org.opensourcephysics.drawing3d.interaction.InteractionEvent;
import org.opensourcephysics.drawing3d.interaction.InteractionListener;
import org.opensourcephysics.drawing3d.interaction.InteractionSource;
import org.opensourcephysics.drawing3d.interaction.InteractionTarget;
import org.opensourcephysics.drawing3d.java3d.Java3dDrawingPanel3D;
import org.opensourcephysics.drawing3d.simple3d.SimpleDrawingPanel3D;
import org.opensourcephysics.drawing3d.utils.Camera;
import org.opensourcephysics.drawing3d.utils.Decoration;
import org.opensourcephysics.drawing3d.utils.ImplementingPanel;
import org.opensourcephysics.drawing3d.utils.VisualizationHints;
import org.opensourcephysics.ejs.EjsRes;
import org.opensourcephysics.tools.VideoTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawingPanel3D
implements InteractionSource,
Renderable {
    private static boolean isJava3DInstalled;
    private static boolean askedToInstallJava3D;
    public static final int IMPLEMENTATION_SIMPLE3D = 0;
    public static final int IMPLEMENTATION_JAVA3D = 1;
    public static final int TARGET_PANEL = 0;
    public static final int BOTTOM_LEFT = 0;
    public static final int BOTTOM_RIGHT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int TOP_LEFT = 3;
    private boolean squareAspect = true;
    private int implementation = -1;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private double zmin;
    private double zmax;
    private double axisXSize = Double.NaN;
    private double axisYSize = Double.NaN;
    private double axisZSize = Double.NaN;
    private VisualizationHints visHints;
    private Camera camera;
    private Decoration decoration;
    private VideoTool vidCap;
    private ImplementingPanel implementingPanel;
    private ImplementingPanel previousImplementingPanel;
    private double axisXScale;
    private double axisYScale;
    private double axisZScale;
    private double maximumSize;
    private double[] center = new double[3];
    private double aconstant;
    private double bconstant;
    private int acenter;
    private int bcenter;
    private List<Element> elementList = new ArrayList<Element>();
    private ArrayList<ElementText> textList = new ArrayList();
    private boolean draggable = true;
    private final InteractionTarget myTarget = new InteractionTarget(null, 0);
    private int keyPressed = -1;
    private int lastX = 0;
    private int lastY = 0;
    private InteractionTarget targetHit = null;
    private InteractionTarget targetEntered = null;
    private double[] trackerPoint = null;
    private List<InteractionListener> listeners = new ArrayList<InteractionListener>();

    static {
        askedToInstallJava3D = false;
        try {
            Class.forName("com.sun.j3d.utils.universe.SimpleUniverse");
            isJava3DInstalled = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            isJava3DInstalled = false;
        }
    }

    public DrawingPanel3D() {
        int n = 0;
        this.visHints = new VisualizationHints(this);
        this.camera = new Camera(this);
        this.decoration = new Decoration(this);
        this.setImplementation(n);
        this.setPreferredMinMax(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
        this.camera.reset();
    }

    public boolean setImplementation(int n) {
        if (this.implementation == n) {
            return true;
        }
        if (n == 1 && !isJava3DInstalled) {
            if (!askedToInstallJava3D) {
                Object[] objectArray = new Object[]{EjsRes.getString("DrawingPanel3D.VisitJava3DSite"), EjsRes.getString("Ok")};
                String string = EjsRes.getString("DrawingPanel3D.InstallJava3D");
                int n2 = JOptionPane.showOptionDialog(null, string, "Easy Java Simulations", -1, 1, null, objectArray, objectArray[0]);
                if (n2 == 0) {
                    OSPDesktop.displayURL("http://java.sun.com/javase/technologies/desktop/java3d");
                }
                askedToInstallJava3D = true;
            }
            return false;
        }
        this.implementation = n;
        this.previousImplementingPanel = this.implementingPanel;
        for (Element object2 : this.elementList) {
            object2.removePanel();
        }
        for (Element element : this.decoration.getElementList()) {
            element.removePanel();
        }
        switch (this.implementation) {
            default: {
                this.implementingPanel = new SimpleDrawingPanel3D(this);
                break;
            }
            case 1: {
                this.implementingPanel = new Java3dDrawingPanel3D(this);
            }
        }
        this.getComponent().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DrawingPanel3D.this.computeConstants(DrawingPanel3D.this.getComponent().getWidth(), DrawingPanel3D.this.getComponent().getHeight());
                for (Element element : DrawingPanel3D.this.elementList) {
                    element.addChange(64);
                }
                for (Element element : DrawingPanel3D.this.decoration.getElementList()) {
                    element.addChange(64);
                }
                DrawingPanel3D.this.implementingPanel.forceRefresh();
                DrawingPanel3D.this.getComponent().repaint();
            }
        });
        IADMouseController iADMouseController = new IADMouseController();
        this.getComponent().addMouseListener(iADMouseController);
        this.getComponent().addMouseMotionListener(iADMouseController);
        this.getComponent().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                DrawingPanel3D.this.keyPressed = keyEvent.getKeyCode();
            }

            public void keyReleased(KeyEvent keyEvent) {
                DrawingPanel3D.this.keyPressed = -1;
            }
        });
        this.getComponent().setFocusable(true);
        this.getComponent().setPreferredSize(new Dimension(300, 300));
        for (Element element : this.elementList) {
            element.setPanel(this);
        }
        for (Element element : this.decoration.getElementList()) {
            element.setPanel(this);
        }
        this.cameraChanged(0);
        if (this.visHints.getBackgroundImage() != null) {
            this.implementingPanel.visualizationChanged(7);
        }
        return true;
    }

    public final int getImplementation() {
        return this.implementation;
    }

    public Component getComponent() {
        return this.implementingPanel.getComponent();
    }

    public VisualizationHints getVisualizationHints() {
        return this.visHints;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public Decoration getDecoration() {
        return this.decoration;
    }

    public ImplementingPanel getImplementingPanel() {
        return this.implementingPanel;
    }

    public ImplementingPanel getPreviousImplementingPanel() {
        return this.previousImplementingPanel;
    }

    public void setAxesSize(double d, double d2, double d3) {
        if (this.axisXSize == d && this.axisYSize == d2 && this.axisZSize == d3) {
            return;
        }
        this.axisXSize = d;
        this.axisYSize = d2;
        this.axisZSize = d3;
        this.adjustScales();
        this.maximumSize = this.getMaximum3DSize();
        this.computeConstants(this.getComponent().getWidth(), this.getComponent().getHeight());
        this.camera.adjust();
        for (Element element : this.elementList) {
            element.addChange(64);
        }
        for (Element element : this.decoration.getElementList()) {
            element.addChange(64);
        }
        this.implementingPanel.forceRefresh();
    }

    public final double getAxisXSize() {
        return this.axisXSize;
    }

    public final double getAxisYSize() {
        return this.axisYSize;
    }

    public final double getAxisZSize() {
        return this.axisZSize;
    }

    public void setPreferredMinMax(double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.xmin == d && this.xmax == d2 && this.ymin == d3 && this.ymax == d4 && this.zmin == d5 && this.zmax == d6) {
            return;
        }
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
        this.zmin = d5;
        this.zmax = d6;
        this.adjustScales();
        double d7 = this.getMaximum3DSize();
        if (d7 != this.maximumSize) {
            this.maximumSize = d7;
            this.computeConstants(this.getComponent().getWidth(), this.getComponent().getHeight());
            this.camera.adjust();
        }
        this.decoration.reset();
        for (Element element : this.elementList) {
            element.addChange(64);
        }
        for (Element element : this.decoration.getElementList()) {
            element.addChange(64);
        }
        this.visHints.setScaleBackground(this.getMaximum3DSize());
        this.implementingPanel.forceRefresh();
    }

    public void zoomToFit() {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        for (Element element : this.elementList) {
            element.getExtrema(dArray, dArray2);
            d = Math.min(Math.min(d, dArray[0]), dArray2[0]);
            d2 = Math.max(Math.max(d2, dArray[0]), dArray2[0]);
            d3 = Math.min(Math.min(d3, dArray[1]), dArray2[1]);
            d4 = Math.max(Math.max(d4, dArray[1]), dArray2[1]);
            d5 = Math.min(Math.min(d5, dArray[2]), dArray2[2]);
            d6 = Math.max(Math.max(d6, dArray[2]), dArray2[2]);
        }
        double d7 = Math.max(Math.max(d2 - d, d4 - d3), d6 - d5);
        if (d7 == 0.0) {
            d7 = 2.0;
        }
        if (d >= d2) {
            d = d2 - d7 / 2.0;
            d2 = d + d7;
        }
        if (d3 >= d4) {
            d3 = d4 - d7 / 2.0;
            d4 = d3 + d7;
        }
        if (d5 >= d6) {
            d5 = d6 - d7 / 2.0;
            d6 = d5 + d7;
        }
        this.setPreferredMinMax(d, d2, d3, d4, d5, d6);
    }

    public final double getPreferredMinX() {
        return this.xmin;
    }

    public final double getPreferredMaxX() {
        return this.xmax;
    }

    public final double getPreferredMinY() {
        return this.ymin;
    }

    public final double getPreferredMaxY() {
        return this.ymax;
    }

    public final double getPreferredMinZ() {
        return this.zmin;
    }

    public final double getPreferredMaxZ() {
        return this.zmax;
    }

    public void addElement(Element element) {
        if (!this.elementList.contains(element)) {
            element.setPanel(this);
            this.elementList.add(element);
            if (element instanceof ElementText) {
                this.textList.add((ElementText)element);
            }
            this.implementingPanel.forceRefresh();
        }
    }

    public void removeElement(Element element) {
        if (this.elementList.remove(element)) {
            if (this.textList.contains(element)) {
                this.textList.remove(element);
            }
            element.removePanel();
            this.implementingPanel.forceRefresh();
        }
    }

    public void removeAllElements() {
        this.elementList.clear();
        this.implementingPanel.forceRefresh();
    }

    public synchronized List<Element> getElements() {
        return new ArrayList<Element>(this.elementList);
    }

    public synchronized List<ElementText> getTextElements() {
        return new ArrayList<ElementText>(this.textList);
    }

    public VideoTool getVideoTool() {
        return this.vidCap;
    }

    public void setVideoTool(VideoTool videoTool) {
        if (this.vidCap != null) {
            this.vidCap.setVisible(false);
        }
        this.vidCap = videoTool;
    }

    @Override
    public BufferedImage render(BufferedImage bufferedImage) {
        return this.implementingPanel.render(bufferedImage);
    }

    @Override
    public BufferedImage render() {
        return this.implementingPanel.render();
    }

    public void update() {
        this.implementingPanel.update();
    }

    @Override
    public InteractionTarget getInteractionTarget(int n) {
        return this.myTarget;
    }

    @Override
    public void addInteractionListener(InteractionListener interactionListener) {
        this.listeners.add(interactionListener);
    }

    @Override
    public void removeInteractionListener(InteractionListener interactionListener) {
        this.listeners.remove(interactionListener);
    }

    private void invokeActions(InteractionEvent interactionEvent) {
        for (InteractionListener interactionListener : this.listeners) {
            interactionListener.interactionPerformed(interactionEvent);
        }
    }

    public void hintChanged(int n) {
        switch (n) {
            case -1: {
                this.decoration.updateAxesLabels();
                this.decoration.setCursorMode();
                this.decoration.updateType();
                break;
            }
            case 0: {
                this.decoration.updateType();
                this.decoration.reset();
                break;
            }
            case 6: {
                this.decoration.updateAxesLabels();
                break;
            }
            case 4: {
                this.decoration.setCursorMode();
                break;
            }
            case 10: {
                this.decoration.adjustColors();
                this.implementingPanel.visualizationChanged(n);
                break;
            }
            case 11: {
                this.decoration.adjustFont();
                break;
            }
            case 7: {
                this.implementingPanel.visualizationChanged(n);
                break;
            }
            case 8: {
                this.implementingPanel.visualizationChanged(n);
                break;
            }
            case 9: {
                this.implementingPanel.visualizationChanged(n);
                break;
            }
            case 12: {
                this.implementingPanel.visualizationChanged(n);
            }
        }
        if (this.implementingPanel != null) {
            this.implementingPanel.forceRefresh();
        }
    }

    public void cameraChanged(int n) {
        switch (n) {
            case 1: {
                this.maximumSize = this.getMaximum3DSize();
                this.computeConstants(this.getComponent().getWidth(), this.getComponent().getHeight());
                this.camera.adjust();
                this.implementingPanel.update();
            }
        }
        this.implementingPanel.cameraChanged(n);
        for (Element element : this.elementList) {
            element.addChange(64);
        }
        for (Element element : this.decoration.getElementList()) {
            element.addChange(64);
        }
        this.implementingPanel.forceRefresh();
    }

    public final double[] getCenter() {
        return (double[])this.center.clone();
    }

    public final double getDiagonal() {
        double d = Double.isNaN(this.axisXSize) ? this.xmax - this.xmin : this.axisXSize;
        double d2 = Double.isNaN(this.axisYSize) ? this.ymax - this.ymin : this.axisYSize;
        double d3 = Double.isNaN(this.axisZSize) ? this.zmax - this.zmin : this.axisZSize;
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public final double getMaximum3DSize() {
        double d = Double.isNaN(this.axisXSize) ? this.xmax - this.xmin : this.axisXSize;
        double d2 = Double.isNaN(this.axisYSize) ? this.ymax - this.ymin : this.axisYSize;
        double d3 = Double.isNaN(this.axisZSize) ? this.zmax - this.zmin : this.axisZSize;
        switch (this.camera.getProjectionMode()) {
            case 0: {
                return Math.max(d, d2);
            }
            case 1: {
                return Math.max(d, d3);
            }
            case 2: {
                return Math.max(d2, d3);
            }
        }
        return Math.max(Math.max(d, d2), d3);
    }

    public void setSquareAspect(boolean bl) {
        if (this.squareAspect == bl) {
            return;
        }
        this.squareAspect = bl;
        this.computeConstants(this.getComponent().getWidth(), this.getComponent().getHeight());
        for (Element element : this.elementList) {
            element.addChange(64);
        }
        for (Element element : this.decoration.getElementList()) {
            element.addChange(64);
        }
        this.implementingPanel.forceRefresh();
    }

    public boolean isSquareAspect() {
        return this.squareAspect;
    }

    private void adjustScales() {
        this.center[0] = Double.isNaN(this.axisXSize) ? (this.xmax + this.xmin) / 2.0 : this.axisXSize / 2.0;
        this.center[1] = Double.isNaN(this.axisYSize) ? (this.ymax + this.ymin) / 2.0 : this.axisYSize / 2.0;
        this.center[2] = Double.isNaN(this.axisZSize) ? (this.zmax + this.zmin) / 2.0 : this.axisZSize / 2.0;
        this.axisXScale = this.axisXSize / (this.xmax - this.xmin);
        this.axisYScale = this.axisYSize / (this.ymax - this.ymin);
        this.axisZScale = this.axisZSize / (this.zmax - this.zmin);
    }

    public void computeConstants(int n, int n2) {
        this.acenter = n / 2;
        this.bcenter = n2 / 2;
        if (this.squareAspect) {
            n = n2 = Math.min(n, n2);
        }
        this.aconstant = 0.5 * (double)n / this.maximumSize;
        this.bconstant = 0.5 * (double)n2 / this.maximumSize;
    }

    private double[] worldPoint(int n, int n2) {
        double d;
        double d2;
        double d3;
        double d4 = 1.8;
        switch (this.camera.getProjectionMode()) {
            case 0: {
                d3 = this.center[0] + (double)(n - this.acenter) / (d4 * this.aconstant);
                if (!Double.isNaN(this.axisXSize)) {
                    d3 = this.xmin + d3 / this.axisXScale;
                }
                d2 = this.center[1] + (double)(this.bcenter - n2) / (d4 * this.bconstant);
                if (!Double.isNaN(this.axisYSize)) {
                    d2 = this.ymin + d2 / this.axisYScale;
                }
                d = Double.NaN;
                break;
            }
            case 1: {
                d3 = this.center[0] + (double)(n - this.acenter) / (d4 * this.aconstant);
                if (!Double.isNaN(this.axisXSize)) {
                    d3 = this.xmin + d3 / this.axisXScale;
                }
                d2 = Double.NaN;
                d = this.center[2] + (double)(this.bcenter - n2) / (d4 * this.bconstant);
                if (Double.isNaN(this.axisZSize)) break;
                d = this.zmin + d / this.axisZScale;
                break;
            }
            case 2: {
                d3 = Double.NaN;
                d2 = this.center[1] + (double)(n - this.acenter) / (d4 * this.aconstant);
                if (!Double.isNaN(this.axisYSize)) {
                    d2 = this.ymin + d2 / this.axisYScale;
                }
                d = this.center[2] + (double)(this.bcenter - n2) / (d4 * this.bconstant);
                if (Double.isNaN(this.axisZSize)) break;
                d = this.zmin + d / this.axisZScale;
                break;
            }
            default: {
                return this.camera.inverseMapping((double[])this.center.clone());
            }
        }
        return new double[]{d3, d2, d};
    }

    public double[] scalePosition(double[] dArray) {
        if (!Double.isNaN(this.axisXSize)) {
            dArray[0] = (dArray[0] - this.xmin) * this.axisXScale;
        }
        if (!Double.isNaN(this.axisYSize)) {
            dArray[1] = (dArray[1] - this.ymin) * this.axisYScale;
        }
        if (!Double.isNaN(this.axisZSize)) {
            dArray[2] = (dArray[2] - this.zmin) * this.axisZScale;
        }
        return this.camera.map(dArray);
    }

    public double[] scaleSize(double[] dArray) {
        if (!Double.isNaN(this.axisXSize)) {
            dArray[0] = dArray[0] * this.axisXScale;
        }
        if (!Double.isNaN(this.axisYSize)) {
            dArray[1] = dArray[1] * this.axisYScale;
        }
        if (!Double.isNaN(this.axisZSize)) {
            dArray[2] = dArray[2] * this.axisZScale;
        }
        return this.camera.map(dArray);
    }

    public double[] projectPosition(double[] dArray) {
        if (!Double.isNaN(this.axisXSize)) {
            dArray[0] = (dArray[0] - this.xmin) * this.axisXScale;
        }
        if (!Double.isNaN(this.axisYSize)) {
            dArray[1] = (dArray[1] - this.ymin) * this.axisYScale;
        }
        if (!Double.isNaN(this.axisZSize)) {
            dArray[2] = (dArray[2] - this.zmin) * this.axisZScale;
        }
        this.camera.projectPosition(dArray);
        double d = 1.8;
        switch (this.camera.getProjectionMode()) {
            case 3: 
            case 10: {
                d = 1.3;
                break;
            }
            case 4: 
            case 11: {
                d = 1.0;
            }
        }
        dArray[0] = (double)this.acenter + dArray[0] * d * this.aconstant;
        dArray[1] = (double)this.bcenter - dArray[1] * d * this.bconstant;
        return dArray;
    }

    public double[] projectSize(double[] dArray, double[] dArray2) {
        if (!Double.isNaN(this.axisXSize)) {
            dArray[0] = (dArray[0] - this.xmin) * this.axisXScale;
            dArray2[0] = dArray2[0] * this.axisXScale;
        }
        if (!Double.isNaN(this.axisYSize)) {
            dArray[1] = (dArray[1] - this.ymin) * this.axisYScale;
            dArray2[1] = dArray2[1] * this.axisYScale;
        }
        if (!Double.isNaN(this.axisZSize)) {
            dArray[2] = (dArray[2] - this.zmin) * this.axisZScale;
            dArray2[2] = dArray2[2] * this.axisZScale;
        }
        this.camera.projectSize(dArray, dArray2);
        double d = 1.8;
        switch (this.camera.getProjectionMode()) {
            case 3: 
            case 10: {
                d = 1.3;
                break;
            }
            case 4: 
            case 11: {
                d = 1.0;
            }
        }
        dArray2[0] = dArray2[0] * (d * this.aconstant);
        dArray2[1] = dArray2[1] * (d * this.bconstant);
        return dArray2;
    }

    public Paint projectPaint(Paint paint, double d) {
        if (paint instanceof Color) {
            return this.projectColor((Color)paint, d);
        }
        return paint;
    }

    public Color projectColor(Color color, double d) {
        if (!this.visHints.isUseColorDepth()) {
            return color;
        }
        float[] fArray = new float[4];
        try {
            color.getRGBComponents(fArray);
            int n = 0;
            while (n < 3) {
                int n2 = n;
                fArray[n2] = (float)((double)fArray[n2] / d);
                fArray[n] = (float)Math.max(Math.min((double)fArray[n], 1.0), 0.0);
                ++n;
            }
            return new Color(fArray[0], fArray[1], fArray[2], fArray[3]);
        }
        catch (Exception exception) {
            return color;
        }
    }

    public void setDraggable(boolean bl) {
        this.draggable = bl;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    private InteractionTarget getTargetHit(int n, int n2) {
        for (Element element : this.elementList) {
            if (!element.isVisible() || !element.isEnabled()) continue;
            element.processChanges(0);
            InteractionTarget interactionTarget = element.getTargetHit(n, n2);
            if (interactionTarget == null) continue;
            return interactionTarget;
        }
        return null;
    }

    private void setMouseCursor(Cursor cursor) {
        this.implementingPanel.getComponent().setCursor(cursor);
    }

    private void displayPosition(double[] dArray) {
        this.visHints.displayPosition(this.camera.getProjectionMode(), dArray);
        this.decoration.positionTrackers(dArray);
    }

    private boolean mouseDraggedComputations(MouseEvent mouseEvent) {
        block52: {
            double d;
            block51: {
                if (mouseEvent.isControlDown()) {
                    if (!this.draggable) {
                        return false;
                    }
                    if (this.camera.is3dMode()) {
                        double d2 = this.camera.getFocusX();
                        double d3 = this.camera.getFocusY();
                        double d4 = this.camera.getFocusZ();
                        double d5 = (double)(mouseEvent.getX() - this.lastX) * this.maximumSize * 0.01;
                        double d6 = (double)(mouseEvent.getY() - this.lastY) * this.maximumSize * 0.01;
                        switch (this.keyPressed) {
                            case 88: {
                                if (this.camera.getCosAlpha() >= 0.0 && Math.abs(this.camera.getSinAlpha()) < this.camera.getCosAlpha()) {
                                    this.camera.setFocusXYZ(d2 + d6, d3, d4);
                                    break;
                                }
                                if (this.camera.getSinAlpha() >= 0.0 && Math.abs(this.camera.getCosAlpha()) < this.camera.getSinAlpha()) {
                                    this.camera.setFocusXYZ(d2 + d5, d3, d4);
                                    break;
                                }
                                if (this.camera.getCosAlpha() < 0.0 && Math.abs(this.camera.getSinAlpha()) < -this.camera.getCosAlpha()) {
                                    this.camera.setFocusXYZ(d2 - d6, d3, d4);
                                    break;
                                }
                                this.camera.setFocusXYZ(d2 - d5, d3, d4);
                                break;
                            }
                            case 89: {
                                if (this.camera.getCosAlpha() >= 0.0 && Math.abs(this.camera.getSinAlpha()) < this.camera.getCosAlpha()) {
                                    this.camera.setFocusXYZ(d2, d3 - d5, d4);
                                    break;
                                }
                                if (this.camera.getSinAlpha() >= 0.0 && Math.abs(this.camera.getCosAlpha()) < this.camera.getSinAlpha()) {
                                    this.camera.setFocusXYZ(d2, d3 + d6, d4);
                                    break;
                                }
                                if (this.camera.getCosAlpha() < 0.0 && Math.abs(this.camera.getSinAlpha()) < -this.camera.getCosAlpha()) {
                                    this.camera.setFocusXYZ(d2, d3 + d5, d4);
                                    break;
                                }
                                this.camera.setFocusXYZ(d2, d3 - d6, d4);
                                break;
                            }
                            case 90: {
                                if (this.camera.getCosBeta() >= 0.0) {
                                    this.camera.setFocusXYZ(d2, d3, d4 + d6);
                                    break;
                                }
                                this.camera.setFocusXYZ(d2, d3, d4 - d6);
                                break;
                            }
                            default: {
                                if (this.camera.getCosBeta() < 0.0) {
                                    d6 = -d6;
                                }
                                if (this.camera.getCosAlpha() >= 0.0 && Math.abs(this.camera.getSinAlpha()) < this.camera.getCosAlpha()) {
                                    this.camera.setFocusXYZ(d2, d3 - d5, d4 + d6);
                                    break;
                                }
                                if (this.camera.getSinAlpha() >= 0.0 && Math.abs(this.camera.getCosAlpha()) < this.camera.getSinAlpha()) {
                                    this.camera.setFocusXYZ(d2 + d5, d3, d4 + d6);
                                    break;
                                }
                                if (this.camera.getCosAlpha() < 0.0 && Math.abs(this.camera.getSinAlpha()) < -this.camera.getCosAlpha()) {
                                    this.camera.setFocusXYZ(d2, d3 + d5, d4 - d6);
                                    break;
                                }
                                this.camera.setFocusXYZ(d2 - d5, d3, d4 - d6);
                                break;
                            }
                        }
                    } else {
                        double d7 = this.camera.getFocusX();
                        double d8 = this.camera.getFocusY();
                        double d9 = this.camera.getFocusZ();
                        double d10 = (double)(mouseEvent.getX() - this.lastX) * this.maximumSize * 0.01;
                        double d11 = (double)(mouseEvent.getY() - this.lastY) * this.maximumSize * 0.01;
                        switch (this.camera.getProjectionMode()) {
                            case 0: {
                                this.camera.setFocusXYZ(d7 - d10, d8 + d11, d9);
                                break;
                            }
                            case 2: {
                                this.camera.setFocusXYZ(d7, d8 - d10, d9 + d11);
                                break;
                            }
                            case 1: {
                                this.camera.setFocusXYZ(d7 - d10, d8, d9 + d11);
                            }
                        }
                    }
                    return false;
                }
                if (mouseEvent.isShiftDown()) {
                    this.camera.setDistanceToScreen(this.camera.getDistanceToScreen() - (double)(mouseEvent.getY() - this.lastY) * this.maximumSize * 0.01);
                    return false;
                }
                if (this.camera.is3dMode() && this.targetHit == null && !mouseEvent.isAltDown()) {
                    if (this.draggable) {
                        this.camera.setAzimuthAndAltitude(this.camera.getAzimuth() - (double)(mouseEvent.getX() - this.lastX) * 0.01, this.camera.getAltitude() + (double)(mouseEvent.getY() - this.lastY) * 0.005);
                    }
                    return false;
                }
                if (this.trackerPoint == null) {
                    return true;
                }
                if (this.camera.is3dMode()) break block51;
                double[] dArray = this.worldPoint(mouseEvent.getX(), mouseEvent.getY());
                switch (this.keyPressed) {
                    case 88: {
                        if (!Double.isNaN(dArray[0])) {
                            this.trackerPoint[0] = dArray[0];
                            break;
                        }
                        break block52;
                    }
                    case 89: {
                        if (!Double.isNaN(dArray[1])) {
                            this.trackerPoint[1] = dArray[1];
                            break;
                        }
                        break block52;
                    }
                    case 90: {
                        if (!Double.isNaN(dArray[2])) {
                            this.trackerPoint[2] = dArray[2];
                            break;
                        }
                        break block52;
                    }
                    default: {
                        if (!Double.isNaN(dArray[0])) {
                            this.trackerPoint[0] = dArray[0];
                        }
                        if (!Double.isNaN(dArray[1])) {
                            this.trackerPoint[1] = dArray[1];
                        }
                        if (!Double.isNaN(dArray[2])) {
                            this.trackerPoint[2] = dArray[2];
                            break;
                        }
                        break block52;
                    }
                }
                break block52;
            }
            double d12 = (double)(mouseEvent.getX() - this.lastX) / (1.3 * this.aconstant);
            double d13 = (double)(mouseEvent.getY() - this.lastY) / (1.3 * this.bconstant);
            double[] dArray = new double[3];
            dArray[2] = this.camera.getCosBeta() >= 0.0 ? -d13 : d13;
            if (this.camera.getCosAlpha() >= 0.0 && Math.abs(this.camera.getSinAlpha()) < this.camera.getCosAlpha()) {
                dArray[0] = 0.0;
                dArray[1] = d12;
                d = -d12;
            } else if (this.camera.getSinAlpha() >= 0.0 && Math.abs(this.camera.getCosAlpha()) < this.camera.getSinAlpha()) {
                dArray[0] = -d12;
                dArray[1] = 0.0;
                d = d12;
            } else if (this.camera.getCosAlpha() < 0.0 && Math.abs(this.camera.getSinAlpha()) < -this.camera.getCosAlpha()) {
                dArray[0] = 0.0;
                dArray[1] = -d12;
                d = d12;
            } else {
                dArray[0] = d12;
                dArray[1] = 0.0;
                d = -d12;
            }
            this.camera.inverseMapping(dArray);
            double d14 = Double.isNaN(this.axisXSize) ? 1.0 : this.axisXScale;
            double d15 = Double.isNaN(this.axisYSize) ? 1.0 : this.axisYScale;
            double d16 = Double.isNaN(this.axisZSize) ? 1.0 : this.axisZScale;
            switch (this.keyPressed) {
                case 88: {
                    this.trackerPoint[0] = this.trackerPoint[0] + (dArray[0] == 0.0 ? d / d14 : dArray[0] / d14);
                    break;
                }
                case 89: {
                    this.trackerPoint[1] = this.trackerPoint[1] + (dArray[1] == 0.0 ? d / d15 : dArray[1] / d15);
                    break;
                }
                case 90: {
                    this.trackerPoint[2] = this.trackerPoint[2] + (dArray[2] == 0.0 ? d / d16 : dArray[2] / d16);
                    break;
                }
                default: {
                    this.trackerPoint[0] = this.trackerPoint[0] + dArray[0] / d14;
                    this.trackerPoint[1] = this.trackerPoint[1] + dArray[1] / d15;
                    this.trackerPoint[2] = this.trackerPoint[2] + dArray[2] / d16;
                }
            }
        }
        return true;
    }

    private void resetInteraction() {
        this.targetHit = null;
        this.displayPosition(null);
        this.implementingPanel.update();
    }

    private class IADMouseController
    extends MouseInputAdapter {
        private IADMouseController() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void mousePressed(MouseEvent mouseEvent) {
            DrawingPanel3D.this.implementingPanel.getComponent().requestFocus();
            if (mouseEvent.isPopupTrigger() || mouseEvent.getModifiers() == 4) {
                return;
            }
            DrawingPanel3D.this.lastX = mouseEvent.getX();
            DrawingPanel3D.this.lastY = mouseEvent.getY();
            DrawingPanel3D.this.targetHit = DrawingPanel3D.this.getTargetHit(DrawingPanel3D.this.lastX, DrawingPanel3D.this.lastY);
            if (DrawingPanel3D.this.targetHit != null) {
                Element element = DrawingPanel3D.this.targetHit.getElement();
                DrawingPanel3D.this.trackerPoint = element.getHotSpot(DrawingPanel3D.this.targetHit);
                element.invokeActions(new InteractionEvent((Object)element, 2000, DrawingPanel3D.this.targetHit.getActionCommand(), DrawingPanel3D.this.targetHit, mouseEvent));
                DrawingPanel3D.this.trackerPoint = element.getHotSpot(DrawingPanel3D.this.targetHit);
            } else {
                if (!DrawingPanel3D.this.myTarget.isEnabled()) {
                    DrawingPanel3D.this.resetInteraction();
                    return;
                }
                if (DrawingPanel3D.this.camera.is3dMode() && !mouseEvent.isAltDown()) {
                    DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2000, DrawingPanel3D.this.myTarget.getActionCommand(), null, mouseEvent));
                    DrawingPanel3D.this.resetInteraction();
                    return;
                }
                DrawingPanel3D.this.trackerPoint = DrawingPanel3D.this.worldPoint(mouseEvent.getX(), mouseEvent.getY());
                if (Double.isNaN(DrawingPanel3D.this.trackerPoint[0])) {
                    ((DrawingPanel3D)DrawingPanel3D.this).trackerPoint[0] = DrawingPanel3D.this.xmax;
                }
                if (Double.isNaN(DrawingPanel3D.this.trackerPoint[1])) {
                    ((DrawingPanel3D)DrawingPanel3D.this).trackerPoint[1] = DrawingPanel3D.this.ymax;
                }
                if (Double.isNaN(DrawingPanel3D.this.trackerPoint[2])) {
                    ((DrawingPanel3D)DrawingPanel3D.this).trackerPoint[2] = DrawingPanel3D.this.zmax;
                }
                DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2000, DrawingPanel3D.this.myTarget.getActionCommand(), DrawingPanel3D.this.trackerPoint, mouseEvent));
            }
            DrawingPanel3D.this.displayPosition(DrawingPanel3D.this.trackerPoint);
            DrawingPanel3D.this.implementingPanel.update();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() || mouseEvent.getModifiers() == 4) {
                return;
            }
            if (DrawingPanel3D.this.targetHit != null) {
                Element element = DrawingPanel3D.this.targetHit.getElement();
                element.invokeActions(new InteractionEvent((Object)element, 2002, DrawingPanel3D.this.targetHit.getActionCommand(), DrawingPanel3D.this.targetHit, mouseEvent));
            } else if (DrawingPanel3D.this.myTarget.isEnabled()) {
                if (!DrawingPanel3D.this.camera.is3dMode() || mouseEvent.isAltDown()) {
                    DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2002, DrawingPanel3D.this.myTarget.getActionCommand(), DrawingPanel3D.this.trackerPoint, mouseEvent));
                } else {
                    DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2002, DrawingPanel3D.this.myTarget.getActionCommand(), null, mouseEvent));
                }
            }
            DrawingPanel3D.this.implementingPanel.setFastRedraw(false);
            DrawingPanel3D.this.resetInteraction();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() || mouseEvent.getModifiers() == 4) {
                return;
            }
            DrawingPanel3D.this.implementingPanel.setFastRedraw(DrawingPanel3D.this.visHints.isAllowQuickRedraw() && DrawingPanel3D.this.keyPressed != 83);
            boolean bl = DrawingPanel3D.this.mouseDraggedComputations(mouseEvent);
            DrawingPanel3D.this.lastX = mouseEvent.getX();
            DrawingPanel3D.this.lastY = mouseEvent.getY();
            if (!bl) {
                DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2001, DrawingPanel3D.this.myTarget.getActionCommand(), null, mouseEvent));
                DrawingPanel3D.this.resetInteraction();
                return;
            }
            if (DrawingPanel3D.this.targetHit != null) {
                Element element = DrawingPanel3D.this.targetHit.getElement();
                element.updateHotSpot(DrawingPanel3D.this.targetHit, DrawingPanel3D.this.trackerPoint);
                element.invokeActions(new InteractionEvent((Object)element, 2001, DrawingPanel3D.this.targetHit.getActionCommand(), DrawingPanel3D.this.targetHit, mouseEvent));
                DrawingPanel3D.this.trackerPoint = element.getHotSpot(DrawingPanel3D.this.targetHit);
                DrawingPanel3D.this.displayPosition(DrawingPanel3D.this.trackerPoint);
            } else if (DrawingPanel3D.this.myTarget.isEnabled()) {
                DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2001, DrawingPanel3D.this.myTarget.getActionCommand(), DrawingPanel3D.this.trackerPoint, mouseEvent));
                DrawingPanel3D.this.displayPosition(DrawingPanel3D.this.trackerPoint);
            }
            DrawingPanel3D.this.implementingPanel.update();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            DrawingPanel3D.this.setMouseCursor(Cursor.getPredefinedCursor(1));
            if (DrawingPanel3D.this.myTarget.isEnabled()) {
                DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2003, DrawingPanel3D.this.myTarget.getActionCommand(), null, mouseEvent));
            }
            DrawingPanel3D.this.targetEntered = null;
            DrawingPanel3D.this.targetHit = null;
        }

        public void mouseExited(MouseEvent mouseEvent) {
            DrawingPanel3D.this.setMouseCursor(Cursor.getPredefinedCursor(0));
            if (DrawingPanel3D.this.myTarget.isEnabled()) {
                DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2004, DrawingPanel3D.this.myTarget.getActionCommand(), null, mouseEvent));
            }
            DrawingPanel3D.this.targetEntered = null;
            DrawingPanel3D.this.targetHit = null;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            mouseEvent.isMetaDown();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            InteractionTarget interactionTarget = DrawingPanel3D.this.getTargetHit(mouseEvent.getX(), mouseEvent.getY());
            if (interactionTarget != null) {
                if (DrawingPanel3D.this.targetEntered == null) {
                    interactionTarget.getElement().invokeActions(new InteractionEvent((Object)interactionTarget.getElement(), 2003, interactionTarget.getActionCommand(), interactionTarget, mouseEvent));
                }
                DrawingPanel3D.this.setMouseCursor(Cursor.getPredefinedCursor(12));
            } else {
                if (DrawingPanel3D.this.targetEntered != null) {
                    DrawingPanel3D.this.targetEntered.getElement().invokeActions(new InteractionEvent((Object)DrawingPanel3D.this.targetEntered.getElement(), 2004, DrawingPanel3D.this.targetEntered.getActionCommand(), DrawingPanel3D.this.targetEntered, mouseEvent));
                } else if (DrawingPanel3D.this.myTarget.isEnabled()) {
                    DrawingPanel3D.this.invokeActions(new InteractionEvent((Object)DrawingPanel3D.this, 2005, DrawingPanel3D.this.myTarget.getActionCommand(), null, mouseEvent));
                }
                DrawingPanel3D.this.setMouseCursor(Cursor.getPredefinedCursor(1));
            }
            DrawingPanel3D.this.targetEntered = interactionTarget;
        }
    }
}

