/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.util.Arrays;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.java3d.Java3dElementPlane;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementPlane;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;

public class ElementPlane
extends Element {
    private double[] vectorU = new double[]{1.0, 0.0, 0.0};
    private double[] vectorV = new double[]{0.0, 1.0, 0.0};
    private double vectorUSize = 1.0;
    private double vectorVSize = 1.0;

    protected ImplementingObject createImplementingObject(int n) {
        switch (n) {
            default: {
                return new SimpleElementPlane(this);
            }
            case 1: 
        }
        return new Java3dElementPlane(this);
    }

    public void setFirstDirection(double[] dArray) {
        if (dArray == null) {
            return;
        }
        if (Arrays.equals(dArray, this.vectorU)) {
            return;
        }
        System.arraycopy(dArray, 0, this.vectorU, 0, 3);
        this.vectorUSize = Math.sqrt(this.vectorU[0] * this.vectorU[0] + this.vectorU[1] * this.vectorU[1] + this.vectorU[2] * this.vectorU[2]);
        this.addChange(8);
    }

    public double[] getFirstDirection() {
        return (double[])this.vectorU.clone();
    }

    public void setSecondDirection(double[] dArray) {
        if (dArray == null) {
            return;
        }
        if (Arrays.equals(dArray, this.vectorV)) {
            return;
        }
        System.arraycopy(dArray, 0, this.vectorV, 0, 3);
        this.vectorVSize = Math.sqrt(this.vectorV[0] * this.vectorV[0] + this.vectorV[1] * this.vectorV[1] + this.vectorV[2] * this.vectorV[2]);
        this.addChange(8);
    }

    public double[] getSecondDirection() {
        return (double[])this.vectorV.clone();
    }

    public double getFirstSize() {
        return this.getSizeX() * this.vectorUSize;
    }

    public double getSecondSize() {
        return this.getSizeY() * this.vectorVSize;
    }

    public static double[][][] createStandardPlane(ElementPlane elementPlane, int n, int n2) {
        double[][][] dArray = new double[n * n2][4][3];
        int n3 = 0;
        double d = 1.0 / (double)n;
        double d2 = 1.0 / (double)n2;
        int n4 = 0;
        while (n4 < n) {
            double d3 = (double)n4 * d - 0.5;
            int n5 = 0;
            while (n5 < n2) {
                double d4 = (double)n5 * d2 - 0.5;
                int n6 = 0;
                while (n6 < 3) {
                    dArray[n3][0][n6] = d3 * elementPlane.vectorU[n6] + d4 * elementPlane.vectorV[n6];
                    ++n6;
                }
                n6 = 0;
                while (n6 < 3) {
                    dArray[n3][1][n6] = (d3 + d) * elementPlane.vectorU[n6] + d4 * elementPlane.vectorV[n6];
                    ++n6;
                }
                n6 = 0;
                while (n6 < 3) {
                    dArray[n3][2][n6] = (d3 + d) * elementPlane.vectorU[n6] + (d4 + d2) * elementPlane.vectorV[n6];
                    ++n6;
                }
                n6 = 0;
                while (n6 < 3) {
                    dArray[n3][3][n6] = d3 * elementPlane.vectorU[n6] + (d4 + d2) * elementPlane.vectorV[n6];
                    ++n6;
                }
                ++n3;
                ++n5;
            }
            ++n4;
        }
        return dArray;
    }
}

