/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3f;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;
import org.opensourcephysics.drawing3d.utils.Resolution;

public abstract class Java3dAbstractTile
extends Java3dElement {
    protected static final int RECOMPUTE_VERTEX = 24;
    private int numberOfTiles = -1;
    private double[][][] standardTile = null;
    private Vector3f[] standardNormals = null;
    private QuadArray qa;
    private Shape3D shape;
    private BranchGroup bg;
    private TexCoord2f[] texCoord = new TexCoord2f[]{new TexCoord2f(0.0f, 0.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(1.0f, 0.0f)};

    public Java3dAbstractTile(Element element) {
        super(element);
        this.shape = new Shape3D();
        this.shape.setAppearance(this.getAppearance());
        this.shape.setCapability(13);
        this.prepareVertex();
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.addChild((Node)this.shape);
        this.addNode((Node)this.bg);
    }

    protected abstract double[][][] createStandardTile(int var1, int var2, int var3);

    protected abstract Vector3f[] createStandardNormals(double[][][] var1, int var2, int var3, int var4);

    public void processChanges(int n, int n2) {
        super.processChanges(n, n2);
        if ((n & 0x18) != 0) {
            this.prepareVertex();
        }
    }

    public boolean isPrimitive() {
        return true;
    }

    protected void prepareVertex() {
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        Resolution resolution = this.element.getStyle().getResolution();
        if (resolution != null) {
            switch (resolution.getType()) {
                case 0: {
                    n = Math.max(resolution.getN1(), 1);
                    n2 = Math.max(resolution.getN2(), 1);
                    n3 = Math.max(resolution.getN3(), 1);
                    break;
                }
                case 1: {
                    n = Math.max((int)Math.round(0.49 + Math.abs(this.element.getSizeX()) / resolution.getMaxLength()), 1);
                    n2 = Math.max((int)Math.round(0.49 + Math.abs(this.element.getSizeY()) / resolution.getMaxLength()), 1);
                    n3 = Math.max((int)Math.round(0.49 + Math.abs(this.element.getSizeZ()) / resolution.getMaxLength()), 1);
                }
            }
        }
        this.standardTile = this.createStandardTile(n, n2, n3);
        if (this.standardTile == null) {
            return;
        }
        this.numberOfTiles = this.standardTile.length;
        if (this.numberOfTiles == 0) {
            return;
        }
        this.standardNormals = this.createStandardNormals(this.standardTile, n, n2, n3);
        int n4 = this.standardTile[0].length;
        this.qa = new QuadArray(this.numberOfTiles * n4 * 2, 39);
        if (n4 == 4) {
            int n5 = 0;
            int n6 = 0;
            while (n6 < this.numberOfTiles) {
                this.qa.setCoordinate(n5, this.standardTile[n6][0]);
                this.qa.setTextureCoordinate(0, n5, this.texCoord[0]);
                this.qa.setNormal(n5++, this.standardNormals[n6]);
                this.qa.setCoordinate(n5, this.standardTile[n6][1]);
                this.qa.setTextureCoordinate(0, n5, this.texCoord[1]);
                this.qa.setNormal(n5++, this.standardNormals[n6]);
                this.qa.setCoordinate(n5, this.standardTile[n6][2]);
                this.qa.setTextureCoordinate(0, n5, this.texCoord[2]);
                this.qa.setNormal(n5++, this.standardNormals[n6]);
                this.qa.setCoordinate(n5, this.standardTile[n6][3]);
                this.qa.setTextureCoordinate(0, n5, this.texCoord[3]);
                this.qa.setNormal(n5++, this.standardNormals[n6]);
                this.qa.setCoordinate(n5, this.standardTile[n6][3]);
                this.qa.setTextureCoordinate(0, n5, this.texCoord[3]);
                this.qa.setNormal(n5++, Java3dAbstractTile.opposite(this.standardNormals[n6]));
                this.qa.setCoordinate(n5, this.standardTile[n6][2]);
                this.qa.setTextureCoordinate(0, n5, this.texCoord[2]);
                this.qa.setNormal(n5++, Java3dAbstractTile.opposite(this.standardNormals[n6]));
                this.qa.setCoordinate(n5, this.standardTile[n6][1]);
                this.qa.setTextureCoordinate(0, n5, this.texCoord[1]);
                this.qa.setNormal(n5++, Java3dAbstractTile.opposite(this.standardNormals[n6]));
                this.qa.setCoordinate(n5, this.standardTile[n6][0]);
                this.qa.setTextureCoordinate(0, n5, this.texCoord[0]);
                this.qa.setNormal(n5++, Java3dAbstractTile.opposite(this.standardNormals[n6]));
                ++n6;
            }
        } else {
            int n7 = 0;
            int n8 = 0;
            while (n8 < this.numberOfTiles) {
                int n9 = 0;
                while (n9 < n4) {
                    this.qa.setCoordinate(n7, this.standardTile[n8][n9]);
                    this.qa.setTextureCoordinate(0, n7, this.texCoord[n9]);
                    this.qa.setNormal(n7++, this.standardNormals[n8]);
                    ++n9;
                }
                n9 = n4 - 1;
                while (n9 >= n4) {
                    this.qa.setCoordinate(n7, this.standardTile[n8][n9]);
                    this.qa.setTextureCoordinate(0, n7, this.texCoord[n9]);
                    this.qa.setNormal(n7++, Java3dAbstractTile.opposite(this.standardNormals[n8]));
                    --n9;
                }
                ++n8;
            }
        }
        this.shape.setGeometry((Geometry)this.qa);
    }

    static Vector3f opposite(Vector3f vector3f) {
        Vector3f vector3f2 = new Vector3f();
        vector3f2.x = -vector3f.x;
        vector3f2.y = -vector3f.y;
        vector3f2.z = -vector3f.z;
        return vector3f2;
    }
}

