/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.interaction.InteractionEvent;
import org.opensourcephysics.drawing3d.interaction.InteractionListener;
import org.opensourcephysics.drawing3d.utils.Camera;
import org.opensourcephysics.drawing3d.utils.CameraInspectorFrame;
import org.opensourcephysics.tools.ToolsRes;

public class CameraInspector
extends JPanel
implements InteractionListener {
    private DrawingPanel3D panel = null;
    private Camera camera = null;
    private NumberFormat format = new DecimalFormat("0.000");
    private JTextField xField;
    private JTextField yField;
    private JTextField zField;
    private JTextField focusxField;
    private JTextField focusyField;
    private JTextField focuszField;
    private JTextField azimuthField;
    private JTextField altitudeField;
    private JTextField rotationField;
    private JTextField distanceField;
    private JRadioButton perspectiveRB;
    private JRadioButton noperspectiveRB;
    private JRadioButton planarxyRB;
    private JRadioButton planarxzRB;
    private JRadioButton planaryzRB;
    private AbstractList<ActionListener> listeners = new ArrayList<ActionListener>();

    public static JFrame createFrame(DrawingPanel3D drawingPanel3D) {
        return new CameraInspectorFrame(ToolsRes.getString("CameraInspector.FrameTitle"), new CameraInspector(drawingPanel3D));
    }

    public static JFrame createFrame(CameraInspector cameraInspector) {
        return new CameraInspectorFrame(ToolsRes.getString("CameraInspector.FrameTitle"), cameraInspector);
    }

    public CameraInspector(DrawingPanel3D drawingPanel3D) {
        this.panel = drawingPanel3D;
        this.camera = drawingPanel3D.getCamera();
        drawingPanel3D.addInteractionListener(this);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                JTextField jTextField = (JTextField)actionEvent.getSource();
                double d = 0.0;
                try {
                    d = CameraInspector.this.format.parse(jTextField.getText()).doubleValue();
                }
                catch (ParseException parseException) {
                    d = 0.0;
                }
                if (string.equals("x")) {
                    CameraInspector.this.camera.setXYZ(d, CameraInspector.this.camera.getY(), CameraInspector.this.camera.getZ());
                } else if (string.equals("y")) {
                    CameraInspector.this.camera.setXYZ(CameraInspector.this.camera.getX(), d, CameraInspector.this.camera.getZ());
                } else if (string.equals("z")) {
                    CameraInspector.this.camera.setXYZ(CameraInspector.this.camera.getX(), CameraInspector.this.camera.getY(), d);
                } else if (string.equals("focusx")) {
                    CameraInspector.this.camera.setFocusXYZ(d, CameraInspector.this.camera.getFocusY(), CameraInspector.this.camera.getFocusZ());
                } else if (string.equals("focusy")) {
                    CameraInspector.this.camera.setFocusXYZ(CameraInspector.this.camera.getFocusX(), d, CameraInspector.this.camera.getFocusZ());
                } else if (string.equals("focusz")) {
                    CameraInspector.this.camera.setFocusXYZ(CameraInspector.this.camera.getFocusX(), CameraInspector.this.camera.getFocusY(), d);
                } else if (string.equals("azimuth")) {
                    CameraInspector.this.camera.setAzimuth(d);
                } else if (string.equals("altitude")) {
                    CameraInspector.this.camera.setAltitude(d);
                } else if (string.equals("rotation")) {
                    CameraInspector.this.camera.setRotation(d);
                } else if (string.equals("screen")) {
                    CameraInspector.this.camera.setDistanceToScreen(d);
                }
                CameraInspector.this.panel.getImplementingPanel().forceRefresh();
                CameraInspector.this.updateFields();
                ActionEvent actionEvent2 = new ActionEvent(CameraInspector.this, 1001, "FieldChange");
                Iterator iterator = CameraInspector.this.listeners.iterator();
                while (iterator.hasNext()) {
                    ((ActionListener)iterator.next()).actionPerformed(actionEvent2);
                }
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("reset")) {
                    CameraInspector.this.camera.reset();
                    CameraInspector.this.panel.getImplementingPanel().forceRefresh();
                    CameraInspector.this.updateFields();
                } else if (string.equals("perspective")) {
                    CameraInspector.this.camera.setProjectionMode(11);
                } else if (string.equals("perspective_on")) {
                    CameraInspector.this.camera.setProjectionMode(4);
                } else if (string.equals("no_perspective")) {
                    CameraInspector.this.camera.setProjectionMode(10);
                } else if (string.equals("perspective_off")) {
                    CameraInspector.this.camera.setProjectionMode(3);
                } else if (string.equals("planarXY")) {
                    CameraInspector.this.camera.setProjectionMode(0);
                } else if (string.equals("planarXZ")) {
                    CameraInspector.this.camera.setProjectionMode(1);
                } else if (string.equals("planarYZ")) {
                    CameraInspector.this.camera.setProjectionMode(2);
                }
                CameraInspector.this.camera.reset();
                ActionEvent actionEvent2 = new ActionEvent(CameraInspector.this, 1001, "ButtonChange");
                Iterator iterator = CameraInspector.this.listeners.iterator();
                while (iterator.hasNext()) {
                    ((ActionListener)iterator.next()).actionPerformed(actionEvent2);
                }
            }
        };
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(2, 3));
        jPanel.setBorder(new TitledBorder(ToolsRes.getString("CameraInspector.ProjectionMode")));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.perspectiveRB = new JRadioButton(ToolsRes.getString("CameraInspector.Perspective"));
        this.perspectiveRB.setActionCommand("perspective");
        this.perspectiveRB.addActionListener(actionListener2);
        jPanel.add(this.perspectiveRB);
        buttonGroup.add(this.perspectiveRB);
        this.planarxyRB = new JRadioButton(ToolsRes.getString("CameraInspector.PlanarXY"));
        this.planarxyRB.setActionCommand("planarXY");
        this.planarxyRB.addActionListener(actionListener2);
        jPanel.add(this.planarxyRB);
        buttonGroup.add(this.planarxyRB);
        this.planaryzRB = new JRadioButton(ToolsRes.getString("CameraInspector.PlanarYZ"));
        this.planaryzRB.setActionCommand("planarYZ");
        this.planaryzRB.addActionListener(actionListener2);
        jPanel.add(this.planaryzRB);
        buttonGroup.add(this.planaryzRB);
        this.noperspectiveRB = new JRadioButton(ToolsRes.getString("CameraInspector.NoPerspective"));
        this.noperspectiveRB.setActionCommand("no_perspective");
        this.noperspectiveRB.addActionListener(actionListener2);
        jPanel.add(this.noperspectiveRB);
        buttonGroup.add(this.noperspectiveRB);
        this.planarxzRB = new JRadioButton(ToolsRes.getString("CameraInspector.PlanarXZ"));
        this.planarxzRB.setActionCommand("planarXZ");
        this.planarxzRB.addActionListener(actionListener2);
        jPanel.add(this.planarxzRB);
        buttonGroup.add(this.planarxzRB);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        this.add((Component)jPanel, "North");
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1));
        JPanel jPanel4 = new JPanel(new GridLayout(0, 1));
        JPanel jPanel5 = new JPanel(new GridLayout(0, 1));
        JPanel jPanel6 = new JPanel(new GridLayout(0, 1));
        this.xField = CameraInspector.createRow(jPanel3, jPanel4, "X", actionListener);
        this.yField = CameraInspector.createRow(jPanel3, jPanel4, "Y", actionListener);
        this.zField = CameraInspector.createRow(jPanel3, jPanel4, "Z", actionListener);
        this.focusxField = CameraInspector.createRow(jPanel5, jPanel6, "FocusX", actionListener);
        this.focusyField = CameraInspector.createRow(jPanel5, jPanel6, "FocusY", actionListener);
        this.focuszField = CameraInspector.createRow(jPanel5, jPanel6, "FocusZ", actionListener);
        this.azimuthField = CameraInspector.createRow(jPanel3, jPanel4, "Azimuth", actionListener);
        this.altitudeField = CameraInspector.createRow(jPanel3, jPanel4, "Altitude", actionListener);
        this.rotationField = CameraInspector.createRow(jPanel5, jPanel6, "Rotation", actionListener);
        this.distanceField = CameraInspector.createRow(jPanel5, jPanel6, "Screen", actionListener);
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.add((Component)jPanel3, "West");
        jPanel7.add((Component)jPanel4, "Center");
        JPanel jPanel8 = new JPanel(new BorderLayout());
        jPanel8.add((Component)jPanel5, "West");
        jPanel8.add((Component)jPanel6, "Center");
        JPanel jPanel9 = new JPanel(new GridLayout(1, 0));
        jPanel9.setBorder(new TitledBorder(ToolsRes.getString("CameraInspector.CameraParameters")));
        jPanel9.add(jPanel7);
        jPanel9.add(jPanel8);
        this.add((Component)jPanel9, "Center");
        JButton jButton = new JButton(ToolsRes.getString("CameraInspector.ResetCamera"));
        jButton.setActionCommand("reset");
        jButton.addActionListener(actionListener2);
        this.add((Component)jButton, "South");
        this.updateFields();
    }

    public void setFormat(NumberFormat numberFormat) {
        this.format = numberFormat;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    public void interactionPerformed(InteractionEvent interactionEvent) {
        if (interactionEvent.getSource() != this.panel) {
            return;
        }
        if (interactionEvent.getInfo() != null) {
            return;
        }
        this.updateFields();
    }

    public void updateFields() {
        switch (this.camera.getProjectionMode()) {
            default: {
                this.perspectiveRB.setSelected(true);
                break;
            }
            case 3: 
            case 10: {
                this.noperspectiveRB.setSelected(true);
                break;
            }
            case 0: {
                this.planarxyRB.setSelected(true);
                break;
            }
            case 1: {
                this.planarxzRB.setSelected(true);
                break;
            }
            case 2: {
                this.planaryzRB.setSelected(true);
            }
        }
        this.xField.setText(this.format.format(this.camera.getX()));
        this.yField.setText(this.format.format(this.camera.getY()));
        this.zField.setText(this.format.format(this.camera.getZ()));
        this.focusxField.setText(this.format.format(this.camera.getFocusX()));
        this.focusyField.setText(this.format.format(this.camera.getFocusY()));
        this.focuszField.setText(this.format.format(this.camera.getFocusZ()));
        this.azimuthField.setText(this.format.format(this.camera.getAzimuth()));
        this.altitudeField.setText(this.format.format(this.camera.getAltitude()));
        this.rotationField.setText(this.format.format(this.camera.getRotation()));
        this.distanceField.setText(this.format.format(this.camera.getDistanceToScreen()));
    }

    private static JTextField createRow(JPanel jPanel, JPanel jPanel2, String string, ActionListener actionListener) {
        if (string == null) {
            jPanel.add(new JLabel());
            jPanel2.add(new JLabel());
            return null;
        }
        JLabel jLabel = new JLabel(ToolsRes.getString("CameraInspector." + string));
        jLabel.setHorizontalAlignment(0);
        jLabel.setBorder(new EmptyBorder(0, 3, 0, 3));
        JTextField jTextField = new JTextField(4);
        jTextField.setActionCommand(string.toLowerCase());
        jTextField.addActionListener(actionListener);
        jPanel.add(jLabel);
        jPanel2.add(jTextField);
        return jTextField;
    }
}

