/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.utils;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementArrow;
import org.opensourcephysics.drawing3d.ElementSegment;
import org.opensourcephysics.drawing3d.ElementText;
import org.opensourcephysics.drawing3d.utils.Resolution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Decoration {
    private static final int AXIS_DIVISIONS = 10;
    private DrawingPanel3D panel;
    private List<Element> list = new ArrayList<Element>();
    private Element xAxis;
    private Element yAxis;
    private Element zAxis;
    private ElementText xText;
    private ElementText yText;
    private ElementText zText;
    private Element[] boxSides = new Element[12];
    private int trackersVisible;
    private ElementSegment[] trackerLines = new ElementSegment[9];

    public Decoration(DrawingPanel3D drawingPanel3D) {
        this.panel = drawingPanel3D;
        Resolution resolution = new Resolution(10, 1, 1);
        int n = 0;
        int n2 = this.boxSides.length;
        while (n < n2) {
            ElementSegment elementSegment = new ElementSegment();
            elementSegment.getStyle().setResolution(resolution);
            this.list.add(elementSegment);
            this.boxSides[n] = elementSegment;
            ++n;
        }
        String[] stringArray = this.panel.getVisualizationHints().getAxesLabels();
        this.xAxis = new ElementArrow();
        this.xAxis.getStyle().setResolution(resolution);
        this.list.add(this.xAxis);
        this.xText = new ElementText();
        this.xText.setText(stringArray[0]);
        this.xText.getStyle().setRelativePosition(0);
        this.list.add(this.xText);
        this.yAxis = new ElementArrow();
        this.yAxis.getStyle().setResolution(resolution);
        this.list.add(this.yAxis);
        this.yText = new ElementText();
        this.yText.setText(stringArray[1]);
        this.yText.getStyle().setRelativePosition(0);
        this.list.add(this.yText);
        this.zAxis = new ElementArrow();
        this.zAxis.getStyle().setResolution(resolution);
        this.list.add(this.zAxis);
        this.zText = new ElementText();
        this.zText.setText(stringArray[2]);
        this.zText.getStyle().setRelativePosition(0);
        this.list.add(this.zText);
        n2 = 0;
        while (n2 < this.trackerLines.length) {
            this.trackerLines[n2] = new ElementSegment();
            this.trackerLines[n2].setVisible(false);
            this.list.add(this.trackerLines[n2]);
            ++n2;
        }
        this.setCursorMode();
        this.adjustColors();
        this.adjustFont();
        this.updateType();
        this.reset();
    }

    public void adjustColors() {
        Color color;
        Color color2;
        Color color3;
        Color color4 = this.panel.getVisualizationHints().getForegroundColor();
        if (this.isDarkBackground()) {
            color3 = Color.ORANGE;
            color2 = Color.YELLOW;
            color = Color.CYAN;
        } else {
            color3 = new Color(128, 0, 0);
            color2 = new Color(0, 128, 0);
            color = new Color(0, 0, 255);
        }
        Element[] elementArray = this.boxSides;
        int n = this.boxSides.length;
        int n2 = 0;
        while (n2 < n) {
            Element element = elementArray[n2];
            element.getStyle().setLineColor(color4);
            ++n2;
        }
        this.boxSides[0].getStyle().setLineColor(color3);
        this.boxSides[3].getStyle().setLineColor(color2);
        this.boxSides[8].getStyle().setLineColor(color);
        this.xAxis.getStyle().setLineColor(color4);
        this.yAxis.getStyle().setLineColor(color4);
        this.zAxis.getStyle().setLineColor(color4);
        this.xAxis.getStyle().setFillColor(color3);
        this.yAxis.getStyle().setFillColor(color2);
        this.zAxis.getStyle().setFillColor(color);
        this.xText.getStyle().setLineColor(color4);
        this.yText.getStyle().setLineColor(color4);
        this.zText.getStyle().setLineColor(color4);
    }

    public void adjustFont() {
        Font font = this.panel.getVisualizationHints().getFont();
        this.xText.setFont(font);
        this.yText.setFont(font);
        this.zText.setFont(font);
    }

    public List<Element> getElementList() {
        return this.list;
    }

    public void updateAxesLabels() {
        String[] stringArray = this.panel.getVisualizationHints().getAxesLabels();
        this.xText.setText(stringArray[0]);
        this.yText.setText(stringArray[1]);
        this.zText.setText(stringArray[2]);
    }

    public void updateType() {
        switch (this.panel.getVisualizationHints().getDecorationType()) {
            case 0: {
                int n = 0;
                int n2 = this.boxSides.length;
                while (n < n2) {
                    this.boxSides[n].setVisible(false);
                    ++n;
                }
                this.xAxis.setVisible(false);
                this.yAxis.setVisible(false);
                this.zAxis.setVisible(false);
                this.xText.setVisible(false);
                this.yText.setVisible(false);
                this.zText.setVisible(false);
                break;
            }
            case 1: 
            case 3: {
                int n = 0;
                int n3 = this.boxSides.length;
                while (n < n3) {
                    this.boxSides[n].setVisible(false);
                    ++n;
                }
                this.xAxis.setVisible(true);
                this.yAxis.setVisible(true);
                this.zAxis.setVisible(true);
                this.xText.setVisible(true);
                this.yText.setVisible(true);
                this.zText.setVisible(true);
                break;
            }
            default: {
                int n = 0;
                int n4 = this.boxSides.length;
                while (n < n4) {
                    this.boxSides[n].setVisible(true);
                    ++n;
                }
                this.xAxis.setVisible(false);
                this.yAxis.setVisible(false);
                this.zAxis.setVisible(false);
                this.xText.setVisible(false);
                this.yText.setVisible(false);
                this.zText.setVisible(false);
            }
        }
    }

    public void reset() {
        double d = this.panel.getPreferredMinX();
        double d2 = this.panel.getPreferredMaxX();
        double d3 = this.panel.getPreferredMinY();
        double d4 = this.panel.getPreferredMaxY();
        double d5 = this.panel.getPreferredMinZ();
        double d6 = this.panel.getPreferredMaxZ();
        double d7 = d2 - d;
        double d8 = d4 - d3;
        double d9 = d6 - d5;
        this.boxSides[0].setXYZ(d, d3, d5);
        this.boxSides[0].setSizeXYZ(d7, 0.0, 0.0);
        this.boxSides[1].setXYZ(d2, d3, d5);
        this.boxSides[1].setSizeXYZ(0.0, d8, 0.0);
        this.boxSides[2].setXYZ(d, d4, d5);
        this.boxSides[2].setSizeXYZ(d7, 0.0, 0.0);
        this.boxSides[3].setXYZ(d, d3, d5);
        this.boxSides[3].setSizeXYZ(0.0, d8, 0.0);
        this.boxSides[4].setXYZ(d, d3, d6);
        this.boxSides[4].setSizeXYZ(d7, 0.0, 0.0);
        this.boxSides[5].setXYZ(d2, d3, d6);
        this.boxSides[5].setSizeXYZ(0.0, d8, 0.0);
        this.boxSides[6].setXYZ(d, d4, d6);
        this.boxSides[6].setSizeXYZ(d7, 0.0, 0.0);
        this.boxSides[7].setXYZ(d, d3, d6);
        this.boxSides[7].setSizeXYZ(0.0, d8, 0.0);
        this.boxSides[8].setXYZ(d, d3, d5);
        this.boxSides[8].setSizeXYZ(0.0, 0.0, d9);
        this.boxSides[9].setXYZ(d2, d3, d5);
        this.boxSides[9].setSizeXYZ(0.0, 0.0, d9);
        this.boxSides[10].setXYZ(d2, d4, d5);
        this.boxSides[10].setSizeXYZ(0.0, 0.0, d9);
        this.boxSides[11].setXYZ(d, d4, d5);
        this.boxSides[11].setSizeXYZ(0.0, 0.0, d9);
        switch (this.panel.getVisualizationHints().getDecorationType()) {
            default: {
                this.xAxis.setXYZ(d, d3, d5);
                this.xAxis.setSizeXYZ(d7, 0.0, 0.0);
                this.xText.setXYZ(d2 + d7 * 0.04, d3, d5);
                this.yAxis.setXYZ(d, d3, d5);
                this.yAxis.setSizeXYZ(0.0, d8, 0.0);
                this.yText.setXYZ(d, d4 + d8 * 0.04, d5);
                this.zAxis.setXYZ(d, d3, d5);
                this.zAxis.setSizeXYZ(0.0, 0.0, d9);
                this.zText.setXYZ(d, d3, d6 + d9 * 0.05);
                break;
            }
            case 3: {
                double d10 = (d + d2) / 2.0;
                double d11 = (d3 + d4) / 2.0;
                double d12 = (d5 + d6) / 2.0;
                this.xAxis.setXYZ(d10, d11, d12);
                this.xAxis.setSizeXYZ(d7 / 2.0, 0.0, 0.0);
                this.xText.setXYZ(d2 + d7 * 0.04, d11, d12);
                this.yAxis.setXYZ(d10, d11, d12);
                this.yAxis.setSizeXYZ(0.0, d8 / 2.0, 0.0);
                this.yText.setXYZ(d10, d4 + d8 * 0.04, d12);
                this.zAxis.setXYZ(d10, d11, d12);
                this.zAxis.setSizeXYZ(0.0, 0.0, d9 / 2.0);
                this.zText.setXYZ(d10, d11, d6 + d9 * 0.05);
            }
        }
    }

    private boolean isDarkBackground() {
        if (this.panel.getVisualizationHints().getBackgroundImage() != null) {
            return false;
        }
        Color color = this.panel.getVisualizationHints().getBackgroundColor();
        return color.getRed() < 128 && color.getGreen() < 128 && color.getBlue() < 128;
    }

    public void setCursorMode() {
        switch (this.panel.getVisualizationHints().getCursorType()) {
            case 0: {
                this.trackersVisible = 0;
                break;
            }
            case 2: {
                this.trackersVisible = 9;
                break;
            }
            default: {
                this.trackersVisible = 3;
                break;
            }
            case 3: {
                this.trackersVisible = 3;
            }
        }
    }

    public void positionTrackers(double[] dArray) {
        boolean bl = dArray != null;
        int n = 0;
        int n2 = this.trackerLines.length;
        while (n < n2) {
            if (n < this.trackersVisible) {
                this.trackerLines[n].setVisible(bl);
            } else {
                this.trackerLines[n].setVisible(false);
            }
            ++n;
        }
        if (!bl) {
            return;
        }
        double d = this.panel.getPreferredMinX();
        double d2 = this.panel.getPreferredMaxX();
        double d3 = this.panel.getPreferredMinY();
        double d4 = this.panel.getPreferredMaxY();
        double d5 = this.panel.getPreferredMinZ();
        double d6 = this.panel.getPreferredMaxZ();
        switch (this.panel.getVisualizationHints().getCursorType()) {
            case 0: {
                return;
            }
            default: {
                this.trackerLines[0].setXYZ(dArray[0], d3, d5);
                this.trackerLines[0].setSizeXYZ(0.0, dArray[1] - d3, 0.0);
                this.trackerLines[1].setXYZ(d, dArray[1], d5);
                this.trackerLines[1].setSizeXYZ(dArray[0] - d, 0.0, 0.0);
                this.trackerLines[2].setXYZ(dArray[0], dArray[1], d5);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, dArray[2] - d5);
                break;
            }
            case 2: {
                this.trackerLines[0].setXYZ(d, dArray[1], dArray[2]);
                this.trackerLines[0].setSizeXYZ(dArray[0] - d, 0.0, 0.0);
                this.trackerLines[1].setXYZ(dArray[0], d3, dArray[2]);
                this.trackerLines[1].setSizeXYZ(0.0, dArray[1] - d3, 0.0);
                this.trackerLines[2].setXYZ(dArray[0], dArray[1], d5);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, dArray[2] - d5);
                this.trackerLines[3].setXYZ(dArray[0], d3, d5);
                this.trackerLines[3].setSizeXYZ(0.0, dArray[1] - d3, 0.0);
                this.trackerLines[4].setXYZ(d, dArray[1], d5);
                this.trackerLines[4].setSizeXYZ(dArray[0] - d, 0.0, 0.0);
                this.trackerLines[5].setXYZ(dArray[0], d3, d5);
                this.trackerLines[5].setSizeXYZ(0.0, 0.0, dArray[2] - d5);
                this.trackerLines[6].setXYZ(d, d3, dArray[2]);
                this.trackerLines[6].setSizeXYZ(dArray[0] - d, 0.0, 0.0);
                this.trackerLines[7].setXYZ(d, dArray[1], d5);
                this.trackerLines[7].setSizeXYZ(0.0, 0.0, dArray[2] - d5);
                this.trackerLines[8].setXYZ(d, d3, dArray[2]);
                this.trackerLines[8].setSizeXYZ(0.0, dArray[1] - d3, 0.0);
                break;
            }
            case 3: {
                this.trackerLines[0].setXYZ(d, dArray[1], dArray[2]);
                this.trackerLines[0].setSizeXYZ(d2 - d, 0.0, 0.0);
                this.trackerLines[1].setXYZ(dArray[0], d3, dArray[2]);
                this.trackerLines[1].setSizeXYZ(0.0, d4 - d3, 0.0);
                this.trackerLines[2].setXYZ(dArray[0], dArray[1], d5);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, d6 - d5);
            }
        }
    }
}

