/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.rk;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODESolverInterpolator;

public abstract class AbstractExplicitRKSolverInterpolator
implements ODESolverInterpolator {
    protected double stepSize = 0.1;
    protected double maximumStepSize = Double.POSITIVE_INFINITY;
    protected int dimension;
    protected int timeIndex;
    protected int error_code = 0;
    protected double initialTime = 0.0;
    protected double finalTime = 0.0;
    protected double deltaTime = 0.0;
    protected double[] initialState;
    protected double[] initialRate;
    protected double[] finalState;
    protected double[] finalRate;
    protected ODE ode;
    protected long counter = 0L;
    protected long evals = 0L;
    private boolean bootStrap1Ready = false;
    private boolean bootStrap2Ready = false;
    private static final double ALPHA = 0.25;
    private static final double bt1_den = 0.1875;
    private static final double bt1_cf1 = 0.3125;
    private static final double bt1_cf0 = -0.1875;
    private static final double bt1_cys = -1.125;
    private static final double BETA1 = 0.7;
    private static final double BETA2 = 0.85;
    private static final double bt2_den = 0.009639000000000005;
    private static final double bt2_cf11 = -0.06999999999999974;
    private static final double bt2_cf01 = 0.33000000000000007;
    private static final double bt2_cys1 = -1.26;
    private static final double bt2_cf12 = -0.46749999999999986;
    private static final double bt2_cf02 = 0.23250000000000015;
    private static final double bt2_cys2 = -0.765;
    private static final double bt2_m44 = -0.16799999999999982;
    private static final double bt2_m54 = -0.17849999999999996;
    private static final double bt2_m45 = -0.4095;
    private static final double bt2_m55 = -0.4924687499999998;
    private double[] state_bt1 = null;
    private double[] rate_bt1;
    private double[] bt1_c2;
    private double[] bt1_c3;
    private double[] bt1_c4;
    private double[] state_bt2 = null;
    private double[] rate_bt21;
    private double[] rate_bt22;
    private double[] bt2_c2;
    private double[] bt2_c3;
    private double[] bt2_c4;
    private double[] bt2_c5;

    protected abstract int getNumberOfEvaluations();

    protected abstract void allocateOtherArrays();

    protected abstract double[] computeIntermediateStep(double var1, double[] var3);

    protected void computeOneStep() {
        this.computeIntermediateStep(this.stepSize, this.finalState);
        this.ode.getRate(this.finalState, this.finalRate);
        this.finalTime = this.initialTime + this.stepSize;
        this.counter += this.evals;
    }

    public final ODE getODE() {
        return this.ode;
    }

    public final void initialize(double d) {
        this.stepSize = d;
        double[] dArray = this.ode.getState();
        if (this.initialState == null || this.initialState.length != dArray.length) {
            this.dimension = dArray.length;
            this.timeIndex = this.dimension - 1;
            this.initialState = new double[this.dimension];
            this.initialRate = new double[this.dimension];
            this.finalState = new double[this.dimension];
            this.finalRate = new double[this.dimension];
            this.allocateOtherArrays();
        }
        this.counter = 0L;
        this.evals = this.getNumberOfEvaluations();
        this.reinitialize(dArray);
    }

    public void reinitialize(double[] dArray) {
        this.initialTime = dArray[this.timeIndex];
        System.arraycopy(dArray, 0, this.initialState, 0, this.dimension);
        this.ode.getRate(this.initialState, this.initialRate);
        this.finalTime = Double.NaN;
        this.error_code = 0;
        this.bootStrap2Ready = false;
        this.bootStrap1Ready = false;
    }

    public double[] getCurrentRate() {
        return this.initialRate;
    }

    public void setEstimateFirstStep(boolean bl) {
    }

    public final void setStepSize(double d) {
        this.stepSize = d;
    }

    public void setMaximumStepSize(double d) {
        this.maximumStepSize = Math.abs(d);
    }

    public final double getStepSize() {
        return this.stepSize;
    }

    public void setTolerances(double d, double d2) {
    }

    public final double getMaximumTime() {
        if (this.error_code != 0) {
            return Double.NaN;
        }
        if (Double.isNaN(this.finalTime)) {
            this.computeOneStep();
            this.deltaTime = this.finalTime - this.initialTime;
            this.bootStrap2Ready = false;
            this.bootStrap1Ready = false;
        }
        return this.finalTime;
    }

    public final long getCounter() {
        return this.counter;
    }

    public final double internalStep() {
        this.initialTime = this.finalTime;
        System.arraycopy(this.finalState, 0, this.initialState, 0, this.dimension);
        System.arraycopy(this.finalRate, 0, this.initialRate, 0, this.dimension);
        this.error_code = 0;
        this.computeOneStep();
        this.bootStrap2Ready = false;
        this.bootStrap1Ready = false;
        this.deltaTime = this.finalTime - this.initialTime;
        return this.finalTime;
    }

    public double getInternalStepSize() {
        return this.deltaTime;
    }

    protected double[] interpolateHermite(double d, double[] dArray) {
        this.hermite((d - this.initialTime) / this.deltaTime, dArray);
        dArray[this.timeIndex] = d;
        return dArray;
    }

    private double[] hermite(double d, double[] dArray) {
        double d2 = d - 1.0;
        double d3 = d * d2;
        double d4 = d3 * (1.0 - 2.0 * d);
        double d5 = -d2 - d4;
        double d6 = d + d4;
        double d7 = d3 * d2 * this.deltaTime;
        double d8 = d3 * d * this.deltaTime;
        int n = 0;
        while (n < this.timeIndex) {
            dArray[n] = d5 * this.initialState[n] + d6 * this.finalState[n] + d7 * this.initialRate[n] + d8 * this.finalRate[n];
            ++n;
        }
        return dArray;
    }

    private void prepareFirstBootstrap() {
        if (this.state_bt1 == null) {
            this.state_bt1 = new double[this.dimension];
            this.rate_bt1 = new double[this.dimension];
            this.bt1_c2 = new double[this.dimension];
            this.bt1_c3 = new double[this.dimension];
            this.bt1_c4 = new double[this.dimension];
        }
        this.hermite(0.25, this.state_bt1);
        this.state_bt1[this.timeIndex] = this.initialTime + 0.25 * this.deltaTime;
        this.ode.getRate(this.state_bt1, this.rate_bt1);
        int n = 0;
        while (n < this.timeIndex) {
            double d = this.finalState[n] - this.initialState[n];
            double d2 = this.deltaTime * this.initialRate[n];
            double d3 = this.deltaTime * this.finalRate[n];
            double d4 = (this.deltaTime * this.rate_bt1[n] + 0.3125 * d3 + -0.1875 * d2 + -1.125 * d) / 0.1875;
            double d5 = d3 + d2 - 2.0 * d - 2.0 * d4;
            this.bt1_c4[n] = d4;
            this.bt1_c3[n] = d5;
            this.bt1_c2[n] = d - d2 - d5 - d4;
            ++n;
        }
        this.bootStrap1Ready = true;
    }

    protected double[] interpolateBootstrap1(double d, double[] dArray) {
        this.bootstrap1((d - this.initialTime) / this.deltaTime, dArray);
        dArray[this.timeIndex] = d;
        return dArray;
    }

    private double[] bootstrap1(double d, double[] dArray) {
        if (!this.bootStrap1Ready) {
            this.prepareFirstBootstrap();
        }
        int n = 0;
        while (n < this.timeIndex) {
            dArray[n] = this.initialState[n] + d * (this.deltaTime * this.initialRate[n] + d * (this.bt1_c2[n] + d * (this.bt1_c3[n] + d * this.bt1_c4[n])));
            ++n;
        }
        return dArray;
    }

    private void prepareSecondBootstrap() {
        if (this.state_bt2 == null) {
            this.state_bt2 = new double[this.dimension];
            this.rate_bt21 = new double[this.dimension];
            this.rate_bt22 = new double[this.dimension];
            this.bt2_c2 = new double[this.dimension];
            this.bt2_c3 = new double[this.dimension];
            this.bt2_c4 = new double[this.dimension];
            this.bt2_c5 = new double[this.dimension];
        }
        this.bootstrap1(0.7, this.state_bt2);
        this.state_bt2[this.timeIndex] = this.initialTime + 0.7 * this.deltaTime;
        this.ode.getRate(this.state_bt2, this.rate_bt21);
        this.bootstrap1(0.85, this.state_bt2);
        this.state_bt2[this.timeIndex] = this.initialTime + 0.85 * this.deltaTime;
        this.ode.getRate(this.state_bt2, this.rate_bt22);
        int n = 0;
        while (n < this.timeIndex) {
            double d = this.finalState[n] - this.initialState[n];
            double d2 = this.deltaTime * this.initialRate[n];
            double d3 = this.deltaTime * this.finalRate[n];
            double d4 = this.deltaTime * this.rate_bt21[n] + -0.06999999999999974 * d3 + 0.33000000000000007 * d2 + -1.26 * d;
            double d5 = this.deltaTime * this.rate_bt22[n] + -0.46749999999999986 * d3 + 0.23250000000000015 * d2 + -0.765 * d;
            double d6 = (-0.4924687499999998 * d4 - -0.4095 * d5) / 0.009639000000000005;
            double d7 = (-0.16799999999999982 * d5 - -0.17849999999999996 * d4) / 0.009639000000000005;
            double d8 = d3 + d2 - 2.0 * d - 2.0 * d6 - 3.0 * d7;
            this.bt2_c5[n] = d7;
            this.bt2_c4[n] = d6;
            this.bt2_c3[n] = d8;
            this.bt2_c2[n] = d - d2 - d8 - d6 - d7;
            ++n;
        }
        this.bootStrap2Ready = true;
    }

    protected double[] interpolateBootstrap2(double d, double[] dArray) {
        this.bootstrap2((d - this.initialTime) / this.deltaTime, dArray);
        dArray[this.timeIndex] = d;
        return dArray;
    }

    private double[] bootstrap2(double d, double[] dArray) {
        if (!this.bootStrap2Ready) {
            this.prepareSecondBootstrap();
        }
        int n = 0;
        while (n < this.timeIndex) {
            dArray[n] = this.initialState[n] + d * (this.deltaTime * this.initialRate[n] + d * (this.bt2_c2[n] + d * (this.bt2_c3[n] + d * (this.bt2_c4[n] + d * this.bt2_c5[n]))));
            ++n;
        }
        return dArray;
    }

    public abstract double[] interpolate(double var1, double[] var3);

    public double[] bestInterpolate(double d, double[] dArray) {
        if (Double.isNaN(this.finalTime)) {
            return null;
        }
        if (d == this.finalTime) {
            System.arraycopy(this.finalState, 0, dArray, 0, this.dimension);
            return dArray;
        }
        if (d == this.initialTime) {
            System.arraycopy(this.initialState, 0, dArray, 0, this.dimension);
            return dArray;
        }
        return this.computeIntermediateStep(d - this.initialTime, dArray);
    }
}

