/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.opensourcephysics.analysis.FourierSinCosAnalysis;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ToolsRes;

public class FourierToolTab
extends DataToolTab {
    protected Dataset source;
    protected PlottingPanel sourcePlot;
    protected DataTable sourceTable;
    JSplitPane sourceSplitPane;

    public FourierToolTab(Dataset dataset) {
        super(FourierToolTab.createFourierData(dataset));
        XMLControlElement xMLControlElement = new XMLControlElement(dataset);
        this.source = new Dataset();
        xMLControlElement.loadObject(this.source);
        this.source.setMarkerColor(Color.red.darker());
        this.source.setConnected(true);
        this.sourcePlot = new PlottingPanel(this.source.getXColumnName(), this.source.getYColumnName(), ToolsRes.getString("FourierToolTab.SourcePlot.Title"));
        this.sourceSplitPane.setLeftComponent(this.sourcePlot);
        this.sourceTable.add(this.source);
        this.sourceSplitPane.setDividerLocation(0.7);
    }

    protected static Data createFourierData(Dataset dataset) {
        Object object;
        Object object2 = dataset.getXPoints();
        double[] dArray = dataset.getYPoints();
        if (dArray.length % 2 == 1) {
            object = new double[dArray.length - 1];
            double[] dArray2 = new double[((Object)object).length];
            System.arraycopy(object2, 0, object, 0, ((Object)object).length);
            System.arraycopy(dArray, 0, dArray2, 0, dArray2.length);
            dataset.clear();
            dataset.append((double[])object, dArray2);
            object2 = object;
            dArray = dArray2;
        }
        object = new FourierSinCosAnalysis();
        ((FourierSinCosAnalysis)object).doAnalysis((double[])object2, dArray, 0);
        return object;
    }

    protected void createGUI() {
        super.createGUI();
        this.sourceTable = new DataTable();
        this.bottomPaneCheckbox.removeActionListener(this.bottomPaneAction);
        this.bottomPaneAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FourierToolTab.this.splitPanes[1].setDividerSize(FourierToolTab.this.splitPanes[2].getDividerSize());
                FourierToolTab.this.splitPanes[1].setDividerLocation(1.0);
                boolean bl = FourierToolTab.this.bottomPaneCheckbox.isSelected();
                FourierToolTab.this.splitPanes[1].setEnabled(bl);
                if (bl) {
                    int n = FourierToolTab.this.splitPanes[1].getDividerLocation();
                    int n2 = 150;
                    FourierToolTab.this.splitPanes[1].setDividerSize(FourierToolTab.this.splitPanes[0].getDividerSize());
                    FourierToolTab.this.splitPanes[1].setDividerLocation(n - n2 - 10);
                    FourierToolTab.this.sourceTable.refreshTable();
                    FourierToolTab.this.sourcePlot.addDrawable(FourierToolTab.this.source);
                }
                FourierToolTab.this.refreshPlot();
            }
        };
        this.bottomPaneCheckbox.addActionListener(this.bottomPaneAction);
        this.sourceSplitPane = new JSplitPane(1);
        this.sourceSplitPane.setResizeWeight(1.0);
        JScrollPane jScrollPane = new JScrollPane(this.sourceTable);
        this.sourceSplitPane.setRightComponent(jScrollPane);
        this.splitPanes[1].setBottomComponent(this.sourceSplitPane);
    }

    protected void refreshGUI() {
        super.refreshGUI();
        this.bottomPaneCheckbox.setText(ToolsRes.getString("FourierToolTab.Checkbox.Source.Text"));
        this.bottomPaneCheckbox.setToolTipText(ToolsRes.getString("FourierToolTab.Checkbox.Source.Tooltip"));
    }

    protected void refreshStatusBar() {
        this.statusLabel.setText(" ");
    }

    protected void setFontLevel(int n) {
        double d = FontSizer.getFactor(n);
        this.sourcePlot.getAxes().resizeFonts(d, this.sourcePlot);
        FontSizer.setFonts(this.sourceTable, n);
        Font font = this.sourceTable.getFont();
        this.sourceTable.setRowHeight(font.getSize() + 4);
        super.setFontLevel(n);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            FourierToolTab fourierToolTab = (FourierToolTab)object;
            xMLControl.setValue("name", fourierToolTab.getName());
            xMLControl.setValue("source_data", fourierToolTab.source);
            DatasetManager datasetManager = new DatasetManager();
            ArrayList<Dataset> arrayList = new ArrayList<Dataset>();
            for (Dataset object22 : fourierToolTab.dataManager.getDatasets()) {
                if (object22 instanceof DataFunction) {
                    arrayList.add(object22);
                    continue;
                }
                datasetManager.addDataset(fourierToolTab.copy(object22, null, false));
            }
            xMLControl.setValue("columns", datasetManager);
            if (!arrayList.isEmpty()) {
                DataFunction[] dataFunctionArray = arrayList.toArray(new DataFunction[0]);
                xMLControl.setValue("data_functions", dataFunctionArray);
            }
            xMLControl.setValue("source_visible", fourierToolTab.bottomPaneCheckbox.isSelected());
            xMLControl.setValue("props_visible", fourierToolTab.propsCheckbox.isSelected());
            xMLControl.setValue("stats_visible", fourierToolTab.statsCheckbox.isSelected());
            int n = fourierToolTab.splitPanes[0].getDividerLocation();
            xMLControl.setValue("split_pane", n);
            n = fourierToolTab.sourceSplitPane.getDividerLocation();
            xMLControl.setValue("source_split_pane", n);
            int[] nArray = fourierToolTab.dataTable.getModelColumnOrder();
            xMLControl.setValue("column_order", nArray);
            String[] stringArray = fourierToolTab.dataTable.getHiddenMarkers();
            xMLControl.setValue("hidden_markers", stringArray);
            Collection<String> collection = fourierToolTab.dataTable.getPatternColumns();
            if (!collection.isEmpty()) {
                ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
                for (String string : collection) {
                    String string2 = fourierToolTab.dataTable.getFormatPattern(string);
                    arrayList2.add(new String[]{string, string2});
                }
                xMLControl.setValue("format_patterns", arrayList2);
            }
        }

        public Object createObject(XMLControl xMLControl) {
            Dataset dataset = (Dataset)xMLControl.getObject("source_data");
            return new FourierToolTab(dataset);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            String[] stringArray3;
            String[] stringArray2;
            final FourierToolTab fourierToolTab = (FourierToolTab)object;
            fourierToolTab.setName(xMLControl.getString("name"));
            for (XMLProperty xMLProperty : xMLControl.getPropertyContent()) {
                if (!xMLProperty.getPropertyName().equals("data_functions")) continue;
                XMLControl[] xMLControlArray = xMLProperty.getChildControls();
                int n3 = 0;
                while (n3 < xMLControlArray.length) {
                    DataFunction nArray = new DataFunction(fourierToolTab.dataManager);
                    xMLControlArray[n3].loadObject(nArray);
                    nArray.setXColumnVisible(false);
                    fourierToolTab.dataManager.addDataset(nArray);
                    ++n3;
                }
                ArrayList<Dataset> arrayList = fourierToolTab.dataManager.getDatasets();
                int n = 0;
                while (n < arrayList.size()) {
                    if (arrayList.get(n) instanceof DataFunction) {
                        ((DataFunction)arrayList.get(n)).refreshFunctionData();
                    }
                    ++n;
                }
                fourierToolTab.dataTable.refreshTable();
                break;
            }
            boolean bl = xMLControl.getBoolean("source_visible");
            fourierToolTab.bottomPaneCheckbox.setSelected(bl);
            boolean bl2 = xMLControl.getBoolean("props_visible");
            fourierToolTab.propsCheckbox.setSelected(bl2);
            boolean bl3 = xMLControl.getBoolean("stats_visible");
            fourierToolTab.statsCheckbox.setSelected(bl3);
            final int n = xMLControl.getInt("split_pane");
            final int n2 = xMLControl.getInt("source_split_pane");
            int[] nArray = (int[])xMLControl.getObject("column_order");
            fourierToolTab.dataTable.setModelColumnOrder(nArray);
            if (nArray == null && (stringArray2 = (String[])xMLControl.getObject("working_columns")) != null) {
                fourierToolTab.dataTable.setWorkingColumns(stringArray2[0], stringArray2[1]);
            }
            stringArray2 = (String[])xMLControl.getObject("hidden_markers");
            fourierToolTab.dataTable.hideMarkers(stringArray2);
            ArrayList arrayList = (ArrayList)xMLControl.getObject("format_patterns");
            if (arrayList != null) {
                for (String[] stringArray3 : arrayList) {
                    fourierToolTab.dataTable.setFormatPattern(stringArray3[0], stringArray3[1]);
                }
            }
            stringArray3 = (String[])xMLControl.getObject("columns");
            int n3 = stringArray3.getDatasets().size();
            int n4 = 0;
            while (n4 < n3) {
                Dataset dataset = stringArray3.getDataset(n4);
                Dataset dataset2 = fourierToolTab.dataTable.getDataset(dataset.getYColumnName());
                fourierToolTab.copy(dataset, dataset2, false);
                ++n4;
            }
            Runnable runnable = new Runnable(){

                public synchronized void run() {
                    fourierToolTab.bottomPaneAction.actionPerformed(null);
                    fourierToolTab.propsAndStatsAction.actionPerformed(null);
                    fourierToolTab.splitPanes[0].setDividerLocation(n);
                    fourierToolTab.sourceSplitPane.setDividerLocation(n2);
                    fourierToolTab.dataTable.refreshTable();
                    fourierToolTab.propsTable.refreshTable();
                    fourierToolTab.tabChanged(false);
                }
            };
            SwingUtilities.invokeLater(runnable);
            return object;
        }
    }
}

